library(GenomicAlignments)
library(GenomicFeatures)
library(MAAPER)


pas_annotation = readRDS("~/Box/Collaboration/2020Tian-QS/data-polyadb/human/human.PAS.hg19.rds")
gtf_rds = "~/Box/Collaboration/2020Tian-QS/data-polyadb/human/GRCh37.87.exonsgr.R3.5.1.rds"

output_dir = "~/Box/Collaboration/2020Tian-QS/code/data-SCT/R1/rds/SCT"



bam_dir = "/projects/f_wl522_1/2020Tian-QS/data-SCT/bam-for-apa/"
donors = paste0("D", 8:12)
bam_c1 = paste0(bam_dir, donors, "-VCT.bam")
bam_c2 = paste0(bam_dir, donors, "-SCT.bam")


maaper(gtf = NULL, pas_annotation, output_dir, bam_c1, bam_c2,
       read_len = 98, ncores = 15,
       num_pas_thre = 25, frac_pas_thre = 0.05,
       dist_thre = 600, num_thre = 50,
       run = "all", region = "all", gtf_rds = gtf_rds,
       paired = FALSE)

