library(GenomicAlignments)
library(GenomicFeatures)
dir = "/projects/f_wl522_1/Rpkg/"
install.packages(paste0(dir, "MAAPER-dev/MAAPER_1.1.0.tar.gz"), repos = NULL)
library(MAAPER)



pas_annotation = readRDS("~/Box/Collaboration/2020Tian-QS/data-polyadb/mouse/mouse.PAS.rds")
gtf = "~/Box/Collaboration/2020Tian-QS/data-polyadb/mouse/gencode.vM1.annotation.gtf"

samples = c("0h", "4h", "8h")
for(sample in samples){
  bam_c1 = paste0("~/Box/Collaboration/2020Tian-QS/data-qs/fav/splitted_bam_v1/",
                  c("NT_0h_T_splitted_1.bam", "NT_0h_T_splitted_2.bam"))
  bam_c2 = paste0("~/Box/Collaboration/2020Tian-QS/data-qs/fav/splitted_bam_v1/AS_",
                  sample, c("_T_splitted_1.bam", "_T_splitted_2.bam"))
  output_dir = paste0("~/Box/Collaboration/2020Tian-QS/code/data-stress/R1/rds/", sample, "/")
  maaper(gtf = gtf, pas_annotation, output_dir, bam_c1, bam_c2,
         read_len = 76, ncores = 16,
         num_pas_thre = 25, frac_pas_thre = 0.05,
         dist_thre = 600, num_thre = 50,
         run = "all", region = "all",
         paired = FALSE)
}












