
np=1e8
nu=1e-5
;r1=.5*1e-5 & r2=.5*1.26e-5  ;(diameter)
r1=1e-5 & r2=1.26e-5
S=1000.
g=9.81

tau1=S*(2*r1)^2/(18*nu)
tau2=S*(2*r2)^2/(18*nu)
;tau1=2*S*(r1)^2/(9*nu)
;tau2=2*S*(r2)^2/(9*nu)

;The fall velocity is given by g*tau, where g=9.81 m/s^2
;and, according to our Eq.(2), tau=2*1000*r1^2/(9*rho*nu),
;so tau=2*1000*12.6e-6^2/(9*1*1e-5)=0.00352s, and v=9.81*0.00352=0.035m/s.

print,2*1000*12.6e-6^2/(9*1*1e-5)
   ;0.00352800

v_rel=g*(tau2-tau1)
v_rel=g*tau1


;lambda=!pi*(r1^2+r2^2)*v_rel*np
lambda=!pi*(r1+r2)^2*v_rel*np

t_col=1/lambda
vel1=g*tau1
vel2=g*tau2
dist=t_col*vel2



print,'t_col=',t_col
print,'vel1,2=',vel1,vel2
print,'dist=',dist

END
