;$Id: pt_funct_rArB.pro,v 1.1 2020/10/11 15:41:05 cvs Exp $
if !d.name eq 'PS' then begin
  device,xsize=9,ysize=6,yoffset=3
  !p.charthick=1.4 & !p.thick=1.4 & !x.thick=1.4 & !y.thick=1.4
end
;
siz=0.9
!p.charsize=1.0
!x.margin=[4.8,.5]
!y.margin=[3.2,.5]
!p.position=0
;
a0=1e-5
n=125
n=50000L
n=50L
i=1.+findgen(20*n)/20.
;
n=5000L
i=2.+findgen(n)
a_ratio=i^.333333333
a=a0*a_ratio
;
t_corr=1./((1.+1./a_ratio)^2*(1.-1./a_ratio^2))
ta_corr=1./(1.+1./a_ratio)^2
tb_corr=1./(1.-1./a_ratio^2)
;
nu=1e-5
dens=1e8
grav=9.81
rhop_ratio=1e3
t_inv        =2.*rhop_ratio/(9.*nu)*(a^2-a0^2)*!pi*(a+a0)^2*dens*grav
t_inv_approx2=2.*rhop_ratio/(9.*nu)* a^2      *!pi*(a+a0)^2*dens*grav
t_inv_approx =2.*rhop_ratio/(9.*nu)* a^2      *!pi* a^2    *dens*grav
;t_inv_approx2=2.*rhop_ratio/(9.*nu)*b^2*!pi*b^2*dens*grav
t=1./t_inv
t_approx=1./t_inv_approx
t_approx2=1./t_inv_approx2
;
i_cut=123
um=1e-6
;
;  panel (b)
;
!y.title='!6'
yr=[.1,4.]
circ_sym,.2,1
plot_oo,a/um,t_corr,xr=xr,yr=yr
oplot,a/um,a*0+1,ps=8
oplot,a/um,ta_corr,col=122
oplot,a/um,tb_corr,col=55
oplot,[1,1]*a[i_cut]/um,yr,li=4
xyouts,20.,0.80,'!8r!6/!8r!dk!n!6=1'
xyouts,11.,0.49,'!8r!6!u4!n/!8r!6!s!dA!n!r!u2!n!8r!6!s!dB!n!r!u2!n',siz=siz*.8
xyouts,20.,0.33,'!8r!6!u2!n/!8r!6!s!dA!n!r!u2!n',col=122
xyouts,20.,1.50,'!8r!6!u2!n/!8r!6!s!dB!n!r!u2!n',col=55
xyouts,53.,0.13,'!8r!6=50!7l!6m',siz=siz*.8
;
fac=20.
i=1.+findgen(fac)/fac
a_ratio=i^.333333333
a=a0*a_ratio
;
t_corr=1./((1.+1./a_ratio)^2*(1.-1./a_ratio^2))
ta_corr=1./(1.+1./a_ratio)^2
tb_corr=1./(1.-1./a_ratio^2)
print,'a=',a/um
;
oplot,a/um,t_corr,li=3
oplot,a/um,ta_corr,col=122,li=3
oplot,a/um,tb_corr,col=55,li=3
;
print,'$mv idl.ps ../Figs/pt_funct_rArB.eps'
END
