;$Id: pt_funct_MFT.pro,v 1.1 2020/10/11 15:41:04 cvs Exp $
if !d.name eq 'PS' then begin
  device,xsize=9,ysize=6,yoffset=3
  !p.charthick=1.4 & !p.thick=1.4 & !x.thick=1.4 & !y.thick=1.4
end
;
siz=0.9
!p.charsize=1.0
!x.margin=[6.8,.5]
!y.margin=[3.2,.5]
!p.position=0
;
a0=1e-5
n=125
n=50000L
n=50L
i=1.+findgen(20*n)/20.
;
n=5000L
i=2.+findgen(n)
a_ratio=i^.333333333
a=a0*a_ratio
;
t_corr=1./((1.+1./a_ratio)^2*(1.-1./a_ratio^2))
ta_corr=1./(1.+1./a_ratio)^2
tb_corr=1./(1.-1./a_ratio^2)
;
nu=1e-5
dens=1e8
grav=9.81
rhop_ratio=1e3
t_inv        =2.*rhop_ratio/(9.*nu)*(a^2-a0^2)*!pi*(a+a0)^2*dens*grav
t_inv_approx2=2.*rhop_ratio/(9.*nu)* a^2      *!pi*(a+a0)^2*dens*grav
t_inv_approx =2.*rhop_ratio/(9.*nu)* a^2      *!pi* a^2    *dens*grav
;t_inv_approx2=2.*rhop_ratio/(9.*nu)*b^2*!pi*b^2*dens*grav
t=1./t_inv
t_approx=1./t_inv_approx
t_approx2=1./t_inv_approx2
;
i_cut=123
um=1e-6
;
;  panel (a)
;
s=1./60.
!p.multi=0
!x.title='!8r!6 [!7l!6m]'
!y.title='!8T!s!dk!n!6!r!uMFT!n [min]'
tt=accum(t,/sum)
tt_approx=accum(t_approx,/sum)
tt_approx2=accum(t_approx2,/sum)
xr=[10.,110.]
yr=[0.,52.]
plot_oi,a[1:*]/um,s*t[0:n-1],xr=xr,yr=yr,/nodata
oplot,[12.6,a[1:*]/um],[0.,s*tt[0:n-1]],li=0
oplot,[12.6,a[1:*]/um],[0.,s*tt_approx[0:n-1]],li=2,col=122
oplot,[12.6,a[1:*]/um],[0.,s*tt_approx2[0:n-1]],li=3,col=55
xyouts,siz=siz*.8,40.0,s*2540,'!8r!6!dA!n!6=!8r!dk!n!6=!8r!6!dB!n',col=122
xyouts,siz=siz*.8,40.0,s*1660,'!8r!6!dA!n!9=!8r!dk!n!9=!8r!6!dB!n'
xyouts,siz=siz*.8,40.0,s*1000,'!8r!6!dA!n!9=!8r!dk!n!6=!8r!6!dB!n',col=55
;
print,a[i_cut]
print,'T50=',tt[i_cut]
print,'T50approx=',tt_approx[i_cut]
;
print,'$mv idl.ps ../Figs/pt_funct_MFT.eps'
END
