;$Id: prob_timestep_mult.pro,v 1.14 2021/04/15 09:32:15 cvs Exp $
;
;  Same as prob_timestep, but with multiple lucky droplet (->jumps)
;  Produces data for ppcollisions.pro (approach III)
;  and for pcomp_dens_all_mult_b.
;
spawn,'date'
Nreal=3000
Nreal=30000
Nreal=100000L
Nreal=2000000L
Nreal=1000000L & lfile_long=0  ;(=1M, for production)
Nreal=300 & lfile_long=1
Nreal=1000 & lfile_long=1
Nreal=30 & lfile_long=1
Nreal=1000 & lfile_long=0  ;(for taver used in ppcollisions)
;
dt=.1 & nt=100000L ;(not needed)
dt=1. & nt=10000
;
Nsteps=125
Nluck=3
flag=intarr(Nluck)
treal=fltarr(Nreal,Nluck)
V=fltarr(Nluck)
Vmean=fltarr(Nluck)
rr=fltarr(Nluck,Nreal,Nsteps)+12.6e-6
rrmean=fltarr(Nluck,Nreal,nt)+12.6e-6
ttmean=fltarr(Nluck,Nreal,nt)
tcoll=fltarr(Nluck,Nreal,Nsteps)
j=intarr(Nluck,Nreal)  ;(counts the collisions)
r=fltarr(Nluck)
rmean=fltarr(Nluck)
rmax=50e-6
fac=4.*!pi/3.
V1=fac*1e-5^3
r1=(V1/fac)^.3333333
g=9.81
rhoratio=1e3
t=0.
;
;  different values of epsilon (here called frac, because it
;  measures the fraction of lucky particles over backgound ones.
;
frac=.2
frac=.02
frac=.01
;
frac=.0
frac=.004
frac=.02
frac=.05
frac=.2
;
dens=11e7
dens=9e7
dens=8e7
dens=12e7
dens=13e7
dens=7e7
dens=1e8
dens_luck=frac*dens/Nluck
densname=str(fix(dens/1e7))
nu=1e-5
;
default,seed,123.
default,lfile_long,0
interluck_counter=fltarr(Nreal)
fo="(i9,6f9.1)"
;
for ireal=0,Nreal-1 do begin
;
;  initialization of r and V
;
t=0.
r1=10e-6
for iluck=0,nluck-1 do begin
  flag[iluck]=0
  r[iluck]=12.6e-6
  rmean[iluck]=12.6e-6
  V[iluck]=2.*V1
  Vmean[iluck]=2.*V1
endfor
;
;  new random number
;
ran=reform(random(nt*Nluck,seed=seed),nt,Nluck)
for it=0L,nt-1 do begin
  t=t+dt
  for iluck=0,nluck-1 do begin
    if not flag[iluck] then begin
      rA2=(r[iluck]+r1)^2
      rB2=r[iluck]^2-r1^2
      lamk=!pi*rA2*2./9.*rhoratio*g/nu*rB2*dens
      ;
      rA2mean=(rmean[iluck]+r1)^2
      rB2mean=rmean[iluck]^2-r1^2
      lamkmean=!pi*rA2mean*2./9.*rhoratio*g/nu*rB2mean*dens
      ;
      ;  collision between luck and back
      ;
      ;if (lamk*dt) gt 1. then stop,'dt too large'
      Vmean[iluck]=lamkmean*dt*V1+Vmean[iluck]
      rmean[iluck]=(Vmean[iluck]/fac)^.3333333 
      rrmean[iluck,ireal,it]=rmean[iluck]
      ttmean[iluck,ireal,it]=t
      if ran[it,iluck] le lamk*dt then begin
        j[iluck,ireal]=j[iluck,ireal]+1
        V[iluck]=V[iluck]+V1
        r[iluck]=(V[iluck]/fac)^.3333333 
        rr[iluck,ireal,j[iluck,ireal]-1]=r[iluck]
        tcoll[iluck,ireal,j[iluck,ireal]-1]=t
      endif
      ;
      ;  inter-luck collisions
      ;
      for jluck=0,nluck-1 do begin
        if iluck ne jluck and not flag[jluck] then begin
          rA2=(r[iluck]+r[jluck])^2
          rB2=r[iluck]^2-r[jluck]^2
          lamk=!pi*rA2*2./9.*rhoratio*g/nu*rB2*dens_luck
          ;if (lamk*dt) gt 1. then stop,'dt too large'
          if ran[it,iluck] le lamk*dt then begin
            j[iluck,ireal]=j[iluck,ireal]+1
            V[iluck]=V[iluck]+V[jluck]
            r[iluck]=(V[iluck]/fac)^.3333333 
            rr[iluck,ireal,j[iluck,ireal]-1]=r[iluck]
            tcoll[iluck,ireal,j[iluck,ireal]-1]=t
            interluck_counter[ireal]=interluck_counter[ireal]+1
          endif
        endif
      endfor
      ;
      if r[iluck] ge rmax then begin
        flag[iluck]=1
        treal[ireal,iluck]=t
      endif
      if total(flag) eq Nluck then goto,ending
    endif
  endfor
  ;t=t+dt
endfor
stop,'not done'
ending:
if ireal mod 100 eq 0 then print,ireal,reform(treal[ireal,*]),reform(r/1e-6),fo=fo
endfor
;
;  mean collision times
;
naver=125
raver=1e-5*(findgen(naver)+1)^.3333333
taver=fltarr(naver)
for iaver=0,naver-1 do begin
  good=where(abs(rr-raver[iaver]) lt 1e-9)
  if good[0] ne -1 then taver[iaver]=mean(tcoll(good))
  ;print,'ngood=',raver[iaver]/1e-6,n_elements(good)
  ;stop
endfor
;
pdf,treal,tt,prob
tmean1=mean(treal)
tmean2=total(tt*prob)/total(prob)
print,tmean1,tmean2
;plot_io,tt/tmean1,prob*tmean1,xr=[0,3],yr=[1e-3,5.]
;
;  write big file with full trajectories (used only when, e.g., 30 realizations)
;
file='Nreal_mult='+str(Nreal)+'_dens_luck'+str(fix(1e3*frac))+'_dens'+densname+'.sav'
print,'?to overwrite: '+file
print,'Nreal,treal,tt,prob,tmean1,dens_luck,rr,tcoll,j,Nluck,frac,densname'
if lfile_long then save,file=file,Nreal,treal,tt,prob,tmean1,dens_luck,rr,tcoll,j,Nluck,frac,densname
;
;  write smaller file
;
file='Nreal_mult='+str(Nreal)+'_dens_luck'+str(fix(1e3*frac))+'_dens'+densname+'_red.sav'
print,'?to overwrite: '+file
print,'Nreal,treal,tt,prob,tmean1,dens_luck,j,Nluck,frac,densname'
;stop
save,file=file,Nreal,treal,tt,prob,tmean1,dens_luck,j,Nluck,frac,densname,raver,taver
;
;  file sizes;
;  rr   =fltarr(Nluck,Nreal,Nsteps)+12.6e-6
;  tcoll=fltarr(Nluck,Nreal,Nsteps)
;  j    =intarr(Nluck,Nreal)  ;(counts the collisions)
;
print
;print,'interluck_counter=',interluck_counter
;plot,tcoll[0,0,*],rr[0,0,*]
spawn,'date'
END
