;$Id: prob_KS05.pro,v 1.2 2020/02/13 07:24:08 brandenb Exp $
;
;  ?is it used?
;
Nreal=3000
Nreal=30000
treal=fltarr(Nreal)
rmax=50e-6
fac=4.*!pi/3.
V1=fac*1e-5^3
r1=(V1/fac)^.3333333
g=9.81
rhoratio=1e3
dens=1e8
nu=1e-5
dt=.1
dt=1.
default,seed,123.
;
for ireal=0,Nreal-1 do begin
;
t=0.
r=12.6e-6
r1=10.0e-6
nt=10000
V=2.*V1
;
ran=random(nt,seed=seed)
for it=0,nt-1 do begin

  ran=expnoise(xxx)
  

  rA2=(r+r1)^2
  rB2=r^2-r1^2
  lamk=!pi*rA2*2./9.*rhoratio*g/nu*rB2*dens
  t=t+dt
  if (lamk*dt) gt 1. then stop,'dt too large'
  if ran[it] le lamk*dt then begin
    V=V+V1
    r=(V/fac)^.3333333 
  endif
  if r ge rmax then goto,ending
endfor
stop,'not done'
ending:
if ireal mod 100 eq 0 then print,ireal,it,t,r/1e-6
treal[ireal]=t
endfor
;
pdf,treal,tt,prob
tmean1=mean(treal)
tmean2=total(tt*prob)/total(prob)
print,tmean1,tmean2
plot_io,tt/tmean1,prob*tmean1,xr=[0,3],yr=[1e-3,5.]
save,file='Nreal='+str(Nreal)+'.sav',Nreal,treal,tt,prob,tmean1
;
END
