;$Id: ppcollisions.pro,v 1.8 2020/06/01 19:04:06 cvs Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=7,yoffset=3
  !p.charthick=2 & !p.thick=2 & !x.thick=2 & !y.thick=2
end
;
;  plot 3 panels with collision histories
;  Data are being produced with prob_timestep_mult.pro
;
siz=1.
xr=[0,4.8]
yr=[10,50]
!p.multi=[0,3,1]
!p.charsize=2.0
!x.margin=[5.8,0.1]
!y.margin=[3.2,1.8]
!x.title='!8t!6 [ks]'
!y.title='!8r!6 [!7l!6m]'
thick=.5
thick2=3
thick3=5
tunit=1e3
restore,'MFT.sav'
n=n_elements(a)
tMFT=tt[0:n-1]/1e3
aMFT=a[1:*]/1e-6
;
!p.title='!7e!6=0.004'
;
file='Nreal_mult=30_dens_luck4_dens10.sav'
plot,xr,yr,/nodata
restore,file
for iluck=0,Nluck-1 do begin
for ireal=0,Nreal-1 do begin
  r=reform(rr[iluck,ireal,*])
  good=where(r ne 12.6e-6)
  jmax=max(good)
  tcoll_=tcoll[iluck,ireal,0:jmax]/tunit
  rr_=rr[iluck,ireal,0:jmax]/1e-6
  pjumps,[0,reform(tcoll_)],[12.6,reform(rr_)]
endfor
endfor
oplot,tMFT,aMFT,thick=thick2,li=2
restore,'Nreal_mult=1000_dens_luck4_dens10_red.sav'
oplot,taver[2:*]/1e3,raver[2:*]/1e-6,thick=thick3
;
!y.title='!6'
!p.title='!7e!6=0.02'
file='Nreal_mult=30_dens_luck20_dens10.sav'
plot,xr,yr,/nodata
restore,file
for iluck=0,Nluck-1 do begin
for ireal=0,Nreal-1 do begin
  r=reform(rr[iluck,ireal,*])
  good=where(r ne 12.6e-6)
  jmax=max(good)
  tcoll_=tcoll[iluck,ireal,0:jmax]/tunit
  rr_=rr[iluck,ireal,0:jmax]/1e-6
  pjumps,tcoll_,rr_
endfor
endfor
oplot,tMFT,aMFT,thick=thick2,li=2
restore,'Nreal_mult=1000_dens_luck20_dens10_red.sav'
oplot,taver[2:*]/1e3,raver[2:*]/1e-6,thick=thick3
;
!p.title='!7e!6=0.05'
file='Nreal_mult=30_dens_luck50_dens10.sav'
plot,xr,yr,/nodata
restore,file
for iluck=0,Nluck-1 do begin
for ireal=0,Nreal-1 do begin
  r=reform(rr[iluck,ireal,*])
  good=where(r ne 12.6e-6)
  jmax=max(good)
  tcoll_=tcoll[iluck,ireal,0:jmax]/tunit
  rr_=rr[iluck,ireal,0:jmax]/1e-6
  pjumps,tcoll_,rr_
endfor
endfor
oplot,tMFT,aMFT,thick=thick2,li=2
restore,'Nreal_mult=1000_dens_luck50_dens10_red.sav'
;restore,'Nreal_mult=1000_dens_luck200_dens10_red.sav' ;(would be shorter times)
oplot,taver[2:*]/1e3,raver[2:*]/1e-6,thick=thick3
;
print,'$mv idl.ps ../Figs/ppcollisions.ps'
END
