;$Id: lagrangian_coll_simple.pro,v 1.4 2020/04/16 02:09:31 cvs Exp $
;
;  ILP model for different combinations or rA and rB.
;  At the end, run .r ppp_simple to fill the directory "dir"
;
nreal=3000 & lrA=1 & lrB=1 & dir='model_11/' & dens=10e7 & L=.0001d0 & Lz=700.
nreal=3000 & lrA=0 & lrB=1 & dir='model_01/' & dens=10e7 & L=.0001d0 & Lz=700.
nreal=3000 & lrA=1 & lrB=0 & dir='model_10/' & dens=10e7 & L=.0001d0 & Lz=700.
nreal=3000 & lrA=0 & lrB=0 & dir='model_00/' & dens=10e7 & L=.0001d0 & Lz=700.
nreal=10000L & lrA=0 & lrB=0 & dir='model_00_10k/' & dens=10e7 & L=.0001d0 & Lz=700.
nreal=100000L & lrA=0 & lrB=0 & dir='model_00_100k/' & dens=10e7 & L=.0001d0 & Lz=700.;(2min)
nreal=1000000L & lrA=0 & lrB=0 & dir='model_00_1M/' & dens=10e7 & L=.0001d0 & Lz=700.;(20min)
nreal=10000000L & lrA=0 & lrB=0 & dir='model_00_10M/' & dens=10e7 & L=.0001d0 & Lz=700.;(3h)
;
n=dens*(L^2*Lz)
print,'n=',n
spawn,'date'
;
default,seed,124
;
x0=.5*L
y0=.5*L
;
nt=125
fac=4.*!pi/3.
V0=fac*1e-5^3
a0=(V0/fac)^.3333333
;
g=9.81
rhoratio=1e3
nu=1e-5
;
t_arr=fltarr(nt,nreal)
tt_arr=fltarr(nt,nreal)
;
for ireal=0,nreal-1 do begin
if (ireal mod 100) eq 0 then print,'ireal=',ireal
;
x=random(n,seed=seed)*L
y=random(n,seed=seed)*L
z=random(n,seed=seed)*Lz
;
;  for each realization, reset V, Lp,
;  and calculate rH once
;
V=V0
Lp=Lz
rH=sqrt((x-x0)^2+(y-y0)^2)
vinf0=g*rhoratio*a0^2*2./(9.*nu)
;
tt=0.
vinf=0. ;(use vinf from i, initialize here)
for i=1,nt-1 do begin
  V=V+V0
  a=(V/fac)^.3333333
  taup=rhoratio*a^2*2./(9.*nu)
  vinf=g*taup
  if lrB then dvinf=vinf else dvinf=vinf-vinf0
  if lrA then rA=a else rA=a+a0
  good=where((rH lt rA) and (z lt Lp))
  best=where(z eq max(z(good)))
  zcoll=z(best[0])
  dz=Lp-zcoll
  t=dz/dvinf
  Lp=zcoll  ;reset
  tt=tt+t
  t_arr[i,ireal]=t
  tt_arr[i,ireal]=tt
endfor
endfor
;
;  compute a pdf for each collision step
;
npdf=200 & xpdfmax=8000.
npdf=800 & xpdfmax=50000.
ttime=fltarr(npdf)
pprob=fltarr(npdf)
;
;  compute here unnormalized pdf
;
it=nt-1
tend=reform(tt_arr[it,*])
pdf,tend,xx,yy,n=npdf,fmin=0.,fmax=xpdfmax
ttime=xx
pprob=yy
;
;  write result
;
tt_mean=total(ttime*pprob)/total(pprob)
wtable2,dir+'red_line_axel2.dat',ttime/tt_mean,pprob*tt_mean
wtable2,dir+'Red_line_axel2.dat',ttime,pprob
;
;  compute moments for log of normalized times
;
mean_tend=mean(tend)
print,'Tmin,Tmean=',min(tend),mean_tend
lnt=alog(tend/mean_tend)
lntm=mean(lnt)
lnt2m=mean((lnt-lntm)^2)
lnt3m=mean((lnt-lntm)^3)/lnt2m^1.5
lnt4m=mean((lnt-lntm)^4)/lnt2m^2-3.
print,lntm,lnt2m,lnt3m,lnt4m
openw,1,dir+'lntm.dat'
printf,1,lntm,lnt2m,lnt3m,lnt4m,'  ',dir
close,1
;save,file=dir+'lntm.sav',lntm,lnt2m,lnt3m,lnt4m
;
spawn,'date'
END
