;
;  efficiency?
;
nreal=3000 & lefficiency=1 & aref=10e-6 & dir='Nreal3e3_E50c/'
nreal=3000 & lefficiency=0 & lrB=1 & dir='Nreal3e3_rB/'
nreal=30000 & lefficiency=0 & dir='Nreal3e4_rB/'
nreal=3000 & lefficiency=0 & lrB=0 & dir='tst/'
;
dens=1e14 & L=1d-4 & Lz=3d-3 ;(dense experiment)
dens=1e8 & L=.0001d0 & Lz=3000. ;(longer experiment, for E50)
dens=1e8 & L=.0001d0 & Lz=300. ;(paper experiment)
;
;  different experiments
;
nreal=30000 & lefficiency=0 & lrB=0 & dir='Nreal3e4_dens9e7/' & dens=9e7 & L=.0001d0 & Lz=600.
nreal=30000 & lefficiency=0 & lrB=0 & dir='Nreal3e4_dens8e7/' & dens=8e7 & L=.0001d0 & Lz=600.
nreal=30000 & lefficiency=0 & lrB=0 & dir='Nreal3e4_dens7e7/' & dens=7e7 & L=.0001d0 & Lz=600.
nreal=30000 & lefficiency=0 & lrB=0 & dir='Nreal3e4_dens13e7/' & dens=13e7 & L=.0001d0 & Lz=600.
nreal=30000 & lefficiency=0 & lrB=0 & dir='Nreal3e4_dens12e7/' & dens=12e7 & L=.0001d0 & Lz=600.
nreal=30000 & lefficiency=0 & lrB=0 & dir='Nreal3e4_dens11e7/' & dens=11e7 & L=.0001d0 & Lz=600.
nreal=30000 & lefficiency=0 & lrB=0 & dir='Nreal3e4_dens10e7/' & dens=10e7 & L=.0001d0 & Lz=600.
nreal=30000 & lefficiency=0 & lrA=1 & lrB=1 & dir='Nreal3e4_dens10e7KS05/' & dens=10e7 & L=.0001d0 & Lz=700.
nreal=30000 & lefficiency=0 & lrA=0 & lrB=0 & dir='Nreal3e4_dens10e7rep/' & dens=10e7 & L=.0001d0 & Lz=700.
nreal=3000 & lefficiency=0 & lrA=1 & lrB=1 & dir='model_11/' & dens=10e7 & L=.0001d0 & Lz=700.
nreal=3000 & lefficiency=0 & lrA=0 & lrB=0 & dir='model_00/' & dens=10e7 & L=.0001d0 & Lz=700.
;
n=dens*(L^2*Lz)
print,'n=',n
;
default,seed,124
seed=124
;
x0=.5*L
y0=.5*L
;
nt=125
fac=4.*!pi/3.
V0=fac*1e-5^3
a0=(V0/fac)^.3333333
;
g=9.81
rhoratio=1e3
nu=1e-5
;
t_arr=fltarr(nt,nreal)
tt_arr=fltarr(nt,nreal)
taup_arr=fltarr(nt,nreal)
vcurr_arr=fltarr(nt,nreal)
tt_exp=fltarr(nt)
;
t2_arr=fltarr(nt,nreal)
tt2_arr=fltarr(nt,nreal)
;
for ireal=0,nreal-1 do begin
if (ireal mod 100) eq 0 then print,'ireal=',ireal
;
x=random(n,seed=seed)*L
y=random(n,seed=seed)*L
z=random(n,seed=seed)*Lz
;
;  for each realization, reset V, Lp,
;  and calculate rH once
;
V=V0
Lp=Lz
rH=sqrt((x-x0)^2+(y-y0)^2)
vinf0=g*rhoratio*a0^2*2./(9.*nu)
;
tt=0.
tt2=0.
vinf=0. ;(use vinf from i, initialize here)
vprev=0.
;print,'i,a,vinf,t,Lp,depth'
for i=1,nt-1 do begin
  V=V+V0
  a=(V/fac)^.3333333
  Re=a*vinf/nu
  if lefficiency then efficiency=(a/aref)^2 else efficiency=1. 
  taup=rhoratio*a^2*2./((9.*nu)*(1.+.15*Re^.66667))*efficiency
  vinf=g*taup
  if lrB then dvinf=vinf else dvinf=vinf-vinf0
  ;
  t=0.
  tprev=0.
  niter=100
  err=1d-4
  if lrA then rA=a else rA=a+a0
  good=where((rH lt rA) and (z lt Lp))
  best=where(z eq max(z(good)))
  zcoll=z(best[0])
  dz=Lp-zcoll
  for iter=0,niter-1 do begin
    t=(dz+(vinf-vprev)*taup*(1.-exp(-t/taup)))/dvinf
    if abs(t-tprev)/tprev lt err then goto,ending
    ;print,iter,t,tprev
    tprev=t
  endfor
  ending:
  vcurr=vprev+(vinf-vprev)*(1.-exp(-t/taup))
  Lp=zcoll
  vprev=vcurr
  depth=1./(!pi*(a+a0)^2*dens)
  tt=tt+t
  t_arr[i,ireal]=t
  tt_arr[i,ireal]=tt
  taup_arr[i,ireal]=taup
  vcurr_arr[i,ireal]=vcurr
  tt_exp[i]=depth/dvinf
  ;
  ;  Kosinski & Shaw reference case
  ;
  ;good2=where((rH lt (2*a)) and (z lt Lp))
  good2=where((rH lt (a)) and (z lt Lp))
  best2=where(z eq max(z(good2)))
  zcoll2=z(best2[0])
  t2=(Lp-zcoll2)/dvinf
  Lp2=zcoll2
  tt2=tt2+t2
  t2_arr[i,ireal]=t2
  tt2_arr[i,ireal]=tt2
  ;
  ;print,i+1,a,vinf,t,Lp,depth,tt
endfor
endfor
;
;  compute a pdf for each collision step
;
npdf=200 & xpdfmax=8000.
time=fltarr(npdf,nt)
prob=fltarr(npdf,nt)
ttime=fltarr(npdf,nt)
pprob=fltarr(npdf,nt)
;
time2=fltarr(npdf,nt)
prob2=fltarr(npdf,nt)
ttime2=fltarr(npdf,nt)
pprob2=fltarr(npdf,nt)
for it=1,nt-1 do begin
  pdf,reform(t_arr[it,*]),xx,yy,n=npdf,fmin=0.,fmax=xpdfmax
  time[*,it]=xx
  prob[*,it]=yy
  pdf,reform(tt_arr[it,*]),xx,yy,n=npdf,fmin=0.,fmax=xpdfmax
  ttime[*,it]=xx
  pprob[*,it]=yy
  ;
  pdf,reform(t2_arr[it,*]),xx,yy,n=npdf,fmin=0.,fmax=xpdfmax
  time2[*,it]=xx
  prob2[*,it]=yy
  pdf,reform(tt2_arr[it,*]),xx,yy,n=npdf,fmin=0.,fmax=xpdfmax
  ttime2[*,it]=xx
  pprob2[*,it]=yy
  ;
endfor
;
plot,time[*,1],prob[*,1],yr=[0,1]
oplot,time2[*,1],prob2[*,1],col=122
;oplot,time[*,30],prob[*,30],col=122
;oplot,time[*,10],prob[*,10],col=55
;
print,'Tmin,Tmean=',min(tt_arr[nt-1,*]),mean(tt_arr[nt-1,*])
END
