;$Id: KS05_coll.pro,v 1.11 2020/04/18 18:53:11 cvs Exp $
;
;  Model where tk is drawn from an exponential distribution.
;  At the end, run .r ppp_simple to fill the directory "dir"
;
nreal=30000 & lrA=1 & lrB=0 & dir='Model_10/' & dens=10e7
nreal=30000 & lrA=0 & lrB=1 & dir='Model_01/' & dens=10e7
nreal=30000 & lrA=0 & lrB=0 & dir='Model_00/' & dens=10e7
nreal=30000 & lrA=1 & lrB=1 & dir='Model_11test/' & dens=10e7  ;(orig KS05)
nreal=30000 & lrA=1 & lrB=1 & kini=1 & dir='Model_11_kini1/' & dens=10e7  ;(orig KS05 <-- blue line)
nreal=30000 & lrA=1 & lrB=1 & kini=2 & dir='Model_11_kini2/' & dens=10e7  ;(semi KS05 <-- red line)
nreal=30000 & lrA=1 & lrB=1 & kini=1 & dir='Model_10_kini1/' & dens=10e7  ;(orig KS05)
nreal=30000 & lrA=0 & lrB=0 & kini=2 & dir='Model_00_kini2/' & dens=10e7  ;(improved <-- black line)
nreal=30000 & lrA=0 & lrB=1 & kini=2 & dir='Model_01_kini2/' & dens=10e7  ;(Ximproved <-- green line)
nreal=30000 & lrA=0 & lrB=1 & kini=1 & dir='Model_01_kini1/' & dens=10e7  ;(Ximproved)
nreal=30000 & lrA=1 & lrB=1 & kini=2 & dir='Model_11_kini2_kend125/' & dens=10e7  ;()
;kend=125
nreal=30000 & lrA=1 & lrB=1 & kini=2 & kend=4000 & dir='Model_11_kini2_kend4000/' & dens=10e7  ;()
nreal=30000 & lrA=1 & lrB=1 & kini=1 & kend=4000 & dir='Model_11_kini1_kend4000/' & dens=10e7  ;()
nreal=3000 & lrA=1 & lrB=1 & kini=1L & kend=100000L & dir='Model_11_kini1_kend1e5/' & dens=10e7  ;()
nreal=3000 & lrA=1 & lrB=1 & kini=2L & kend=100000L & dir='Model_11_kini2_kend1e5/' & dens=10e7  ;()
;
nreal=1000000L & lrA=0 & lrB=0 & kini=2 & kend=125 & dir='Model_00_kini2_1M/' & dens=10e7  ;(improved <-- black line)
nreal=1000000L & lrA=1 & lrB=1 & kini=2 & kend=125 & dir='Model_11_kini2_1M/' & dens=10e7  ;(semi KS05 <-- red line)
nreal=1000000L & lrA=0 & lrB=1 & kini=2 & kend=125 & dir='Model_01_kini2_1M/' & dens=10e7  ;(Ximproved <-- green line)
nreal=1000000L & lrA=1 & lrB=1 & kini=1 & kend=125 & dir='Model_11_kini1_1M/' & dens=10e7  ;(orig KS05 <-- blue line)
;
nreal=10000000L & lrA=0 & lrB=0 & kini=2 & kend=125 & dir='Model_00_kini2_10M/' & dens=10e7  ;(improved <-- black line)
nreal=10000000L & lrA=0 & lrB=1 & kini=2 & kend=125 & dir='Model_01_kini2_10M/' & dens=10e7  ;(Ximproved <-- green line)
nreal=10000000L & lrA=1 & lrB=1 & kini=2 & kend=125 & dir='Model_11_kini2_10M/' & dens=10e7  ;(semi KS05 <-- red line)
nreal=10000000L & lrA=1 & lrB=1 & kini=1 & kend=125 & dir='Model_11_kini1_10M/' & dens=10e7  ;(orig KS05 <-- blue line)
;
nreal=100000000L & lrA=0 & lrB=0 & kini=2 & kend=125 & dir='Model_00_kini2_100M/' & dens=10e7  ;(improved <-- black line)
;nreal=100000000L & lrA=0 & lrB=1 & kini=2 & kend=125 & dir='Model_01_kini2_100M/' & dens=10e7  ;(Ximproved <-- green line)
;nreal=100000000L & lrA=1 & lrB=1 & kini=2 & kend=125 & dir='Model_11_kini2_100M/' & dens=10e7  ;(semi KS05 <-- red line)
;nreal=100000000L & lrA=1 & lrB=1 & kini=1 & kend=125 & dir='Model_11_kini1_100M/' & dens=10e7  ;(orig KS05 <-- blue line)
;
nreal=1000L & lrA=1 & lrB=1 & kini=2 & kend=125 & dir='Model_11_kini2_1k/' & dens=10e7  ;(improved <-- black line)
nreal=10000L & lrA=1 & lrB=1 & kini=2 & kend=125 & dir='Model_11_kini2_10k/' & dens=10e7  ;(improved <-- black line)
;
;  Model_11_kini1_100M:
;  Model_11_kini2_100M:
;
;  10M -> 22 min
;  100M -> 220 min ~ 4h
;
default,seed,124
spawn,'date'
;
fac=4.*!pi/3.
V0=fac*1e-5^3
a1=(V0/fac)^.3333333
;
g=9.81
rhoratio=1e3
nu=1e-5
;
t_arr=fltarr(nreal)
tt_arr=fltarr(nreal)
;
for ireal=0,nreal-1 do begin
;ran=abs(expnoise(kend,seed=seed))
ran=-alog(random(kend-kini+1,seed=seed))
if (ireal mod 500) eq 0 then print,'ireal=',ireal
;
V=V0
coeff=!pi*rhoratio*(2.*g)/(9.*nu)*dens
;
tt=0.
onethird=1./3.
for k=kini,kend do begin
  i=k-kini ;(array index)
  V=V+V0
  a=a1*k^onethird
  if lrB then rB2=a^2 else rB2=a^2-a1^2
  if lrA then rA2=a^2 else rA2=(a+a1)^2
  tauk=1./(coeff*rA2*rB2)
  tk=tauk*ran[i]
  tt=tt+tk
  if k eq kend then begin
    t_arr[ireal]=tk
    tt_arr[ireal]=tt
  endif
endfor
endfor
;
;  compute a pdf for each collision step
;
npdf=200 & xpdfmax=8000.
npdf=800 & xpdfmax=50000.
ttime=fltarr(npdf)
pprob=fltarr(npdf)
;
;  compute here unnormalized pdf
;
tend=reform(tt_arr)
pdf,tend,xx,yy,n=npdf,fmin=0.,fmax=xpdfmax
ttime=xx
pprob=yy
;
;  write result
;
tt_mean=total(ttime*pprob)/total(pprob)
wtable2,dir+'red_line_axel2.dat',ttime/tt_mean,pprob*tt_mean
wtable2,dir+'Red_line_axel2.dat',ttime,pprob
;
;  compute moments for log of normalized times
;
mean_tend=mean(tend)
print,'Tmin,Tmean=',min(tend),mean_tend
lnt=alog(tend/mean_tend)
lntm=mean(lnt)
lnt2m=mean((lnt-lntm)^2)
lnt3m=mean((lnt-lntm)^3)/lnt2m^1.5
lnt4m=mean((lnt-lntm)^4)/lnt2m^2-3.
print,lntm,lnt2m^.5,lnt3m,lnt4m
openw,1,dir+'lntm.dat'
printf,1,lntm,lnt2m^.5,lnt3m,lnt4m,'  ',dir
close,1
;save,file=dir+'lntm.sav',lntm,lnt2m^.5,lnt3m,lnt4m
;
spawn,'date'
END
