clear; startup;

% =========================================================================
% =========================================================================
%
% Matlab plotting scripts for the analysis of UKESM1 prepared for:
%
%   Yool, A., Palmiéri, J., Jones, C. G., de Mora, L., Kuhlbrodt, T., 
%   Popova, E. E., Nurser, A. J. G., Hirschi, J., Blaker, A. T., 
%	Coward, A. C., Blockley, E. W., and Sellar, A. A.: Evaluating the 
% 	physical and biogeochemical state of the global ocean component of 
%	UKESM1 in CMIP6 Historical simulations, Geosci. Model Dev. Discuss. 
%	[preprint], https://doi.org/10.5194/gmd-2020-333, in review, 2020.
%
%   Accepted for publication: 20 April 2021
%
% Note: scripts provided to document analysis, and may require editing to
% fully replicate plots in manuscript
%
% =========================================================================
% =========================================================================

% =========================================================================
%
% This script plots Supplementary Figure S13
%
% =========================================================================
% =========================================================================

load ukesm1_PD_ensemble

% =========================================================================

% load up background files
load nemo_area100e
load nemo_mask100e
fname = sprintf('%s/mean_nemo_%so_1y_20001201-20101201_grid-T.nc', dname(1).name, rname(1).name);
t1 = ncread(fname, 'deptht_bounds');
nemo_dep = double(t1(1,:)); nemo_dep(end+1) = double(t1(2,end));
t1 = ncread(fname, 'deptht');
nemo_mid = double(t1');

% total grid area
t1 = area100e + nemo_mask100e(:,:,1);
t2 = isfinite(t1);
tot_area100e = sum(t1(t2)); % m2

% extra mask to get rid of Mediterranean, Black and Caspian Seas
t1 = nemo_mask100e(:,:,1) + 1;
t1(isnan(t1)) = 0;
t1(235:249,283:344) = t1(235:249,283:344) + 2;
t1(249:262,291:344) = t1(249:262,291:344) + 4;
t1(262:276,330:344) = t1(262:276,330:344) + 8;
t2 = t1;
t2(t1 < 1) = NaN; t2(t1 > 1) = NaN;
med_mask100e = t2;

nxx = -179.5:1:179.5;  nyy = -89.5:1:89.5;
[lon100, lat100] = meshgrid(nxx, nyy);
nxx = -180:1:180;  nyy = -90:1:90;
[lon100b, lat100b] = meshgrid(nxx, nyy);
nxx = -179.5:2:179.5;  nyy = -89.5:2:89.5;
[lon200, lat200] = meshgrid(nxx, nyy);

load woa_mask
clear t1; t1(:,1:180) = woa_mask(:,181:360); t1(:,181:360) = woa_mask(:,1:180);
woa_mask = t1;

load woa_basin

helvetica;
pngopt = 0;

% =========================================================================

surf1 = [1 1 1 1]; surf2 = [362 332 31 1];

clear mod_zmi_ens mod_zme_ens mod_zmi mod_zme;

for e = 1:1:tsize
for m = 12:-1:1 % loop reversed to reach full size at first iteration
  fprintf('- Month %d\n', m);
  pnom = sprintf('%s/clim_medusa_%so_1m_2000%s-2009%s_ptrc-T.nc', dname(e).name, rname(e).name, numprint(m, 2), numprint(m, 2));
  dnom = sprintf('%s/clim_medusa_%so_1m_2000%s-2009%s_diad-T.nc', dname(e).name, rname(e).name, numprint(m, 2), numprint(m, 2));
  fprintf('- Reading %s\n', pnom);
  % ZMI, ZME; mg C / m3
  t1 = ncread(pnom, 'ZMI', surf1, surf2); t2 = permute(t1, [2 1 3]); mod_zmi_ens(:,:,:,m,e) = t2 * 5.625 * 12.011;
  t1 = ncread(pnom, 'ZME', surf1, surf2); t2 = permute(t1, [2 1 3]); mod_zme_ens(:,:,:,m,e) = t2 * 5.625 * 12.011;
end
end

mod_zmi = mean(mod_zmi_ens, 5);
mod_zme = mean(mod_zme_ens, 5);

mod_zmi_std = std(mod_zmi_ens, [], 5);
mod_zme_std = std(mod_zme_ens, [], 5);

mod_zmi_cov = mod_zmi_std ./ mod_zmi;
mod_zme_cov = mod_zme_std ./ mod_zme;

% integrate to 200m (technically 210m) average
clear int_zmi_ens int_zme_ens;
nemo_thk = nemo_dep(2:end) - nemo_dep(1:end-1);
for e = 1:1:tsize
for m = 1:1:12
  tot_zmi = mod_zmi_ens(:,:,1,1,e) * 0;
  tot_zme = mod_zme_ens(:,:,1,1,e) * 0;
  for k = 1:1:31
    t0 = mod_zmi_ens(:,:,k,m,e); t0(isnan(t0)) = 0;
    tot_zmi = tot_zmi + t0 * nemo_thk(k);
    t0 = mod_zme_ens(:,:,k,m,e); t0(isnan(t0)) = 0;
    tot_zme = tot_zme + t0 * nemo_thk(k);
  end
  int_zmi_ens(:,:,m,e) = tot_zmi;
  int_zme_ens(:,:,m,e) = tot_zme;
end
end

avg_zmi_ens = int_zmi_ens / nemo_dep(32);
avg_zme_ens = int_zme_ens / nemo_dep(32);

% monthly zoo averaged over ensemble
avg_zmi = mean(avg_zmi_ens, 4);
avg_zme = mean(avg_zme_ens, 4);

% monthly st. dev. zoo over ensemble
std_zmi = std(avg_zmi_ens, [], 4);
std_zme = std(avg_zme_ens, [], 4);

% monthly CoV zoo over ensemble
cov_zmi = std_zmi ./ avg_zmi;
cov_zme = std_zme ./ avg_zme;

% annual mean zoo for ensemble
ann_avg_zmi = squeeze(mean(avg_zmi_ens, 3));
ann_avg_zme = squeeze(mean(avg_zme_ens, 3));

% st. dev. of annual mean zoo over ensemble
ann_std_zmi = std(ann_avg_zmi, [], 3);
ann_std_zme = std(ann_avg_zme, [], 3);

% CoV of annual mean zoo over ensemble
ann_cov_zmi = ann_std_zmi ./ mean(avg_zmi, 3);
ann_cov_zme = ann_std_zme ./ mean(avg_zme, 3);
% I think that *this* is finally what I want

% =========================================================================

load copepod_2012_data

% =========================================================================

lon_rng = [-180 180]; lat_rng = [-90 90];

% gpos = [-0.025 -0.05 0.10 0.10; -0.025 -0.05 0.10 0.10; -0.025 0.0 0.10 0.10; -0.025 0.0 0.10 0.10];
gpos = [-0.075 -0.05 0.135 0.1; -0.05 -0.05 0.135 0.1; -0.075 0.0 0.135 0.1; -0.05 0.0 0.135 0.1];

djf = [12 1 2]; jja = [6 7 8];

load coast

% Mesozooplankton
tstr = char('Observed, JJA', 'Observed, DJF', 'Simulated, JJA', 'Simulated, DJF');
clear m1 o1; 
v = 4; o1(:,:,1) = nanmean(zoo200(:,:,jja), 3); o1(:,:,2) = nanmean(zoo200(:,:,djf), 3);
v = 5; m1(:,:,1) = mean(avg_zme(:,:,jja), 3); m1(:,:,2) = mean(avg_zme(:,:,djf), 3);
figure(1); clf; turbo(60);
pvar = [1 3]; for i = 1:1:2, subplot(2,2,pvar(i));
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat200, lon200, o1(:,:,i));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([0 30]);
  pos = get(gca, 'Position'); pos = pos + gpos(pvar(i),:); set(gca, 'Position', pos);
  tl = title (tstr(i,:)); tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.5; set(tl, 'Position', tlp);
end
pvar = [2 4]; for i = 1:1:2, subplot(2,2,pvar(i));
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, m1(:,:,i));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([0 30]);
  pos = get(gca, 'Position'); pos = pos + gpos(pvar(i),:); set(gca, 'Position', pos);
  tl = title (tstr(i+2,:)); tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.5; set(tl, 'Position', tlp);
  if pvar(i) == 4, cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos); end
end
def_figure; oname = sprintf('FIGS/ukesm1_PD_obs_mod_zoo_01.png'); exportgraphics(gcf, oname, 'Resolution', 600);  

% regrid model mesozoo to regular grid ready for zonal average
load woa_mask2

clear new_zme m1;
m1(:,:,1) = mean(avg_zme(:,:,jja), 3); m1(:,:,2) = mean(avg_zme(:,:,djf), 3);
m1(isnan(m1)) = 0;
q1 = scatregrid(yy100e, xx100e, m1(:,:,1), lat100, lon100);
new_zme(:,:,1) = q1 + woa_mask2;
q1 = scatregrid(yy100e, xx100e, m1(:,:,2), lat100, lon100);
new_zme(:,:,2) = q1 + woa_mask2;

nyy100 = -89.5:1:89.5; nyy200 = -89:2:89;

gpos = [-0.075 -0.05 0.135 0.1; -0.05 -0.05 0.135 0.1; -0.075 0.0 0.135 0.1; -0.05 0.0 0.135 0.1];

% Mesozooplankton
tstr = char('Observed, annual', 'Observed, DJF', 'Simulated, annual', 'Simulated, DJF');
clear m1 o1; 
o1(:,:,1) = zoo200(:,:,13);
m1(:,:,1) = mean(avg_zme, 3); 
figure(1); clf; turbo(60);
pvar = [1 3]; for i = 1:1:1, subplot(2,2,pvar(i));
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat200, lon200, o1(:,:,i));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([0 30]);
  pos = get(gca, 'Position'); pos = pos + gpos(pvar(i),:); set(gca, 'Position', pos);
  tl = title (tstr(i,:)); tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.5; set(tl, 'Position', tlp);
end
pvar = [2 4]; for i = 1:1:1, subplot(2,2,pvar(i));
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, m1(:,:,i));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([0 30]);
  pos = get(gca, 'Position'); pos = pos + gpos(pvar(i),:); set(gca, 'Position', pos);
  tl = title (tstr(i+2,:)); tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.5; set(tl, 'Position', tlp);
  if pvar(i) == 2, cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos); end
end
o0 = nanmean(zoo100(:,:,jja), 3); o1 = nanmean(o0, 2); m1 = nanmean(new_zme(:,:,1), 2);
subplot (2,2,3);
plot (nyy100, o1, 'r.', nyy100, m1, 'b-');
axis ([-90 90 0 28]); set(gca, 'XTick', -90:30:90, 'YTick', 0:20:60);
xlabel ('Latitude [{\circ}N]'); ylabel ('Biomass [mg C m^{-3}]');
title ('JJA');
o0 = nanmean(zoo100(:,:,djf), 3); o1 = nanmean(o0, 2); m1 = nanmean(new_zme(:,:,2), 2);
subplot (2,2,4);
plot (nyy100, o1, 'r.', nyy100, m1, 'b-');
axis ([-90 90 0 28]); set(gca, 'XTick', -90:30:90, 'YTick', 0:20:60);
xlabel ('Latitude [{\circ}N]'); ylabel ('Biomass [mg C m^{-3}]');
title ('DJF');
legend ('Observed', 'Simulated', 'Location', 'NorthEast');
def_figure; oname = sprintf('FIGS/ukesm1_PD_obs_mod_zoo_02.png'); exportgraphics(gcf, oname, 'Resolution', 600);  

% Mesozooplankton
tstr = char('Observed, annual', 'Observed, DJF', 'Simulated, annual', 'Simulated, DJF');
clear m1 o1; 
o1(:,:,1) = zoo100(:,:,13);
m1(:,:,1) = mean(avg_zme, 3); 
figure(1); clf; turbo(60);
pvar = [1 3]; for i = 1:1:1, subplot(2,2,pvar(i));
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100, lon100, o1(:,:,i));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([0 30]);
  pos = get(gca, 'Position'); pos = pos + gpos(pvar(i),:); set(gca, 'Position', pos);
  tl = title (tstr(i,:)); tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.5; set(tl, 'Position', tlp);
end
pvar = [2 4]; for i = 1:1:1, subplot(2,2,pvar(i));
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, m1(:,:,i));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([0 30]);
  pos = get(gca, 'Position'); pos = pos + gpos(pvar(i),:); set(gca, 'Position', pos);
  tl = title (tstr(i+2,:)); tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.5; set(tl, 'Position', tlp);
  if pvar(i) == 2, cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos); end
end
o0 = nanmean(zoo100(:,:,jja), 3); o1 = nanmean(o0, 2); m1 = nanmean(new_zme(:,:,1), 2);
subplot (2,2,3);
plot (nyy100, o1, 'r.', nyy100, m1, 'b-');
axis ([-90 90 0 28]); set(gca, 'XTick', -90:30:90, 'YTick', 0:20:60);
xlabel ('Latitude [{\circ}N]'); ylabel ('Biomass [mg C m^{-3}]');
title ('JJA');
o0 = nanmean(zoo100(:,:,djf), 3); o1 = nanmean(o0, 2); m1 = nanmean(new_zme(:,:,2), 2);
subplot (2,2,4);
plot (nyy100, o1, 'r.', nyy100, m1, 'b-');
axis ([-90 90 0 28]); set(gca, 'XTick', -90:30:90, 'YTick', 0:20:60);
xlabel ('Latitude [{\circ}N]'); ylabel ('Biomass [mg C m^{-3}]');
title ('DJF');
legend ('Observed', 'Simulated', 'Location', 'NorthEast');
def_figure; oname = sprintf('FIGS/ukesm1_PD_obs_mod_zoo_03.png'); exportgraphics(gcf, oname, 'Resolution', 600);  

clear new_zme m1;
m1(:,:,1) = mean(avg_zme(:,:,1:12), 3); 
m1(isnan(m1)) = 0;
q1 = scatregrid(yy100e, xx100e, m1, lat100, lon100);
new_zme = q1 + woa_mask2;

% Mesozooplankton
tstr = char('Observed, annual', 'Observed, DJF', 'Simulated, annual', 'Simulated, DJF');
clear m1 o1; 
o1(:,:,1) = zoo200(:,:,13);
m1(:,:,1) = mean(avg_zme, 3); 
figure(1); clf; turbo(60);
pvar = [1 3]; for i = 1:1:1, subplot(2,2,pvar(i));
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat200, lon200, o1(:,:,i));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([0 30]);
  pos = get(gca, 'Position'); pos = pos + gpos(pvar(i),:); set(gca, 'Position', pos);
  tl = title (tstr(i,:)); tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.5; set(tl, 'Position', tlp);
end
pvar = [2 4]; for i = 1:1:1, subplot(2,2,pvar(i));
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, m1(:,:,i));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([0 30]);
  pos = get(gca, 'Position'); pos = pos + gpos(pvar(i),:); set(gca, 'Position', pos);
  tl = title ('Ensemble, annual, mean'); tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.5; set(tl, 'Position', tlp);
  if pvar(i) == 2, cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos); end
end
o0 = nanmean(zoo100(:,:,13), 3); o1 = nanmean(o0, 2); m1 = nanmean(new_zme, 2);
subplot (2,2,3);
plot (nyy100, o1, 'r.', nyy100, m1, 'b-');
axis ([-90 90 0 28]); set(gca, 'XTick', -90:30:90, 'YTick', 0:20:60);
xlabel ('Latitude [{\circ}N]'); ylabel ('Biomass [mg C m^{-3}]');
title ('Annual');
legend ('Observed', 'Simulated', 'Location', 'NorthEast');
m1 = ann_cov_zme;
pvar = [4]; for i = 1:1:1, subplot(2,2,pvar(i));
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, m1);
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([0 1.5]);
  pos = get(gca, 'Position'); pos = pos + gpos(pvar(i),:); set(gca, 'Position', pos);
  tl = title ('Ensemble, annual, CoV'); tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.5; set(tl, 'Position', tlp);
  if pvar(i) == 4, cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos); end
end
def_figure; oname = sprintf('FIGS/ukesm1_PD_obs_mod_zoo_04.png'); exportgraphics(gcf, oname, 'Resolution', 600);  
