clear; startup;

% =========================================================================
% =========================================================================
%
% Matlab plotting scripts for the analysis of UKESM1 prepared for:
%
%   Yool, A., Palmiéri, J., Jones, C. G., de Mora, L., Kuhlbrodt, T., 
%   Popova, E. E., Nurser, A. J. G., Hirschi, J., Blaker, A. T., 
%	Coward, A. C., Blockley, E. W., and Sellar, A. A.: Evaluating the 
% 	physical and biogeochemical state of the global ocean component of 
%	UKESM1 in CMIP6 Historical simulations, Geosci. Model Dev. Discuss. 
%	[preprint], https://doi.org/10.5194/gmd-2020-333, in review, 2020.
%
%   Accepted for publication: 20 April 2021
%
% Note: scripts provided to document analysis, and may require editing to
% fully replicate plots in manuscript
%
% =========================================================================
% =========================================================================

% =========================================================================
%
% This script plots Supplementary Figure S9
%
% =========================================================================
% =========================================================================

load ukesm1_PD_ensemble

% =========================================================================

% load up background files
load nemo_area100e
load nemo_mask100e
fname = sprintf('%s/mean_nemo_%so_1y_20001201-20101201_grid-T.nc', dname(1).name, rname(1).name);
t1 = ncread(fname, 'deptht_bounds');
nemo_dep = double(t1(1,:)); nemo_dep(end+1) = double(t1(2,end));
t1 = ncread(fname, 'deptht');
nemo_mid = double(t1');

% total grid area
t1 = area100e + nemo_mask100e(:,:,1);
t2 = isfinite(t1);
tot_area100e = sum(t1(t2)); % m2

% extra mask to get rid of Mediterranean, Black and Caspian Seas
t1 = nemo_mask100e(:,:,1) + 1;
t1(isnan(t1)) = 0;
t1(235:249,283:344) = t1(235:249,283:344) + 2;
t1(249:262,291:344) = t1(249:262,291:344) + 4;
t1(262:276,330:344) = t1(262:276,330:344) + 8;
t2 = t1;
t2(t1 < 1) = NaN; t2(t1 > 1) = NaN;
med_mask100e = t2;

nxx = -179.5:1:179.5;  nyy = -89.5:1:89.5;
[lon100, lat100] = meshgrid(nxx, nyy);
nxx = -180:1:180;  nyy = -90:1:90;
[lon100b, lat100b] = meshgrid(nxx, nyy);

load woa_mask
clear t1; t1(:,1:180) = woa_mask(:,181:360); t1(:,181:360) = woa_mask(:,1:180);
woa_mask = t1;

load woa_basin

helvetica;
pngopt = 0;

% =========================================================================

% load up model data
load ukesm1_PD_output_27nov19

% load up observational data

load obs_2d_seas_moll_states_2019.mat

% =========================================================================

% to use this script, need to first regrid to regular 1-degree
use_surf(:,:,:,1) = seas_states_2d(:,:,:,1);
use_surf(:,:,:,2) = seas_states_2d(:,:,:,2);
use_surf(:,:,:,3) = seas_states_2d(:,:,:,4);
use_surf(:,:,:,4) = seas_states_2d(:,:,:,5);
use_surf(:,:,:,5) = seas_states_2d(:,:,:,8);
use_surf(:,:,:,6) = seas_states_2d(:,:,:,9);
use_surf(:,:,:,7) = seas_states_2d(:,:,:,14);

woalat = repmat([-89.5:1:89.5]', [1 360]);
woalon = repmat([-179.5:1:179.5], [180 1]);

for f = 1:1:7
  for m = 1:1:5
    t0 = use_surf(2:1:end-1,2:1:end-1,m,f);
    t1 = [t0 t0 t0];
    x = xx100e(2:1:end-1,2:1:end-1); x1 = [(x - 360) x (x + 360)];
    y = yy100e(2:1:end-1,2:1:end-1); y1 = [(y - 360) y (y + 360)];
    t2 = isfinite(t1);
    tq = t1(t2);
    xq = x1(t2);
    yq = y1(t2);
    F = scatteredInterpolant(xq, yq, tq);
    t3 = F(woalon, woalat);
    use_surf2(:,:,m,f) = t3 + woa_mask;
  end
end

% =========================================================================

path(path, '/noc/users/axy/Matlab/GLODAP_v2');

% GLODAPv2
load per_m3_fields

use_obs2 = moll_obs_2d(:,:,:,1:3);
t1 = mean(moll_obs_2d(:,:,:,4:6), 4);
use_obs2(:,:,:,4) = t1;
use_obs2(:,:,:,5) = repmat(new_totco2(:,:,1), [1 1 5]);
use_obs2(:,:,:,6) = repmat(new_totalk(:,:,1), [1 1 5]);

% =========================================================================

addpath('/noc/users/axy/Matlab/Datasets/Rodenbeck');
addpath('/noc/users/axy/Matlab/Datasets/DMS');

load rodenbeck_1982-2017_monthly_CO2_WOAgrid.mat

t1 = rg_mon_flux(:,:,:,18:27);
clear obs_flux; for m = 1:1:12, obs_flux(:,:,m) = mean(t1(:,:,m,:), 4); end

seas = [3 4 5; 6 7 8; 9 10 11; 12 1 2];

conv1 = (-1 * 1e15 * 1e-3 / 12.011 / 360 );

for s = 1:1:5
  if s < 5, want_seas = seas(s,:); else, want_seas = 1:1:12; end
  t1 = obs_flux(:,:,want_seas);
  t2 = mean(t1, 3);
  use_obs2(:,:,s,7) = (t2 * conv1) + woa_basin2(:,:,1);
end

% =========================================================================

t1 = grid_area([-90:1:90], [-180:1:180]);
warea = t1(1:end-1,1:end-1);

clear obs_avg obs_std mod_avg mod_std obs_mod_corrcoef obs_mod_rmserror
for f = 1:1:7
  for m = 1:1:5
    for b = 1:1:6
      o1 = use_obs2(:,:,m,f) + woa_basin2(:,:,b);
      m1 = use_surf2(:,:,m,f) + woa_basin2(:,:,b);
      q1 = isnan(o1); q2 = isnan(m1);
      o1(q2) = NaN; m1(q1) = NaN;
      w1 = warea; w1(isnan(o1)) = NaN;
      vdat = isfinite(o1);
      if sum(vdat(:)) > 0
        %
        d = o1(vdat);
        x = m1(vdat);
        w = w1(vdat);
        %
        tot = sum(d .* w); totw = sum(w); wavgd = tot / totw;
        s1 = d - wavgd; s2 = s1 .* s1; s3 = s2 .* w; s4 = sum(s3(:));
        s5 = sum(w(:)); s6 = s4 ./ s5; s7 = s6 .^ 0.5; wstdd = s7;
        %
        tot = sum(x .* w); totw = sum(w); wavgx = tot / totw;
        s1 = x - wavgx; s2 = s1 .* s1; s3 = s2 .* w; s4 = sum(s3(:));
        s5 = sum(w(:)); s6 = s4 ./ s5; s7 = s6 .^ 0.5; wstdx = s7;
        %
        r1 = d - wmean(d(:), w(:)); r2 = x - wmean(x(:), w(:));
        r3 = r1 .* r2; r4 = r3 .* w;
        r5 = sum(w(:)); r6 = sum(r4(:)) / r5; r7 = r6 / (wstdd * wstdx);
        %
        p1 = ((x - d).^2); p2 = wmean(p1(:), w(:)); p3 = p2 .^ 0.5;
        %
        obs_avg(b,m,f) = wavgd; obs_std(b,m,f) = wstdd;
        mod_avg(b,m,f) = wavgx; mod_std(b,m,f) = wstdx;
        obs_mod_corrcoef(b,m,f) = r7;
        obs_mod_rmserror(b,m,f) = p3;
      end
    end
  end
end

bnom = char('World', 'Atlantic', 'Pacific', 'Indian', 'Southern', 'Arctic');
mnom = char('MAM', 'JJA', 'SON', 'DJF', 'Ann');
mbnom = char('MAM', 'JJA', 'SON', 'DJF', 'Ann', 'Atlantic', 'Pacific', 'Indian', 'Southern', 'Arctic');

fnom = char('Dissolved inorganic nitrogen', 'Silicic acid', 'Chlorophyll', ...
  'Primary production (mean)', 'Dissolved inorganic carbon', 'Alkalinity', 'Air-sea CO_{2} flux');
for f = 1:1:7, flen(f) = lenstr(fnom(f,:)); end

for f = 1:1:7
  tstr = sprintf('%s', fnom(f,1:flen(f)));
  % do time (global average) second
  o1 = obs_std(2:6,:,f); o2 = o1(:);
  m1 = mod_std(2:6,:,f); m2 = m1(:);
  r1 = obs_mod_corrcoef(2:6,:,f);
  if f == 5 | f == 6, r1(:,2:5) = -1; end;
  r1(isnan(r1)) = -1; r2 = r1(:);
  figure(1); clf; def_figure; hold on;
  [h1, lg] = taydiag_apr2020(m2(:)./o2(:), 1, r2(:), 1, mbnom(:,:), tstr, 2);
  oname = sprintf('FIGS/ukesm1_PD_bgc_taylor_0%db.png', f); exportgraphics(gcf, oname, 'Resolution', 600);  
  set(lg, 'Visible', 'off');
  oname = sprintf('FIGS/ukesm1_PD_bgc_taylor_NOLEG_0%db.png', f); exportgraphics(gcf, oname, 'Resolution', 600);  
end

% =========================================================================

t1 = grid_area([-90:1:90], [-180:1:180]);
warea = t1(1:end-1,1:end-1);

clear obs_avg obs_std mod_avg mod_std obs_mod_corrcoef obs_mod_rmserror
for f = 1:1:7
  for m = 1:1:5
    if m < 5
      n1 = m; s1 = m + 2; if s1 > 4, s1 = s1 - 4; end
      o0n = use_obs2(:,:,n1,f); o0s = use_obs2(:,:,s1,f); o0(1:90,:) = o0s(1:90,:); o0(91:180,:) = o0n(91:180,:); 
      m0n = use_surf2(:,:,n1,f); m0s = use_surf2(:,:,s1,f); m0(1:90,:) = m0s(1:90,:); m0(91:180,:) = m0n(91:180,:); 
    else
      o0 = use_obs2(:,:,m,f); m0 = use_surf2(:,:,m,f);
    end
    if f == 5 | f == 6, m0 = use_surf2(:,:,5,f); end
    for b = 1:1:6
      o1 = o0 + woa_basin2(:,:,b);
      m1 = m0 + woa_basin2(:,:,b);
      q1 = isnan(o1); q2 = isnan(m1);
      o1(q2) = NaN; m1(q1) = NaN;
      w1 = warea; w1(isnan(o1)) = NaN;
      vdat = isfinite(o1);
      if sum(vdat(:)) > 0
        %
        d = o1(vdat);
        x = m1(vdat);
        w = w1(vdat);
        %
        tot = sum(d .* w); totw = sum(w); wavgd = tot / totw;
        s1 = d - wavgd; s2 = s1 .* s1; s3 = s2 .* w; s4 = sum(s3(:));
        s5 = sum(w(:)); s6 = s4 ./ s5; s7 = s6 .^ 0.5; wstdd = s7;
        %
        tot = sum(x .* w); totw = sum(w); wavgx = tot / totw;
        s1 = x - wavgx; s2 = s1 .* s1; s3 = s2 .* w; s4 = sum(s3(:));
        s5 = sum(w(:)); s6 = s4 ./ s5; s7 = s6 .^ 0.5; wstdx = s7;
        %
        r1 = d - wmean(d(:), w(:)); r2 = x - wmean(x(:), w(:));
        r3 = r1 .* r2; r4 = r3 .* w;
        r5 = sum(w(:)); r6 = sum(r4(:)) / r5; r7 = r6 / (wstdd * wstdx);
        %
        p1 = ((x - d).^2); p2 = wmean(p1(:), w(:)); p3 = p2 .^ 0.5;
        %
        obs_avg(b,m,f) = wavgd; obs_std(b,m,f) = wstdd;
        mod_avg(b,m,f) = wavgx; mod_std(b,m,f) = wstdx;
        obs_mod_corrcoef(b,m,f) = r7;
        obs_mod_rmserror(b,m,f) = p3;
      end
    end
  end
end

bnom = char('World', 'Atlantic', 'Pacific', 'Indian', 'Southern', 'Arctic');
mnom = char('MAM', 'JJA', 'SON', 'DJF', 'Ann');
mbnom = char('Spring', 'Summer', 'Autumn', 'Winter', 'Annual', 'Atlantic', 'Pacific', 'Indian', 'Southern', 'Arctic');

fnom = char('Surface DIN', 'Surface silicic acid', 'Surface chlorophyll', ...
  'Primary production', 'Surface DIC', 'Surface alkalinity', 'Air-sea CO_{2} flux');
for f = 1:1:7, flen(f) = lenstr(fnom(f,:)); end

for f = 1:1:7
  tstr = sprintf('%s', fnom(f,1:flen(f)));
  % do time (global average) second
  o1 = obs_std(2:6,:,f); o2 = o1(:); o2(o2 == 0) = NaN;
  m1 = mod_std(2:6,:,f); m2 = m1(:); m2(m2 == 0) = NaN;
  r1 = obs_mod_corrcoef(2:6,:,f); max(r1(:));
  if f == 5 | f == 6, m2(6:25) = -1; end;
  r1(isnan(r1)) = -1; r2 = r1(:);
  r2(r2 < 0) = 0;
  figure(f); clf; def_figure; hold on;
  if f == 2, smax = 5; else, smax = 2; end;
  [h1, lg] = taydiag_apr2020(m2(:)./o2(:), 1, r2(:), 1, mbnom(:,:), tstr, smax);
  % lgpos = get(lg, 'OuterPosition'); lgpos(3) = lgpos(3) * 1.2; set(lg, 'OuterPosition', lgpos);
  oname = sprintf('FIGS/ukesm1_PD_bgc_taylor_SYNC_0%db.png', f); exportgraphics(gcf, oname, 'Resolution', 600);  
  set(lg, 'Visible', 'off');
  oname = sprintf('FIGS/ukesm1_PD_bgc_taylor_SYNC_NOLEG_0%db.png', f); exportgraphics(gcf, oname, 'Resolution', 600);  
end

for f = 1:1:7
  tstr = sprintf('%s', fnom(f,1:flen(f)));
  % do time (global average) second
  o1 = obs_std(2:6,:,f); o2 = o1(:); o2(o2 == 0) = NaN;
  m1 = mod_std(2:6,:,f); m2 = m1(:); m2(m2 == 0) = NaN;
  r1 = obs_mod_corrcoef(2:6,:,f); max(r1(:));
  mo2 = m2 ./ o2;
  fprintf('f = %d, max = %4.3f\n', f, nanmax(mo2(:)));
end

% =========================================================================
% =========================================================================

t1 = grid_area([-90:1:90], [-180:1:180]);
warea = t1(1:end-1,1:end-1);

% new masks
clear msk;
q1 = woa_basin2(:,:,1); msk(:,:,1) = q1;
q1 = woa_basin2(:,:,5); msk(:,:,2) = q1;
q0 = woa_basin2(:,:,2); 
q1 = q0; q1(lat100 > -10) = NaN; msk(:,:,3) = q1;
q1 = q0; q1(lat100 < -10) = NaN; q1(lat100 > 10) = NaN; msk(:,:,4) = q1;
q1 = q0; q1(lat100 < 10) = NaN; q1(lat100 > 40) = NaN; msk(:,:,5) = q1;
q1 = q0; q1(lat100 < 40) = NaN; msk(:,:,6) = q1;
q0 = woa_basin2(:,:,3); % t1 = woa_basin2(:,:,4); q0(isfinite(t1)) = 0;
q1 = q0; q1(lat100 > -10) = NaN; msk(:,:,7) = q1;
q1 = q0; q1(lat100 < -10) = NaN; q1(lat100 > 10) = NaN; msk(:,:,8) = q1;
q1 = q0; q1(lat100 < 10) = NaN; q1(lat100 > 40) = NaN; msk(:,:,9) = q1;
q1 = q0; q1(lat100 < 40) = NaN; msk(:,:,10) = q1;
q1 = woa_basin2(:,:,6); msk(:,:,11) = q1;

clear obs_avg obs_std mod_avg mod_std obs_mod_corrcoef obs_mod_rmserror
for f = 1:1:7
  for m = 1:1:5
    if m < 5
      n1 = m; s1 = m + 2; if s1 > 4, s1 = s1 - 4; end
      o0n = use_obs2(:,:,n1,f); o0s = use_obs2(:,:,s1,f); o0(1:90,:) = o0s(1:90,:); o0(91:180,:) = o0n(91:180,:); 
      m0n = use_surf2(:,:,n1,f); m0s = use_surf2(:,:,s1,f); m0(1:90,:) = m0s(1:90,:); m0(91:180,:) = m0n(91:180,:); 
    else
      o0 = use_obs2(:,:,m,f); m0 = use_surf2(:,:,m,f);
    end
    if f == 5 | f == 6, m0 = use_surf2(:,:,5,f); end
    for b = 1:1:11
      o1 = o0 + msk(:,:,b);
      m1 = m0 + msk(:,:,b);
      q1 = isnan(o1); q2 = isnan(m1);
      o1(q2) = NaN; m1(q1) = NaN;
      w1 = warea; w1(isnan(o1)) = NaN;
      vdat = isfinite(o1);
      if sum(vdat(:)) > 0
        %
        d = o1(vdat);
        x = m1(vdat);
        w = w1(vdat);
        %
        tot = sum(d .* w); totw = sum(w); wavgd = tot / totw; totd = tot; aread = totw;
        s1 = d - wavgd; s2 = s1 .* s1; s3 = s2 .* w; s4 = sum(s3(:));
        s5 = sum(w(:)); s6 = s4 ./ s5; s7 = s6 .^ 0.5; wstdd = s7;
        %
        tot = sum(x .* w); totw = sum(w); wavgx = tot / totw; totx = tot; areax = totw;
        s1 = x - wavgx; s2 = s1 .* s1; s3 = s2 .* w; s4 = sum(s3(:));
        s5 = sum(w(:)); s6 = s4 ./ s5; s7 = s6 .^ 0.5; wstdx = s7;
        %
        r1 = d - wmean(d(:), w(:)); r2 = x - wmean(x(:), w(:));
        r3 = r1 .* r2; r4 = r3 .* w;
        r5 = sum(w(:)); r6 = sum(r4(:)) / r5; r7 = r6 / (wstdd * wstdx);
        %
        p1 = ((x - d).^2); p2 = wmean(p1(:), w(:)); p3 = p2 .^ 0.5;
        %
        obs_avg(b,m,f) = wavgd; obs_std(b,m,f) = wstdd;
        mod_avg(b,m,f) = wavgx; mod_std(b,m,f) = wstdx;
        obs_mod_corrcoef(b,m,f) = r7;
        obs_mod_rmserror(b,m,f) = p3;
        obs_tot(b,m,f) = totd; mod_tot(b,m,f) = totx;
        obs_area(b,m,f) = aread; mod_area(b,m,f) = areax;
      end
    end
  end
end

bnom = char('World', 'Southern', 'Subtrop. S. Atl.', 'Eq. Atlantic', 'Subtrop. N. Atl.', 'Subpol. N. Atl.', ...
  'Subtrop. S. Pac.', 'Eq. Pacific', 'Subtrop. N. Pac.', 'Subpol. N. Pac.', 'Arctic');
mnom = char('MAM', 'JJA', 'SON', 'DJF', 'Ann');

fnom = char('Surface DIN', 'Surface silicic acid', 'Surface chlorophyll', ...
  'Primary production', 'Surface DIC', 'Surface alkalinity', 'Air-sea CO_{2} flux');
for f = 1:1:7, flen(f) = lenstr(fnom(f,:)); end

fprintf('\t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \n', 1:11);
for f = 1:1:7
  fprintf('%s\n', fnom(f,1:flen(f)));
  t1 = obs_avg(:,5,f);
  if f == 5 | f == 6, t1 = round(t1); fprintf('Observed\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \n', t1);
  else, fprintf('Observed &\t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \n', t1); end
  t1 = mod_avg(:,5,f);
  if f == 5 | f == 6, t1 = round(t1); fprintf('Model   \t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \n', t1);
  else, fprintf('Model  & \t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \t%4.3f & \n', t1); end
end


  
    fprintf('%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \t\t%d & \n', t1);
