clear; startup;

% =========================================================================
% =========================================================================
%
% Matlab plotting scripts for the analysis of UKESM1 prepared for:
%
%   Yool, A., Palmiéri, J., Jones, C. G., de Mora, L., Kuhlbrodt, T., 
%   Popova, E. E., Nurser, A. J. G., Hirschi, J., Blaker, A. T., 
%	Coward, A. C., Blockley, E. W., and Sellar, A. A.: Evaluating the 
% 	physical and biogeochemical state of the global ocean component of 
%	UKESM1 in CMIP6 Historical simulations, Geosci. Model Dev. Discuss. 
%	[preprint], https://doi.org/10.5194/gmd-2020-333, in review, 2020.
%
%   Accepted for publication: 20 April 2021
%
% Note: scripts provided to document analysis, and may require editing to
% fully replicate plots in manuscript
%
% =========================================================================
% =========================================================================

% =========================================================================
%
% This script plots Figure 8
%
% =========================================================================

% =========================================================================

load ukesm1_PD_ensemble

% =========================================================================

% load up background files
load nemo_area100e
load nemo_mask100e
fname = sprintf('%s/mean_nemo_%so_1y_20001201-20101201_grid-T.nc', dname(1).name, rname(1).name);
t1 = ncread(fname, 'deptht_bounds');
nemo_dep = double(t1(1,:)); nemo_dep(end+1) = double(t1(2,end));
t1 = ncread(fname, 'deptht');
nemo_mid = double(t1');

% total grid area
t1 = area100e + nemo_mask100e(:,:,1);
t2 = isfinite(t1);
tot_area100e = sum(t1(t2)); % m2

% extra mask to get rid of Mediterranean, Black and Caspian Seas
t1 = nemo_mask100e(:,:,1) + 1;
t1(isnan(t1)) = 0;
t1(235:249,283:344) = t1(235:249,283:344) + 2;
t1(249:262,291:344) = t1(249:262,291:344) + 4;
t1(262:276,330:344) = t1(262:276,330:344) + 8;
t2 = t1;
t2(t1 < 1) = NaN; t2(t1 > 1) = NaN;
med_mask100e = t2;

nxx = -179.5:1:179.5;  nyy = -89.5:1:89.5;
[lon100, lat100] = meshgrid(nxx, nyy);
nxx = -180:1:180;  nyy = -90:1:90;
[lon100b, lat100b] = meshgrid(nxx, nyy);

load woa_mask
clear t1; t1(:,1:180) = woa_mask(:,181:360); t1(:,181:360) = woa_mask(:,1:180);
woa_mask = t1;

load woa_basin

helvetica;
pngopt = 0;

% =========================================================================

clear gbl_msf atl_msf pac_msf;

for r = 1:1:9
  fnom = sprintf('mean_nemo_%so_1y_20001201-20101201_diaptr.nc', rname(r).name);
  if r == 1, zon_lat = ncread(fnom, 'nav_lat'); zon_dep = ncread(fnom, 'deptht') / 1e3; end
  gbl_msf(:,:,r) = permute(ncread(fnom, 'zomsfglo'), [3 2 1]);
  atl_msf(:,:,r) = permute(ncread(fnom, 'zomsfatl'), [3 2 1]);
  pac_msf(:,:,r) = gbl_msf(:,:,r) - atl_msf(:,:,r);
  pac_msf(:,1:134,r) = 0;
end

avg_gbl_msf = mean(gbl_msf, 3);
avg_atl_msf = mean(atl_msf, 3);
avg_pac_msf = mean(pac_msf, 3);

std_gbl_msf = std(gbl_msf, [], 3);
std_atl_msf = std(atl_msf, [], 3);
std_pac_msf = std(pac_msf, [], 3);

cov_gbl_msf = std_gbl_msf ./ avg_gbl_msf;
cov_atl_msf = std_atl_msf ./ avg_atl_msf;
cov_pac_msf = std_pac_msf ./ avg_pac_msf;

zon_lat(end) = zon_lat(end) + 1e-4;

figure(1); clf; therm6(41);
subplot (2,1,1);
msf1 = avg_gbl_msf;
[C,h] = contourf(zon_lat,zon_dep, msf1, [-40:2:40]);
hold on
gbl_msf_inf=msf1; gbl_msf_inf(msf1 == 0) = 1e8;
contour(zon_lat, zon_dep, gbl_msf_inf, [9e7 9e7], 'color', [0.5 0.5 0.5], 'linewidth', 2); %to add land contours
caxis ([-40 40]);
set (gca, 'YDir', 'reverse');
set (gca, 'XTick', -90:30:90, 'YTick', 0:1:6);
cb = colorbar; cbar_ylabel (cb, '[Sv]');
% xlabel ('Latitude [{\circ}N]');
ylabel ('Depth [km]');
title ('Global meridional streamfunction');
subplot (2,1,2);
msf1 = std_gbl_msf;
[C,h] = contourf(zon_lat,zon_dep, msf1, [-2:0.1:2]);
hold on
gbl_msf_inf=msf1; gbl_msf_inf(avg_gbl_msf == 0) = 1e8;
contour(zon_lat, zon_dep, gbl_msf_inf, [9e7 9e7], 'color', [0.5 0.5 0.5], 'linewidth', 2); %to add land contours
caxis ([-2 2]);
set (gca, 'YDir', 'reverse');
set (gca, 'XTick', -90:30:90, 'YTick', 0:1:6);
cb = colorbar; cbar_ylabel (cb, '[Sv]');
xlabel ('Latitude [{\circ}N]');
ylabel ('Depth [km]');
title ('St. dev. global meridional streamfunction');
paper; orient portrait; def_figure;
def_figure; oname = sprintf('FIGS/ukesm1_PD_streamfunction_gbl_std.png'); exportgraphics(gcf, oname, 'Resolution', 600);  

figure(1); clf; therm6(41);
subplot (2,1,1);
msf1 = avg_atl_msf;
[C,h] = contourf(zon_lat,zon_dep, msf1, [-40:2:40]);
hold on
gbl_msf_inf=msf1; gbl_msf_inf(msf1 == 0) = 1e8;
contour(zon_lat, zon_dep, gbl_msf_inf, [9e7 9e7], 'color', [0.5 0.5 0.5], 'linewidth', 2); %to add land contours
caxis ([-20 20]);
set (gca, 'YDir', 'reverse');
set (gca, 'XTick', -90:30:90, 'YTick', 0:1:6);
cb = colorbar; cbar_ylabel (cb, '[Sv]');
% xlabel ('Latitude [{\circ}N]');
ylabel ('Depth [km]');
title ('Atlantic meridional streamfunction');
subplot (2,1,2);
msf1 = std_atl_msf;
[C,h] = contourf(zon_lat,zon_dep, msf1, [-1:0.05:1]);
hold on
gbl_msf_inf=msf1; gbl_msf_inf(avg_atl_msf == 0) = 1e8;
contour(zon_lat, zon_dep, gbl_msf_inf, [9e7 9e7], 'color', [0.5 0.5 0.5], 'linewidth', 2); %to add land contours
caxis ([-1 1]);
set (gca, 'YDir', 'reverse');
set (gca, 'XTick', -90:30:90, 'YTick', 0:1:6);
cb = colorbar; cbar_ylabel (cb, '[Sv]');
xlabel ('Latitude [{\circ}N]');
ylabel ('Depth [km]');
title ('St. dev. Atlantic meridional streamfunction');
paper; orient portrait; def_figure;
def_figure; oname = sprintf('FIGS/ukesm1_PD_streamfunction_atl_std.png'); exportgraphics(gcf, oname, 'Resolution', 600);  

figure(1); clf; therm6(41);
subplot (2,1,1);
msf1 = avg_pac_msf;
[C,h] = contourf(zon_lat,zon_dep, msf1, [-40:2:40]);
hold on
gbl_msf_inf=msf1; gbl_msf_inf(msf1 == 0) = 1e8;
contour(zon_lat, zon_dep, gbl_msf_inf, [9e7 9e7], 'color', [0.5 0.5 0.5], 'linewidth', 2); %to add land contours
caxis ([-20 20]);
set (gca, 'YDir', 'reverse');
set (gca, 'XTick', -90:30:90, 'YTick', 0:1:6);
cb = colorbar; cbar_ylabel (cb, '[Sv]');
% xlabel ('Latitude [{\circ}N]');
ylabel ('Depth [km]');
title ('Pacific meridional streamfunction');
subplot (2,1,2);
msf1 = std_pac_msf;
[C,h] = contourf(zon_lat,zon_dep, msf1, [-1:0.05:1]);
hold on
gbl_msf_inf=msf1; gbl_msf_inf(avg_pac_msf == 0) = 1e8;
contour(zon_lat, zon_dep, gbl_msf_inf, [9e7 9e7], 'color', [0.5 0.5 0.5], 'linewidth', 2); %to add land contours
caxis ([-1 1]);
set (gca, 'YDir', 'reverse');
set (gca, 'XTick', -90:30:90, 'YTick', 0:1:6);
cb = colorbar; cbar_ylabel (cb, '[Sv]');
xlabel ('Latitude [{\circ}N]');
ylabel ('Depth [km]');
title ('St. dev. Pacific meridional streamfunction');
paper; orient portrait; def_figure;
def_figure; oname = sprintf('FIGS/ukesm1_PD_streamfunction_pac_std.png'); exportgraphics(gcf, oname, 'Resolution', 600);  

figure(1); clf
plot (avg_gbl_msf, std_gbl_msf, 'ro', avg_atl_msf, std_atl_msf, 'g^', avg_pac_msf, std_pac_msf, 'bs');

figure(1); clf
plot (avg_gbl_msf(40,:), std_gbl_msf(40,:), 'ro', avg_atl_msf(40,:), std_atl_msf(40,:), 'g^', avg_pac_msf(40,:), std_pac_msf(40,:), 'bs');

load global_stream_z.mat

% make some corrections
Psi(Psi == 0) = 1e12;
Psi(isnan(Psi)) = 0;
Psi(Psi == 1e12) = 1e-6;
obs_msf = -1 * Psi;
obs_lat = Lat2;
obs_dep = Z2 / 1e3;

cont = -40:2:40; clim = [cont(1) cont(end)];

figure(1); clf; therm6(41);
subplot (2,1,1);
[C,h] = contourf(obs_lat, obs_dep, obs_msf, cont);
hold on
obs_msf_inf = obs_msf; obs_msf_inf(obs_msf == 0) = 1e8;
contour(obs_lat, obs_dep, obs_msf_inf, [9e7 9e7], 'color', [0.5 0.5 0.5], 'linewidth', 2); %to add land contours
caxis ([clim]);
mrkr = ['-']; hm = plot ([-62 -62], [0 6], mrkr, [-32 -32], [0 6], mrkr, [24 24], [0 6], mrkr, [47 47], [0 6], mrkr, [60 60], [0 6], mrkr);
for i = 1:1:5, set(hm(i), 'Color', [0.7 0.7 0.7]); end
set (gca, 'YDir', 'reverse');
set (gca, 'XTick', -90:30:90, 'YTick', 0:1:6);
yaxis ([0 zon_dep(end)]);
% xaxis ([-35 zon_lat(end)]);
cb = colorbar; cbar_ylabel (cb, '[Sv]');
% xlabel ('Latitude [{\circ}N]');
ylabel ('Depth [km]');
title ('Global meridional streamfunction, observed');
subplot (2,1,2);
[C,h] = contourf(zon_lat,zon_dep, avg_gbl_msf, cont);
hold on
gbl_msf_inf=avg_gbl_msf; gbl_msf_inf(avg_gbl_msf == 0) = 1e8;
contour(zon_lat, zon_dep, gbl_msf_inf, [9e7 9e7], 'color', [0.5 0.5 0.5], 'linewidth', 2); %to add land contours
caxis ([clim]);
set (gca, 'YDir', 'reverse');
set (gca, 'XTick', -90:30:90, 'YTick', 0:1:6);
yaxis ([0 zon_dep(end)]);
cb = colorbar; cbar_ylabel (cb, '[Sv]');
xlabel ('Latitude [{\circ}N]');
ylabel ('Depth [km]');
title ('Global meridional streamfunction, UKESM1');
paper; orient portrait; def_figure; 
% set(gcf, 'PaperPosition', [0.8353 3.3765 6.5882 6.6412]); % [2.1217 4.5763 16.7340 18.5506]);
def_figure; oname = sprintf('FIGS/ukesm1_PD_streamfunction_OBS_MOD_gbl.png'); exportgraphics(gcf, oname, 'Resolution', 600);  

% ===== 
% George's ECCO dataset
fnom = char('eccov4r4_moc.nc');
obs_lat = ncread(fnom, 'lat');
obs_dep = ncread(fnom, 'Zl') / -1e3;
obs_msf = permute(mean(ncread(fnom, 'psi_moc'), 3), [2 1]);

% load global_stream_z.mat
% 
% % make some corrections
% Psi(Psi == 0) = 1e12;
% Psi(isnan(Psi)) = 0;
% Psi(Psi == 1e12) = 1e-6;
% obs_msf = -1 * Psi;
% obs_lat = Lat2;
% obs_dep = Z2 / 1e3;

% obs_msf(obs_msf == 0) = NaN;
obs_dep(51) = 6.1;
obs_msf(51,:) = 0;

cont = -40:2:40; clim = [cont(1) cont(end)];

figure(1); clf; therm6(41);
subplot (2,1,1);
[C,h] = contourf(obs_lat, obs_dep, obs_msf, cont);
hold on
obs_msf_inf = obs_msf; obs_msf_inf(obs_msf == 0) = 1e8;
contour(obs_lat, obs_dep, obs_msf_inf, [9e7 9e7], 'color', [0.5 0.5 0.5], 'linewidth', 2); %to add land contours
caxis ([clim]);
% mrkr = ['-']; hm = plot ([-62 -62], [0 6], mrkr, [-32 -32], [0 6], mrkr, [24 24], [0 6], mrkr, [47 47], [0 6], mrkr, [60 60], [0 6], mrkr);
% for i = 1:1:5, set(hm(i), 'Color', [0.7 0.7 0.7]); end
set (gca, 'YDir', 'reverse');
set (gca, 'XTick', -90:30:90, 'YTick', 0:1:6);
yaxis ([0 zon_dep(end)]);
cb = colorbar; cbar_ylabel (cb, '[Sv]');
ylabel ('Depth [km]');
title ('Global meridional streamfunction, observed');
subplot (2,1,2);
[C,h] = contourf(zon_lat,zon_dep, avg_gbl_msf, cont);
hold on
gbl_msf_inf=avg_gbl_msf; gbl_msf_inf(avg_gbl_msf == 0) = 1e8;
contour(zon_lat, zon_dep, gbl_msf_inf, [9e7 9e7], 'color', [0.5 0.5 0.5], 'linewidth', 2); %to add land contours
caxis ([clim]);
set (gca, 'YDir', 'reverse');
set (gca, 'XTick', -90:30:90, 'YTick', 0:1:6);
yaxis ([0 zon_dep(end)]);
cb = colorbar; cbar_ylabel (cb, '[Sv]');
xlabel ('Latitude [{\circ}N]');
ylabel ('Depth [km]');
title ('Global meridional streamfunction, UKESM1');
paper; orient portrait; def_figure; 
% set(gcf, 'PaperPosition', [0.8353 3.3765 6.5882 6.6412]); % [2.1217 4.5763 16.7340 18.5506]);
def_figure; oname = sprintf('FIGS/ukesm1_PD_streamfunction_ECCO_MOD_gbl.png'); exportgraphics(gcf, oname, 'Resolution', 600);  

% =====
% George's ECCO dataset
fnom = char('eccov4r4_moc_eulerian_gm.nc');
obs_lat = ncread(fnom, 'lat');
obs_dep = ncread(fnom, 'Zl') / -1e3;
obs_msf = permute(mean(ncread(fnom, 'psi_moc'), 3), [2 1]);

% obs_msf(obs_msf == 0) = NaN;
obs_dep(51) = 6.1;
obs_msf(51,:) = 0;

cont = -40:2:40; clim = [cont(1) cont(end)];

figure(1); clf; therm6(41);
subplot (2,1,1);
[C,h] = contourf(obs_lat, obs_dep, obs_msf, cont);
hold on
obs_msf_inf = obs_msf; obs_msf_inf(obs_msf == 0) = 1e8;
contour(obs_lat, obs_dep, obs_msf_inf, [9e7 9e7], 'color', [0.5 0.5 0.5], 'linewidth', 2); %to add land contours
caxis ([clim]);
% mrkr = ['-']; hm = plot ([-62 -62], [0 6], mrkr, [-32 -32], [0 6], mrkr, [24 24], [0 6], mrkr, [47 47], [0 6], mrkr, [60 60], [0 6], mrkr);
% for i = 1:1:5, set(hm(i), 'Color', [0.7 0.7 0.7]); end
set (gca, 'YDir', 'reverse');
set (gca, 'XTick', -90:30:90, 'YTick', 0:1:6);
yaxis ([0 zon_dep(end)]);
cb = colorbar; cbar_ylabel (cb, '[Sv]');
ylabel ('Depth [km]');
title ('Global meridional streamfunction, observed');
subplot (2,1,2);
[C,h] = contourf(zon_lat,zon_dep, avg_gbl_msf, cont);
hold on
gbl_msf_inf=avg_gbl_msf; gbl_msf_inf(avg_gbl_msf == 0) = 1e8;
contour(zon_lat, zon_dep, gbl_msf_inf, [9e7 9e7], 'color', [0.5 0.5 0.5], 'linewidth', 2); %to add land contours
caxis ([clim]);
set (gca, 'YDir', 'reverse');
set (gca, 'XTick', -90:30:90, 'YTick', 0:1:6);
yaxis ([0 zon_dep(end)]);
cb = colorbar; cbar_ylabel (cb, '[Sv]');
xlabel ('Latitude [{\circ}N]');
ylabel ('Depth [km]');
title ('Global meridional streamfunction, UKESM1');
paper; orient portrait; def_figure;
% set(gcf, 'PaperPosition', [0.8353 3.3765 6.5882 6.6412]); % [2.1217 4.5763 16.7340 18.5506]);
def_figure; oname = sprintf('FIGS/ukesm1_PD_streamfunction_ECCO-GM_MOD_gbl.png'); exportgraphics(gcf, oname, 'Resolution', 600);  

cont = -20:1:20; clim = [cont(1) cont(end)];

figure(1); clf; therm6(41);
subplot (2,1,1);
t1 = avg_atl_msf; t1(t1 > max(cont)) = max(cont) - 1e-3; t1(t1 < min(cont)) = min(cont) + 1e-3;
[C,h] = contourf(zon_lat,zon_dep, t1, cont);
hold on
gbl_msf_inf=t1; gbl_msf_inf(t1 == 0) = 1e8;
contour(zon_lat, zon_dep, gbl_msf_inf, [9e7 9e7], 'color', [0.5 0.5 0.5], 'linewidth', 2); %to add land contours
caxis ([clim]);
set (gca, 'YDir', 'reverse');
set (gca, 'XTick', -90:30:90, 'YTick', 0:1:6);
yaxis ([0 zon_dep(end)]);
cb = colorbar; cbar_ylabel (cb, '[Sv]');
ylabel ('Depth [km]');
title ('Atlantic meridional streamfunction, UKESM1');
subplot (2,1,2);
t1 = avg_pac_msf; t1(t1 > max(cont)) = max(cont) - 1e-3; t1(t1 < min(cont)) = min(cont) + 1e-3;
[C,h] = contourf(zon_lat,zon_dep, t1, cont);
hold on
gbl_msf_inf=t1; gbl_msf_inf(t1 == 0) = 1e8;
contour(zon_lat, zon_dep, gbl_msf_inf, [9e7 9e7], 'color', [0.5 0.5 0.5], 'linewidth', 2); %to add land contours
caxis ([clim]);
set (gca, 'YDir', 'reverse');
set (gca, 'XTick', -90:30:90, 'YTick', 0:1:6);
yaxis ([0 zon_dep(end)]);
cb = colorbar; cbar_ylabel (cb, '[Sv]');
xlabel ('Latitude [{\circ}N]');
ylabel ('Depth [km]');
title ('Indo-Pacific meridional streamfunction, UKESM1');
paper; orient portrait; def_figure;
% set(gcf, 'PaperPosition', [0.8353 3.3765 6.5882 6.6412]); % [2.1217 4.5763 16.7340 18.5506]);
def_figure; oname = sprintf('FIGS/ukesm1_PD_streamfunction_atl_pac.png'); exportgraphics(gcf, oname, 'Resolution', 600);  
