clear; startup;

% =========================================================================
% =========================================================================
%
% Matlab plotting scripts for the analysis of UKESM1 prepared for:
%
%   Yool, A., Palmiéri, J., Jones, C. G., de Mora, L., Kuhlbrodt, T., 
%   Popova, E. E., Nurser, A. J. G., Hirschi, J., Blaker, A. T., 
%	Coward, A. C., Blockley, E. W., and Sellar, A. A.: Evaluating the 
% 	physical and biogeochemical state of the global ocean component of 
%	UKESM1 in CMIP6 Historical simulations, Geosci. Model Dev. Discuss. 
%	[preprint], https://doi.org/10.5194/gmd-2020-333, in review, 2020.
%
%   Accepted for publication: 20 April 2021
%
% Note: scripts provided to document analysis, and may require editing to
% fully replicate plots in manuscript
%
% =========================================================================
% =========================================================================

% =========================================================================
%
% This script plots Supplementary Figure S6
%
% =========================================================================
% =========================================================================

% =========================================================================

load ukesm1_PD_ensemble

% =========================================================================

% load up background files
load nemo_area100e
load nemo_mask100e
fname = sprintf('%s/mean_nemo_%so_1y_20001201-20101201_grid-T.nc', dname(1).name, rname(1).name);
t1 = ncread(fname, 'deptht_bounds');
nemo_dep = double(t1(1,:)); nemo_dep(end+1) = double(t1(2,end));
t1 = ncread(fname, 'deptht');
nemo_mid = double(t1');

% total grid area
t1 = area100e + nemo_mask100e(:,:,1);
t2 = isfinite(t1);
tot_area100e = sum(t1(t2)); % m2

% extra mask to get rid of Mediterranean, Black and Caspian Seas
t1 = nemo_mask100e(:,:,1) + 1;
t1(isnan(t1)) = 0;
t1(235:249,283:344) = t1(235:249,283:344) + 2;
t1(249:262,291:344) = t1(249:262,291:344) + 4;
t1(262:276,330:344) = t1(262:276,330:344) + 8;
t2 = t1;
t2(t1 < 1) = NaN; t2(t1 > 1) = NaN;
med_mask100e = t2;

nxx = -179.5:1:179.5;  nyy = -89.5:1:89.5;
[lon100, lat100] = meshgrid(nxx, nyy);
nxx = -180:1:180;  nyy = -90:1:90;
[lon100b, lat100b] = meshgrid(nxx, nyy);
t1 = grid_area([-90:1:90], [-180:1:180]); area100 = t1(1:end-1,1:end-1) * 1e6;

load woa_mask
clear t1; t1(:,1:180) = woa_mask(:,181:360); t1(:,181:360) = woa_mask(:,1:180);
woa_mask = t1;

load woa_basin

helvetica;
pngopt = 0;

% ----------------------------------------------------------------------

addpath('~/Matlab/Datasets/Sea-Ice/');

mod_ice = zeros([332 362 12 3 9]);
for e = 1:1:tsize
for m = 12:-1:1 % loop reversed to reach full size at first iteration
  fprintf('- Ensemble %d, Month %d\n', e, m);
  pnom = sprintf('%s/clim_cice_%si_1m_2000%s-2009%s.nc', dname(e).name, rname(e).name, numprint(m, 2), numprint(m, 2));
  if e == 1 & m == 1
      t1 = ncread(pnom, 'TLON'); t2 = permute(t1, [2 1]); lon_ice(:,:) = t2;
      t1 = ncread(pnom, 'TLAT'); t2 = permute(t1, [2 1]); lat_ice(:,:) = t2;
  end
  % Ice thickness
  t1 = ncread(pnom, 'hi'); t2 = permute(t1, [2 1]); t3(2:331,2:361) = t2; t3(:,1) = t3(:,361); t3(:,362) = t3(:,2); t3(1,:) = NaN; t3(332,:) = t3(331,:);
  mod_ice(:,:,m,1,e) = t3;
  % Ice area
  t1 = ncread(pnom, 'aice'); t2 = permute(t1, [2 1]); t3(2:331,2:361) = t2; t3(:,1) = t3(:,361); t3(:,362) = t3(:,2); t3(1,:) = NaN; t3(332,:) = t3(331,:);
  mod_ice(:,:,m,2,e) = t3;
  % Area
  t1 = ncread(pnom, 'tarea'); t2 = permute(t1, [2 1]); t3(2:331,2:361) = t2; t3(:,1) = t3(:,361); t3(:,362) = t3(:,2); t3(1,:) = NaN; t3(332,:) = t3(331,:);
  mod_ice(:,:,m,3,e) = t3;
end
end

% ----------------------------------------------------------------------

fnom = char('cryosat_seaice_thickness_mean_month_2011to2013.nc');
t1 = ncread(fnom, 'lon'); icelon = t1;
t1 = ncread(fnom, 'lat'); icelat = t1;
t1 = ncread(fnom, 'thick'); icethk = t1;

load coast;

lon_rng = [-180 180]; lat_rng = [50 90];
figure(1); clf; turbo(60);
ax = axesm('MapProjection', 'stereo', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
t1 = [icethk(:,:,3) icethk(:,:,3) icethk(:,:,3)];
x1 = [(icelon - 360) icelon (icelon + 360)];
y1 = [icelat icelat icelat];
pcolorm(y1, x1, t1);
plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
caxis ([0 6]);

% ----------------------------------------------------------------------
 
gpos = [-0.075 -0.025 0.135 0.1; -0.05 -0.025 0.135 0.1; -0.075 0.05 0.135 0.1; -0.05 0.05 0.135 0.1];

nxx = -539.5:1:539.5;  nyy = -89.5:1:89.5;
[lon100b, lat100b] = meshgrid(nxx, nyy);

tstr = char('Observed, March', 'Simulated, March', 'Observed, September', 'Simulated, September');
for f = 1:1:4, tlen(f) = lenstr(tstr(f,:)); end
figure(1); clf; pal0 = turbo(58); pal(1:60,1:3) = 1; pal(3:60,:) = pal0; colormap(pal);
lon_rng = [-180 180]; lat_rng = [50 90];
subplot(2,2,1);
ax = axesm('MapProjection', 'stereo', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
t1 = [icethk(:,:,3) icethk(:,:,3) icethk(:,:,3)];
t1(t1 < 0.01) = NaN;
x1 = [(icelon - 360) icelon (icelon + 360)];
y1 = [icelat icelat icelat];
pcolorm(y1, x1, t1);
plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
caxis ([0 6]);
pos = get(gca, 'Position'); pos = pos + gpos(1,:); set(gca, 'Position', pos);
tp = title (tstr(1,1:tlen(1))); set(tp, 'Position', [0 0.80 0]);
subplot(2,2,3);
t1 = mean(mod_ice(:,:,3,1,:), 5); t1(t1 == 0) = NaN;
t1(t1 < 0.01) = NaN;
ax = axesm('MapProjection', 'stereo', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
pcolorm(yy100e, xx100e, t1);
plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
caxis ([0 6]);
pos = get(gca, 'Position'); pos = pos + gpos(3,:); set(gca, 'Position', pos);
tp = title (tstr(2,1:tlen(2))); set(tp, 'Position', [0 0.80 0]);
%   cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
%     set(cb, 'Position', cbpos); set(gca, 'Position', pos);
lon_rng = [-180 180]; lat_rng = [50 90];
subplot(2,2,2);
ax = axesm('MapProjection', 'stereo', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
t1 = [icethk(:,:,9) icethk(:,:,9) icethk(:,:,9)];
t1(t1 < 0.01) = NaN;
x1 = [(icelon - 360) icelon (icelon + 360)];
y1 = [icelat icelat icelat];
pcolorm(y1, x1, t1);
plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
caxis ([0 6]);
pos = get(gca, 'Position'); pos = pos + gpos(2,:); set(gca, 'Position', pos);
tp = title (tstr(3,1:tlen(3))); set(tp, 'Position', [0 0.80 0]);
subplot(2,2,4);
t1 = mean(mod_ice(:,:,9,1,:), 5); t1(t1 == 0) = NaN;
t1(t1 < 0.01) = NaN;
ax = axesm('MapProjection', 'stereo', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
pcolorm(yy100e, xx100e, t1);
plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
caxis ([0 6]);
pos = get(gca, 'Position'); pos = pos + gpos(4,:); set(gca, 'Position', pos);
tp = title (tstr(4,1:tlen(4))); set(tp, 'Position', [0 0.80 0]);
cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos = [(pos(1)+0.1) (cbpos(2)-0.075) (pos(3)-0.2) cbpos(4)]; 
set(cb, 'Position', cbpos); set(gca, 'Position', pos);
set(cb, 'XTick', 0:2:6);
def_figure; 
set(gcf, 'PaperPosition', [4.1217 8.5763 12.7340 12.5506]);
oname = sprintf('FIGS/ukesm1_PD_seaice_thk_%s.png', numprint(1,2)); exportgraphics(gcf, oname, 'Resolution', 600);

tstr = char('Observed, March', 'Simulated, March', 'Observed, September', 'Simulated, September');
for f = 1:1:4, tlen(f) = lenstr(tstr(f,:)); end
figure(1); clf; turbo(60); % pal0 = turbo(58); pal(1:60,1:3) = 1; pal(3:60,:) = pal0; colormap(pal);
lon_rng = [-180 180]; lat_rng = [50 90];
subplot(2,2,1);
ax = axesm('MapProjection', 'stereo', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
t1 = [icethk(:,:,3) icethk(:,:,3) icethk(:,:,3)];
t1(t1 < 0.01) = NaN;
x1 = [(icelon - 360) icelon (icelon + 360)];
y1 = [icelat icelat icelat];
pcolorm(y1, x1, t1);
plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
caxis ([0 6]);
pos = get(gca, 'Position'); pos = pos + gpos(1,:); set(gca, 'Position', pos);
tp = title (tstr(1,1:tlen(1))); set(tp, 'Position', [0 0.80 0]);
subplot(2,2,3);
t1 = mean(mod_ice(:,:,3,1,:), 5); t1(t1 == 0) = NaN;
t1(t1 < 0.01) = NaN;
ax = axesm('MapProjection', 'stereo', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
pcolorm(yy100e, xx100e, t1);
plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
caxis ([0 6]);
pos = get(gca, 'Position'); pos = pos + gpos(3,:); set(gca, 'Position', pos);
tp = title (tstr(2,1:tlen(2))); set(tp, 'Position', [0 0.80 0]);
%   cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
%     set(cb, 'Position', cbpos); set(gca, 'Position', pos);
lon_rng = [-180 180]; lat_rng = [50 90];
subplot(2,2,2);
ax = axesm('MapProjection', 'stereo', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
t1 = [icethk(:,:,9) icethk(:,:,9) icethk(:,:,9)];
t1(t1 < 0.01) = NaN;
x1 = [(icelon - 360) icelon (icelon + 360)];
y1 = [icelat icelat icelat];
pcolorm(y1, x1, t1);
plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
caxis ([0 6]);
pos = get(gca, 'Position'); pos = pos + gpos(2,:); set(gca, 'Position', pos);
tp = title (tstr(3,1:tlen(3))); set(tp, 'Position', [0 0.80 0]);
subplot(2,2,4);
t1 = mean(mod_ice(:,:,9,1,:), 5); t1(t1 == 0) = NaN;
t1(t1 < 0.01) = NaN;
ax = axesm('MapProjection', 'stereo', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
pcolorm(yy100e, xx100e, t1);
plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
caxis ([0 6]);
pos = get(gca, 'Position'); pos = pos + gpos(4,:); set(gca, 'Position', pos);
tp = title (tstr(4,1:tlen(4))); set(tp, 'Position', [0 0.80 0]);
cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos = [(pos(1)+0.1) (cbpos(2)-0.075) (pos(3)-0.2) cbpos(4)]; 
set(cb, 'Position', cbpos); set(gca, 'Position', pos);
set(cb, 'XTick', 0:2:6);
def_figure; 
set(gcf, 'PaperPosition', [4.1217 8.5763 12.7340 12.5506]);
oname = sprintf('FIGS/ukesm1_PD_seaice_thk_%sb.png', numprint(1,2)); exportgraphics(gcf, oname, 'Resolution', 600);
