clear; startup;

% =========================================================================
% =========================================================================
%
% Matlab plotting scripts for the analysis of UKESM1 prepared for:
%
%   Yool, A., Palmiéri, J., Jones, C. G., de Mora, L., Kuhlbrodt, T., 
%   Popova, E. E., Nurser, A. J. G., Hirschi, J., Blaker, A. T., 
%	Coward, A. C., Blockley, E. W., and Sellar, A. A.: Evaluating the 
% 	physical and biogeochemical state of the global ocean component of 
%	UKESM1 in CMIP6 Historical simulations, Geosci. Model Dev. Discuss. 
%	[preprint], https://doi.org/10.5194/gmd-2020-333, in review, 2020.
%
%   Accepted for publication: 20 April 2021
%
% Note: scripts provided to document analysis, and may require editing to
% fully replicate plots in manuscript
%
% =========================================================================
% =========================================================================

% =========================================================================
%
% This script plots Hovmoller panels for Figures 10, 11, 12, 13, and 14, 
% and Supplementary Figure S3
%
% =========================================================================
% =========================================================================

% =========================================================================

load ukesm1_PD_ensemble

% =========================================================================

% load up background files
load nemo_area100e
load nemo_mask100e
fname = sprintf('%s/mean_nemo_%so_1y_20001201-20101201_grid-T.nc', dname(1).name, rname(1).name);
t1 = ncread(fname, 'deptht_bounds');
nemo_dep = double(t1(1,:)); nemo_dep(end+1) = double(t1(2,end));
t1 = ncread(fname, 'deptht');
nemo_mid = double(t1');

% total grid area
t1 = area100e + nemo_mask100e(:,:,1);
t2 = isfinite(t1);
tot_area100e = sum(t1(t2)); % m2

% extra mask to get rid of Mediterranean, Black and Caspian Seas
t1 = nemo_mask100e(:,:,1) + 1;
t1(isnan(t1)) = 0;
t1(235:249,283:344) = t1(235:249,283:344) + 2;
t1(249:262,291:344) = t1(249:262,291:344) + 4;
t1(262:276,330:344) = t1(262:276,330:344) + 8;
t2 = t1;
t2(t1 < 1) = NaN; t2(t1 > 1) = NaN;
med_mask100e = t2;

nxx = -179.5:1:179.5;  nyy = -89.5:1:89.5;
[lon100, lat100] = meshgrid(nxx, nyy);
nxx = -180:1:180;  nyy = -90:1:90;
[lon100b, lat100b] = meshgrid(nxx, nyy);

load woa_mask
clear t1; t1(:,1:180) = woa_mask(:,181:360); t1(:,181:360) = woa_mask(:,1:180);
woa_mask = t1;

load woa_basin

helvetica;
pngopt = 0;

% ----------------------------------------------------------------------

load ('ukesm1_PD_phys_output');

% SST and sea-ice
t1 = ncread('HadISST_sst.nc', 'sst');
t2 = flipdim(permute(t1, [2 1 3]), 1);
% ends April 2018; i.e. need to lose 8 years and 4 months from end
t3 = t2(:,:,1:(end - ((8 * 12) + 4)));
t4 = t3(:,:,1561:end);
t4(t4 == -1000) = NaN;
phys_obs(:,:,:,1) = t4;
t1 = ncread('HadISST_ice.nc', 'sic');
t2 = flipdim(permute(t1, [2 1 3]), 1);
% ends April 2018; i.e. need to lose 8 years and 4 months from end
t3 = t2(:,:,1:(end - ((8 * 12) + 4)));
t4 = t3(:,:,1561:end);
t4(t4 == -1000) = NaN;
phys_obs(:,:,:,2) = t4;

for m = 1:1:12
  top = 108 + m; bot = m;
  t1 = nanmean(phys_obs(:,:,bot:12:top,:), 3);
  clim_obs(:,:,m,:) = t1;
end

seas = [3 4 5; 6 7 8; 9 10 11; 12 1 2];

for s = 1:1:4
  for v = 1:1:2
    t1 = clim_obs(:,:,seas(s,:),v);
    t2 = mean(t1, 3);
    seas_clim_obs(:,:,s,v) = t2;
  end
end

% make a HadISST grid
[xx, yy] = meshgrid([-180:1:179], [-90:1:89]);
[xxb, yyb] = meshgrid([-180:1:180], [-90:1:90]);

lonlim = [-180 180]; latlim = [50 90];

t1 = ncread('HadISST_ice.nc', 'sic');

lon_rng = [-180 180]; lat_rng = [-90 90];
% gpos = [-0.05 -0.025 0.125 0.10; -0.025 -0.025 0.125 0.10; -0.05 -0.05 0.125 0.10; -0.025 -0.05 0.125 0.10];
% gpos = [-0.075 -0.025 0.135 0.1; -0.05 -0.025 0.135 0.1; -0.075 -0.05 0.135 0.1; -0.05 -0.05 0.135 0.1];
gpos = [-0.075 -0.025 0.135 0.1; -0.05 -0.025 0.135 0.1; -0.075 0.05 0.135 0.1; -0.05 0.05 0.135 0.1];
% gpos = gpos * 0;

t1 = woa_basin2(:,:,1);
t2 = woa_basin2(:,:,6);
t1(isfinite(t2)) = NaN;
arc_mask = t1;

load coast;

% ----------------------------------------------------------------------

t1 = mean(mod_phys, 5);
[xx1, yy1] = meshgrid([-179.5:1:179.5], [-89.5:1:89.5]);

for i = 1:1:3
  for j = 1:1:12
    t2 = t1(:,:,j,i);
    t3 = scatregrid(yy100e, xx100e, t2, yy1, xx1);
    rg_mod_phys(:,:,j,i) = t3 + woa_mask;
  end
end

for m = 1:1:12
  % SST
  t1 = clim_obs(:,:,m,1); t2 = nanmean(t1, 2);
  hov_obs(:,m,1) = t2;
  t1 = rg_mod_phys(:,:,m,1); t1(1:12,:) = NaN; t2 = nanmean(t1, 2);
  hov_mod(:,m,1) = t2;
  % SST
  t1 = clim_obs(:,:,m,2); t2 = nanmean(t1, 2);
  hov_obs(:,m,2) = t2;
  t1 = rg_mod_phys(:,:,m,3); t1(1:12,:) = NaN; t2 = nanmean(t1, 2);
  hov_mod(:,m,2) = t2;
end

monstr = char('J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D');
scl = 0.7;

figure(1); clf; turbo(32);
subplot (1,2,1);
clear t1; t1(:,2:13) = hov_obs(:,:,1); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, 32);
caxis ([-2 30]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); ylabel ('Latitude [{\circ}N]');
title ('Observed');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
subplot (1,2,2);
clear t1; t1(:,2:13) = hov_mod(:,:,1); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, 32);
caxis ([-2 30]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); % ylabel ('Latitude [{\circ}N]');
title ('Model');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
cb = colorbar; cbpos = get(cb, 'Position'); cbpos(1) = pos(1) + pos(3) + 0.025;
set (cb, 'Position', cbpos); set (gca, 'Position', pos);
paper; orient portrait; set(gcf, 'PaperPosition', [2.1217 8.5763 16.7340 12.5506]);
oname = sprintf('FIGS/ukesm1_hovmoller_phys_%s.png', numprint(1,2)); exportgraphics(gcf, oname, 'Resolution', 600);

figure(1); clf; therm6(21);
subplot (1,2,2);
clear t1; t1(:,2:13) = hov_mod(:,:,1) - hov_obs(:,:,1); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, 21);
caxis ([-2 2]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); ylabel ('Latitude [{\circ}N]');
title ('Model - Observed');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
cb = colorbar; cbpos = get(cb, 'Position'); cbpos(1) = pos(1) + pos(3) + 0.025;
set (cb, 'Position', cbpos); set (gca, 'Position', pos);
paper; orient portrait; set(gcf, 'PaperPosition', [2.1217 8.5763 16.7340 12.5506]);
oname = sprintf('FIGS/ukesm1_hovmoller_phys_DELTA_%s.png', numprint(1,2)); exportgraphics(gcf, oname, 'Resolution', 600);

figure(1); clf; turbo(20);
subplot (1,2,1);
clear t1; t1(:,2:13) = hov_obs(:,:,2); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, 20);
caxis ([-0.001 1.001]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); ylabel ('Latitude [{\circ}N]');
title ('Observed');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
subplot (1,2,2);
clear t1; t1(:,2:13) = hov_mod(:,:,2); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, 20);
caxis ([-0.001 1.001]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); % ylabel ('Latitude [{\circ}N]');
title ('Model');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
cb = colorbar; cbpos = get(cb, 'Position'); cbpos(1) = pos(1) + pos(3) + 0.025;
set (cb, 'Position', cbpos); set (gca, 'Position', pos);
paper; orient portrait; set(gcf, 'PaperPosition', [2.1217 8.5763 16.7340 12.5506 ]);
oname = sprintf('FIGS/ukesm1_hovmoller_phys_%s.png', numprint(2,2)); exportgraphics(gcf, oname, 'Resolution', 600);

% ----------------------------------------------------------------------
% ----------------------------------------------------------------------
% ----------------------------------------------------------------------

clear; startup;

% =========================================================================

load ukesm1_PD_ensemble

% =========================================================================

% load up background files
load nemo_area100e
load nemo_mask100e
fname = sprintf('%s/mean_nemo_%so_1y_20001201-20101201_grid-T.nc', dname(1).name, rname(1).name);
t1 = ncread(fname, 'deptht_bounds');
nemo_dep = double(t1(1,:)); nemo_dep(end+1) = double(t1(2,end));
t1 = ncread(fname, 'deptht');
nemo_mid = double(t1');

% total grid area
t1 = area100e + nemo_mask100e(:,:,1);
t2 = isfinite(t1);
tot_area100e = sum(t1(t2)); % m2

% extra mask to get rid of Mediterranean, Black and Caspian Seas
t1 = nemo_mask100e(:,:,1) + 1;
t1(isnan(t1)) = 0;
t1(235:249,283:344) = t1(235:249,283:344) + 2;
t1(249:262,291:344) = t1(249:262,291:344) + 4;
t1(262:276,330:344) = t1(262:276,330:344) + 8;
t2 = t1;
t2(t1 < 1) = NaN; t2(t1 > 1) = NaN;
med_mask100e = t2;

nxx = -179.5:1:179.5;  nyy = -89.5:1:89.5;
[lon100, lat100] = meshgrid(nxx, nyy);
nxx = -180:1:180;  nyy = -90:1:90;
[lon100b, lat100b] = meshgrid(nxx, nyy);

load woa_mask
clear t1; t1(:,1:180) = woa_mask(:,181:360); t1(:,181:360) = woa_mask(:,1:180);
woa_mask = t1;

load woa_basin

helvetica;
pngopt = 0;

% ----------------------------------------------------------------------

load woa13_all_BGC
t1 = squeeze(woa13_nit(:,:,1,:));
obs_din = t1;
t1 = squeeze(woa13_sil(:,:,1,:));
obs_sil = t1;
woa_mask = obs_din(:,:,1) * 0;

load seawifs_chl_1997-2010
obs_chl = chl_100_clim;

load ('~/Matlab/Datasets/NPP/all_npp_2000-2010_100.mat');

mon_vgpm1 = npp_clim_100(:,:,:,1);
mon_eppl1 = npp_clim_100(:,:,:,2);
mon_cbpm1 = npp_clim_100(:,:,:,3);

% load up model data
load ukesm1_PD_output_27nov19

% ----------------------------------------------------------------------

[xx1, yy1] = meshgrid([-179.5:1:179.5], [-89.5:1:89.5]);

for i = 1:1:4
  if i == 1, t1 = states_2d(:,:,1:12,1);
  elseif i == 2, t1 = states_2d(:,:,1:12,2);
  elseif i == 3, t1 = states_2d(:,:,1:12,4);
  elseif i == 4, t1 = states_2d(:,:,1:12,5); end
  for j = 1:1:12
    t2 = t1(:,:,j);
    t3 = scatregrid(yy100e, xx100e, t2, yy1, xx1);
    rg_mod_bgc(:,:,j,i) = t3 + woa_mask;
  end
end

for m = 1:1:12
  % OBS
  t1 = woa13_nit(:,:,1,m); t2 = nanmean(t1, 2); hov_obs(:,m,1) = t2;
  t1 = woa13_sil(:,:,1,m); t2 = nanmean(t1, 2); hov_obs(:,m,2) = t2;
  t1 = chl_100_clim(:,:,m); t2 = nanmean(t1, 2); hov_obs(:,m,3) = t2;
  t1 = npp_clim_100(:,:,m,4); t2 = nanmean(t1, 2); hov_obs(:,m,4) = t2;
  % MOD
  for i = 1:1:4
    t1 = rg_mod_bgc(:,:,m,i); t2 = nanmean(t1, 2);
    hov_mod(:,m,i) = t2;
  end
end

monstr = char('J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D');
scl = 0.7;

figure(1); clf; turbo(30);
subplot (1,2,1);
clear t1; t1(:,2:13) = hov_obs(:,:,1); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, 30);
caxis ([0 30]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); ylabel ('Latitude [{\circ}N]');
title ('Observed');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
subplot (1,2,2);
clear t1; t1(:,2:13) = hov_mod(:,:,1); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, 30);
caxis ([0 30]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); % ylabel ('Latitude [{\circ}N]');
title ('Model');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
cb = colorbar; cbpos = get(cb, 'Position'); cbpos(1) = pos(1) + pos(3) + 0.025;
set (cb, 'Position', cbpos); set (gca, 'Position', pos);
paper; orient portrait; set(gcf, 'PaperPosition', [2.1217 8.5763 16.7340 12.5506]);
oname = sprintf('FIGS/ukesm1_hovmoller_bgc_%s.png', numprint(1,2)); exportgraphics(gcf, oname, 'Resolution', 600);

figure(1); clf; turbo(30);
subplot (1,2,1);
clear t1; t1(:,2:13) = hov_obs(:,:,2); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, 30);
caxis ([0 90]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); ylabel ('Latitude [{\circ}N]');
title ('Observed');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
subplot (1,2,2);
clear t1; t1(:,2:13) = hov_mod(:,:,2); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, 30);
caxis ([0 90]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); % ylabel ('Latitude [{\circ}N]');
title ('Model');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
cb = colorbar; cbpos = get(cb, 'Position'); cbpos(1) = pos(1) + pos(3) + 0.025;
set (cb, 'Position', cbpos); set (gca, 'Position', pos);
paper; orient portrait; set(gcf, 'PaperPosition', [2.1217 8.5763 16.7340 12.5506 ]);
oname = sprintf('FIGS/ukesm1_hovmoller_bgc_%s.png', numprint(2,2)); exportgraphics(gcf, oname, 'Resolution', 600);

figure(1); clf; turbo(30);
subplot (1,2,1);
clear t1; t1(:,2:13) = hov_obs(:,:,3); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
clear t2; for m = 1:1:14, t2(:,m) = smooth(t1(:,m),11); end; t2(isnan(t1)) = NaN;
t1b = log10(t2);
contourf(-0.5:1:12.5, -89.5:1:89.5, t1b, 30);
caxis ([-2 0.5001]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); ylabel ('Latitude [{\circ}N]');
title ('Observed');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
subplot (1,2,2);
clear t1; t1(:,2:13) = hov_mod(:,:,3); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
t1b = log10(t1);
contourf(-0.5:1:12.5, -89.5:1:89.5, t1b, 30);
caxis ([-2 0.5001]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); % ylabel ('Latitude [{\circ}N]');
title ('Model');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
cb = colorbar; cbpos = get(cb, 'Position'); cbpos(1) = pos(1) + pos(3) + 0.025;
set (cb, 'YTick', [-2 -1 0 0.5], 'YTicklabel', [0.01 0.1 1.0 3]);
set (cb, 'Position', cbpos); set (gca, 'Position', pos);
paper; orient portrait; set(gcf, 'PaperPosition', [2.1217 8.5763 16.7340 12.5506]);
oname = sprintf('FIGS/ukesm1_hovmoller_bgc_%s.png', numprint(3,2)); exportgraphics(gcf, oname, 'Resolution', 600);

figure(1); clf; turbo(30);
subplot (1,2,1);
clear t1; t1(:,2:13) = hov_obs(:,:,4); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
clear t2; for m = 1:1:14, t2(:,m) = smooth(t1(:,m),5); end; t2(isnan(t1)) = NaN;
contourf(-0.5:1:12.5, -89.5:1:89.5, t2, 30);
caxis ([0 1.5]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); ylabel ('Latitude [{\circ}N]');
title ('Observed');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
subplot (1,2,2);
clear t1; t1(:,2:13) = hov_mod(:,:,4); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, 30);
caxis ([0 1.5]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); % ylabel ('Latitude [{\circ}N]');
title ('Model');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
cb = colorbar; cbpos = get(cb, 'Position'); cbpos(1) = pos(1) + pos(3) + 0.025;
set (cb, 'Position', cbpos); set (gca, 'Position', pos);
paper; orient portrait; set(gcf, 'PaperPosition', [2.1217 8.5763 16.7340 12.5506]);
oname = sprintf('FIGS/ukesm1_hovmoller_bgc_%s.png', numprint(4,2)); exportgraphics(gcf, oname, 'Resolution', 600);

