clear; startup;

% =========================================================================
% =========================================================================
%
% Matlab plotting scripts for the analysis of UKESM1 prepared for:
%
%   Yool, A., Palmiéri, J., Jones, C. G., de Mora, L., Kuhlbrodt, T., 
%   Popova, E. E., Nurser, A. J. G., Hirschi, J., Blaker, A. T., 
%	Coward, A. C., Blockley, E. W., and Sellar, A. A.: Evaluating the 
% 	physical and biogeochemical state of the global ocean component of 
%	UKESM1 in CMIP6 Historical simulations, Geosci. Model Dev. Discuss. 
%	[preprint], https://doi.org/10.5194/gmd-2020-333, in review, 2020.
%
%   Accepted for publication: 20 April 2021
%
% Note: scripts provided to document analysis, and may require editing to
% fully replicate plots in manuscript
%
% =========================================================================
% =========================================================================

% =========================================================================
%
% This script plots Figure 9, and Supplementary Figures S8 and S12
%
% =========================================================================

helvetica;
pngopt = 0;

% =========================================================================

load ukesm1_PD_ensemble

% =========================================================================

varnom = char('AMOC_26N', 'AMOC_26N_nomexico', 'DrakePassageTransport', 'GlobalMeanSalinity', ...
  'GlobalMeanTemperature', 'NorthernTotalIceArea', 'SouthernTotalIceArea', 'TotalAirSeaFluxCO2', ...
  'NoCaspianAirSeaFluxCO2', 'TotalIntegratedPrimaryProduction', 'Nitrate', 'Silicate', ...
  'Iron', 'DIC', 'Alkalinity', 'Oxygen', 'VolumeMeanOxygen', 'TotalDust', 'MLD', ...
  'Temperature', 'Salinity');
for v = 1:1:21, varlen(v) = lenstr(varnom(v,:)); end

for v = 1:1:21
  for e = 1:1:tsize
    jnom = sprintf('PD_timeseries/u-%s_%s.shelve.txt', rname(e).name, varnom(v,1:varlen(v)));
    fprintf('- Reading %s\n', jnom);
    t1 = load (jnom);
    evalstr = sprintf('mod_t.e%dv%d = t1(:,1);', e, v); eval(evalstr);
    evalstr = sprintf('mod_fld.e%dv%d = t1(:,2);', e, v); eval(evalstr);
  end
end

% load up control
for v = 1:1:21
  jnom = sprintf('PD_timeseries/u-%s_%s.shelve.txt', 'aw310', varnom(v,1:varlen(v)));
  fprintf('- Reading %s\n', jnom);
  t1 = load (jnom);
  evalstr = sprintf('pic_t.v%d = t1(:,1);', v); eval(evalstr);
  evalstr = sprintf('pic_fld.v%d = t1(:,2);', v); eval(evalstr);
end

% details of 12 historical ensemble members
% u-az513 - starts from 2020-01-01; want control: 2160-2180
% u-az515 - starts from 2050-01-01; want control: 2190-2210
% u-az524 - starts from 1995-01-01; want control: 2135-2155
% u-bb075 - starts from 1960-01-01; want control: 2100-2120
% u-bb277 - starts from 2395-01-01; want control: 2535-2555
% u-bc470 - starts from 2285-01-01; want control: 2425-2445
% u-bc179 - starts from 2250-01-01; want control: 2390-2410
% u-bc292 - starts from 2165-01-01; want control: 2305-2325
% u-bc370 - starts from 2120-01-01; want control: 2260-2280
%
% u-bd288 - starts from 2340-01-01; want control: 2480-2500
% u-bd416 - starts from 2460-01-01; want control: 2600-2620
% u-bd483 - starts from 2200-01-01; want control: 2340-2360

clear ctrl_time;
for e = 1:1:tsize
  t1 = rname(e).name;
  if t1 == 'az513', ctrl_time(e) = 2020;
  elseif t1 == 'az515', ctrl_time(e) = 2050;
  elseif t1 == 'az524', ctrl_time(e) = 1995;
  elseif t1 == 'bb075', ctrl_time(e) = 1960;
  elseif t1 == 'bb277', ctrl_time(e) = 2395;
  elseif t1 == 'bc470', ctrl_time(e) = 2285;
  elseif t1 == 'bc179', ctrl_time(e) = 2250;
  elseif t1 == 'bc292', ctrl_time(e) = 2165;
  elseif t1 == 'bc370', ctrl_time(e) = 2120;
  elseif t1 == 'bd288', ctrl_time(e) = 2340;
  elseif t1 == 'bd416', ctrl_time(e) = 2460;
  elseif t1 == 'bd483', ctrl_time(e) = 2200; end
end

% =========================================================================

pal0 = odvpal(tsize+2); pal = pal0(2:end-1,:);

for v = 1:1:21
  figure(1); clf; hold on;
  for e = 1:1:tsize
    evalstr = sprintf('h1 = mod_fld.e%dv%d;', e, v); eval(evalstr);
    evalstr = sprintf('t1 = mod_t.e%dv%d;', e, v); eval(evalstr);
    [q1, q2] = find(pic_t.v1 > ctrl_time(e)); q3 = min(q1);
    evalstr = sprintf('c0 = pic_fld.v%d;', v); eval(evalstr);
    c1 = c0(q3:1:(q3+163));
    h = plot (t1, c1, '--'); set (h, 'Color', pal(e,:));
    h = plot (t1, h1, '-'); set (h, 'Color', pal(e,:));
  end
end

% varnom = char('AMOC_26N', 'AMOC_26N_nomexico', 'DrakePassageTransport', 'GlobalMeanSalinity', ...
%   'GlobalMeanTemperature', 'NorthernTotalIceArea', 'SouthernTotalIceArea', 'TotalAirSeaFluxCO2', ...
%   'NoCaspianAirSeaFluxCO2', 'TotalIntegratedPrimaryProduction', 'Nitrate', 'Silicate', ...
%   'Iron', 'DIC', 'Alkalinity', 'Oxygen', 'VolumeMeanOxygen', 'TotalDust');

truenom = char('Atlantic Meridional Overturning Circulation', ...
  'Atlantic Meridional Overturning Circulation', ...
  'Drake Passage transport', ...
  'Global mean salinity', ...
  'Global mean temperature', ...
  'Northern sea-ice area', ...
  'Southern sea-ice area', ...
  'Global air-sea CO_{2} flux', ...
  'Global air-sea CO_{2} flux', ...
  'Global net primary production', ...
  'Global mean surface DIN', ...
  'Global mean surface silicic acid', ...
  'Global mean surface iron', ...
  'Global mean surface DIC', ...
  'Global mean surface alkalinity', ...
  'Global mean surface oxgen', ...
  'Global mean oxygen', ...
  'Global total aeolian iron', ...
  'Global mean MLD', ...
  'Global mean surface temperature', ...
  'Global mean surface salinity');
for v = 1:1:21, truelen(v) = lenstr(truenom(v,:)); end
unitnom = char('Sv', 'Sv', 'Sv', 'PSU', '{\circ}C', ...
  '10^{6} km^{2}', '10^{6} km^{2}', ...
  'Pg C y^{-1}', 'Pg C y^{-1}', 'Pg C y^{-1}', ...
  'mmol N m^{-3}', 'mmol Si m^{-3}', '{\mu}mol Fe m^{-3}', ...
  'mmol C m^{-3}', 'meq m^{-3}', 'mmol O_{2} m^{-3}', ...
  'mmol O_{2} m^{-3}', 'Gmol Fe y^{-1}', 'm', '{\circ}C', 'PSU');
for v = 1:1:21, unitlen(v) = lenstr(unitnom(v,:)); end

helvetica;

ylim = [10 19; 10 19; 110 190; 34.72 34.73; 3.6 4; 10 14; 4.5 13.5; -1.5 2.5; -1.5 2.5; 36 54; ...
  6.9 8.1; 8 10.5; 0.495 0.540; 1990 2070; 2313 2323; 251 253; 188 193; 1.6 3.4; 47 53; ...
  17.3 18.6; 34.24 34.36];

for v = 1:1:21
  figure(1); clf; hold on;
  evalstr = sprintf('c0 = pic_fld.v%d; t0 = pic_t.v%d;', v, v); eval(evalstr);
  c1 = c0; % smooth(c0);
  plot (t0, c1, 'k:');
  for e = 1:1:tsize
    evalstr = sprintf('h1 = mod_fld.e%dv%d;', e, v); eval(evalstr);
    h2 = h1; % smooth(h1);
    evalstr = sprintf('ht1 = mod_t.e%dv%d;', e, v); eval(evalstr);
    [q1, q2] = find(pic_t.v1 > ctrl_time(e)); q3 = min(q1);
    evalstr = sprintf('c0 = pic_fld.v%d;', v); eval(evalstr);
    c1 = c0(q3:1:(q3+163)); c2 = c1; % smooth(c1);
    evalstr = sprintf('ct0 = pic_t.v%d;', v); eval(evalstr);
    ct1 = ct0(q3:1:(q3+163));
    h = plot (ct1, c2, 'k-'); % set (h, 'Color', pal(e,:));
    h = plot (ct1, h2, '-');  set (h, 'Color', pal(e,:));
  end
  for e = 1:1:tsize
    evalstr = sprintf('h1 = mod_fld.e%dv%d;', e, v); eval(evalstr);
    h2 = h1; % smooth(h1);
    evalstr = sprintf('ht1 = mod_t.e%dv%d;', e, v); eval(evalstr);
    [q1, q2] = find(pic_t.v1 > ctrl_time(e)); q3 = min(q1);
    evalstr = sprintf('c0 = pic_fld.v%d;', v); eval(evalstr);
    c1 = c0(q3:1:(q3+163)); c2 = c1; % smooth(c1);
    evalstr = sprintf('ct0 = pic_t.v%d;', v); eval(evalstr);
    ct1 = ct0(q3:1:(q3+163));
    h = plot (ct1(1), h2(1), 'o');  set (h, 'Color', pal(e,:), 'MarkerFaceColor', pal(e,:)); % , 'MarkerSize', 10);
  end
  xaxis ([1950 2570]);
  xlabel ('Time [arbitrary years]');
  ylstr = sprintf('[%s]', unitnom(v,1:unitlen(v))); yl = ylabel (ylstr);
  title (truenom(v,1:truelen(v)));
  %
  fnom = sprintf('apr07_hist_CTRL_ensemble_%s', numprint(v, 2));
  paper; orient portrait; def_figure;
  print ('-depsc', '-painters', fnom);
end
pdfconvert('apr07_hist_CTRL_ensemble_', 'apr07_hist_CTRL_ensemble', 1);

% -----

for v = 1:1:21
  evalstr = sprintf('c0 = pic_fld.v%d;', v); eval(evalstr);
  c1 = c0; % smooth(c0);
  for e = 1:1:tsize
    evalstr = sprintf('h1 = mod_fld.e%dv%d;', e, v); eval(evalstr);
    h2 = h1; % smooth(h1);
    [q1, q2] = find(pic_t.v1 > ctrl_time(e)); q3 = min(q1);
    evalstr = sprintf('c0 = pic_fld.v%d;', v); eval(evalstr);
    c1 = c0(q3:1:(q3+163)); c2 = c1; % smooth(c1);
    all_hist(:,e,v) = h2;
    all_ctrl(:,e,v) = c2;
  end
end

tval = mod_t.e1v1;
pal0 = odvpal(tsize+2); pal = pal0(2:end-1,:);

for v = 1:1:21
  c1 = all_ctrl(:,:,v); avg_c1 = mean(c1, 2);
  h1 = all_hist(:,:,v); avg_h1 = mean(h1, 2);
  del1 = all_hist(:,:,v) - all_ctrl(:,:,v);
  rel1 = del1 ./ all_ctrl(:,:,v);
  avg1 = mean(del1, 2);
  min1 = min(del1, [], 2);
  max1 = max(del1, [], 2);
  
  figure(1); clf;
  subplot (1,2,1); hold on;
  h = plot (tval, c1, 'k-'); set(h, 'LineWidth', 0.1, 'Color', [0.7 0.7 0.7]);
  for e = 1:1:tsize, h = plot (tval, h1(:,e), '-'); set(h, 'LineWidth', 0.1, 'Color', pal(e,:).^0.2); end
  h = plot (tval, avg_c1, 'k-'); set(h, 'LineWidth', 1);
  h = plot (tval, avg_h1, 'm-'); set(h, 'LineWidth', 1); %, 'Color', pal(1,:));
  xaxis ([1850 2015]);
  title (truenom(v,1:truelen(v)));
  xlabel ('Time [year]');
  ylstr = sprintf('[%s]', unitnom(v,1:unitlen(v))); yl = ylabel (ylstr);
  subplot (1,2,2); hold on;
  h = plot (tval, avg1, 'm-'); set(h, 'LineWidth', 1);
  h = plot (tval, min1, 'b-'); set(h, 'LineWidth', 0.25);
  h = plot (tval, max1, 'r-'); set(h, 'LineWidth', 0.25);
  plot ([1850 2015], [0 0], 'k:');
  xaxis ([1850 2015]);
  xlabel ('Time [year]');
  ylstr = sprintf('[{\\Delta} %s]', unitnom(v,1:unitlen(v))); yl = ylabel (ylstr);
  title ('Difference from PI control');
  %
  fnom = sprintf('apr07_hist_ensemble_%s', numprint(v, 2));
  paper; orient portrait; % def_figure;
  set(gcf, 'PaperPosition', [2.1217 10.5763 16.7340 8.5506]);
  print ('-depsc', '-painters', fnom);
end
pdfconvert('apr07_hist_ensemble_', 'apr07_hist_ensemble', 1);

% =====

truenom = char('Atlantic Meridional Overturning Circulation', ...
  'Atlantic Meridional Overturning Circulation', ...
  'Drake Passage transport', ...
  'Global mean salinity', ...
  'Global mean temperature', ...
  'Northern sea-ice area', ...
  'Southern sea-ice area', ...
  'Global air-sea CO_{2} flux', ...
  'Global air-sea CO_{2} flux', ...
  'Global net primary production', ...
  'Global mean surface DIN', ...
  'Global mean surface silicic acid', ...
  'Global mean surface iron', ...
  'Global mean surface DIC', ...
  'Global mean surface alkalinity', ...
  'Global mean surface oxgen', ...
  'Global mean oxygen', ...
  'Global total aeolian iron', ...
  'Global mean MLD', ...
  'Global mean surface temperature', ...
  'Global mean surface salinity');
for v = 1:1:21, truelen(v) = lenstr(truenom(v,:)); end
unitnom = char('Sv', 'Sv', 'Sv', 'PSU', '{\circ}C', ...
  '10^{6} km^{2}', '10^{6} km^{2}', ...
  'Pg C y^{-1}', 'Pg C y^{-1}', 'Pg C y^{-1}', ...
  'mmol N m^{-3}', 'mmol Si m^{-3}', '{\mu}mol Fe m^{-3}', ...
  'mmol C m^{-3}', 'meq m^{-3}', 'mmol O_{2} m^{-3}', ...
  'mmol O_{2} m^{-3}', 'Gmol Fe y^{-1}', 'm', '{\circ}C', 'PSU');
for v = 1:1:21, unitlen(v) = lenstr(unitnom(v,:)); end

helvetica;

tvar = 1851:1:2014;

ylim = [10 20; 10 20; 130 180; 34.726 34.729; 3.725 3.85; 7 14; 7 14; -0.5 2.75; -0.5 2.75; 44 52; ...
  6.9 8.1; 8 10.5; 0.495 0.540; 1990 2070; 2313 2323; 248 254; 188 193; 1.6 3.4; 47 53; ...
  17.3 18.6; 34.24 34.36];

for v = 1:1:21
  evalstr = sprintf('c0 = pic_fld.v%d;', v); eval(evalstr);
  c1 = c0; % smooth(c0);
  figure(1); clf; hold on;
  plot (tvar, tvar * 0, 'k:');
  delta_h2c2 = tvar' * 0;
  for e = 1:1:tsize
    evalstr = sprintf('h1 = mod_fld.e%dv%d;', e, v); eval(evalstr);
    h2 = h1; % smooth(h1);
    evalstr = sprintf('ht1 = mod_t.e%dv%d;', e, v); eval(evalstr);
    [q1, q2] = find(pic_t.v1 > ctrl_time(e)); q3 = min(q1);
    evalstr = sprintf('c0 = pic_fld.v%d;', v); eval(evalstr);
    c1 = c0(q3:1:(q3+163)); c2 = c1; % smooth(c1);
    evalstr = sprintf('ct0 = pic_t.v%d;', v); eval(evalstr);
    ct1 = ct0(q3:1:(q3+163));
    avg_ctrl(e,v) = mean(c2(:)); std_ctrl(e,v) = std(c2(:));
    min_ctrl(e,v) = min(c2(:));  max_ctrl(e,v) = max(c2(:));
    avg_hist(e,v) = mean(h2(:)); std_hist(e,v) = std(h2(:));
    min_hist(e,v) = min(h2(:));  max_hist(e,v) = max(h2(:));
    [q1, q2] = polyfit(1:1:164, c2', 1);
    M_ctrl(e,v) = q1(1); C_ctrl(e,v) = q1(2);
    [q1, q2] = polyfit(1:1:164, h2', 1);
    M_hist(e,v) = q1(1); C_hist(e,v) = q1(2);
    %
    h = plot (tvar, h2, '-'); set (h, 'Color', pal(e,:)); set (h, 'LineWidth', 1);
    delta_h2c2 = delta_h2c2 + h2;
  end
  h = plot (tvar, delta_h2c2 / tsize, 'k-'); set (h, 'LineWidth', 2);
  xaxis ([1850 2015]); yaxis ([ylim(v,1) ylim(v,2)]);
  xlabel ('Time [years]');
  ylstr = sprintf('[%s]', unitnom(v,1:unitlen(v))); yl = ylabel (ylstr);
  titstr = sprintf('%s', truenom(v,1:truelen(v))); title (titstr);
  fnom = sprintf('ukesm1_PD_hist_ensemble_%s', numprint(v, 2));
  %   input ('- Press a key');
  % end
  paper; orient portrait; def_figure;
  print ('-depsc', '-painters', fnom);
  pngconvert(fnom, 600, pngopt);
end

% =====

obs_amoc = [19.29265519 18.5246228  18.96942522 18.0040161  17.30005408 ...
       15.43643674 14.87498209 15.82403071 15.03053074 16.12537559 ...
       16.01450178 16.70831559 16.86399025 16.95768764];
obs_time = (2003 + (11/12)):1:(2016 + (11/12));

tvar = (1851+(5/12)):1:(2014+(5/12));

v = 1;
evalstr = sprintf('c0 = pic_fld.v%d;', v); eval(evalstr);
c1 = c0; % smooth(c0);
figure(1); clf; hold on;
h = plot (obs_time, obs_amoc, 'r-'); set (h, 'LineWidth', 3); %, 'Color', [0.7 0.7 0.7]);
plot (tvar, tvar * 0, 'k:');
delta_h2c2 = tvar' * 0;
for e = 1:1:tsize
  evalstr = sprintf('h1 = mod_fld.e%dv%d;', e, v); eval(evalstr);
  h2 = h1; % smooth(h1);
  evalstr = sprintf('ht1 = mod_t.e%dv%d;', e, v); eval(evalstr);
  [q1, q2] = find(pic_t.v1 > ctrl_time(e)); q3 = min(q1);
  evalstr = sprintf('c0 = pic_fld.v%d;', v); eval(evalstr);
  c1 = c0(q3:1:(q3+163)); c2 = c1; % smooth(c1);
  evalstr = sprintf('ct0 = pic_t.v%d;', v); eval(evalstr);
  ct1 = ct0(q3:1:(q3+163));
  avg_ctrl(e,v) = mean(c2(:)); std_ctrl(e,v) = std(c2(:));
  min_ctrl(e,v) = min(c2(:));  max_ctrl(e,v) = max(c2(:));
  avg_hist(e,v) = mean(h2(:)); std_hist(e,v) = std(h2(:));
  min_hist(e,v) = min(h2(:));  max_hist(e,v) = max(h2(:));
  [q1, q2] = polyfit(1:1:164, c2', 1);
  M_ctrl(e,v) = q1(1); C_ctrl(e,v) = q1(2);
  [q1, q2] = polyfit(1:1:164, h2', 1);
  M_hist(e,v) = q1(1); C_hist(e,v) = q1(2);
  %
  h = plot (tvar, h2, '-'); set (h, 'Color', pal(e,:)); set (h, 'LineWidth', 1);
  delta_h2c2 = delta_h2c2 + h2;
end
h = plot (tvar, delta_h2c2 / tsize, 'k-'); set (h, 'LineWidth', 2);
h = plot (obs_time, obs_amoc, 'k-'); set (h, 'LineWidth', 3);
h = plot (obs_time, obs_amoc, 'r-'); set (h, 'LineWidth', 2); %, 'Color', [0.7 0.7 0.7]);
xaxis ([1850 2015]); yaxis ([ylim(v,1) ylim(v,2)]);
xlabel ('Time [years]');
ylstr = sprintf('[%s]', unitnom(v,1:unitlen(v))); yl = ylabel (ylstr);
titstr = sprintf('%s', truenom(v,1:truelen(v))); title (titstr);
legend ('RAPID-MOCHA', 'Location', 'SouthEast');
fnom = sprintf('ukesm1_PD_hist_ensemble_%s_OBS3', numprint(v, 2));
paper; orient portrait; def_figure;
print ('-depsc', '-painters', fnom); pngconvert(fnom, 600, pngopt);
axis ([2000 2015 13 20]);
fnom = sprintf('ukesm1_PD_hist_ensemble_%s_OBS4', numprint(v, 2));
paper; orient portrait; def_figure;
print ('-depsc', '-painters', fnom); pngconvert(fnom, 600, pngopt);

% =====

for v = 1:1:21
  fprintf('%s, %s\n', truenom(v,1:truelen(v)), unitnom(v,1:unitlen(v)));
  for e = 1:1:tsize
    fprintf('%d\t& %6.2f\t& %6.3f\t& %6.2f\t& %6.2f\t& %6.3f \\\\ \n', e, ...
      avg_hist(e,v), std_hist(e,v), min_hist(e,v), max_hist(e,v), M_hist(e,v) * 10);
    fprintf('\t& {\\it %6.2f}\t& {\\it %6.3f}\t& {\\it %6.2f}\t& {\\it %6.2f}\t& {\\it %6.3f} \\\\ \n', ...
      avg_ctrl(e,v), std_ctrl(e,v), min_ctrl(e,v), max_ctrl(e,v), M_ctrl(e,v) * 10);
  end
  fprintf('Mean\t& %6.2f\t& %6.3f\t& %6.2f\t& %6.2f\t& %6.3f \\\\ \n', ...
    mean(avg_hist(:,v),1), mean(std_hist(:,v),1), mean(min_hist(:,v),1), mean(max_hist(:,v),1), mean(M_hist(e,v),1) * 10);
  fprintf('\t& {\\it %6.2f}\t& {\\it %6.3f}\t& {\\it %6.2f}\t& {\\it %6.2f}\t& {\\it %6.3f} \\\\ \n', ...
    mean(avg_ctrl(:,v),1), mean(std_ctrl(:,v),1), mean(min_ctrl(:,v),1), mean(max_ctrl(:,v),1), mean(M_ctrl(e,v),1) * 10);
end

for v = 1:1:21
  fprintf('%s, %s\n', truenom(v,1:truelen(v)), unitnom(v,1:unitlen(v)));
  fprintf('Mean\t& %6.2f\t& %6.3f\t& %6.2f\t& %6.2f\t& %6.3f \\\\ \n', ...
    mean(avg_hist(:,v),1), mean(std_hist(:,v),1), mean(min_hist(:,v),1), mean(max_hist(:,v),1), mean(M_hist(e,v),1) * 10);
  fprintf('\t& {\\it %6.2f}\t& {\\it %6.3f}\t& {\\it %6.2f}\t& {\\it %6.2f}\t& {\\it %6.3f} \\\\ \n', ...
    mean(avg_ctrl(:,v),1), mean(std_ctrl(:,v),1), mean(min_ctrl(:,v),1), mean(max_ctrl(:,v),1), mean(M_ctrl(e,v),1) * 10);
end


for v = 1:1:21
  evalstr = sprintf('c0 = pic_fld.v%d;', v); eval(evalstr);
  c1 = c0; % smooth(c0);
  figure(1); clf; hold on;
  plot (tvar, tvar * 0, 'k:');
  delta_h2c2 = tvar' * 0;
  for e = 1:1:tsize
    evalstr = sprintf('h1 = mod_fld.e%dv%d;', e, v); eval(evalstr);
    h2 = h1; % smooth(h1);
    evalstr = sprintf('ht1 = mod_t.e%dv%d;', e, v); eval(evalstr);
    [q1, q2] = find(pic_t.v1 > ctrl_time(e)); q3 = min(q1);
    evalstr = sprintf('c0 = pic_fld.v%d;', v); eval(evalstr);
    c1 = c0(q3:1:(q3+163)); c2 = c1; % smooth(c1);
    evalstr = sprintf('ct0 = pic_t.v%d;', v); eval(evalstr);
    ct1 = ct0(q3:1:(q3+163));
    avg_ctrl(e,v) = mean(c2(:)); std_ctrl(e,v) = std(c2(:));
    min_ctrl(e,v) = min(c2(:));  max_ctrl(e,v) = max(c2(:));
    avg_hist(e,v) = mean(h2(:)); std_hist(e,v) = std(h2(:));
    min_hist(e,v) = min(h2(:));  max_hist(e,v) = max(h2(:));
    [q1, q2] = polyfit(1:1:164, c2', 1);
    M_ctrl(e,v) = q1(1); C_ctrl(e,v) = q1(2);
    [q1, q2] = polyfit(1:1:164, h2', 1);
    M_hist(e,v) = q1(1); C_hist(e,v) = q1(2);
    %
    h = plot (tvar, h2 - c2, '-'); set (h, 'Color', pal(e,:)); set (h, 'LineWidth', 1);
    delta_h2c2 = delta_h2c2 + (h2 - c2);
  end
  plot (tvar, tvar * 0, 'k:');
  h = plot (tvar, delta_h2c2 / tsize, 'k-'); set (h, 'LineWidth', 2);
  xaxis ([1850 2015]);
  xlabel ('Time [years]');
  ylstr = sprintf('[%s]', unitnom(v,1:unitlen(v))); yl = ylabel (ylstr);
  titstr = sprintf('\\Delta %s', truenom(v,1:truelen(v))); title (titstr);
  fnom = sprintf('apr07_hist_ensemble_%s', numprint(v, 2));
  paper; orient portrait; def_figure;
  print ('-depsc', '-painters', fnom);
  pngconvert(fnom, 600, pngopt);
end

for v = 1:1:21
  fprintf('%s, %s\n', truenom(v,1:truelen(v)), unitnom(v,1:unitlen(v)));
  for e = 1:1:tsize
    fprintf('%d\t& %6.2f\t& %6.3f\t& %6.2f\t& %6.2f\t& %6.3f \\\\ \n', e, ...
      avg_hist(e,v), std_hist(e,v), min_hist(e,v), max_hist(e,v), M_hist(e,v) * 10);
    fprintf('\t& {\\it %6.2f}\t& {\\it %6.3f}\t& {\\it %6.2f}\t& {\\it %6.2f}\t& {\\it %6.3f} \\\\ \n', ...
      avg_ctrl(e,v), std_ctrl(e,v), min_ctrl(e,v), max_ctrl(e,v), M_ctrl(e,v) * 10);
  end
  fprintf('Mean\t& %6.2f\t& %6.3f\t& %6.2f\t& %6.2f\t& %6.3f \\\\ \n', ...
    mean(avg_hist(:,v),1), mean(std_hist(:,v),1), mean(min_hist(:,v),1), mean(max_hist(:,v),1), mean(M_hist(e,v),1) * 10);
  fprintf('\t& {\\it %6.2f}\t& {\\it %6.3f}\t& {\\it %6.2f}\t& {\\it %6.2f}\t& {\\it %6.3f} \\\\ \n', ...
    mean(avg_ctrl(:,v),1), mean(std_ctrl(:,v),1), mean(min_ctrl(:,v),1), mean(max_ctrl(:,v),1), mean(M_ctrl(e,v),1) * 10);
end

for v = 1:1:21
  figure(1); clf; hold on;
  evalstr = sprintf('c0 = pic_fld.v%d;', v); eval(evalstr);
  c1 = c0; % smooth(c0);
  plot (pic_t.v1, c1, 'k:');
  for e = 1:1:tsize
    evalstr = sprintf('h1 = mod_fld.e%dv%d;', e, v); eval(evalstr);
    h2 = h1; % smooth(h1);
    evalstr = sprintf('ht1 = mod_t.e%dv%d;', e, v); eval(evalstr);
    [q1, q2] = find(pic_t.v1 > ctrl_time(e)); q3 = min(q1);
    evalstr = sprintf('c0 = pic_fld.v%d;', v); eval(evalstr);
    c1 = c0(q3:1:(q3+163)); c2 = c1; % smooth(c1);
    evalstr = sprintf('ct0 = pic_t.v%d;', v); eval(evalstr);
    ct1 = ct0(q3:1:(q3+163));
    h = plot (ct1, c2, 'k-'); % set (h, 'Color', pal(e,:));
    h = plot (ct1, h2, '-');  set (h, 'Color', pal(e,:));
  end
  for e = 1:1:tsize
    evalstr = sprintf('h1 = mod_fld.e%dv%d;', e, v); eval(evalstr);
    h2 = h1; % smooth(h1);
    evalstr = sprintf('ht1 = mod_t.e%dv%d;', e, v); eval(evalstr);
    [q1, q2] = find(pic_t.v1 > ctrl_time(e)); q3 = min(q1);
    evalstr = sprintf('c0 = pic_fld.v%d;', v); eval(evalstr);
    c1 = c0(q3:1:(q3+163)); c2 = c1; % smooth(c1);
    evalstr = sprintf('ct0 = pic_t.v%d;', v); eval(evalstr);
    ct1 = ct0(q3:1:(q3+163));
    h = plot (ct1(1), h2(1), 'o');  set (h, 'Color', pal(e,:), 'MarkerFaceColor', pal(e,:)); % , 'MarkerSize', 10);
  end
  xaxis ([1950 2570]);
  xlabel ('Time [arbitrary years]');
  ylstr = sprintf('[%s]', unitnom(v,1:unitlen(v))); yl = ylabel (ylstr);
  title (truenom(v,1:truelen(v)));
  %
  fnom = sprintf('jan23_hist_ensemble_%s', numprint(v, 2));
  paper; orient portrait; def_figure;
  print ('-depsc', '-painters', fnom);
end
pdfconvert('jan23_hist_', 'jan23_hist_ensemble', 3);
