clear; startup;

% =========================================================================
% =========================================================================
%
% Matlab plotting scripts for the analysis of UKESM1 prepared for:
%
%   Yool, A., Palmiéri, J., Jones, C. G., de Mora, L., Kuhlbrodt, T., 
%   Popova, E. E., Nurser, A. J. G., Hirschi, J., Blaker, A. T., 
%	Coward, A. C., Blockley, E. W., and Sellar, A. A.: Evaluating the 
% 	physical and biogeochemical state of the global ocean component of 
%	UKESM1 in CMIP6 Historical simulations, Geosci. Model Dev. Discuss. 
%	[preprint], https://doi.org/10.5194/gmd-2020-333, in review, 2020.
%
%   Accepted for publication: 20 April 2021
%
% Note: scripts provided to document analysis, and may require editing to
% fully replicate plots in manuscript
%
% =========================================================================
% =========================================================================

% =========================================================================
%
% This script plots Figure 17
%
% =========================================================================

helvetica;
pngopt = 0;

t1 = load('uptake_data_for_GFN_2014.txt');
obs_t = t1(:,1);
obs_flx = t1(:,2);
obs_flxmin = t1(:,3);
obs_flxmax = t1(:,4);

jobnom = char('aw310', 'bc179', 'bc292', 'bc370', ...
  'bb075', 'az513', 'az515', ...
  'az524', 'bb277', 'bc470');

for j = 1:1:10
  jnom = sprintf('PD_timeseries/u-%s_TotalAirSeaFluxCO2.shelve.txt', jobnom(j,:));
  t1 = load (jnom);
  evalstr = sprintf('mod_t.j%d = t1(:,1);', j); eval(evalstr);
  if j == 1,
    evalstr = sprintf('mod_t.j%d = t1(:,1) - 110;', j); eval(evalstr); end
  evalstr = sprintf('mod_flx.j%d = t1(:,2);', j); eval(evalstr);
end

xdat = [obs_t; flipdim(obs_t, 1)];
ydat = [obs_flxmin; flipdim(obs_flxmax, 1)];

jcol(1,:) = [0 0 0];
t1 = odvpal(11); jcol(2:10,:) = t1(2:10,:);

figure(1); clf; hold on;
ho = plot (obs_t, obs_flx, 'k-');
set (ho, 'LineWidth', 2);
for j = 1:1:10
  evalstr = sprintf('h = plot (mod_t.j%d, mod_flx.j%d, ''-'');', j, j);
  eval(evalstr);
  set (h, 'Color', jcol(j,:));
  set (h, 'LineWidth', 2);
  if j == 1, set (h, 'LineWidth', 0.5); end
end
hf = fill (xdat, ydat, [0.6 0.6 0.6]);
set (hf, 'EdgeColor', [1 1 1]);
ho = plot (obs_t, obs_flx, 'k-');
set (ho, 'LineWidth', 2);
for j = 1:1:10
  evalstr = sprintf('h = plot (mod_t.j%d, mod_flx.j%d, ''-'');', j, j);
  eval(evalstr);
  set (h, 'Color', jcol(j,:));
  set (h, 'LineWidth', 2);
  if j == 1, set (h, 'LineWidth', 0.5); end
end
j = 1;
evalstr = sprintf('h = plot (mod_t.j%d, mod_flx.j%d, ''-'');', j, j);
eval(evalstr); set (h, 'Color', jcol(j,:)); set (h, 'LineWidth', 2);
set (h, 'LineWidth', 0.5);
%
plot (obs_t, obs_t * 0, 'k:');
lg = legend ('Estimated', 'UKESM1 ctrl', 'UKESM1 hist 1', 'UKESM1 hist 2', 'UKESM1 hist 3', ...
  'UKESM1 hist 4', 'UKESM1 hist 5', 'UKESM1 hist 6', 'UKESM1 hist 7', 'UKESM1 hist 8', 'UKESM1 hist 9', 'Location', 'NorthWest');
lgpos = get(lg, 'Position'); lgpos(3) = lgpos(3) + 0.05; set(lg, 'Position', lgpos);
ylabel ('Air-sea CO_2 flux [Pg C y^{-1}]');
xlabel ('Time [year]');
topbox;
axis ([1850 2013 -0.5 3.5]); set (gca, 'XTick', 1850:50:2000);
paper; orient portrait; def_figure; print -depsc -painters co2flux_jun06_01
pngconvert('co2flux_jun06_01', 600);
axis ([1800 2013 -0.5 3.5]); set (gca, 'XTick', 1800:50:2000);
paper; orient portrait; def_figure; print -depsc -painters co2flux_jun06_02
pngconvert('co2flux_jun06_02', 600);
pdfconvert('co2flux_jun06_', 'co2flux_jun06_plots', 1);

% =====

% out to 2013
t1 = obs_flx(86:end);
tot_obs = sum(t1);
for j = 2:1:10
  evalstr = sprintf('t1 = mod_flx.j%d;', j); eval(evalstr);
  t2 = sum(t1(1:end-1));
  tot_mod(j-1) = t2;
end

% chop off at 2009
t1 = obs_flx(86:end-4);
tot_obs = sum(t1);
for j = 2:1:10
  evalstr = sprintf('t1 = mod_flx.j%d;', j); eval(evalstr);
  t2 = sum(t1(1:end-5));
  tot_mod(j-1) = t2;
end

% =====

jobnom = char('aw310', 'aw331', 'ax195', 'ax589', 'ax718', ...
  'ay078', 'ay167', 'ay491');

varnom = char('AMOC_26N', 'AMOC_26N_nomexico', 'DrakePassageTransport', 'GlobalMeanSalinity', ...
  'GlobalMeanTemperature', 'NorthernTotalIceArea', 'SouthernTotalIceArea', 'TotalAirSeaFluxCO2', ...
  'TotalIntegratedPrimaryProduction');
for v = 1:1:9, varlen(v) = lenstr(varnom(v,:)); end

for v = 1:1:9
  for j = 1:1:8
    jnom = sprintf('u-%s_%s.shelve.txt', jobnom(j,:), varnom(v,1:varlen(v)));
    fprintf('- Reading %s\n', jnom);
    t1 = load (jnom);
    evalstr = sprintf('mod_t.j%dv%d = t1(:,1);', j, v); eval(evalstr);
    evalstr = sprintf('mod_fld.j%dv%d = t1(:,2);', j, v); eval(evalstr);
  end
end

jcol(1,:) = [0 0 0];
t1 = odvpal(9); jcol(2:8,:) = t1(2:8,:);

for v = 1:1:9
  figure(1); clf; hold on;
  for j = 1:1:8
    evalstr = sprintf('xv = mod_t.j%dv%d;', j, v); eval(evalstr);
    evalstr = sprintf('yv = mod_fld.j%dv%d;', j, v); eval(evalstr);
    h = plot (xv, yv, '-');
    set (h, 'Color', jcol(j,:));
    set (h, 'LineWidth', 2);
  end
  j = 1;
  evalstr = sprintf('xv = mod_t.j%dv%d;', j, v); eval(evalstr);
  evalstr = sprintf('yv = mod_fld.j%dv%d;', j, v); eval(evalstr);
  h = plot (xv, yv, '-');
  set (h, 'Color', jcol(j,:));
  set (h, 'LineWidth', 2);
  %
  xaxis ([1850 2013]);
  xlabel ('Time [year]');
  ylabel ('[-]');
  title (fixtxt(varnom(v,1:varlen(v)))); topbox;
  pos1 = get(gca, 'Position');
  lg = legend ('ctrl', 'hist 1', 'hist 2', 'hist 3', ...
    'hist 4', 'hist 5', 'hist 6', 'hist 7', 'Location', 'SouthEastOutside');
  lgpos = get(lg, 'Position'); % lgpos(3) = lgpos(3) + 0.05; set(lg, 'Position', lgpos);
  pos2 = get(gca, 'Position');
  q1 = lgpos(1) + lgpos(3); q2 = 0.99 - q1; lgpos(1) = lgpos(1) + q2;
  q3 = pos2(1) - 0.075; pos2(1) = 0.075; pos2(3) = pos2(3) + q2 + q3;
  set(lg, 'Position', lgpos); set(gca, 'Position', pos2);
  fnom = sprintf('jun25_fields_%s', numprint(v, 2));
  paper; orient portrait; def_figure; print ('-depsc', '-painters', fnom); 
end

for v = 1:1:9
  figure(1); clf; hold on;
  for j = 1:1:8
    evalstr = sprintf('xv = mod_t.j%dv%d;', j, v); eval(evalstr);
    evalstr = sprintf('yv = mod_fld.j%dv%d;', j, v); eval(evalstr);
    yv = smooth(yv, 10);
    h = plot (xv, yv, '-');
    set (h, 'Color', jcol(j,:));
    set (h, 'LineWidth', 2);
  end
  j = 1;
  evalstr = sprintf('xv = mod_t.j%dv%d;', j, v); eval(evalstr);
  evalstr = sprintf('yv = mod_fld.j%dv%d;', j, v); eval(evalstr);
  yv = smooth(yv, 10);
  h = plot (xv, yv, '-');
  set (h, 'Color', jcol(j,:));
  set (h, 'LineWidth', 2);
  %
  xaxis ([1850 2013]);
  xlabel ('Time [year]');
  ylabel ('[-]');
  titstr = sprintf('%s, 10-year smooth', fixtxt(varnom(v,1:varlen(v)))); title (titstr); topbox;
  pos1 = get(gca, 'Position');
  lg = legend ('ctrl', 'hist 1', 'hist 2', 'hist 3', ...
    'hist 4', 'hist 5', 'hist 6', 'hist 7', 'Location', 'SouthEastOutside');
  lgpos = get(lg, 'Position'); % lgpos(3) = lgpos(3) + 0.05; set(lg, 'Position', lgpos);
  pos2 = get(gca, 'Position');
  q1 = lgpos(1) + lgpos(3); q2 = 0.99 - q1; lgpos(1) = lgpos(1) + q2;
  q3 = pos2(1) - 0.075; pos2(1) = 0.075; pos2(3) = pos2(3) + q2 + q3;
  set(lg, 'Position', lgpos); set(gca, 'Position', pos2);
  fnom = sprintf('jun25_fields_%s', numprint(v + 9, 2));
  paper; orient portrait; def_figure; print ('-depsc', '-painters', fnom); 
end

pdfconvert('jun25_fields_', 'jun25_fields_plots', 1);
