clear; startup;

% =========================================================================
% =========================================================================
%
% Matlab plotting scripts for the analysis of UKESM1 prepared for:
%
%   Yool, A., Palmiéri, J., Jones, C. G., de Mora, L., Kuhlbrodt, T., 
%   Popova, E. E., Nurser, A. J. G., Hirschi, J., Blaker, A. T., 
%	Coward, A. C., Blockley, E. W., and Sellar, A. A.: Evaluating the 
% 	physical and biogeochemical state of the global ocean component of 
%	UKESM1 in CMIP6 Historical simulations, Geosci. Model Dev. Discuss. 
%	[preprint], https://doi.org/10.5194/gmd-2020-333, in review, 2020.
%
%   Accepted for publication: 20 April 2021
%
% Note: scripts provided to document analysis, and may require editing to
% fully replicate plots in manuscript
%
% =========================================================================
% =========================================================================

% =========================================================================
%
% This script plots Figures 23 and 24, and Supplementary Figures S10, S21,
% S22, S23, S24, S25 and S26
%
% =========================================================================

varnom = char('no3', 'si', 'chl', 'intpp', 'dissic', 'talk', 'fgco2');
for v = 1:1:7, varlen(v) = lenstr(varnom(v,:)); end

% HadGEM2-ES, 195912-200519
dnom = char('HadGEM2ES');
inom = char('Omon_HadGEM2-ES_historical_r1i1p1_195912-200512.nc');
for v = 1:1:7
  vnom = varnom(v,1:varlen(v));
  fnom = sprintf('%s/%s_%s', dnom, vnom, inom); fprintf('- Reading %s\n', fnom);
  t1 = ncread(fnom, vnom);
  t2 = permute(t1, [2 1 3]);
  t3 = t2(:,:,end-119:end);
  clear t4; for m = 1:1:12
    t4(:,:,m) = mean(t3(:,:,m:12:end), 3);
  end
  t5 = mean(t4, 3);
  evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); eval(evalstr);
  evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); eval(evalstr);
  if v == 1
    t1 = ncread(fnom, 'lat');
    t2 = ncread(fnom, 'lon');
    evalstr = sprintf('%s.lat = t1;', dnom); eval(evalstr);
    evalstr = sprintf('%s.lon = t2;', dnom); eval(evalstr);
  end
end

save ('HadGEM2ES_CMIP5', 'HadGEM2ES_mon', 'HadGEM2ES_ann', 'HadGEM2ES', '-v7.3');

% CanESM5, 1850-2014
dnom = char('CanESM5');
vnom = char('no3'); inom = sprintf('%s/%s_Oyr_CanESM5_historical_r1i1p1f1_gn_1850-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,150:159)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
t1 = ncread(inom, 'latitude'); evalstr = sprintf('%s.lat = t1;', dnom); eval(evalstr);
t1 = ncread(inom, 'longitude'); evalstr = sprintf('%s.lon = t1;', dnom); eval(evalstr);
%
vnom = char('chl'); inom = sprintf('%s/%s_Oyr_CanESM5_historical_r1i1p1f1_gn_1850-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,150:159)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('intpp'); inom = sprintf('%s/%s_Omon_CanESM5_historical_r1i1p2f1_gn_185001-201412.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3]); t3 = squeeze(t2(:,:,(end-179):(end-60)));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('dissic'); inom = sprintf('%s/%s_Oyr_CanESM5_historical_r1i1p1f1_gn_1850-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,150:159)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('talk'); inom = sprintf('%s/%s_Oyr_CanESM5_historical_r1i1p1f1_gn_1850-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,150:159)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('fgco2'); inom = sprintf('%s/%s_Oyr_CanESM5_historical_r1i1p1f1_gn_1850-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3]); t3 = mean(squeeze(t2(:,:,150:159)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);

save ('CanESM5_CMIP6', 'CanESM5_mon', 'CanESM5_ann', 'CanESM5', '-v7.3');

% CESM2, 2000-2014
dnom = char('CESM2');
vnom = char('no3'); inom = sprintf('%s/%s_Oyr_CESM2-FV2_historical_r1i1p1f1_gn_2000-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,1:10)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
t1 = ncread(inom, 'lat'); evalstr = sprintf('%s.lat = t1;', dnom); eval(evalstr);
t1 = ncread(inom, 'lon'); evalstr = sprintf('%s.lon = t1;', dnom); eval(evalstr);
%
vnom = char('si'); inom = sprintf('%s/%s_Oyr_CESM2-FV2_historical_r1i1p1f1_gn_2000-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,1:10)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('chl'); inom = sprintf('%s/%s_Oyr_CESM2-FV2_historical_r1i1p1f1_gn_2000-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,1:10)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('dissic'); inom = sprintf('%s/%s_Oyr_CESM2-FV2_historical_r1i1p1f1_gn_2000-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,1:10)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('talk'); inom = sprintf('%s/%s_Oyr_CESM2-FV2_historical_r1i1p1f1_gn_2000-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,1:10)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('fgco2'); inom = sprintf('%s/%s_Oyr_CESM2-FV2_historical_r1i1p1f1_gn_2000-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3]); t3 = mean(squeeze(t2(:,:,1:10)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);

save ('CESM2_CMIP6', 'CESM2_ann', 'CESM2', '-v7.3');

% CNRM, 2000-2014
dnom = char('CNRM');
vnom = char('no3'); inom = sprintf('%s/%s_Omon_CNRM-ESM2-1_historical_r1i1p1f2_gn_200001-201412.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = squeeze(t2(:,:,1,1:120));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
t1 = ncread(inom, 'lat'); evalstr = sprintf('%s.lat = t1;', dnom); eval(evalstr);
t1 = ncread(inom, 'lon'); evalstr = sprintf('%s.lon = t1;', dnom); eval(evalstr);
%
vnom = char('si'); inom = sprintf('%s/%s_Omon_CNRM-ESM2-1_historical_r1i1p1f2_gn_200001-201412.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = squeeze(t2(:,:,1,1:120));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('chl'); inom = sprintf('%s/%s_Omon_CNRM-ESM2-1_historical_r1i1p1f2_gn_200001-201412.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = squeeze(t2(:,:,1,1:120));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('intpp'); inom = sprintf('%s/%s_Omon_CNRM-ESM2-1_historical_r1i1p1f2_gn_185001-201412.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3]); t3 = squeeze(t2(:,:,1801:19201:120));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('dissic'); inom = sprintf('%s/%s_Omon_CNRM-ESM2-1_historical_r1i1p1f2_gn_200001-201412.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = squeeze(t2(:,:,1,1:120));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('talk'); inom = sprintf('%s/%s_Omon_CNRM-ESM2-1_historical_r1i1p1f2_gn_200001-201412.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = squeeze(t2(:,:,1,1:120));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('fgco2'); inom = sprintf('%s/%s_Omon_CNRM-ESM2-1_historical_r1i1p1f2_gn_185001-201412.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3]); t3 = squeeze(t2(:,:,1801:1920));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);

save ('CNRM_CMIP6', 'CNRM_mon', 'CNRM_ann', 'CNRM', '-v7.3');

% IPSL, 1850-2014
dnom = char('IPSL');
vnom = char('no3'); inom = sprintf('%s/%s_Oyr_IPSL-CM6A-LR_historical_r32i1p1f1_gn_1850-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,151:160)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
t1 = ncread(inom, 'nav_lat'); evalstr = sprintf('%s.lat = t1;', dnom); eval(evalstr);
t1 = ncread(inom, 'nav_lon'); evalstr = sprintf('%s.lon = t1;', dnom); eval(evalstr);
%
vnom = char('si'); inom = sprintf('%s/%s_Oyr_IPSL-CM6A-LR_historical_r32i1p1f1_gn_1850-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,151:160)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('chl'); inom = sprintf('%s/%s_Oyr_IPSL-CM6A-LR_historical_r32i1p1f1_gn_1850-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,151:160)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('intpp'); inom = sprintf('%s/%s_Omon_IPSL-CM6A-LR_historical_r32i1p1f1_gn_185001-201412.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3]); t3 = squeeze(t2(:,:,1801:1920));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('dissic'); inom = sprintf('%s/%s_Oyr_IPSL-CM6A-LR_historical_r32i1p1f1_gn_1850-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,151:160)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('talk'); inom = sprintf('%s/%s_Oyr_IPSL-CM6A-LR_historical_r32i1p1f1_gn_1850-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,151:160)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('fgco2'); inom = sprintf('%s/%s_Oyr_IPSL-CM6A-LR_historical_r32i1p1f1_gn_1850-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3]); t3 = mean(squeeze(t2(:,:,151:160)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);

save ('IPSL_CMIP6', 'IPSL_mon', 'IPSL_ann', 'IPSL', '-v7.3');

% MIROC, 1850-2014
dnom = char('MIROC');
vnom = char('no3'); inom = sprintf('%s/%s_Oyr_MIROC-ES2L_historical_r1i1p1f2_gn_1850-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,151:160)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
t1 = ncread(inom, 'latitude'); evalstr = sprintf('%s.lat = t1;', dnom); eval(evalstr);
t1 = ncread(inom, 'longitude'); evalstr = sprintf('%s.lon = t1;', dnom); eval(evalstr);
%
vnom = char('chl'); inom = sprintf('%s/%s_Oyr_MIROC-ES2L_historical_r1i1p1f2_gn_1850-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,151:160)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('intpp'); inom = sprintf('%s/%s_Omon_MIROC-ES2L_historical_r1i1p1f2_gn_185001-201412.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3]); t3 = squeeze(t2(:,:,1801:1920));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('dissic'); inom = sprintf('%s/%s_Omon_MIROC-ES2L_historical_r1i1p1f2_gn_185001-201412.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom, [1 1 1 1801], [inf inf 1 120]); t2 = permute(t1, [2 1 3 4]); t3 = squeeze(t2(:,:,1,:));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('talk'); inom = sprintf('%s/%s_Omon_MIROC-ES2L_historical_r1i1p1f2_gn_185001-201412.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom, [1 1 1 1801], [inf inf 1 120]); t2 = permute(t1, [2 1 3 4]); t3 = squeeze(t2(:,:,1,:));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('fgco2'); inom = sprintf('%s/%s_Oyr_MIROC-ES2L_historical_r1i1p1f2_gn_1850-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3]); t3 = mean(squeeze(t2(:,:,151:160)),3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);

save ('MIROC_CMIP6', 'MIROC_mon', 'MIROC_ann', 'MIROC', '-v7.3');

% MPI, 1850-2014
dnom = char('MPI');
vnom = char('no3'); inom = sprintf('%s/%s_Oyr_MPI-ESM1-2-LR_historical_r1i1p1f1_gn_1990-2009.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,11:20)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
t1 = ncread(inom, 'latitude'); evalstr = sprintf('%s.lat = t1;', dnom); eval(evalstr);
t1 = ncread(inom, 'longitude'); evalstr = sprintf('%s.lon = t1;', dnom); eval(evalstr);
%
vnom = char('si'); inom = sprintf('%s/%s_Oyr_MPI-ESM1-2-LR_historical_r1i1p1f1_gn_1990-2009.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,11:20)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('chl'); inom = sprintf('%s/%s_Oyr_MPI-ESM1-2-LR_historical_r1i1p1f1_gn_1990-2009.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,11:20)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('intpp'); inom = sprintf('%s/%s_Omon_MPI-ESM1-2-LR_historical_r1i1p1f1_gn_199001-200912.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3]); t3 = squeeze(t2(:,:,121:240));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('dissic'); inom = sprintf('%s/%s_Omon_MPI-ESM1-2-LR_historical_r1i1p1f1_gn_199001-200912.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = squeeze(t2(:,:,1,121:240));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('talk'); inom = sprintf('%s/%s_Omon_MPI-ESM1-2-LR_historical_r1i1p1f1_gn_199001-200912.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = squeeze(t2(:,:,1,121:240));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('fgco2'); inom = sprintf('%s/%s_Oyr_MPI-ESM1-2-LR_historical_r1i1p1f1_gn_1990-2009.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3]); t3 = mean(squeeze(t2(:,:,11:20)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);

save ('MPI_CMIP6', 'MPI_mon', 'MPI_ann', 'MPI', '-v7.3');

% MRI, 1950-2014
dnom = char('MRI');
vnom = char('no3'); inom = sprintf('%s/%s_Oyr_MRI-ESM2-0_historical_r1i2p1f1_gn_1950-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,51:60)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
t1 = ncread(inom, 'latitude'); evalstr = sprintf('%s.lat = t1;', dnom); eval(evalstr);
t1 = ncread(inom, 'longitude'); evalstr = sprintf('%s.lon = t1;', dnom); eval(evalstr);
%
vnom = char('chl'); inom = sprintf('%s/%s_Oyr_MRI-ESM2-0_historical_r1i2p1f1_gn_1950-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,51:60)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('intpp'); inom = sprintf('%s/%s_Omon_MRI-ESM2-0_historical_r1i2p1f1_gn_185001-201412.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3]); t3 = squeeze(t2(:,:,1801:1920));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('dissic'); inom = sprintf('%s/%s_Oyr_MRI-ESM2-0_historical_r1i2p1f1_gn_1950-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,51:60)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('talk'); inom = sprintf('%s/%s_Oyr_MRI-ESM2-0_historical_r1i2p1f1_gn_1950-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,51:60)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('fgco2'); inom = sprintf('%s/%s_Oyr_MRI-ESM2-0_historical_r1i2p1f1_gn_1850-2014.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3]); t3 = mean(squeeze(t2(:,:,151:160)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);

save ('MRI_CMIP6', 'MRI_mon', 'MRI_ann', 'MRI', '-v7.3');

% NorESM2, 1850-2014
dnom = char('NorESM2');
vnom = char('no3'); inom = sprintf('%s/%s_Oyr_NorESM2-LM_historical_r1i1p1f1_gn_2000-2009.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,:)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
t1 = ncread(inom, 'latitude'); evalstr = sprintf('%s.lat = t1;', dnom); eval(evalstr);
t1 = ncread(inom, 'longitude'); evalstr = sprintf('%s.lon = t1;', dnom); eval(evalstr);
%
vnom = char('si'); inom = sprintf('%s/%s_Oyr_NorESM2-LM_historical_r1i1p1f1_gn_2000-2009.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,:)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('chl'); inom = sprintf('%s/%s_Omon_NorESM2-LM_historical_r1i1p1f1_gr_200001-200912.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = squeeze(t2(:,:,1,:));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('intpp'); inom = sprintf('%s/%s_Omon_NorESM2-LM_historical_r1i1p1f1_gn_200001-200912.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3]); t3 = squeeze(t2(:,:,:));
clear t4; for m = 1:1:12, t4(:,:,m) = mean(t3(:,:,m:12:end), 3); end; t5 = mean(t4, 3);
evalstr = sprintf('%s_mon.%s = t4;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
evalstr = sprintf('%s_ann.%s = t5;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('dissic'); inom = sprintf('%s/%s_Oyr_NorESM2-LM_historical_r1i1p1f1_gn_2000-2009.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,:)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('talk'); inom = sprintf('%s/%s_Oyr_NorESM2-LM_historical_r1i1p1f1_gn_2000-2009.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3 4]); t3 = mean(squeeze(t2(:,:,1,:)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);
%
vnom = char('fgco2'); inom = sprintf('%s/%s_Oyr_NorESM2-LM_historical_r1i1p1f1_gn_2000-2009.nc', dnom, vnom); fprintf('- Reading %s\n', inom);
t1 = ncread(inom, vnom); t2 = permute(t1, [2 1 3]); t3 = mean(squeeze(t2(:,:,:)), 3);
evalstr = sprintf('%s_ann.%s = t3;', dnom, vnom); fprintf('- Reading %s\n', inom); eval(evalstr);

save ('NorESM2_CMIP6', 'NorESM2_mon', 'NorESM2_ann', 'NorESM2', '-v7.3');

% ======================================================================
% ======================================================================
% ======================================================================

clear; startup;

load ukesm1_PD_ensemble

% load up background files
load nemo_area100e
load nemo_mask100e
fname = sprintf('%s/mean_nemo_%so_1y_20001201-20101201_grid-T.nc', dname(1).name, rname(1).name);
t1 = ncread(fname, 'deptht_bounds');
nemo_dep = double(t1(1,:)); nemo_dep(end+1) = double(t1(2,end));
t1 = ncread(fname, 'deptht');
nemo_mid = double(t1');

% total grid area
t1 = area100e + nemo_mask100e(:,:,1);
t2 = isfinite(t1);
tot_area100e = sum(t1(t2)); % m2

% extra mask to get rid of Mediterranean, Black and Caspian Seas
t1 = nemo_mask100e(:,:,1) + 1;
t1(isnan(t1)) = 0;
t1(235:249,283:344) = t1(235:249,283:344) + 2;
t1(249:262,291:344) = t1(249:262,291:344) + 4;
t1(262:276,330:344) = t1(262:276,330:344) + 8;
t2 = t1;
t2(t1 < 1) = NaN; t2(t1 > 1) = NaN;
med_mask100e = t2;

nxx = -179.5:1:179.5;  nyy = -89.5:1:89.5;
[lon100, lat100] = meshgrid(nxx, nyy);
nxx = -180:1:180;  nyy = -90:1:90;
[lon100b, lat100b] = meshgrid(nxx, nyy);

load woa_mask
clear t1; t1(:,1:180) = woa_mask(:,181:360); t1(:,181:360) = woa_mask(:,1:180);
woa_mask = t1;

load woa_basin

helvetica;
pngopt = 0;

% ======================================================================

mnom = char('HadGEM2ES', 'CESM2', 'CNRM', 'CanESM5', 'IPSL', 'MIROC', ...
  'MPI', 'MRI', 'NorESM2');
for m = 1:1:9, mlen(m) = lenstr(mnom(m,:)); end

varnom = char('no3', 'si', 'chl', 'intpp', 'dissic', 'talk', 'fgco2');
for v = 1:1:7, varlen(v) = lenstr(varnom(v,:)); end

load HadGEM2ES_CMIP5
for m = 2:1:9
  evalstr = sprintf('load %s_CMIP6', mnom(m,1:mlen(m))); eval (evalstr);
end

% HadGEM2ES
got_var = [1 1 1 1 1 1 1];
[this_lon, this_lat] = meshgrid(HadGEM2ES.lon, HadGEM2ES.lat);
m = 1;
for v = 1:1:7
  if got_var(v) == 1
    evalstr = sprintf('t0 = %s_ann.%s;', mnom(m,1:mlen(m)), varnom(v,1:varlen(v))); fprintf('%s\n', evalstr); eval(evalstr);
    t1 = [t0 t0 t0]; 
    x1 = [(this_lon - 360) this_lon (this_lon + 360)]; y1 = [this_lat this_lat this_lat];
    t2 = isfinite(t1); tq = t1(t2); xq = x1(t2); yq = y1(t2);
    F = scatteredInterpolant(xq, yq, tq); t3 = F(lon100, lat100);
    cmip6_regrid(:,:,v,m) = t3 + woa_mask;
  else
    cmip6_regrid(:,:,v,m) = lon100 + NaN;
  end
end

% CESM2
got_var = [1 1 1 0 1 1 1];
this_lon = permute(CESM2.lon, [2 1]); this_lat = permute(CESM2.lat, [2 1]); 
this_lon = double(this_lon); this_lat = double(this_lat);
m = 2;
for v = 1:1:7
  if got_var(v) == 1
    evalstr = sprintf('t0 = %s_ann.%s;', mnom(m,1:mlen(m)), varnom(v,1:varlen(v))); fprintf('%s\n', evalstr); eval(evalstr);
    t1 = [t0 t0 t0]; 
    x1 = [(this_lon - 360) this_lon (this_lon + 360)]; y1 = [this_lat this_lat this_lat];
    t2 = isfinite(t1); tq = t1(t2); xq = x1(t2); yq = y1(t2);
    F = scatteredInterpolant(xq, yq, tq); t3 = F(lon100, lat100);
    cmip6_regrid(:,:,v,m) = t3 + woa_mask;
  else
    cmip6_regrid(:,:,v,m) = lon100 + NaN;
  end
end

% CNRM
got_var = [1 1 1 1 1 1 1];
this_lon = permute(CNRM.lon, [2 1]); this_lat = permute(CNRM.lat, [2 1]); 
this_lon = double(this_lon); this_lat = double(this_lat);
m = 3;
for v = 1:1:7
  if got_var(v) == 1
    evalstr = sprintf('t0 = %s_ann.%s;', mnom(m,1:mlen(m)), varnom(v,1:varlen(v))); fprintf('%s\n', evalstr); eval(evalstr);
    t1 = [t0 t0 t0]; 
    x1 = [(this_lon - 360) this_lon (this_lon + 360)]; y1 = [this_lat this_lat this_lat];
    t2 = isfinite(t1); tq = t1(t2); xq = x1(t2); yq = y1(t2);
    F = scatteredInterpolant(xq, yq, tq); t3 = F(lon100, lat100);
    cmip6_regrid(:,:,v,m) = t3 + woa_mask;
  else
    cmip6_regrid(:,:,v,m) = lon100 + NaN;
  end
end

% CanESM5
got_var = [1 0 1 1 1 1 1];
this_lon = permute(CanESM5.lon, [2 1]); this_lat = permute(CanESM5.lat, [2 1]); 
this_lon = double(this_lon); this_lat = double(this_lat);
m = 4;
for v = 1:1:7
  if got_var(v) == 1
    evalstr = sprintf('t0 = %s_ann.%s;', mnom(m,1:mlen(m)), varnom(v,1:varlen(v))); fprintf('%s\n', evalstr); eval(evalstr);
    t1 = [t0 t0 t0]; 
    x1 = [(this_lon - 360) this_lon (this_lon + 360)]; y1 = [this_lat this_lat this_lat];
    t2 = isfinite(t1); tq = t1(t2); xq = x1(t2); yq = y1(t2);
    F = scatteredInterpolant(xq, yq, tq); t3 = F(lon100, lat100);
    cmip6_regrid(:,:,v,m) = t3 + woa_mask;
  else
    cmip6_regrid(:,:,v,m) = lon100 + NaN;
  end
end

% IPSL
got_var = [1 1 1 1 1 1 1];
this_lon = permute(IPSL.lon, [2 1]); this_lat = permute(IPSL.lat, [2 1]); 
this_lon = double(this_lon); this_lat = double(this_lat);
m = 5;
for v = 1:1:7
  if got_var(v) == 1
    evalstr = sprintf('t0 = %s_ann.%s;', mnom(m,1:mlen(m)), varnom(v,1:varlen(v))); fprintf('%s\n', evalstr); eval(evalstr);
    t1 = [t0 t0 t0]; 
    x1 = [(this_lon - 360) this_lon (this_lon + 360)]; y1 = [this_lat this_lat this_lat];
    t2 = isfinite(t1); tq = t1(t2); xq = x1(t2); yq = y1(t2);
    F = scatteredInterpolant(xq, yq, tq); t3 = F(lon100, lat100);
    cmip6_regrid(:,:,v,m) = t3 + woa_mask;
  else
    cmip6_regrid(:,:,v,m) = lon100 + NaN;
  end
end

% MIROC
got_var = [1 0 1 1 1 1 1];
this_lon = permute(MIROC.lon, [2 1]); this_lat = permute(MIROC.lat, [2 1]); 
m = 6;
for v = 1:1:7
  if got_var(v) == 1
    evalstr = sprintf('t0 = %s_ann.%s;', mnom(m,1:mlen(m)), varnom(v,1:varlen(v))); fprintf('%s\n', evalstr); eval(evalstr);
    t1 = [t0 t0 t0]; 
    x1 = [(this_lon - 360) this_lon (this_lon + 360)]; y1 = [this_lat this_lat this_lat];
    t2 = isfinite(t1); tq = t1(t2); xq = x1(t2); yq = y1(t2);
    F = scatteredInterpolant(xq, yq, tq); t3 = F(lon100, lat100);
    cmip6_regrid(:,:,v,m) = t3 + woa_mask;
  else
    cmip6_regrid(:,:,v,m) = lon100 + NaN;
  end
end

% MPI
got_var = [1 1 1 1 1 1 1];
this_lon = permute(MPI.lon, [2 1]); this_lat = permute(MPI.lat, [2 1]); 
m = 7;
for v = 1:1:7
  if got_var(v) == 1
    evalstr = sprintf('t0 = %s_ann.%s;', mnom(m,1:mlen(m)), varnom(v,1:varlen(v))); fprintf('%s\n', evalstr); eval(evalstr);
    t1 = [t0 t0 t0]; 
    x1 = [(this_lon - 360) this_lon (this_lon + 360)]; y1 = [this_lat this_lat this_lat];
    t2 = isfinite(t1); tq = t1(t2); xq = x1(t2); yq = y1(t2);
    F = scatteredInterpolant(xq, yq, tq); t3 = F(lon100, lat100);
    cmip6_regrid(:,:,v,m) = t3 + woa_mask;
  else
    cmip6_regrid(:,:,v,m) = lon100 + NaN;
  end
end

% MRI
got_var = [1 0 1 1 1 1 1];
this_lon = permute(MRI.lon, [2 1]); this_lat = permute(MRI.lat, [2 1]); 
m = 8;
for v = 1:1:7
  if got_var(v) == 1
    evalstr = sprintf('t0 = %s_ann.%s;', mnom(m,1:mlen(m)), varnom(v,1:varlen(v))); fprintf('%s\n', evalstr); eval(evalstr);
    t1 = [t0 t0 t0]; 
    x1 = [(this_lon - 360) this_lon (this_lon + 360)]; y1 = [this_lat this_lat this_lat];
    t2 = isfinite(t1); tq = t1(t2); xq = x1(t2); yq = y1(t2);
    F = scatteredInterpolant(xq, yq, tq); t3 = F(lon100, lat100);
    cmip6_regrid(:,:,v,m) = t3 + woa_mask;
  else
    cmip6_regrid(:,:,v,m) = lon100 + NaN;
  end
end

% NorESM2
got_var = [1 1 1 1 1 1 1];
this_lon = permute(NorESM2.lon, [2 1]); this_lat = permute(NorESM2.lat, [2 1]); 
m = 9;
for v = 1:1:7
  if got_var(v) == 1
    evalstr = sprintf('t0 = %s_ann.%s;', mnom(m,1:mlen(m)), varnom(v,1:varlen(v))); fprintf('%s\n', evalstr); eval(evalstr);
    t1 = [t0 t0 t0]; 
    x1 = [(this_lon - 360) this_lon (this_lon + 360)]; y1 = [this_lat this_lat this_lat];
    t2 = isfinite(t1); tq = t1(t2); xq = x1(t2); yq = y1(t2);
    F = scatteredInterpolant(xq, yq, tq); t3 = F(lon100, lat100);
    cmip6_regrid(:,:,v,m) = t3 + woa_mask;
  else
    cmip6_regrid(:,:,v,m) = lon100 + NaN;
  end
end

save ('cmip6_ann_regrid', 'cmip6_regrid', 'lon100', 'lat100', '-v7.3');

% ======================================================================
% ======================================================================
% ======================================================================

clear; startup;

load woa_mask
clear t1; t1(:,1:180) = woa_mask(:,181:360); t1(:,181:360) = woa_mask(:,1:180);
woa_mask = t1;

load woa_basin

helvetica;
pngopt = 0;

for y = 1:1:10, yr = 1999 + y;
  for m = 1:1:12
    fnom = sprintf('~/BIO/ROAM_runs/EXP550/%d/ORCA1_%d%s30d30P.nc', yr, yr, numprint(m, 2)); fprintf(' - Reading %s\n', fnom);
    t1 = ncread(fnom, 'DIN', [1 1 1 1], [362 292 1 1]); t2 = permute(t1, [2 1 3]); tmp_fld(:,:,m,y,1) = t2;
    t1 = ncread(fnom, 'SIL', [1 1 1 1], [362 292 1 1]); t2 = permute(t1, [2 1 3]); tmp_fld(:,:,m,y,2) = t2;
    t1 = ncread(fnom, 'CHN', [1 1 1 1], [362 292 1 1]); t2 = permute(t1, [2 1 3]); tmp_fld(:,:,m,y,3) = t2;
    t1 = ncread(fnom, 'CHD', [1 1 1 1], [362 292 1 1]); t2 = permute(t1, [2 1 3]); tmp_fld(:,:,m,y,3) = tmp_fld(:,:,m,y,3) + t2;
    t1 = ncread(fnom, 'DIC', [1 1 1 1], [362 292 1 1]); t2 = permute(t1, [2 1 3]); tmp_fld(:,:,m,y,5) = t2;
    t1 = ncread(fnom, 'ALK', [1 1 1 1], [362 292 1 1]); t2 = permute(t1, [2 1 3]); tmp_fld(:,:,m,y,6) = t2;
    fnom = sprintf('~/BIO/ROAM_runs/EXP550/%d/ORCA1_%d%s30d30D.nc', yr, yr, numprint(m, 2)); fprintf(' - Reading %s\n', fnom);
    t1 = ncread(fnom, 'PRN'); t2 = permute(t1, [2 1]); tmp_fld(:,:,m,y,4) = t2;
    t1 = ncread(fnom, 'PRD'); t2 = permute(t1, [2 1]); tmp_fld(:,:,m,y,4) = tmp_fld(:,:,m,y,4) + t2;
    t1 = ncread(fnom, 'CO2FLUX'); t2 = permute(t1, [2 1]); tmp_fld(:,:,m,y,7) = t2;
  end
end

varnom = char('no3', 'si', 'chl', 'intpp', 'dissic', 'talk', 'fgco2');
for v = 1:1:7, varlen(v) = lenstr(varnom(v,:)); end

for f = 1:1:7
  t1 = tmp_fld(:,:,:,:,f); t1(:,1,:,:) = t1(:,361,:,:); t1(:,362,:,:) = t1(:,2,:,:);
  t2 = squeeze(mean(t1, 4));
  t3 = mean(t2, 3);
  evalstr = sprintf('MEDUSA_mon.%s = t2;', varnom(f,1:varlen(f))); eval(evalstr);
  evalstr = sprintf('MEDUSA_ann.%s = t3;', varnom(f,1:varlen(f))); eval(evalstr);
end

load nemo_grid;

nxx = -179.5:1:179.5;  nyy = -89.5:1:89.5;
[lon100, lat100] = meshgrid(nxx, nyy);

MEDUSA.lon = xx; MEDUSA.lat = yy;

% MEDUSA
got_var = [1 1 1 1 1 1 1];
this_lon = permute(MEDUSA.lon, [1 2]); this_lat = permute(MEDUSA.lat, [1 2]); 
for v = 1:1:7
  if got_var(v) == 1
    evalstr = sprintf('t0 = %s_ann.%s;', 'MEDUSA', varnom(v,1:varlen(v))); fprintf('%s\n', evalstr); eval(evalstr);
    t1 = [t0 t0 t0]; 
    x1 = [(this_lon - 360) this_lon (this_lon + 360)]; y1 = [this_lat this_lat this_lat];
    t2 = isfinite(t1); tq = t1(t2); xq = x1(t2); yq = y1(t2);
    F = scatteredInterpolant(xq, yq, tq); t3 = F(lon100, lat100);
    medusa_regrid(:,:,v) = t3 + woa_mask;
  else
    medusa_regrid(:,:,v) = lon100 + NaN;
  end
end

save ('MEDUSA_for_CMIP6', 'MEDUSA_mon', 'MEDUSA_ann', 'MEDUSA', 'medusa_regrid', 'lon100', 'lat100', '-v7.3');

% ======================================================================
% ======================================================================
% ======================================================================

clear; startup;

% =========================================================================

load ukesm1_PD_ensemble

% =========================================================================

% load up background files
load nemo_area100e
load nemo_mask100e
fname = sprintf('%s/mean_nemo_%so_1y_20001201-20101201_grid-T.nc', dname(1).name, rname(1).name);
t1 = ncread(fname, 'deptht_bounds');
nemo_dep = double(t1(1,:)); nemo_dep(end+1) = double(t1(2,end));
t1 = ncread(fname, 'deptht');
nemo_mid = double(t1');

% total grid area
t1 = area100e + nemo_mask100e(:,:,1);
t2 = isfinite(t1);
tot_area100e = sum(t1(t2)); % m2

% extra mask to get rid of Mediterranean, Black and Caspian Seas
t1 = nemo_mask100e(:,:,1) + 1;
t1(isnan(t1)) = 0;
t1(235:249,283:344) = t1(235:249,283:344) + 2;
t1(249:262,291:344) = t1(249:262,291:344) + 4;
t1(262:276,330:344) = t1(262:276,330:344) + 8;
t2 = t1;
t2(t1 < 1) = NaN; t2(t1 > 1) = NaN;
med_mask100e = t2;

nxx = -179.5:1:179.5;  nyy = -89.5:1:89.5;
[lon100, lat100] = meshgrid(nxx, nyy);
nxx = -180:1:180;  nyy = -90:1:90;
[lon100b, lat100b] = meshgrid(nxx, nyy);

load woa_mask
clear t1; t1(:,1:180) = woa_mask(:,181:360); t1(:,181:360) = woa_mask(:,1:180);
woa_mask = t1;

load woa_basin

helvetica;
pngopt = 0;

% =========================================================================

% % load up observational data
% load OBS/obs_2d_seas_moll_states.mat

load OBS/woa09_din
t1 = squeeze(woa_din(:,:,1,:));pwd
clear t2; t2(:,1:180,:) = t1(:,181:360,:); t2(:,181:360,:) = t1(:,1:180,:);
obs_mon_surf_din = t2;

load OBS/woa09_sil
t1 = squeeze(woa_sil(:,:,1,:));
clear t2; t2(:,1:180,:) = t1(:,181:360,:); t2(:,181:360,:) = t1(:,1:180,:);
obs_mon_surf_sil = t2;

load seawifs_chl_1997-2010
obs_mon_surf_chl = chl_100_clim + repmat(woa_mask, [1 1 12]);

load OBS/mon_vgpm1_npp
load OBS/mon_eppl1_npp
load OBS/mon_cbpm1_npp
t1 = (mon_vgpm1 + mon_eppl1 + mon_cbpm1) / 3;
obs_mon_npp = t1;

load OBS/woa09_dic_v3
obs_ann_surf_dic = end_dic(:,:,1);

load OBS/woa09_alk_v3
obs_ann_surf_alk = end_alk(:,:,1);

obs_surf(:,:,1) = mean(obs_mon_surf_din, 3);
obs_surf(:,:,2) = mean(obs_mon_surf_sil, 3);
obs_surf(:,:,3) = chl_100_ann; % just use special annual mean
obs_surf(:,:,4) = mean(obs_mon_npp, 3);
clear t1; t1(:,1:180) = obs_ann_surf_dic(:,181:360); t1(:,181:360) = obs_ann_surf_dic(:,1:180);
obs_surf(:,:,5) = t1;
clear t1; t1(:,1:180) = obs_ann_surf_alk(:,181:360); t1(:,181:360) = obs_ann_surf_alk(:,1:180);
obs_surf(:,:,6) = t1;

addpath('/noc/users/axy/Matlab/Datasets/Rodenbeck');

load rodenbeck_1982-2017_monthly_CO2_WOAgrid.mat

t1 = rg_mon_flux(:,:,:,18:27);
clear obs_flux; for m = 1:1:12, obs_flux(:,:,m) = mean(t1(:,:,m,:), 4); end

obs_surf(:,:,7) = mean(obs_flux, 3) + woa_mask;

% =========================================================================

load ukesm1_PD_output_27nov19
 
% vnom = char('din', 'sil', 'fer', 'chl', 'tpp', 'prn', 'prd', 'dic', 'alk', 'ph', ...
%   'cal', 'ccd', 'dpc', 'flx', 'oxy', 'phn', 'phd', 'pds', 'mlp', 'sfr', ...
%   'opl', 'cal', 'zmi', 'zme', 'scp', 'fcp', 's100', 'f100', 'pnjlim', 'pnnlim', ...
%   'pnflim', 'pdjlim', 'pdnlim', 'pdflim', 'pdslim');

% to use this script, need to first regrid to regwhoular 1-degree
use_surf(:,:,1) = states_2d(:,:,13,1);
use_surf(:,:,2) = states_2d(:,:,13,2);
use_surf(:,:,3) = states_2d(:,:,13,4);
use_surf(:,:,4) = states_2d(:,:,13,5);
use_surf(:,:,5) = states_2d(:,:,13,8);
use_surf(:,:,6) = states_2d(:,:,13,9);
use_surf(:,:,7) = states_2d(:,:,13,14);

this_lon = xx100e; this_lat = yy100e;
for v = 1:1:7
  t0 = use_surf(:,2:1:361,v);
    t1 = [t0 t0 t0]; 
    x1 = [(this_lon - 360) this_lon (this_lon + 360)]; y1 = [this_lat this_lat this_lat];
    t2 = isfinite(t1); tq = t1(t2); xq = x1(t2); yq = y1(t2);
    F = scatteredInterpolant(xq, yq, tq); t3 = F(lon100, lat100);
    ukesm1_regrid(:,:,v) = t3 + woa_mask;
end

% =========================================================================

load MEDUSA_for_CMIP6

% =========================================================================

load cmip6_ann_regrid

% =========================================================================

plot_var(:,:,:,1) = obs_surf;
plot_var(:,:,:,2) = ukesm1_regrid;
plot_var(:,:,:,3) = medusa_regrid;
plot_var(:,:,:,4:12) = cmip6_regrid;

% check units

% for i = 1:1:7
%   
%   figure(1); clf; odvpal(60);
%   for m = 1:1:4
%     subplot (2,2,m);
%     pcolor (plot_var(:,:,i,m)); shading flat; colorbar;
%   end
%   pause
%   
% end

plot_var(:,:,1,4:12) = plot_var(:,:,1,4:12) * 1e3;
plot_var(:,:,2,4:12) = plot_var(:,:,2,4:12) * 1e3;
plot_var(:,:,3,4:12) = plot_var(:,:,3,4:12) * 1e6;
plot_var(:,:,3,6:2:8) = plot_var(:,:,3,6:2:8) * 1e-3;
plot_var(:,:,4,3) = plot_var(:,:,4,3) * 1e-3 * 6.625 * 12.011;
plot_var(:,:,4,4:12) = plot_var(:,:,4,4:12) * 86400 * 12.011;
plot_var(:,:,5,4:12) = plot_var(:,:,5,4:12) * 1e3;
plot_var(:,:,6,4:12) = plot_var(:,:,6,4:12) * 1e3;
plot_var(:,:,7,1) = plot_var(:,:,7,1) * (-1 * 1e15 * 1e-3 / 12.011 / 360 );
plot_var(:,:,7,3) = plot_var(:,:,7,3) * 6.06; 
plot_var(:,:,7,4:12) = plot_var(:,:,7,4:12) * 86400 * 1e6 / 12.011;

for i = 1:1:7
  
  figure(1); clf; odvpal(60);
  for m = 1:1:9
    subplot (3,3,m);
    pcolor (plot_var(:,:,i,m+3)); shading flat; colorbar;
  end
  pause
  
end

% =========================================================================

mnom = char('Observations', 'UKESM1', 'MEDUSA-2',...
  'HadGEM2-ES', 'CESM2-FV2', 'CNRM-ESM2-1', ...
  'CanESM5', 'IPSL-CM6A-LR', 'MIROC-ES2L', ...
  'MPI-ESM1-2-LR', 'MRI-ESM2-0', 'NorESM2-LM');
for m = 1:1:12, mlen(m) = lenstr(mnom(m,:)); end

lon_rng = [-180 180]; lat_rng = [-90 90];

% rmpath('/nerc/packages/satprogs/satmat/STAPLOT/');
% rmpath('/nerc/packages/satprogs/satmat/Maps/');

mn0 = [0 0 -2 0 1900 2000 -15];
mx0 = [35 90 0.7 1.5 2300 2600 15];
xt = [0.01 0.02 0.05 0.1 0.2 0.5 1 2 5]; lxt = log10(xt);

nxx = -179.5:1:179.5;  nyy = -89.5:1:89.5;
[lon100, lat100] = meshgrid(nxx, nyy);
nxx = -180:1:180;  nyy = -90:1:90;
[lon100b, lat100b] = meshgrid(nxx, nyy);

load coast;

unom = char('[mmol N m^{-3}]', '[mmol Si m^{-3}]', '[mg chl m^{-3}]', ...
  '[g C m^{-2} d^{-1}]', '[mmol C m^{-3}]', '[meq m^{-3}]', '[mmol C m^{-2} d^{-1}]');
for u = 1:1:7, ulen(u) = lenstr(unom(u,:)); end

gpos = [-0.12 -0.05 0.15 0.1];

for m = 1:1:12, mnomlen(m) = lenstr(mnom(m,:)); end

for f = 1:1:7
  clear t0; t0 = squeeze(plot_var(:,:,f,:)); 
  if f == 3, t0 = real(log10(t0)); end
  mn = mn0(f); mx = mx0(f);
  %
  figure(1); clf; turbo(60); if f == 7, therm6(31); end
%   tstr = sprintf('%s', fnom(f,1:flen(f)));
  subplot (4,3,1); t1 = t0(:,:,1);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100, lon100, t1);
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([mn mx]); titstr = sprintf('Observations'); tl = title (titstr); set(tl, 'FontSize', 8);
  tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.75; set(tl, 'Position', tlp); topbox;
  pos = get(gca, 'Position'); pos = pos + gpos; set(gca, 'Position', pos);
  for m = 2:1:12
    subplot (4,3,m); t1 = t0(:,:,m);
    ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
    pcolorm(lat100, lon100, t1);
    plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
    caxis ([mn mx]); tl = title (mnom(m,1:mnomlen(m))); set(tl, 'FontSize', 8);
    tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.75; set(tl, 'Position', tlp); topbox;
    pos = get(gca, 'Position'); pos = pos + gpos; set(gca, 'Position', pos);
  end
  subplot (4,3,3); t1 = t0(:,:,3);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100, lon100, t1);
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([mn mx]); tl = title (mnom(3,1:mnomlen(3))); set(tl, 'FontSize', 8);
  tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.75; set(tl, 'Position', tlp); topbox;
  pos = get(gca, 'Position'); pos = pos + gpos; set(gca, 'Position', pos);
  pos = get(gca, 'Position'); cb = colorbar;
  % cbar_ylabel(cb, unom(f,1:ulen(f))); 
  cbpos = get(cb, 'Position');
  cbyl = get(cb, 'YLabel'); set(cbyl, 'FontSize', 8);
  cbpos(1) = pos(1) + pos(3) - 0.035; % cbpos(2) = pos(2);
  cbpos(4) = 0.15; % cbpos(4) = pos(4);
  set(cb, 'Position', cbpos, 'FontSize', 8); set(gca, 'Position', pos);
  % sort out chlorophyll colourbar
  if f == 3, set(cb, 'YTick', lxt, 'YTickLabel', xt); end
  %
  oname0 = sprintf('FIGS/ukesm1_PD_cmip6_intercomparison_UKESM1_%d.png', f);
  paper; set(gcf, 'PaperPosition', [2.1217 7.0763 16.7340 15.5506]);
  exportgraphics(gcf, oname0, 'Resolution', 600);
end

% =========================================================================

lon_rng = [-180 180]; lat_rng = [45 90];
gpos = [-0.12 -0.05 0.05 0.05];

lat100x = lat100; lat100x(:,361:362) = lat100(:,1:2);
lon100x(:,2:361) = lon100; lon100x(:,1) = lon100x(:,2) - 1; lon100x(:,362) = lon100x(:,361) + 1;

for f = 1:1:7
  clear t0; t0 = squeeze(plot_var(:,:,f,:)); 
  t0b(:,2:361,:) = t0; t0b(:,1,:) = t0(:,360,:); t0b(:,362,:) = t0(:,1,:); t0 = t0b;
  if f == 3, t0 = real(log10(t0)); end
  mn = mn0(f); mx = mx0(f);
  %
  figure(1); clf; turbo(60); if f == 7, therm6(31); end
%   tstr = sprintf('%s', fnom(f,1:flen(f)));
  subplot (4,3,1); t1 = t0(:,:,1);
  ax = axesm('MapProjection', 'eqaazim', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100x, lon100x, t1);
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([mn mx]); titstr = sprintf('Observations'); tl = title (titstr); set(tl, 'FontSize', 8);
  tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.25; set(tl, 'Position', tlp); topbox;
  pos = get(gca, 'Position'); pos = pos + gpos; set(gca, 'Position', pos);
  for m = 2:1:12
    subplot (4,3,m); t1 = t0(:,:,m);
    ax = axesm('MapProjection', 'eqaazim', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100x, lon100x, t1);
    plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
    caxis ([mn mx]); tl = title (mnom(m,1:mnomlen(m))); set(tl, 'FontSize', 8);
    tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.25; set(tl, 'Position', tlp); topbox;
    pos = get(gca, 'Position'); pos = pos + gpos; set(gca, 'Position', pos);
  end
  subplot (4,3,3); t1 = t0(:,:,3);
  ax = axesm('MapProjection', 'eqaazim', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100x, lon100x, t1);
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([mn mx]); tl = title (mnom(3,1:mnomlen(3))); set(tl, 'FontSize', 8);
  tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.25; set(tl, 'Position', tlp); topbox;
  pos = get(gca, 'Position'); pos = pos + gpos; set(gca, 'Position', pos);
  pos = get(gca, 'Position'); cb = colorbar;
  % cbar_ylabel(cb, unom(f,1:ulen(f))); 
  cbpos = get(cb, 'Position');
  cbyl = get(cb, 'YLabel'); set(cbyl, 'FontSize', 8);
   cbpos(1) = pos(1) + pos(3) - 0.035; cbpos(2) = cbpos(2) + 0.03;
  cbpos(4) = 0.15; % cbpos(4) = pos(4);
  set(cb, 'Position', cbpos, 'FontSize', 8); set(gca, 'Position', pos);
  % sort out chlorophyll colourbar
  if f == 3, set(cb, 'YTick', lxt, 'YTickLabel', xt); end
  %
  oname0 = sprintf('FIGS/ukesm1_PD_cmip6_intercomparison_UKESM1_ARCTIC_%d.png', f);
  paper; set(gcf, 'PaperPosition', [2.1217 7.0763 16.7340 15.5506]);
  exportgraphics(gcf, oname0, 'Resolution', 600);
end

lon_rng = [-180 180]; lat_rng = [-90 -45];
gpos = [-0.12 -0.05 0.05 0.05];

for f = 1:1:7
  clear t0; t0 = squeeze(plot_var(:,:,f,:)); 
  t0b(:,2:361,:) = t0; t0b(:,1,:) = t0(:,360,:); t0b(:,362,:) = t0(:,1,:); t0 = t0b;
  if f == 3, t0 = real(log10(t0)); end
  mn = mn0(f); mx = mx0(f);
  %
  figure(1); clf; turbo(60); if f == 7, therm6(31); end
%   tstr = sprintf('%s', fnom(f,1:flen(f)));
  subplot (4,3,1); t1 = t0(:,:,1);
  ax = axesm('MapProjection', 'eqaazim', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100x, lon100x, t1);
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([mn mx]); titstr = sprintf('Observations'); tl = title (titstr); set(tl, 'FontSize', 8);
  tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.25; set(tl, 'Position', tlp); topbox;
  pos = get(gca, 'Position'); pos = pos + gpos; set(gca, 'Position', pos);
  for m = 2:1:12
    subplot (4,3,m); t1 = t0(:,:,m);
    ax = axesm('MapProjection', 'eqaazim', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100x, lon100x, t1);
    plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
    caxis ([mn mx]); tl = title (mnom(m,1:mnomlen(m))); set(tl, 'FontSize', 8);
    tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.25; set(tl, 'Position', tlp); topbox;
    pos = get(gca, 'Position'); pos = pos + gpos; set(gca, 'Position', pos);
  end
  subplot (4,3,3); t1 = t0(:,:,3);
  ax = axesm('MapProjection', 'eqaazim', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100x, lon100x, t1);
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([mn mx]); tl = title (mnom(3,1:mnomlen(3))); set(tl, 'FontSize', 8);
  tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.25; set(tl, 'Position', tlp); topbox;
  pos = get(gca, 'Position'); pos = pos + gpos; set(gca, 'Position', pos);
  pos = get(gca, 'Position'); cb = colorbar;
  % cbar_ylabel(cb, unom(f,1:ulen(f))); 
  cbpos = get(cb, 'Position');
  cbyl = get(cb, 'YLabel'); set(cbyl, 'FontSize', 8);
   cbpos(1) = pos(1) + pos(3) - 0.035; cbpos(2) = cbpos(2) + 0.03;
  cbpos(4) = 0.15; % cbpos(4) = pos(4);
  set(cb, 'Position', cbpos, 'FontSize', 8); set(gca, 'Position', pos);
  % sort out chlorophyll colourbar
  if f == 3, set(cb, 'YTick', lxt, 'YTickLabel', xt); end
  %
  oname0 = sprintf('FIGS/ukesm1_PD_cmip6_intercomparison_UKESM1_ANTARCTIC_%d.png', f);
  paper; set(gcf, 'PaperPosition', [2.1217 7.0763 16.7340 15.5506]);
  exportgraphics(gcf, oname0, 'Resolution', 600);
end

% =========================================================================

t1 = grid_area([-90:1:90], [-180:1:180]);
warea = t1(1:end-1,1:end-1);

clear obs_avg obs_std mod_avg mod_std obs_mod_corrcoef obs_mod_rmserror
for f = 1:1:7
  for m = 1:1:11
    for b = 1:1:6
      o1 = plot_var(:,:,f,1) + woa_basin2(:,:,b);
      m1 = plot_var(:,:,f,m+1) + woa_basin2(:,:,b);
      q1 = isnan(o1); q2 = isnan(m1);
      o1(q2) = NaN; m1(q1) = NaN;
      w1 = warea; w1(isnan(o1)) = NaN;
      vdat = isfinite(o1);
      if sum(vdat(:)) > 0
        %
        d = o1(vdat);
        x = m1(vdat);
        w = w1(vdat);
        %
        tot = sum(d .* w); totw = sum(w); wavgd = tot / totw;
        s1 = d - wavgd; s2 = s1 .* s1; s3 = s2 .* w; s4 = sum(s3(:));
        s5 = sum(w(:)); s6 = s4 ./ s5; s7 = s6 .^ 0.5; wstdd = s7;
        %
        tot = sum(x .* w); totw = sum(w); wavgx = tot / totw;
        s1 = x - wavgx; s2 = s1 .* s1; s3 = s2 .* w; s4 = sum(s3(:));
        s5 = sum(w(:)); s6 = s4 ./ s5; s7 = s6 .^ 0.5; wstdx = s7;
        %
        r1 = d - wmean(d(:), w(:)); r2 = x - wmean(x(:), w(:));
        r3 = r1 .* r2; r4 = r3 .* w;
        r5 = sum(w(:)); r6 = sum(r4(:)) / r5; r7 = r6 / (wstdd * wstdx);
        %
        p1 = ((x - d).^2); p2 = wmean(p1(:), w(:)); p3 = p2 .^ 0.5;
        %
        obs_avg(b,f,m) = wavgd; obs_std(b,f,m) = wstdd;
        mod_avg(b,f,m) = wavgx; mod_std(b,f,m) = wstdx;
        obs_mod_corrcoef(b,f,m) = r7;
        obs_mod_rmserror(b,f,m) = p3;
      end
    end
  end
end

bnom = char('World', 'Atlantic', 'Pacific', 'Indian', 'Southern', 'Arctic');

mnom = char('UKESM1', 'MEDUSA-2',...
  'HadGEM2-ES', 'CESM2-FV2', 'CNRM-ESM2-1', ...
  'CanESM5', 'IPSL-CM6A-LR', 'MIROC-ES2L', ...
  'MPI-ESM1-2-LR', 'MRI-ESM2-0', 'NorESM2-LM');
for m = 1:1:11, mlen(m) = lenstr(mnom(m,:)); end

fnom = char('Dissolved inorganic nitrogen', 'Silicic acid', 'Chlorophyll', ...
  'Primary production (mean)', 'Dissolved inorganic carbon', 'Alkalinity', ...
  'Air-sea CO2 flux');
for f = 1:1:7, flen(f) = lenstr(fnom(f,:)); end

for f = 1:1:7
  tstr = sprintf('%s', fnom(f,1:flen(f)));
  % do time (global average) second
  o1 = obs_std(1,f,:);
  m1 = mod_std(1,f,:);
  r1 = obs_mod_corrcoef(1,f,:); r1(isnan(r1)) = -1;
  figure(1); clf; def_figure;
  [h1, lg] = taydiag(m1./o1, 1, r1, 1, mnom, tstr);
  q1 = get(h1, 'Children'); set (q1(90), 'MarkerSize', 20, 'LineWidth', 4);
  oname = sprintf('FIGS/ukesm1_PD_cmip6_taylor_0%db.png', f); 
  paper; def_figure; 
  exportgraphics(gcf, oname, 'Resolution', 600);
end

for f = 1:1:7
  tstr = sprintf('%s', fnom(f,1:flen(f)));
  % do time (global average) second
  o1 = obs_std(1,f,:);
  m1 = mod_std(1,f,:);
  r1 = obs_mod_corrcoef(1,f,:); r1(isnan(r1)) = -1;
  figure(1); clf; def_figure;
  [h1, lg] = taydiag(m1./o1, 1, r1, 1, mnom, tstr);
  q1 = get(h1, 'Children'); set (q1(90), 'MarkerSize', 20, 'LineWidth', 4);
  set(lg, 'Visible', 'off');
  oname = sprintf('FIGS/ukesm1_PD_cmip6_taylor_NOLEG_0%db.png', f); 
  paper; def_figure; 
  exportgraphics(gcf, oname, 'Resolution', 600);
end

