clear; startup;

% =========================================================================
% =========================================================================
%
% Matlab plotting scripts for the analysis of UKESM1 prepared for:
%
%   Yool, A., Palmiéri, J., Jones, C. G., de Mora, L., Kuhlbrodt, T., 
%   Popova, E. E., Nurser, A. J. G., Hirschi, J., Blaker, A. T., 
%	Coward, A. C., Blockley, E. W., and Sellar, A. A.: Evaluating the 
% 	physical and biogeochemical state of the global ocean component of 
%	UKESM1 in CMIP6 Historical simulations, Geosci. Model Dev. Discuss. 
%	[preprint], https://doi.org/10.5194/gmd-2020-333, in review, 2020.
%
%   Accepted for publication: 20 April 2021
%
% Note: scripts provided to document analysis, and may require editing to
% fully replicate plots in manuscript
%
% =========================================================================
% =========================================================================

% =========================================================================
%
% This script plots Figure 15, and Supplementary Figure S20
%
% =========================================================================

% =========================================================================

load ukesm1_PD_ensemble

% =========================================================================

% load up background files
load nemo_area100e
load nemo_mask100e
fname = sprintf('%s/mean_nemo_%so_1y_20001201-20101201_grid-T.nc', dname(1).name, rname(1).name);
t1 = ncread(fname, 'deptht_bounds');
nemo_dep = double(t1(1,:)); nemo_dep(end+1) = double(t1(2,end));
t1 = ncread(fname, 'deptht');
nemo_mid = double(t1');

% total grid area
t1 = area100e + nemo_mask100e(:,:,1);
t2 = isfinite(t1);
tot_area100e = sum(t1(t2)); % m2

% extra mask to get rid of Mediterranean, Black and Caspian Seas
t1 = nemo_mask100e(:,:,1) + 1;
t1(isnan(t1)) = 0;
t1(235:249,283:344) = t1(235:249,283:344) + 2;
t1(249:262,291:344) = t1(249:262,291:344) + 4;
t1(262:276,330:344) = t1(262:276,330:344) + 8;
t2 = t1;
t2(t1 < 1) = NaN; t2(t1 > 1) = NaN;
med_mask100e = t2;

nxx = -179.5:1:179.5;  nyy = -89.5:1:89.5;
[lon100, lat100] = meshgrid(nxx, nyy);
nxx = -180:1:180;  nyy = -90:1:90;
[lon100b, lat100b] = meshgrid(nxx, nyy);
nxx = -179.5:2:179.5;  nyy = -89.5:2:89.5;
[lon200, lat200] = meshgrid(nxx, nyy);

load woa_mask
clear t1; t1(:,1:180) = woa_mask(:,181:360); t1(:,181:360) = woa_mask(:,1:180);
woa_mask = t1;

load woa_basin

helvetica;
pngopt = 0;

% ----------------------------------------------------------------------

clear mod_carb;

for e = 1:1:tsize
  pnom = sprintf('%s/mean_medusa_%so_1y_20001201-20101201_ptrc-T.nc', dname(e).name, rname(e).name);
  fprintf('- Reading %s\n', pnom);
  t1 = ncread(pnom, 'DIC');
  t2 = permute(t1, [2 1 3]);
  mod_carb(:,:,1,e) = t2(:,:,1);
  t1 = ncread(pnom, 'ALK');
  t2 = permute(t1, [2 1 3]);
  mod_carb(:,:,2,e) = t2(:,:,1);
  pnom = sprintf('%s/mean_medusa_%so_1y_20001201-20101201_diad-T.nc', dname(e).name, rname(e).name);
  fprintf('- Reading %s\n', pnom);
  t1 = ncread(pnom, 'OCN_PH');
  t2 = permute(t1, [2 1]);
  mod_carb(:,:,3,e) = t2;
  t1 = ncread(pnom, 'OM_CAL');
  t2 = permute(t1, [2 1]);
  mod_carb(:,:,4,e) = t2;
  pnom = sprintf('%s/mean_nemo_%so_1y_20001201-20101201_grid-T.nc', dname(e).name, rname(e).name);
  fprintf('- Reading %s\n', pnom);
  t1 = ncread(pnom, 'thetao');
  t2 = permute(t1, [2 1 3]);
  mod_tmp(:,:,e) = t2(:,:,1);
  t1 = ncread(pnom, 'so');
  t2 = permute(t1, [2 1 3]);
  mod_sal(:,:,e) = t2(:,:,1);
end

% ----------------------------------------------------------------------

path(path, '/noc/users/axy/Matlab/GLODAP_v2');

% GLODAPv2
load per_m3_fields

t1 = ncread('GLODAPv2.2016b.pHtsinsitutp.nc', 'pHtsinsitutp');
t2 = permute(t1, [2 1 3]);
t3 = t2(:,161:1:360,:); t3(:,201:360,:) = t2(:,1:160,:);
new_phinst = t3;
t1 = ncread('GLODAPv2.2016b.OmegaC.nc', 'OmegaC');
t2 = permute(t1, [2 1 3]);
t3 = t2(:,161:1:360,:); t3(:,201:360,:) = t2(:,1:160,:);
new_omegac = t3;

t1 = ncread('GLODAPv2.2016b.temperature.nc', 'temperature');
t2 = permute(t1, [2 1 3]);
t3 = t2(:,161:1:360,:); t3(:,201:360,:) = t2(:,1:160,:);
new_temper = t3;
t1 = ncread('GLODAPv2.2016b.salinity.nc', 'salinity');
t2 = permute(t1, [2 1 3]);
t3 = t2(:,161:1:360,:); t3(:,201:360,:) = t2(:,1:160,:);
new_salint = t3;

% ----------------------------------------------------------------------

% pH and omega calcite
lon_rng = [-180 180]; lat_rng = [-90 90];
% gpos = [-0.05 -0.025 0.125 0.10; -0.025 -0.025 0.125 0.10; -0.05 -0.05 0.125 0.10; -0.025 -0.05 0.125 0.10];
gpos = [-0.075 -0.025 0.135 0.1; -0.05 -0.025 0.135 0.1; -0.075 -0.05 0.135 0.1; -0.05 -0.05 0.135 0.1];
% gpos = gpos * 0;

t1 = woa_basin2(:,:,1);
t2 = woa_basin2(:,:,6);
t1(isfinite(t2)) = NaN;
arc_mask = t1;

load coast; 

tstr = char('Observed, DIC', 'Simulated DIC', 'Observed, alkalinity', 'Simulated, alkalinity');
for f = 1:1:4, tlen(f) = lenstr(tstr(f,:)); end
figure(1); clf; turbo(60);
subplot(2,2,1);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100, lon100, new_totco2(:,:,1));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([1700 2250]);
  pos = get(gca, 'Position'); pos = pos + gpos(1,:); set(gca, 'Position', pos);
  tp = title (tstr(1,1:tlen(1))); set(tp, 'Position', [0 1.6 0]);
subplot(2,2,2); t1 = mean(mod_carb(:,:,1,:), 4);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, t1);
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([1700 2250]);
  pos = get(gca, 'Position'); pos = pos + gpos(2,:); set(gca, 'Position', pos);
  tp = title (tstr(2,1:tlen(2))); set(tp, 'Position', [0 1.6 0]);
  cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos);
subplot(2,2,3);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100, lon100, new_totalk(:,:,1));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([2100 2500]);
  pos = get(gca, 'Position'); pos = pos + gpos(3,:); set(gca, 'Position', pos);
  tp = title (tstr(3,1:tlen(3))); set(tp, 'Position', [0 1.6 0]);
subplot(2,2,4); t1 = mean(mod_carb(:,:,2,:), 4);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, t1);
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([2100 2500]);
  pos = get(gca, 'Position'); pos = pos + gpos(4,:); set(gca, 'Position', pos);
  tp = title (tstr(4,1:tlen(4))); set(tp, 'Position', [0 1.6 0]);
  cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos);
paper; orient portrait; def_figure; 
onom = sprintf('FIGS/ukesm1_PD_obs_mod_carb_%s.png', numprint(1, 2));
exportgraphics(gcf, onom, 'Resolution', 600);

tstr = char('Observed, DIC', 'Simulated DIC', 'Observed, alkalinity', 'Simulated, alkalinity');
for f = 1:1:4, tlen(f) = lenstr(tstr(f,:)); end
figure(1); clf; turbo(60);
subplot(2,2,1);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100, lon100, new_totco2(:,:,1));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([1800 2300]);
  pos = get(gca, 'Position'); pos = pos + gpos(1,:); set(gca, 'Position', pos);
  tp = title (tstr(1,1:tlen(1))); set(tp, 'Position', [0 1.6 0]);
subplot(2,2,2); t1 = mean(mod_carb(:,:,1,:), 4);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, t1);
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([1800 2300]);
  pos = get(gca, 'Position'); pos = pos + gpos(2,:); set(gca, 'Position', pos);
  tp = title (tstr(2,1:tlen(2))); set(tp, 'Position', [0 1.6 0]);
  cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos);
subplot(2,2,3);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100, lon100, new_totalk(:,:,1));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([2075 2525]);
  pos = get(gca, 'Position'); pos = pos + gpos(3,:); set(gca, 'Position', pos);
  tp = title (tstr(3,1:tlen(3))); set(tp, 'Position', [0 1.6 0]);
subplot(2,2,4); t1 = mean(mod_carb(:,:,2,:), 4);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, t1);
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([2075 2525]);
  pos = get(gca, 'Position'); pos = pos + gpos(4,:); set(gca, 'Position', pos);
  tp = title (tstr(4,1:tlen(4))); set(tp, 'Position', [0 1.6 0]);
  cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos);
paper; orient portrait; def_figure; 
onom = sprintf('FIGS/ukesm1_PD_obs_mod_carb_%sb.png', numprint(1, 2));
exportgraphics(gcf, onom, 'Resolution', 600);

tstr = char('Observed, DIC', 'Simulated DIC', 'Observed, alkalinity', 'Simulated, alkalinity');
for f = 1:1:4, tlen(f) = lenstr(tstr(f,:)); end
figure(1); clf; turbo(60);
subplot(2,2,1);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100, lon100, new_pi_dic(:,:,1));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([1800 2300]);
  pos = get(gca, 'Position'); pos = pos + gpos(1,:); set(gca, 'Position', pos);
  tp = title (tstr(1,1:tlen(1))); set(tp, 'Position', [0 1.6 0]);
subplot(2,2,2); t1 = mean(mod_carb(:,:,1,:), 4);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, t1);
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([1800 2300]);
  pos = get(gca, 'Position'); pos = pos + gpos(2,:); set(gca, 'Position', pos);
  tp = title (tstr(2,1:tlen(2))); set(tp, 'Position', [0 1.6 0]);
  cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos);
subplot(2,2,3);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100, lon100, new_totalk(:,:,1));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([2075 2525]);
  pos = get(gca, 'Position'); pos = pos + gpos(3,:); set(gca, 'Position', pos);
  tp = title (tstr(3,1:tlen(3))); set(tp, 'Position', [0 1.6 0]);
subplot(2,2,4); t1 = mean(mod_carb(:,:,2,:), 4);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, t1);
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([2075 2525]);
  pos = get(gca, 'Position'); pos = pos + gpos(4,:); set(gca, 'Position', pos);
  tp = title (tstr(4,1:tlen(4))); set(tp, 'Position', [0 1.6 0]);
  cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos);
paper; orient portrait; def_figure; 
onom = sprintf('FIGS/ukesm1_PD_obs_mod_carb_%sc.png', numprint(1, 2));
exportgraphics(gcf, onom, 'Resolution', 600);

tstr = char('Observed, pH', 'Simulated pH', 'Observed, {\Omega}_{calcite}', 'Simulated, {\Omega}_{calcite}');
for f = 1:1:4, tlen(f) = lenstr(tstr(f,:)); end
figure(1); clf; turbo(60);
subplot(2,2,1);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100, lon100, new_phinst(:,:,1));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([7.8999 8.3001]);
  pos = get(gca, 'Position'); pos = pos + gpos(1,:); set(gca, 'Position', pos);
  tp = title (tstr(1,1:tlen(1))); set(tp, 'Position', [0 1.6 0]);
subplot(2,2,2); t1 = mean(mod_carb(:,:,3,:), 4);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, t1);
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([7.8999 8.3001]);
  pos = get(gca, 'Position'); pos = pos + gpos(2,:); set(gca, 'Position', pos);
  tp = title (tstr(2,1:tlen(2))); set(tp, 'Position', [0 1.6 0]);
  cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos);
subplot(2,2,3);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100, lon100, new_omegac(:,:,1));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([1-0.001 7]);
  pos = get(gca, 'Position'); pos = pos + gpos(3,:); set(gca, 'Position', pos);
  tp = title (tstr(3,1:tlen(3))); set(tp, 'Position', [0 1.6 0]);
subplot(2,2,4); t1 = mean(mod_carb(:,:,4,:), 4);
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, t1);
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([1-0.001 7]);
  pos = get(gca, 'Position'); pos = pos + gpos(4,:); set(gca, 'Position', pos);
  tp = title (tstr(4,1:tlen(4))); set(tp, 'Position', [0 1.6 0]);
  cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos);
paper; orient portrait; def_figure; 
onom = sprintf('FIGS/ukesm1_PD_obs_mod_carb_%s.png', numprint(2, 2));
exportgraphics(gcf, onom, 'Resolution', 600);

% ALK vs. SAL
s1 = new_salint(:,:,1); a1 = new_totalk(:,:,1);
s2 = mean(mod_sal, 3); a2 = mean(mod_carb(:,:,2,:), 4);

s1(s1 <= 10) = NaN; s1(s1 > 40) = NaN;
s2(s2 <= 10) = NaN; s2(s2 > 40) = NaN;

q1 = isfinite(s1); q2 = isfinite(a1); q3 = q1 + q2; q0 = find(q3 == 2);
[q1, q2] = polyfit(s1(q0), a1(q0), 1);
M1 = q1(1); C1 = q1(2);

q1 = isfinite(s2); q2 = isfinite(a2); q3 = q1 + q2; q0 = find(q3 == 2);
[q1, q2] = polyfit(s2(q0), a2(q0), 1);
M2 = q1(1); C2 = q1(2);

sx = 0:1:45;

figure(1); clf; hold on;
h1 = plot (s1(:), a1(:), 'r.'); h2 = plot (s2(:), a2(:), 'b.');
h = plot (sx, C1 + (M1 * sx), 'r-'); set (h,'LineWidth', 3);
h = plot (sx, C2 + (M2 * sx), 'b-'); set (h,'LineWidth', 3);
axis ([10 40 800 2800]);
ylabel ('Alkalinity [meq m^{-3}]');
xlabel ('Salinity [PSU]');
lg = legend ('Observed', 'Modelled', 'Obs. fit', 'Mod. fit', 'Location', 'northwest');
lgpos = get(lg, 'Position'); lgpos(3) = 0.26; set (lg, 'Position', lgpos);
str1 = sprintf('A = (%4.2f . S) + %4.1f', M1, C1);
h1 = text(10.75, 2240, str1); set(h1, 'Color', [1 0 0]);
str1 = sprintf('A = (%4.2f . S) + %4.1f', M2, C2);
h2 = text(10.75, 2115, str1); set(h2, 'Color', [0 0 1]);
set (h1, 'LineWidth', 0.2); set (h2, 'LineWidth', 0.2); 
topbox;
paper; orient portrait; def_figure; 
onom = sprintf('FIGS/ukesm1_PD_obs_mod_SSS_ALK.png');
exportgraphics(gcf, onom, 'Resolution', 600);

% OK, latitude plot
s1 = new_salint(:,:,1); a1 = new_totalk(:,:,1);
s2 = mean(mod_sal, 3); a2 = mean(mod_carb(:,:,2,:), 4);

q1 = scatregrid(yy100e, xx100e, s2, lat100, lon100);
s2a = q1;
q1 = scatregrid(yy100e, xx100e, a2, lat100, lon100);
a2a = q1;

q1 = grid_area([-90:1:90], [-180:1:180]);
area100 = q1(1:180,1:360);

msk = s1 * 0;

t1 = s1 + msk; t2 = t1 .* area100; t3 = isnan(t1); t4 = area100; t4(t3) = NaN;
t5 = nansum(t2, 2); t6 = nansum(t4, 2); avg_s1 = t5 ./ t6;

t1 = a1 + msk; t2 = t1 .* area100; t3 = isnan(t1); t4 = area100; t4(t3) = NaN;
t5 = nansum(t2, 2); t6 = nansum(t4, 2); avg_a1 = t5 ./ t6;

t1 = s2a + msk; t2 = t1 .* area100; t3 = isnan(t1); t4 = area100; t4(t3) = NaN;
t5 = nansum(t2, 2); t6 = nansum(t4, 2); avg_s2 = t5 ./ t6;

t1 = a2a + msk; t2 = t1 .* area100; t3 = isnan(t1); t4 = area100; t4(t3) = NaN;
t5 = nansum(t2, 2); t6 = nansum(t4, 2); avg_a2 = t5 ./ t6;

figure(1); clf;
subplot (2,1,1);
plot (lat100(:,1), avg_s1, 'r-', lat100(:,1), avg_s2, 'b-');
axis ([-90 90 28.5 36.5]);
set (gca, 'XTick', -90:30:90, 'YTick', 28:1:36);
ylabel ('Salinity [PSU]');
subplot (2,1,2);
plot (lat100(:,1), avg_a1, 'r-', lat100(:,1), avg_a2, 'b-');
axis ([-90 90 2075 2425]);
set (gca, 'XTick', -90:30:90, 'YTick', 2100:50:2400);
ylabel ('Alkalinity [meq m^{-3}]');
xlabel ('Latitude [{\circ}N]');
legend ('Observed ', 'Modelled ', 'Location', 'southwest');
paper; orient portrait; def_figure; 
onom = sprintf('FIGS/ukesm1_PD_obs_mod_SSS_ALK_02.png');
exportgraphics(gcf, onom, 'Resolution', 600);

q1 = isfinite(avg_s1); q2 = isfinite(avg_a1); q3 = q1 + q2; q0 = find(q3 == 2);
[q1, q2] = polyfit(avg_s1(q0), avg_a1(q0), 1);
M1z = q1(1); C1z = q1(2);

q1 = isfinite(avg_s2); q2 = isfinite(avg_a2); q3 = q1 + q2; q0 = find(q3 == 2);
[q1, q2] = polyfit(avg_s2(q0), avg_a2(q0), 1);
M2z = q1(1); C2z = q1(2);

figure(1); clf;
plot (avg_s1(:), avg_a1(:), 'r.', avg_s1(:), (avg_s1(:) * M1z) + C1z, 'r-', ...
  avg_s2(:), avg_a2(:), 'b.', avg_s2(:), (avg_s2(:) * M2z) + C2z, 'b-');
ylabel ('Alkalinity [meq m^{-3}]');
xlabel ('Salinity [PSU]');
legend ('Observed', 'Obs. fit', 'Modelled', 'Mod. fit', 'Location', 'northwest');
str1 = sprintf('A = (%4.2f . S) + %4.1f', M1z, C1z);
h1 = text(29.25, 2330, str1); set(h1, 'Color', [1 0 0]);
str1 = sprintf('A = (%4.2f . S) + %4.1f', M2z, C2z);
h2 = text(29.25, 2305, str1); set(h2, 'Color', [0 0 1]);
paper; orient portrait; def_figure; 
onom = sprintf('FIGS/ukesm1_PD_obs_mod_carb_%s.png', numprint(4, 2));
exportgraphics(gcf, onom, 'Resolution', 600);
