clear; startup;

% =========================================================================
% =========================================================================
%
% Matlab plotting scripts for the analysis of UKESM1 prepared for:
%
%   Yool, A., Palmiéri, J., Jones, C. G., de Mora, L., Kuhlbrodt, T., 
%   Popova, E. E., Nurser, A. J. G., Hirschi, J., Blaker, A. T., 
%	Coward, A. C., Blockley, E. W., and Sellar, A. A.: Evaluating the 
% 	physical and biogeochemical state of the global ocean component of 
%	UKESM1 in CMIP6 Historical simulations, Geosci. Model Dev. Discuss. 
%	[preprint], https://doi.org/10.5194/gmd-2020-333, in review, 2020.
%
%   Accepted for publication: 20 April 2021
%
% Note: scripts provided to document analysis, and may require editing to
% fully replicate plots in manuscript
%
% =========================================================================
% =========================================================================

% =========================================================================
%
% This script plots Figure 16, and Supplementary Figures S14 and S15 
%
% =========================================================================

% =========================================================================

load ukesm1_PD_ensemble

% =========================================================================

% load up background files
load nemo_area100e
load nemo_mask100e
fname = sprintf('%s/mean_nemo_%so_1y_20001201-20101201_grid-T.nc', dname(1).name, rname(1).name);
t1 = ncread(fname, 'deptht_bounds');
nemo_dep = double(t1(1,:)); nemo_dep(end+1) = double(t1(2,end));
t1 = ncread(fname, 'deptht');
nemo_mid = double(t1');

% total grid area
t1 = area100e + nemo_mask100e(:,:,1);
t2 = isfinite(t1);
tot_area100e = sum(t1(t2)); % m2

% extra mask to get rid of Mediterranean, Black and Caspian Seas
t1 = nemo_mask100e(:,:,1) + 1;
t1(isnan(t1)) = 0;
t1(235:249,283:344) = t1(235:249,283:344) + 2;
t1(249:262,291:344) = t1(249:262,291:344) + 4;
t1(262:276,330:344) = t1(262:276,330:344) + 8;
t2 = t1;
t2(t1 < 1) = NaN; t2(t1 > 1) = NaN;
med_mask100e = t2;

nxx = -179.5:1:179.5;  nyy = -89.5:1:89.5;
[lon100, lat100] = meshgrid(nxx, nyy);
nxx = -180:1:180;  nyy = -90:1:90;
[lon100b, lat100b] = meshgrid(nxx, nyy);

load woa_mask
clear t1; t1(:,1:180) = woa_mask(:,181:360); t1(:,181:360) = woa_mask(:,1:180);
woa_mask = t1;

load woa_basin

helvetica;
pngopt = 0;

pal60 = turbo(60);
del30 = therm6(31);

% ----------------------------------------------------------------------

for e = 1:1:tsize
  for m = 12:-1:1
    fprintf('- Month %d\n', m);
    dnom = sprintf('%s/clim_medusa_%so_1m_2000%s-2009%s_diad-T.nc', dname(e).name, rname(e).name, numprint(m, 2), numprint(m, 2));
    t1 = ncread(dnom, 'CO2FLUX'); t2 = permute(t1, [2 1]); mod_flx_ens(:,:,m,e) = t2;
    t1 = ncread(dnom, 'OCN_PCO2'); t2 = permute(t1, [2 1]); mod_pco_ens(:,:,m,e) = t2;
    t1 = ncread(dnom, 'DMS_SURF'); t2 = permute(t1, [2 1]); mod_dms_ens(:,:,m,e) = t2;
  end
end

% ----------------------------------------------------------------------

[xx1, yy1] = meshgrid([-179.5:1:179.5], [-89.5:1:89.5]);

for i = 1:1:3
  if i == 1, t0 = mod_flx_ens(:,:,1:12,:);
  elseif i == 2, t0 = mod_dms_ens(:,:,1:12,:); 
  elseif i == 3, t0 = mod_pco_ens(:,:,1:12,:); end
  t1 = mean(t0, 4);
  for j = 1:1:12
    t2 = t1(:,:,j);
    t3 = scatregrid(yy100e(:,2:end-1), xx100e(:,2:end-1), t2(:,2:end-1), yy1, xx1);
    rg_mod_bgc(:,:,j,i) = t3 + woa_mask;
  end
end

% ----------------------------------------------------------------------

addpath('/noc/users/axy/Matlab/Datasets/Rodenbeck');
addpath('/noc/users/axy/Matlab/Datasets/DMS');

load rodenbeck_1982-2017_monthly_CO2_WOAgrid.mat

t1 = rg_mon_flux(:,:,:,18:27);
clear obs_flux; for m = 1:1:12, obs_flux(:,:,m) = mean(t1(:,:,m,:), 4); end

t1 = rg_mon_pco2(:,:,:,18:27);
clear obs_pco2; for m = 1:1:12, obs_pco2(:,:,m) = mean(t1(:,:,m,:), 4); end

load dms_data

obs_dms = dms_clim;

% ----------------------------------------------------------------------

for m = 1:1:12
  % OBS
  t1 = obs_flux(:,:,m) + woa_mask; t2 = nanmean(t1, 2); hov_obs(:,m,1) = t2;
  t1 = obs_pco2(:,:,m) + woa_mask; t2 = nanmean(t1, 2); hov_obs(:,m,3) = t2;
  t1 = obs_dms(:,:,m); t2 = nanmean(t1, 2); hov_obs(:,m,2) = t2;
  % MOD
  for i = 1:1:3
    t1 = rg_mod_bgc(:,:,m,i); t2 = nanmean(t1, 2);
    hov_mod(:,m,i) = t2;
  end
end

% ----------------------------------------------------------------------

monstr = char('J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D');

% obs units: Pg C / m2 / y    (sea-air)
% mod units: mmol C / m2 / d  (air-sea)
%     units: mol C / m2 / mon

conv1 = (-1 * 1e15 * 1e-3 / 12.011 / 360 );

cpal = 21;
scl = 0.7;

figure(1); clf; therm6(cpal);
subplot (1,2,1);
clear t1; t1(:,2:13) = hov_obs(:,:,1) * conv1; t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
t1(t1 > 10) = 10; t1(t1 < -10) = -10;
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, cpal);
caxis ([-10.001 10.001]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); ylabel ('Latitude [{\circ}N]');
title ('Observed');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
subplot (1,2,2);
clear t1; t1(:,2:13) = hov_mod(:,:,1); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
t1(t1 > 10) = 10; t1(t1 < -10) = -10;
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, cpal);
caxis ([-10.001 10.001]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); % ylabel ('Latitude [{\circ}N]');
title ('Model');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
cb = colorbar; cbpos = get(cb, 'Position'); cbpos(1) = pos(1) + pos(3) + 0.025;
set (cb, 'Position', cbpos); set (gca, 'Position', pos);
paper; orient portrait; set(gcf, 'PaperPosition', [2.1217 8.5763 16.7340 12.5506]);
onom = sprintf('FIGS/ukesm1_hovmoller_bgc2_%s.png', numprint(1, 2));
exportgraphics(gcf, onom, 'Resolution', 600);

cpal = 20;
figure(1); clf; turbo(cpal);
subplot (1,2,1);
clear t1; t1(:,2:13) = hov_obs(:,:,2); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
t1(t1 > 10) = 10;
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, cpal);
caxis ([0 10]); 
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); ylabel ('Latitude [{\circ}N]');
title ('Observed');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
subplot (1,2,2);
clear t1; t1(:,2:13) = hov_mod(:,:,2); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
t1(t1 > 10) = 10;
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, cpal);
caxis ([0 10]);
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); % ylabel ('Latitude [{\circ}N]');
title ('Model');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
cb = colorbar; cbpos = get(cb, 'Position'); cbpos(1) = pos(1) + pos(3) + 0.025;
set (cb, 'Position', cbpos); set (gca, 'Position', pos);
paper; orient portrait; set(gcf, 'PaperPosition', [2.1217 8.5763 16.7340 12.5506]);
onom = sprintf('FIGS/ukesm1_hovmoller_bgc2_%s.png', numprint(2, 2));
exportgraphics(gcf, onom, 'Resolution', 600);

figure(1); clf; turbo(cpal);
subplot (1,2,1);
clear t1; t1(:,2:13) = hov_obs(:,:,3); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
% t1(t1 > 10) = 10;
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, cpal);
caxis ([220 420]); 
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); ylabel ('Latitude [{\circ}N]');
title ('Observed');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
subplot (1,2,2);
clear t1; t1(:,2:13) = hov_mod(:,:,3); t1(:,1) = t1(:,13); t1(:,14) = t1(:,2); 
contourf(-0.5:1:12.5, -89.5:1:89.5, t1, cpal);
caxis ([220 420]); 
xaxis ([0 12]); set (gca, 'XTick', 0.5:1:11.5, 'XTickLabel', monstr);
yaxis ([-90 90]); set (gca, 'YTick', -90:30:90);
xlabel ('Time [month]'); % ylabel ('Latitude [{\circ}N]');
title ('Model');
pos = get(gca, 'Position'); pos(1) = pos(1) - 0.025; pos(2) = pos(2) + (pos(4) * ((1-scl)/2)); pos(4) = pos(4) * scl; set (gca, 'Position', pos);
cb = colorbar; cbpos = get(cb, 'Position'); cbpos(1) = pos(1) + pos(3) + 0.025;
set (cb, 'Position', cbpos); set (gca, 'Position', pos);
paper; orient portrait; set(gcf, 'PaperPosition', [2.1217 8.5763 16.7340 12.5506]);
onom = sprintf('FIGS/ukesm1_hovmoller_bgc2_%s.png', numprint(3, 2));
exportgraphics(gcf, onom, 'Resolution', 600);

% ----------------------------------------------------------------------

tstr = char('Observed, JJA', 'Observed, DJF', 'Simulated, JJA', 'Simulated, DJF');
tstr2 = char('Simulated, JJA', 'Simulated, DJF', 'Simulated, JJA, CoV', 'Simulated, DJF, CoV');
lon_rng = [-180 180]; lat_rng = [-90 90];
seas = [6 7 8; 12 1 2];
load coast; 

% obs units: Pg C / m2 / y    (sea-air)
% mod units: mmol C / m2 / d  (air-sea)
%     units: mol C / m2 / mon

conv1 = (-1 * 1e15 * 1e-3 / 12.011 / 360 );

% CO2 FLUX
gpos = [-0.075 -0.05 0.135 0.1; -0.05 -0.05 0.135 0.1; -0.075 0.0 0.135 0.1; -0.05 0.0 0.135 0.1];
clear m1 o1;
v = 1; o1(:,:,1) = mean(obs_flux(:,:,seas(1,:)), 3) + woa_mask;
o1(:,:,2) = mean(obs_flux(:,:,seas(2,:)), 3) + woa_mask; o1 = o1 * conv1;
v = 1; m1(:,:,1) = mean(mean(mod_flx_ens(:,:,seas(1,:),:), 4), 3); 
m1(:,:,2) = mean(mean(mod_flx_ens(:,:,seas(2,:),:), 4), 3); % m1 = m1 * conv2;
figure(1); clf; therm6(31);
pvar = [1 2]; for i = 1:1:2, subplot(2,2,pvar(i));
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100, lon100, o1(:,:,i));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([-20 20]);
  pos = get(gca, 'Position'); pos = pos + gpos(pvar(i),:); set(gca, 'Position', pos);
  tl = title (tstr(i,:)); tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.5; set(tl, 'Position', tlp);
end
pvar = [3 4]; for i = 1:1:2, subplot(2,2,pvar(i));
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, m1(:,:,i));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([-20 20]);
  pos = get(gca, 'Position'); pos = pos + gpos(pvar(i),:); set(gca, 'Position', pos);
  tl = title (tstr(i+2,:)); tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.5; set(tl, 'Position', tlp);
  if pvar(i) == 4, cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos); end
end
def_figure; 
onom = sprintf('FIGS/ukesm1_PD_obs_mod_COUPLE_%s.png', numprint(1, 2));
exportgraphics(gcf, onom, 'Resolution', 600);

% DMS
gpos = [-0.075 -0.05 0.135 0.1; -0.05 -0.05 0.135 0.1; -0.075 0.0 0.135 0.1; -0.05 0.0 0.135 0.1];
clear m1 o1;
v = 1; o1(:,:,1) = mean(obs_dms(:,:,seas(1,:)), 3) + woa_mask;
o1(:,:,2) = mean(obs_dms(:,:,seas(2,:)), 3) + woa_mask; % o1 = o1 * conv1;
v = 1; m1(:,:,1) = mean(mean(mod_dms_ens(:,:,seas(1,:),:), 4), 3); 
m1(:,:,2) = mean(mean(mod_dms_ens(:,:,seas(2,:),:), 4), 3); % m1 = m1 * conv2;
figure(1); clf; turbo(60);
pvar = [1 2]; for i = 1:1:2, subplot(2,2,pvar(i));
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100, lon100, o1(:,:,i));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([0 10]);
  pos = get(gca, 'Position'); pos = pos + gpos(pvar(i),:); set(gca, 'Position', pos);
  tl = title (tstr(i,:)); tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.5; set(tl, 'Position', tlp);
end
pvar = [3 4]; for i = 1:1:2, subplot(2,2,pvar(i));
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, m1(:,:,i));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([0 10]);
  pos = get(gca, 'Position'); pos = pos + gpos(pvar(i),:); set(gca, 'Position', pos);
  tl = title (tstr(i+2,:)); tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.5; set(tl, 'Position', tlp);
  if pvar(i) == 4, cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos); end
end
def_figure; 
onom = sprintf('FIGS/ukesm1_PD_obs_mod_COUPLE_%s.png', numprint(2, 2));
exportgraphics(gcf, onom, 'Resolution', 600);

% pCO2
gpos = [-0.075 -0.05 0.135 0.1; -0.05 -0.05 0.135 0.1; -0.075 0.0 0.135 0.1; -0.05 0.0 0.135 0.1];
clear m1 o1;
v = 1; o1(:,:,1) = mean(obs_pco2(:,:,seas(1,:)), 3) + woa_mask;
o1(:,:,2) = mean(obs_pco2(:,:,seas(2,:)), 3) + woa_mask; % o1 = o1 * conv1;
v = 1; m1(:,:,1) = mean(mean(mod_pco_ens(:,:,seas(1,:),:), 4), 3); 
m1(:,:,2) = mean(mean(mod_pco_ens(:,:,seas(2,:),:), 4), 3); % m1 = m1 * conv2;
figure(1); clf; turbo(60);
pvar = [1 2]; for i = 1:1:2, subplot(2,2,pvar(i));
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(lat100, lon100, o1(:,:,i));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([200 450]);
  pos = get(gca, 'Position'); pos = pos + gpos(pvar(i),:); set(gca, 'Position', pos);
  tl = title (tstr(i,:)); tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.5; set(tl, 'Position', tlp);
end
pvar = [3 4]; for i = 1:1:2, subplot(2,2,pvar(i));
  ax = axesm('MapProjection', 'mollweid', 'MapLonLim', lon_rng, 'MapLatLim', lat_rng); hold on;
  pcolorm(yy100e, xx100e, m1(:,:,i));
  plotm(lat, long, '-k', 'LineWidth', 0.5); axis off; h = framem; set (h, 'LineWidth', 0.5);
  caxis ([200 450]);
  pos = get(gca, 'Position'); pos = pos + gpos(pvar(i),:); set(gca, 'Position', pos);
  tl = title (tstr(i+2,:)); tlp = get(tl, 'Position'); tlp(2) = tlp(2) - 0.5; set(tl, 'Position', tlp);
  if pvar(i) == 4, cb = colorbar('horiz'); cbpos = get(cb, 'Position'); cbpos(1) = cbpos(1) + 0.025; cbpos(2) = cbpos(2) - 0.05; cbpos(3) = cbpos(3) - 0.05;
    set(cb, 'Position', cbpos); set(gca, 'Position', pos); end
end
def_figure; 
onom = sprintf('FIGS/ukesm1_PD_obs_mod_COUPLE_%s.png', numprint(3, 2));
exportgraphics(gcf, onom, 'Resolution', 600);
