function [a] = therm6(fine, no_white)
% THERM6  Creates a thermal palette of user-specified size
%
%	This command builds on RAIN to allow the user to specify
%   the actual number of colours in the thermal palette.
%
%	>> therm6(12);
%
%	This will produce a palette with exactly 12 colours in
%	it.  The colours used will be drawn from the standard
%	thermal/rainbow palette.
%
% This version alters the thermal palette somewhat to try
% to increase contrast near the central white region.
%
% Note : using an odd number of colours is encouraged with
% this palette, since it results in a single white region
% at the exact centre of the palette.
%
% Note : adding a second argument will force a palette
% with an even number of colours to *NOT* have a white
% central region.  It will do nothing for a palette with
% an odd number of colours.
%
%	>> therm6(12, 1);
%
% Andrew Yool (axy@noc.ac.uk)

nargs = nargin;
if nargs > 1
  no_white = 1;
else
  no_white = 0;
end

basefine = 200;

pal=[
  0.5000    1.0000    1.0000;
  0         0         0.8000;
  1.0000    1.0000    1.0000;
  0.7500         0         0;
  1.0000    1.0000    0.3300];

clear pal2;
basefine=basefine + 1;

if basefine<0
  pal2=pal;
else
  pal2(1,:)=pal(1,:);
  for i=1:1:4
    pos=((i-1)*basefine)+1;
    stepr=(pal(i,1) - pal(i+1,1))/basefine;
    stepg=(pal(i,2) - pal(i+1,2))/basefine;
    stepb=(pal(i,3) - pal(i+1,3))/basefine;
    for j=1:1:basefine
      pal2(pos+j,1)=pal(i,1) - (stepr*j);
      pal2(pos+j,2)=pal(i,2) - (stepg*j);
      pal2(pos+j,3)=pal(i,3) - (stepb*j);
    end
  end
end

% ----------------------------------------------------------------------
% a later bodge to do a better job for even-sized palettes
q1 = ((basefine - 1) * 1.9) + 2;
q2 = q1 + 1;
q3 = q1 * 2;
q4 = ((basefine - 1) * 4) + 5;
q5 = q4 - q1 + 1;
pal2b = pal2(1:q1,:);
pal2b(q2:q3,:) = pal2(q5:q4,:);
pal2 = pal2b;
% ----------------------------------------------------------------------

bigpal = max(size(pal2));

if fine < 2
  pal3 = pal2(1,:);
elseif fine == 2
  pal3(1,:) = pal2(1,:);
  pal3(fine,:) = pal2(end,:);
elseif fine > 200
  error (' Please be serious - do you really want such a large palette?');
else
  pal3(1,:) = pal2(1,:);
  pal3(fine,:) = pal2(end,:);
  
  t1 = bigpal - fine;
  t2 = (t1 / (fine - 1));
  pos = 1;
  for i = 2:1:(fine - 1)
    pos = pos + t2 + 1;
    pos2 = round(pos);
    pal3(i,:) = pal2(pos2,:);
  end
end

% Put white in centre of colourbar
odd = mod(fine, 2);
if odd == 1
  % Number of colours is odd (central white region)
  pos = round(((fine - 1) / 2) + 1);
  pal3(pos,1:3) = [1 1 1];
else
  if no_white == 0
    % Number of colours is even (central 2 cells white)
    pos = round(fine/2);
    pal3(pos,1:3) = [1 1 1];
    pal3(pos+1,1:3) = [1 1 1];
  end
end

colormap(pal3);
a = pal3;
