! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Auxiliary Routines File
! 
! Generated by KPP-2.2.4_gc symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : gckpp_Util.f90
! Time                 : Thu Jul 19 13:05:49 2018
! Working directory    : /n/home05/msulprizio/GC/Code.Dev/KPP/Tropchem
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_Util

  USE gckpp_Parameters
  IMPLICIT NONE

CONTAINS



! User INLINED Utility Functions

! End INLINED Utility Functions

! Utility Functions from KPP_HOME/util/util
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! UTIL - Utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! ****************************************************************
!                            
! InitSaveData - Opens the data file for writing
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE InitSaveData ()

      USE gckpp_Parameters

      open(10, file='gckpp.dat')

      END SUBROUTINE InitSaveData

! End of InitSaveData function
! ****************************************************************

! ****************************************************************
!                            
! SaveData - Write LOOKAT species in the data file 
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE SaveData ()

      USE gckpp_Global
      USE gckpp_Monitor

      INTEGER i

      WRITE(10,999) (TIME-TSTART)/3600.D0,  &
                   (C(LOOKAT(i))/CFACTOR, i=1,NLOOKAT)
999   FORMAT(E24.16,100(1X,E24.16))

      END SUBROUTINE SaveData

! End of SaveData function
! ****************************************************************

! ****************************************************************
!                            
! CloseSaveData - Close the data file 
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE CloseSaveData ()

      USE gckpp_Parameters

      CLOSE(10)

      END SUBROUTINE CloseSaveData

! End of CloseSaveData function
! ****************************************************************

! ****************************************************************
!                            
! GenerateMatlab - Generates MATLAB file to load the data file 
!   Parameters : 
!                It will have a character string to prefix each 
!                species name with.                                                 
!
! ****************************************************************

      SUBROUTINE GenerateMatlab ( PREFIX )

      USE gckpp_Parameters
      USE gckpp_Global
      USE gckpp_Monitor

      
      CHARACTER(LEN=8) PREFIX 
      INTEGER i

      open(20, file='gckpp.m')
      write(20,*) 'load gckpp.dat;'
      write(20,990) PREFIX
990   FORMAT(A1,'c = gckpp;')
      write(20,*) 'clear gckpp;'
      write(20,991) PREFIX, PREFIX
991   FORMAT(A1,'t=',A1,'c(:,1);')
      write(20,992) PREFIX
992   FORMAT(A1,'c(:,1)=[];')

      do i=1,NLOOKAT
        write(20,993) PREFIX, SPC_NAMES(LOOKAT(i)), PREFIX, i
993     FORMAT(A1,A6,' = ',A1,'c(:,',I2,');')
      end do
      
      CLOSE(20)

      END SUBROUTINE GenerateMatlab

! End of GenerateMatlab function
! ****************************************************************


! End Utility Functions from KPP_HOME/util/util
! End of UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Shuffle_user2kpp - function to copy concentrations from USER to KPP
!   Arguments :
!      V_USER    - Concentration of variable species in USER's order
!      V         - Concentrations of variable species (local)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Shuffle_user2kpp ( V_USER, V )

! V_USER - Concentration of variable species in USER's order
  REAL(kind=dp) :: V_USER(NVAR)
! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)

  V(151) = V_USER(1)
  V(188) = V_USER(2)
  V(171) = V_USER(3)
  V(4) = V_USER(4)
  V(199) = V_USER(5)
  V(87) = V_USER(6)
  V(157) = V_USER(7)
  V(91) = V_USER(8)
  V(158) = V_USER(9)
  V(45) = V_USER(10)
  V(206) = V_USER(11)
  V(102) = V_USER(12)
  V(92) = V_USER(13)
  V(165) = V_USER(14)
  V(58) = V_USER(15)
  V(51) = V_USER(16)
  V(122) = V_USER(17)
  V(113) = V_USER(18)
  V(111) = V_USER(19)
  V(117) = V_USER(21)
  V(96) = V_USER(22)
  V(39) = V_USER(23)
  V(67) = V_USER(24)
  V(1) = V_USER(25)
  V(2) = V_USER(26)
  V(3) = V_USER(27)
  V(196) = V_USER(28)
  V(173) = V_USER(29)
  V(52) = V_USER(30)
  V(129) = V_USER(31)
  V(78) = V_USER(32)
  V(46) = V_USER(33)
  V(40) = V_USER(34)
  V(68) = V_USER(35)
  V(210) = V_USER(36)
  V(104) = V_USER(37)
  V(69) = V_USER(38)
  V(79) = V_USER(39)
  V(162) = V_USER(40)
  V(186) = V_USER(41)
  V(81) = V_USER(42)
  V(211) = V_USER(43)
  V(5) = V_USER(44)
  V(41) = V_USER(45)
  V(42) = V_USER(46)
  V(107) = V_USER(47)
  V(95) = V_USER(48)
  V(126) = V_USER(49)
  V(70) = V_USER(50)
  V(115) = V_USER(51)
  V(116) = V_USER(52)
  V(213) = V_USER(53)
  V(77) = V_USER(54)
  V(131) = V_USER(55)
  V(177) = V_USER(56)
  V(147) = V_USER(57)
  V(139) = V_USER(58)
  V(191) = V_USER(59)
  V(175) = V_USER(60)
  V(103) = V_USER(61)
  V(184) = V_USER(62)
  V(179) = V_USER(63)
  V(195) = V_USER(64)
  V(140) = V_USER(65)
  V(53) = V_USER(66)
  V(71) = V_USER(67)
  V(164) = V_USER(68)
  V(72) = V_USER(69)
  V(204) = V_USER(70)
  V(142) = V_USER(71)
  V(143) = V_USER(72)
  V(93) = V_USER(73)
  V(108) = V_USER(74)
  V(88) = V_USER(75)
  V(99) = V_USER(76)
  V(161) = V_USER(77)
  V(130) = V_USER(78)
  V(43) = V_USER(79)
  V(47) = V_USER(80)
  V(38) = V_USER(81)
  V(105) = V_USER(82)
  V(54) = V_USER(83)
  V(64) = V_USER(84)
  V(59) = V_USER(85)
  V(60) = V_USER(86)
  V(55) = V_USER(87)
  V(146) = V_USER(88)
  V(29) = V_USER(89)
  V(65) = V_USER(90)
  V(6) = V_USER(91)
  V(190) = V_USER(92)
  V(118) = V_USER(93)
  V(56) = V_USER(94)
  V(163) = V_USER(95)
  V(80) = V_USER(96)
  V(123) = V_USER(97)
  V(61) = V_USER(98)
  V(127) = V_USER(99)
  V(7) = V_USER(100)
  V(8) = V_USER(101)
  V(183) = V_USER(102)
  V(9) = V_USER(103)
  V(10) = V_USER(104)
  V(154) = V_USER(105)
  V(141) = V_USER(106)
  V(138) = V_USER(107)
  V(112) = V_USER(108)
  V(156) = V_USER(109)
  V(137) = V_USER(110)
  V(149) = V_USER(111)
  V(178) = V_USER(112)
  V(166) = V_USER(113)
  V(176) = V_USER(114)
  V(11) = V_USER(115)
  V(12) = V_USER(116)
  V(128) = V_USER(117)
  V(169) = V_USER(118)
  V(13) = V_USER(119)
  V(14) = V_USER(120)
  V(15) = V_USER(121)
  V(16) = V_USER(122)
  V(18) = V_USER(123)
  V(17) = V_USER(124)
  V(19) = V_USER(125)
  V(20) = V_USER(126)
  V(197) = V_USER(127)
  V(159) = V_USER(128)
  V(133) = V_USER(129)
  V(148) = V_USER(130)
  V(153) = V_USER(131)
  V(114) = V_USER(132)
  V(160) = V_USER(133)
  V(63) = V_USER(134)
  V(202) = V_USER(137)
  V(198) = V_USER(138)
  V(135) = V_USER(139)
  V(182) = V_USER(140)
  V(132) = V_USER(141)
  V(106) = V_USER(142)
  V(124) = V_USER(143)
  V(207) = V_USER(144)
  V(44) = V_USER(145)
  V(136) = V_USER(146)
  V(145) = V_USER(147)
  V(97) = V_USER(148)
  V(66) = V_USER(149)
  V(187) = V_USER(150)
  V(98) = V_USER(151)
  V(21) = V_USER(152)
  V(119) = V_USER(153)
  V(120) = V_USER(154)
  V(200) = V_USER(155)
  V(150) = V_USER(156)
  V(125) = V_USER(157)
  V(94) = V_USER(158)
  V(181) = V_USER(159)
  V(208) = V_USER(160)
  V(209) = V_USER(161)
  V(212) = V_USER(162)
  V(121) = V_USER(163)
  V(203) = V_USER(165)
  V(82) = V_USER(166)
  V(205) = V_USER(167)
  V(73) = V_USER(168)
  V(168) = V_USER(169)
  V(167) = V_USER(170)
  V(83) = V_USER(172)
  V(174) = V_USER(173)
  V(89) = V_USER(174)
  V(48) = V_USER(175)
  V(155) = V_USER(177)
  V(85) = V_USER(178)
  V(49) = V_USER(179)
  V(144) = V_USER(180)
  V(189) = V_USER(181)
  V(86) = V_USER(182)
  V(152) = V_USER(183)
  V(22) = V_USER(184)
  V(170) = V_USER(185)
  V(193) = V_USER(186)
  V(185) = V_USER(187)
  V(90) = V_USER(188)
  V(74) = V_USER(189)
  V(75) = V_USER(190)
  V(194) = V_USER(191)
  V(172) = V_USER(192)
  V(192) = V_USER(193)
  V(109) = V_USER(194)
  V(100) = V_USER(195)
  V(110) = V_USER(196)
  V(134) = V_USER(197)
  V(84) = V_USER(198)
  V(201) = V_USER(199)
  V(23) = V_USER(200)
  V(24) = V_USER(201)
  V(25) = V_USER(202)
  V(26) = V_USER(203)
  V(27) = V_USER(204)
  V(28) = V_USER(205)
  V(30) = V_USER(206)
  V(50) = V_USER(207)
  V(57) = V_USER(208)
  V(180) = V_USER(209)
  V(101) = V_USER(210)
  V(76) = V_USER(211)
  V(62) = V_USER(212)
      
END SUBROUTINE Shuffle_user2kpp

! End of Shuffle_user2kpp function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Shuffle_kpp2user - function to restore concentrations from KPP to USER
!   Arguments :
!      V         - Concentrations of variable species (local)
!      V_USER    - Concentration of variable species in USER's order
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Shuffle_kpp2user ( V, V_USER )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! V_USER - Concentration of variable species in USER's order
  REAL(kind=dp) :: V_USER(NVAR)

  V_USER(1) = V(151)
  V_USER(2) = V(188)
  V_USER(3) = V(171)
  V_USER(4) = V(4)
  V_USER(5) = V(199)
  V_USER(6) = V(87)
  V_USER(7) = V(157)
  V_USER(8) = V(91)
  V_USER(9) = V(158)
  V_USER(10) = V(45)
  V_USER(11) = V(206)
  V_USER(12) = V(102)
  V_USER(13) = V(92)
  V_USER(14) = V(165)
  V_USER(15) = V(58)
  V_USER(16) = V(51)
  V_USER(17) = V(122)
  V_USER(18) = V(113)
  V_USER(19) = V(111)
  V_USER(21) = V(117)
  V_USER(22) = V(96)
  V_USER(23) = V(39)
  V_USER(24) = V(67)
  V_USER(25) = V(1)
  V_USER(26) = V(2)
  V_USER(27) = V(3)
  V_USER(28) = V(196)
  V_USER(29) = V(173)
  V_USER(30) = V(52)
  V_USER(31) = V(129)
  V_USER(32) = V(78)
  V_USER(33) = V(46)
  V_USER(34) = V(40)
  V_USER(35) = V(68)
  V_USER(36) = V(210)
  V_USER(37) = V(104)
  V_USER(38) = V(69)
  V_USER(39) = V(79)
  V_USER(40) = V(162)
  V_USER(41) = V(186)
  V_USER(42) = V(81)
  V_USER(43) = V(211)
  V_USER(44) = V(5)
  V_USER(45) = V(41)
  V_USER(46) = V(42)
  V_USER(47) = V(107)
  V_USER(48) = V(95)
  V_USER(49) = V(126)
  V_USER(50) = V(70)
  V_USER(51) = V(115)
  V_USER(52) = V(116)
  V_USER(53) = V(213)
  V_USER(54) = V(77)
  V_USER(55) = V(131)
  V_USER(56) = V(177)
  V_USER(57) = V(147)
  V_USER(58) = V(139)
  V_USER(59) = V(191)
  V_USER(60) = V(175)
  V_USER(61) = V(103)
  V_USER(62) = V(184)
  V_USER(63) = V(179)
  V_USER(64) = V(195)
  V_USER(65) = V(140)
  V_USER(66) = V(53)
  V_USER(67) = V(71)
  V_USER(68) = V(164)
  V_USER(69) = V(72)
  V_USER(70) = V(204)
  V_USER(71) = V(142)
  V_USER(72) = V(143)
  V_USER(73) = V(93)
  V_USER(74) = V(108)
  V_USER(75) = V(88)
  V_USER(76) = V(99)
  V_USER(77) = V(161)
  V_USER(78) = V(130)
  V_USER(79) = V(43)
  V_USER(80) = V(47)
  V_USER(81) = V(38)
  V_USER(82) = V(105)
  V_USER(83) = V(54)
  V_USER(84) = V(64)
  V_USER(85) = V(59)
  V_USER(86) = V(60)
  V_USER(87) = V(55)
  V_USER(88) = V(146)
  V_USER(89) = V(29)
  V_USER(90) = V(65)
  V_USER(91) = V(6)
  V_USER(92) = V(190)
  V_USER(93) = V(118)
  V_USER(94) = V(56)
  V_USER(95) = V(163)
  V_USER(96) = V(80)
  V_USER(97) = V(123)
  V_USER(98) = V(61)
  V_USER(99) = V(127)
  V_USER(100) = V(7)
  V_USER(101) = V(8)
  V_USER(102) = V(183)
  V_USER(103) = V(9)
  V_USER(104) = V(10)
  V_USER(105) = V(154)
  V_USER(106) = V(141)
  V_USER(107) = V(138)
  V_USER(108) = V(112)
  V_USER(109) = V(156)
  V_USER(110) = V(137)
  V_USER(111) = V(149)
  V_USER(112) = V(178)
  V_USER(113) = V(166)
  V_USER(114) = V(176)
  V_USER(115) = V(11)
  V_USER(116) = V(12)
  V_USER(117) = V(128)
  V_USER(118) = V(169)
  V_USER(119) = V(13)
  V_USER(120) = V(14)
  V_USER(121) = V(15)
  V_USER(122) = V(16)
  V_USER(123) = V(18)
  V_USER(124) = V(17)
  V_USER(125) = V(19)
  V_USER(126) = V(20)
  V_USER(127) = V(197)
  V_USER(128) = V(159)
  V_USER(129) = V(133)
  V_USER(130) = V(148)
  V_USER(131) = V(153)
  V_USER(132) = V(114)
  V_USER(133) = V(160)
  V_USER(134) = V(63)
  V_USER(137) = V(202)
  V_USER(138) = V(198)
  V_USER(139) = V(135)
  V_USER(140) = V(182)
  V_USER(141) = V(132)
  V_USER(142) = V(106)
  V_USER(143) = V(124)
  V_USER(144) = V(207)
  V_USER(145) = V(44)
  V_USER(146) = V(136)
  V_USER(147) = V(145)
  V_USER(148) = V(97)
  V_USER(149) = V(66)
  V_USER(150) = V(187)
  V_USER(151) = V(98)
  V_USER(152) = V(21)
  V_USER(153) = V(119)
  V_USER(154) = V(120)
  V_USER(155) = V(200)
  V_USER(156) = V(150)
  V_USER(157) = V(125)
  V_USER(158) = V(94)
  V_USER(159) = V(181)
  V_USER(160) = V(208)
  V_USER(161) = V(209)
  V_USER(162) = V(212)
  V_USER(163) = V(121)
  V_USER(165) = V(203)
  V_USER(166) = V(82)
  V_USER(167) = V(205)
  V_USER(168) = V(73)
  V_USER(169) = V(168)
  V_USER(170) = V(167)
  V_USER(172) = V(83)
  V_USER(173) = V(174)
  V_USER(174) = V(89)
  V_USER(175) = V(48)
  V_USER(177) = V(155)
  V_USER(178) = V(85)
  V_USER(179) = V(49)
  V_USER(180) = V(144)
  V_USER(181) = V(189)
  V_USER(182) = V(86)
  V_USER(183) = V(152)
  V_USER(184) = V(22)
  V_USER(185) = V(170)
  V_USER(186) = V(193)
  V_USER(187) = V(185)
  V_USER(188) = V(90)
  V_USER(189) = V(74)
  V_USER(190) = V(75)
  V_USER(191) = V(194)
  V_USER(192) = V(172)
  V_USER(193) = V(192)
  V_USER(194) = V(109)
  V_USER(195) = V(100)
  V_USER(196) = V(110)
  V_USER(197) = V(134)
  V_USER(198) = V(84)
  V_USER(199) = V(201)
  V_USER(200) = V(23)
  V_USER(201) = V(24)
  V_USER(202) = V(25)
  V_USER(203) = V(26)
  V_USER(204) = V(27)
  V_USER(205) = V(28)
  V_USER(206) = V(30)
  V_USER(207) = V(50)
  V_USER(208) = V(57)
  V_USER(209) = V(180)
  V_USER(210) = V(101)
  V_USER(211) = V(76)
  V_USER(212) = V(62)
      
END SUBROUTINE Shuffle_kpp2user

! End of Shuffle_kpp2user function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! GetMass - compute total mass of selected atoms
!   Arguments :
!      CL        - Concentration of all species (local)
!      Mass      - value of mass balance
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE GetMass ( CL, Mass )

! CL - Concentration of all species (local)
  REAL(kind=dp) :: CL(NSPEC)
! Mass - value of mass balance
  REAL(kind=dp) :: Mass(1)

      
END SUBROUTINE GetMass

! End of GetMass function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! ComputeFamilies - function to calculate user-defined Prod/Loss families
!   Arguments :
!      V         - Concentrations of variable species (local)
!      FAM       - Accumulated user-defined prod/loss families.
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE ComputeFamilies ( V, FAM )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! FAM - Accumulated user-defined prod/loss families.
  REAL(kind=dp) :: FAM(NFAM)


! Computation of prod/loss families
  FAM(1) = V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(33)+V(33)&
             &+V(31)+V(31)+0.96*V(33)+0.21*V(31)+1.78*V(31)+0.36*V(31)+V(31)+V(31)+V(33)+0.15*V(31)+0.15*V(31)+0.15*V(33)&
             &+0.81*V(33)+V(33)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+2*V(31)+V(31)+V(31)+V(31)+V(33)+V(31)+1.394*V(31)&
             &+V(31)+1.58*V(31)+1.01*V(31)+V(31)+1.15*V(31)+0.15*V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)&
             &+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+0.82*V(31)+0.78*V(31)+V(31)+2*V(31)+0.5*V(31)&
             &+V(31)+0.5*V(31)+V(31)+V(31)+V(31)+2*V(31)+V(31)+V(31)+V(31)+0.3*V(31)+V(31)+0.4*V(31)+V(31)+V(31)+V(31)
  FAM(2) = V(32)+V(32)+V(32)+V(32)+V(32)+2*V(32)+V(32)+V(32)+V(32)+1.4*V(32)+1.04*V(32)+1.04*V(32)+0.0599999*V(32)+0.04&
             &*V(32)+V(32)+0.106*V(32)+0.04*V(32)+0.34*V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)&
             &+V(32)+V(32)+1.5*V(32)+V(32)+V(32)+2*V(32)+0.64*V(32)+V(32)+V(32)+2*V(32)+2*V(32)+V(32)+V(32)+V(32)+V(32)&
             &+V(32)+V(32)+2*V(32)+2*V(32)+2*V(32)+2*V(32)+2*V(32)+2*V(32)+2*V(32)+0.9*V(32)+0.9*V(32)+0.388*V(32)+V(32)&
             &+V(32)+2*V(32)+V(32)+V(32)+V(32)+2*V(32)+2*V(32)+V(32)+2*V(32)+V(32)+V(32)+V(32)+2*V(32)+2*V(32)+0.5*V(32)&
             &+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)&
             &+V(32)+V(32)+2*V(32)+2*V(32)+2*V(32)+3*V(32)+3*V(32)+3*V(32)+4*V(32)+4*V(32)+4*V(32)+V(32)+V(32)+2*V(32)+2&
             &*V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+2*V(32)+V(32)+2*V(32)+V(32)+V(32)+2*V(32)
  FAM(3) = V(33)+V(33)+0.05*V(33)+0.728*V(33)+V(33)+0.5*V(33)+V(33)+V(33)+0.5*V(33)+0.075*V(33)+0.29*V(33)+0.33*V(33)&
             &+0.595*V(33)+0.375*V(33)+0.39*V(33)+0.56*V(33)+V(33)+0.03*V(33)+0.505*V(33)+V(33)+2*V(33)+V(33)+2*V(33)+V(33)&
             &+0.5*V(33)+0.495*V(33)+0.56*V(33)+0.625*V(33)+0.5*V(33)+0.6*V(33)+0.678*V(33)+0.89*V(33)+0.09*V(33)+0.857&
             &*V(33)+0.5*V(33)+0.21*V(33)+V(33)+V(33)+V(33)+V(33)+V(33)+0.09*V(33)+1.5*V(33)+0.14*V(37)+0.14*V(37)+0.14&
             &*V(37)+0.5*V(33)+0.55*V(33)+V(33)+V(33)+V(33)+0.88*V(33)+V(33)+V(33)+V(33)+V(33)+2*V(33)+2*V(33)+V(33)+V(33)&
             &+V(33)+V(33)+V(33)+0.67*V(33)+0.5*V(33)+0.5*V(33)+V(33)+V(33)+1.89*V(33)
  FAM(4) = V(34)+V(34)+V(34)+V(34)+V(34)+V(34)+V(34)+V(34)
  FAM(5) = V(35)+V(35)+V(35)+V(35)+V(35)+V(35)+V(35)+V(35)
  FAM(6) = V(36)+V(36)
  FAM(7) = V(37)+V(37)+V(37)+V(37)+V(37)+V(37)+V(37)+V(37)+V(37)+0.02*V(37)+0.02*V(37)+0.02*V(37)
      
END SUBROUTINE ComputeFamilies

! End of ComputeFamilies function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE gckpp_Util

