! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Linear Algebra Data and Routines File
! 
! Generated by KPP-2.2.4_gc symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : gckpp_LinearAlgebra.f90
! Time                 : Thu Jul 19 13:05:49 2018
! Working directory    : /n/home05/msulprizio/GC/Code.Dev/KPP/Tropchem
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_LinearAlgebra

  USE gckpp_Parameters
  USE gckpp_JacobianSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! SPARSE_UTIL - SPARSE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecomp( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER  :: IER
      REAL(kind=dp) :: JVS(LU_NONZERO), W(NVAR), a
      INTEGER  :: k, kk, j, jj

      a = 0. ! mz_rs_20050606
      IER = 0
      DO k=1,NVAR
        ! mz_rs_20050606: don't check if real value == 0
        ! IF ( JVS( LU_DIAG(k) ) .EQ. 0. ) THEN
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(a) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecomp


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplx( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization, complex
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER        :: IER
      DOUBLE COMPLEX :: JVS(LU_NONZERO), W(NVAR), a
      REAL(kind=dp)  :: b = 0.0
      INTEGER        :: k, kk, j, jj

      IER = 0
      DO k=1,NVAR
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(b) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecompCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplxR( JVSR, JVSI, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!    Sparse LU factorization, complex
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER       :: IER
      REAL(kind=dp) :: JVSR(LU_NONZERO), JVSI(LU_NONZERO) 
      REAL(kind=dp) :: WR(NVAR), WI(NVAR), ar, ai, den
      INTEGER       :: k, kk, j, jj

      IER = 0
      ar  = 0.0
      DO k=1,NVAR
        IF (  ( ABS(JVSR(LU_DIAG(k))) < TINY(ar) ) .AND. &
              ( ABS(JVSI(LU_DIAG(k))) < TINY(ar) ) )  THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              WR( LU_ICOL(kk) ) = JVSR(kk)
              WI( LU_ICOL(kk) ) = JVSI(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            den = JVSR(LU_DIAG(j))**2 + JVSI(LU_DIAG(j))**2
            ar = -(WR(j)*JVSR(LU_DIAG(j)) + WI(j)*JVSI(LU_DIAG(j)))/den
            ai = -(WI(j)*JVSR(LU_DIAG(j)) - WR(j)*JVSI(LU_DIAG(j)))/den
            WR(j) = -ar
            WI(j) = -ai
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               WR( LU_ICOL(jj) ) = WR( LU_ICOL(jj) ) + ar*JVSR(jj) - ai*JVSI(jj)
               WI( LU_ICOL(jj) ) = WI( LU_ICOL(jj) ) + ar*JVSI(jj) + ai*JVSR(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVSR(kk) = WR( LU_ICOL(kk) )
            JVSI(kk) = WI( LU_ICOL(kk) )
         END DO
      END DO

END SUBROUTINE KppDecompCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER  :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER       :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveCmplx

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), sumr, sumi, den

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             XR(i) = XR(i) - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
             XI(i) = XI(i) - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
         END DO  
      END DO

      DO i=NVAR,1,-1
        sumr = XR(i); sumi = XI(i)
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
            sumr = sumr - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
            sumi = sumi - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
        END DO
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (sumr*JVSR(LU_DIAG(i)) + sumi*JVSI(LU_DIAG(i)))/den
        XI(i) = (sumi*JVSR(LU_DIAG(i)) - sumr*JVSI(LU_DIAG(i)))/den
      END DO
      
END SUBROUTINE KppSolveCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve transpose subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), den

      DO i=1,NVAR
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (XR(i)*JVSR(LU_DIAG(i)) + XI(i)*JVSI(LU_DIAG(i)))/den
        XI(i) = (XI(i)*JVSR(LU_DIAG(i)) - XR(i)*JVSI(LU_DIAG(i)))/den
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplxR


!
! Next few commented subroutines perform sparse big linear algebra
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppDecompBig( JVS, IP, IER )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse LU factorization
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE gckpp_Parameters
!  USE gckpp_JacobianSP
!
!      INTEGER  :: IP3(3), IER, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), W(3,3,NVAR), a(3,3), E(3,3)
!      INTEGER  :: k, kk, j, jj
!
!      a = 0.0d0
!      IER = 0
!      DO k=1,NVAR
!        DO kk = LU_CROW(k), LU_CROW(k+1)-1
!              W( 1:3,1:3,LU_ICOL(kk) ) = JVS(1:3,1:3,kk)
!        END DO
!        DO kk = LU_CROW(k), LU_DIAG(k)-1
!            j = LU_ICOL(kk)
!            E(1:3,1:3) = JVS( 1:3,1:3,LU_DIAG(j) )
!            ! CALL DGETRF(3,3,E,3,IP3,IER) 
!            CALL FAC3(E,IP3,IER)
!            IF ( IER /= 0 )  RETURN
!            ! a = W(j) / JVS( LU_DIAG(j) )
!            a(1:3,1:3) = W( 1:3,1:3,j )
!            ! CALL DGETRS ('N',3,3,E,3,IP3,a,3,IER) 
!            CALL SOL3('N',E,IP3,a(1,1))
!            CALL SOL3('N',E,IP3,a(1,2))
!            CALL SOL3('N',E,IP3,a(1,3))
!            W(1:3,1:3,j) = a(1:3,1:3)
!            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
!               W( 1:3,1:3,LU_ICOL(jj) ) = W( 1:3,1:3,LU_ICOL(jj) ) &
!                        - MATMUL( a(1:3,1:3) , JVS(1:3,1:3,jj) )
!            END DO
!         END DO
!         DO kk = LU_CROW(k), LU_CROW(k+1)-1
!            JVS(1:3,1:3,kk) = W( 1:3,1:3,LU_ICOL(kk) )
!         END DO
!      END DO
!
!      DO k=1,NVAR
!         ! CALL WGEFA(JVS(1,1,LU_DIAG(k)),3,3,IP(1,k),IER)
!         ! CALL DGETRF(3,3,JVS(1,1,LU_DIAG(k)),3,IP(1,k),IER)
!         CALL FAC3(JVS(1,1,LU_DIAG(k)),IP(1,k),IER)
!         IF ( IER /= 0 )  RETURN
!      END DO 
!      
!END SUBROUTINE KppDecompBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBig( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse solve subroutine using indirect addressing
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE gckpp_Parameters
!  USE gckpp_JacobianSP
!
!      INTEGER  :: i, j, k, m, IP3(3), IP(3,NVAR), IER
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR), sum(3)
!
!      DO i=1,NVAR
!        DO j = LU_CROW(i), LU_DIAG(i)-1 
!          !X(1:3,i) = X(1:3,i) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       X(k,i) = X(k,i) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO  
!      END DO
!
!      DO i=NVAR,1,-1
!        sum(1:3) = X(1:3,i);
!        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
!          !sum(1:3) = sum(1:3) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       sum(k) = sum(k) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO
!        ! X(i) = sum/JVS(LU_DIAG(i));
!        ! CALL DGETRS ('N',3,1,JVS(1:3,1:3,LU_DIAG(i)),3,IP(1,i),sum,3,0) 
!        ! CALL WGESL('N',JVS(1,1,LU_DIAG(i)),3,3,IP(1,i),sum)
!        CALL SOL3('N',JVS(1,1,LU_DIAG(i)),IP(1,i),sum)
!        X(1:3,i) = sum(1:3)
!      END DO
!      
!END SUBROUTINE KppSolveBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBigTR( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Big sparse transpose solve using indirect addressing
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE gckpp_Parameters
!  USE gckpp_JacobianSP
!
!      INTEGER       :: i, j, k, m, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR)
!
!      DO i=1,NVAR
!        ! X(i) = X(i)/JVS(LU_DIAG(i))
!        CALL SOL3('T',JVS(1,1,LU_DIAG(i)),IP(1,i),X(1,i))
!        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !    - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!
!      DO i=NVAR, 1, -1
!        DO j=LU_CROW(i),LU_DIAG(i)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !   - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!      
!END SUBROUTINE KppSolveBigTR
!
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE FAC3(A,IPVT,INFO)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     FAC3 FACTORS THE MATRIX A (3,3) BY
!!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!!     LINPACK - LIKE 
!!
!!     Remove comments to perform pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!
!      REAL(kind=dp) :: A(3,3)
!      INTEGER       :: IPVT(3),INFO
!!      INTEGER       :: L
!!      REAL(kind=dp) :: t, dmax, da, TMP(3)
!      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0
!
!      info = 0
!!      t = TINY(da)
!!      
!!      da = ABS(A(1,1)); L = 1
!!      IF ( ABS(A(2,1))>da ) THEN
!!        da = ABS(A(2,1)); L = 2
!!        IF ( ABS(A(3,1))>da ) THEN
!!          L = 3
!!        END IF  
!!      END IF  
!!      IPVT(1)  = L
!!      IF (L /=1 ) THEN
!!         TMP(1:3) = A(L,1:3)
!!         A(L,1:3) = A(1,1:3)
!!         A(1,1:3) = TMP(1:3)
!!      END IF
!!      IF (ABS(A(1,1)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!
!      A(2,1) = A(2,1)/A(1,1)
!      A(2,2) = A(2,2) - A(2,1)*A(1,2)
!      A(2,3) = A(2,3) - A(2,1)*A(1,3)
!      A(3,1) = A(3,1)/A(1,1)
!      A(3,2) = A(3,2) - A(3,1)*A(1,2)
!      A(3,3) = A(3,3) - A(3,1)*A(1,3)
!      
!!      IPVT(2)  = 2
!!      IF (ABS(A(3,2))>ABS(A(2,2))) THEN
!!         IPVT(2)  = 3
!!         TMP(2:3) = A(3,2:3)
!!         A(3,2:3) = A(2,2:3)
!!         A(2,2:3) = TMP(2:3)
!!      END IF
!!      IF (ABS(A(2,2)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!      
!      A(3,2)   = A(3,2)/A(2,2)
!      A(3,3)   = A(3,3) - A(3,2)*A(2,3)
!      IPVT(3)  = 3
!      
!END SUBROUTINE FAC3
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE SOL3(Trans,A,IPVT,b)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     SOL3 solves the system 3x3
!!     A * x = b  or  trans(a) * x = b
!!     using the factors computed by WGEFA.
!!
!!     Trans      = 'N'   to solve  A*x = b ,
!!                = 'T'   to solve  transpose(A)*x = b
!!     LINPACK - LIKE 
!!
!!     Remove comments to use pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!      CHARACTER     :: Trans
!      REAL(kind=dp) :: a(3,3),b(3)
!      INTEGER       :: IPVT(3)
!!      INTEGER       :: L
!!      REAL(kind=dp) :: TMP
!      
!      SELECT CASE (Trans)
!
!      CASE ('n','N')  !  Solve  A * x = b
!
!!     Solve  L*y = b
!!         L = IPVT(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!         b(2) = b(2)-A(2,1)*b(1)
!         b(3) = b(3)-A(3,1)*b(1)
!         
!!         L = IPVT(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(3) = b(3)-A(3,2)*b(2)
!
!!     Solve  U*x = y
!         b(3) = b(3)/A(3,3)
!         b(2) = (b(2)-A(2,3)*b(3))/A(2,2)
!         b(1) = (b(1)-A(1,3)*b(3)-A(1,2)*b(2))/A(1,1)
!      
!      
!      CASE ('t','T')  !  Solve transpose(A) * x = b
!
!!      Solve transpose(U)*y = b
!         b(1) = b(1)/A(1,1)
!         b(2) = (b(2)-A(1,2)*b(1))/A(2,2)
!         b(3) = (b(3)-A(1,3)*b(1)-A(2,3)*b(2))/A(3,3)
!
!!      Solve transpose(L)*x = y
!         b(2) = b(2)-A(3,2)*b(3)
!!         L = ipvt(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(1) = b(1)-A(3,1)*b(3)-A(2,1)*b(2)
!!         L = ipvt(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!   
!      END SELECT
!
!END SUBROUTINE SOL3

! End of SPARSE_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolve - sparse back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolve ( JVS, X )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)

  X(57) = X(57)-JVS(401)*X(50)
  X(58) = X(58)-JVS(406)*X(45)
  X(61) = X(61)-JVS(421)*X(41)
  X(73) = X(73)-JVS(476)*X(38)-JVS(477)*X(43)-JVS(478)*X(47)
  X(81) = X(81)-JVS(508)*X(69)
  X(99) = X(99)-JVS(599)*X(88)
  X(104) = X(104)-JVS(627)*X(81)
  X(107) = X(107)-JVS(647)*X(105)
  X(124) = X(124)-JVS(739)*X(106)
  X(127) = X(127)-JVS(759)*X(65)
  X(130) = X(130)-JVS(777)*X(56)-JVS(778)*X(80)-JVS(779)*X(123)
  X(133) = X(133)-JVS(802)*X(48)
  X(139) = X(139)-JVS(855)*X(119)-JVS(856)*X(120)-JVS(857)*X(125)-JVS(858)*X(128)-JVS(859)*X(129)-JVS(860)*X(131)&
             &-JVS(861)*X(132)-JVS(862)*X(135)
  X(140) = X(140)-JVS(880)*X(128)-JVS(881)*X(133)-JVS(882)*X(137)
  X(142) = X(142)-JVS(906)*X(102)-JVS(907)*X(111)-JVS(908)*X(113)-JVS(909)*X(122)
  X(143) = X(143)-JVS(920)*X(69)-JVS(921)*X(79)-JVS(922)*X(82)-JVS(923)*X(94)-JVS(924)*X(104)
  X(144) = X(144)-JVS(938)*X(86)
  X(146) = X(146)-JVS(959)*X(55)-JVS(960)*X(59)-JVS(961)*X(60)-JVS(962)*X(100)-JVS(963)*X(109)-JVS(964)*X(110)-JVS(965)&
             &*X(137)
  X(147) = X(147)-JVS(973)*X(42)-JVS(974)*X(45)-JVS(975)*X(50)-JVS(976)*X(76)-JVS(977)*X(88)-JVS(978)*X(95)-JVS(979)&
             &*X(99)-JVS(980)*X(126)-JVS(981)*X(138)-JVS(982)*X(141)-JVS(983)*X(146)
  X(149) = X(149)-JVS(1004)*X(112)-JVS(1005)*X(137)
  X(150) = X(150)-JVS(1013)*X(137)-JVS(1014)*X(149)
  X(151) = X(151)-JVS(1023)*X(74)-JVS(1024)*X(96)
  X(152) = X(152)-JVS(1035)*X(86)-JVS(1036)*X(137)-JVS(1037)*X(138)-JVS(1038)*X(141)-JVS(1039)*X(144)
  X(155) = X(155)-JVS(1069)*X(85)
  X(157) = X(157)-JVS(1084)*X(91)
  X(158) = X(158)-JVS(1095)*X(75)-JVS(1096)*X(96)
  X(159) = X(159)-JVS(1107)*X(137)-JVS(1108)*X(149)
  X(160) = X(160)-JVS(1117)*X(114)-JVS(1118)*X(153)
  X(161) = X(161)-JVS(1128)*X(1)-JVS(1129)*X(2)-JVS(1130)*X(3)-JVS(1131)*X(43)-JVS(1132)*X(46)-JVS(1133)*X(53)-JVS(1134)&
             &*X(54)-JVS(1135)*X(56)-JVS(1136)*X(64)-JVS(1137)*X(73)-JVS(1138)*X(80)-JVS(1139)*X(93)-JVS(1140)*X(123)&
             &-JVS(1141)*X(130)
  X(162) = X(162)-JVS(1152)*X(111)-JVS(1153)*X(113)-JVS(1154)*X(142)
  X(163) = X(163)-JVS(1166)*X(43)-JVS(1167)*X(47)-JVS(1168)*X(73)-JVS(1169)*X(93)-JVS(1170)*X(123)-JVS(1171)*X(130)&
             &-JVS(1172)*X(161)
  X(164) = X(164)-JVS(1182)*X(44)-JVS(1183)*X(61)-JVS(1184)*X(70)-JVS(1185)*X(87)-JVS(1186)*X(94)-JVS(1187)*X(108)&
             &-JVS(1188)*X(111)-JVS(1189)*X(113)-JVS(1190)*X(117)-JVS(1191)*X(122)-JVS(1192)*X(123)-JVS(1193)*X(124)&
             &-JVS(1194)*X(126)-JVS(1195)*X(130)-JVS(1196)*X(136)-JVS(1197)*X(137)-JVS(1198)*X(142)-JVS(1199)*X(145)&
             &-JVS(1200)*X(147)-JVS(1201)*X(149)-JVS(1202)*X(150)-JVS(1203)*X(159)-JVS(1204)*X(160)-JVS(1205)*X(161)&
             &-JVS(1206)*X(162)-JVS(1207)*X(163)
  X(165) = X(165)-JVS(1243)*X(122)-JVS(1244)*X(161)-JVS(1245)*X(163)
  X(166) = X(166)-JVS(1256)*X(112)-JVS(1257)*X(149)
  X(167) = X(167)-JVS(1265)*X(119)-JVS(1266)*X(120)-JVS(1267)*X(128)
  X(168) = X(168)-JVS(1277)*X(119)-JVS(1278)*X(120)-JVS(1279)*X(128)-JVS(1280)*X(167)
  X(169) = X(169)-JVS(1289)*X(128)
  X(170) = X(170)-JVS(1298)*X(112)-JVS(1299)*X(149)-JVS(1300)*X(166)
  X(171) = X(171)-JVS(1311)*X(129)-JVS(1312)*X(133)-JVS(1313)*X(144)-JVS(1314)*X(151)-JVS(1315)*X(153)-JVS(1316)*X(155)&
             &-JVS(1317)*X(157)-JVS(1318)*X(158)-JVS(1319)*X(159)-JVS(1320)*X(160)-JVS(1321)*X(166)-JVS(1322)*X(170)
  X(172) = X(172)-JVS(1351)*X(49)-JVS(1352)*X(84)-JVS(1353)*X(154)
  X(173) = X(173)-JVS(1366)*X(156)
  X(174) = X(174)-JVS(1379)*X(119)-JVS(1380)*X(120)
  X(175) = X(175)-JVS(1389)*X(96)-JVS(1390)*X(117)-JVS(1391)*X(142)-JVS(1392)*X(143)-JVS(1393)*X(162)-JVS(1394)*X(163)&
             &-JVS(1395)*X(165)
  X(176) = X(176)-JVS(1412)*X(119)-JVS(1413)*X(120)-JVS(1414)*X(128)
  X(177) = X(177)-JVS(1424)*X(88)-JVS(1425)*X(101)-JVS(1426)*X(105)-JVS(1427)*X(126)-JVS(1428)*X(131)-JVS(1429)*X(146)&
             &-JVS(1430)*X(149)-JVS(1431)*X(150)-JVS(1432)*X(166)
  X(179) = X(179)-JVS(1456)*X(105)-JVS(1457)*X(109)-JVS(1458)*X(110)
  X(180) = X(180)-JVS(1467)*X(101)-JVS(1468)*X(156)
  X(181) = X(181)-JVS(1479)*X(114)-JVS(1480)*X(121)-JVS(1481)*X(153)
  X(182) = X(182)-JVS(1492)*X(42)-JVS(1493)*X(50)-JVS(1494)*X(76)-JVS(1495)*X(88)-JVS(1496)*X(91)-JVS(1497)*X(95)&
             &-JVS(1498)*X(99)-JVS(1499)*X(101)-JVS(1500)*X(103)-JVS(1501)*X(105)-JVS(1502)*X(126)-JVS(1503)*X(132)&
             &-JVS(1504)*X(133)-JVS(1505)*X(135)-JVS(1506)*X(146)-JVS(1507)*X(150)-JVS(1508)*X(152)-JVS(1509)*X(153)&
             &-JVS(1510)*X(154)-JVS(1511)*X(157)-JVS(1512)*X(159)-JVS(1513)*X(166)-JVS(1514)*X(176)-JVS(1515)*X(178)&
             &-JVS(1516)*X(179)-JVS(1517)*X(180)
  X(184) = X(184)-JVS(1550)*X(100)-JVS(1551)*X(109)-JVS(1552)*X(110)-JVS(1553)*X(137)-JVS(1554)*X(178)
  X(185) = X(185)-JVS(1565)*X(87)-JVS(1566)*X(89)-JVS(1567)*X(90)-JVS(1568)*X(124)-JVS(1569)*X(126)-JVS(1570)*X(169)&
             &-JVS(1571)*X(170)-JVS(1572)*X(174)-JVS(1573)*X(178)-JVS(1574)*X(179)-JVS(1575)*X(184)
  X(186) = X(186)-JVS(1588)*X(69)-JVS(1589)*X(81)-JVS(1590)*X(82)-JVS(1591)*X(143)-JVS(1592)*X(162)-JVS(1593)*X(163)&
             &-JVS(1594)*X(165)-JVS(1595)*X(175)
  X(187) = X(187)-JVS(1612)*X(98)-JVS(1613)*X(148)-JVS(1614)*X(156)
  X(188) = X(188)-JVS(1628)*X(75)-JVS(1629)*X(158)-JVS(1630)*X(174)-JVS(1631)*X(185)
  X(189) = X(189)-JVS(1645)*X(128)-JVS(1646)*X(156)-JVS(1647)*X(169)
  X(190) = X(190)-JVS(1659)*X(118)-JVS(1660)*X(138)-JVS(1661)*X(141)-JVS(1662)*X(156)-JVS(1663)*X(183)
  X(191) = X(191)-JVS(1673)*X(85)-JVS(1674)*X(88)-JVS(1675)*X(98)-JVS(1676)*X(105)-JVS(1677)*X(107)-JVS(1678)*X(108)&
             &-JVS(1679)*X(121)-JVS(1680)*X(126)-JVS(1681)*X(127)-JVS(1682)*X(131)-JVS(1683)*X(133)-JVS(1684)*X(136)&
             &-JVS(1685)*X(145)-JVS(1686)*X(146)-JVS(1687)*X(148)-JVS(1688)*X(149)-JVS(1689)*X(154)-JVS(1690)*X(155)&
             &-JVS(1691)*X(156)-JVS(1692)*X(157)-JVS(1693)*X(159)-JVS(1694)*X(160)-JVS(1695)*X(166)-JVS(1696)*X(167)&
             &-JVS(1697)*X(168)-JVS(1698)*X(169)-JVS(1699)*X(174)-JVS(1700)*X(176)-JVS(1701)*X(178)-JVS(1702)*X(179)&
             &-JVS(1703)*X(181)-JVS(1704)*X(183)-JVS(1705)*X(184)-JVS(1706)*X(187)-JVS(1707)*X(188)-JVS(1708)*X(189)&
             &-JVS(1709)*X(190)
  X(192) = X(192)-JVS(1728)*X(100)-JVS(1729)*X(109)-JVS(1730)*X(110)-JVS(1731)*X(156)
  X(193) = X(193)-JVS(1741)*X(118)-JVS(1742)*X(138)-JVS(1743)*X(141)-JVS(1744)*X(153)-JVS(1745)*X(170)-JVS(1746)*X(176)&
             &-JVS(1747)*X(178)-JVS(1748)*X(183)-JVS(1749)*X(185)-JVS(1750)*X(190)-JVS(1751)*X(192)
  X(194) = X(194)-JVS(1763)*X(74)-JVS(1764)*X(86)-JVS(1765)*X(89)-JVS(1766)*X(90)-JVS(1767)*X(112)-JVS(1768)*X(118)&
             &-JVS(1769)*X(119)-JVS(1770)*X(120)-JVS(1771)*X(124)-JVS(1772)*X(126)-JVS(1773)*X(134)-JVS(1774)*X(138)&
             &-JVS(1775)*X(141)-JVS(1776)*X(144)-JVS(1777)*X(145)-JVS(1778)*X(149)-JVS(1779)*X(151)-JVS(1780)*X(153)&
             &-JVS(1781)*X(155)-JVS(1782)*X(158)-JVS(1783)*X(160)-JVS(1784)*X(166)-JVS(1785)*X(167)-JVS(1786)*X(168)&
             &-JVS(1787)*X(169)-JVS(1788)*X(170)-JVS(1789)*X(174)-JVS(1790)*X(176)-JVS(1791)*X(178)-JVS(1792)*X(179)&
             &-JVS(1793)*X(180)-JVS(1794)*X(181)-JVS(1795)*X(183)-JVS(1796)*X(184)-JVS(1797)*X(185)-JVS(1798)*X(187)&
             &-JVS(1799)*X(189)-JVS(1800)*X(190)-JVS(1801)*X(192)-JVS(1802)*X(193)
  X(195) = X(195)-JVS(1819)*X(67)-JVS(1820)*X(68)-JVS(1821)*X(78)-JVS(1822)*X(87)-JVS(1823)*X(94)-JVS(1824)*X(96)&
             &-JVS(1825)*X(97)-JVS(1826)*X(115)-JVS(1827)*X(117)-JVS(1828)*X(122)-JVS(1829)*X(139)-JVS(1830)*X(140)&
             &-JVS(1831)*X(142)-JVS(1832)*X(143)-JVS(1833)*X(146)-JVS(1834)*X(148)-JVS(1835)*X(150)-JVS(1836)*X(156)&
             &-JVS(1837)*X(159)-JVS(1838)*X(162)-JVS(1839)*X(163)-JVS(1840)*X(165)-JVS(1841)*X(166)-JVS(1842)*X(171)&
             &-JVS(1843)*X(173)-JVS(1844)*X(174)-JVS(1845)*X(175)-JVS(1846)*X(176)-JVS(1847)*X(177)-JVS(1848)*X(178)&
             &-JVS(1849)*X(179)-JVS(1850)*X(180)-JVS(1851)*X(181)-JVS(1852)*X(183)-JVS(1853)*X(184)-JVS(1854)*X(185)&
             &-JVS(1855)*X(186)-JVS(1856)*X(187)-JVS(1857)*X(188)-JVS(1858)*X(189)-JVS(1859)*X(190)-JVS(1860)*X(191)&
             &-JVS(1861)*X(192)-JVS(1862)*X(193)
  X(196) = X(196)-JVS(1882)*X(45)-JVS(1883)*X(50)-JVS(1884)*X(66)-JVS(1885)*X(70)-JVS(1886)*X(76)-JVS(1887)*X(85)&
             &-JVS(1888)*X(88)-JVS(1889)*X(91)-JVS(1890)*X(97)-JVS(1891)*X(98)-JVS(1892)*X(100)-JVS(1893)*X(101)-JVS(1894)&
             &*X(103)-JVS(1895)*X(109)-JVS(1896)*X(110)-JVS(1897)*X(114)-JVS(1898)*X(116)-JVS(1899)*X(121)-JVS(1900)*X(127)&
             &-JVS(1901)*X(128)-JVS(1902)*X(133)-JVS(1903)*X(137)-JVS(1904)*X(138)-JVS(1905)*X(141)-JVS(1906)*X(144)&
             &-JVS(1907)*X(146)-JVS(1908)*X(147)-JVS(1909)*X(148)-JVS(1910)*X(149)-JVS(1911)*X(150)-JVS(1912)*X(151)&
             &-JVS(1913)*X(152)-JVS(1914)*X(153)-JVS(1915)*X(154)-JVS(1916)*X(155)-JVS(1917)*X(156)-JVS(1918)*X(157)&
             &-JVS(1919)*X(158)-JVS(1920)*X(159)-JVS(1921)*X(160)-JVS(1922)*X(166)-JVS(1923)*X(167)-JVS(1924)*X(168)&
             &-JVS(1925)*X(169)-JVS(1926)*X(170)-JVS(1927)*X(172)-JVS(1928)*X(173)-JVS(1929)*X(174)-JVS(1930)*X(176)&
             &-JVS(1931)*X(177)-JVS(1932)*X(178)-JVS(1933)*X(179)-JVS(1934)*X(180)-JVS(1935)*X(181)-JVS(1936)*X(183)&
             &-JVS(1937)*X(184)-JVS(1938)*X(185)-JVS(1939)*X(186)-JVS(1940)*X(187)-JVS(1941)*X(188)-JVS(1942)*X(189)&
             &-JVS(1943)*X(190)-JVS(1944)*X(191)-JVS(1945)*X(192)-JVS(1946)*X(193)-JVS(1947)*X(194)-JVS(1948)*X(195)
  X(197) = X(197)-JVS(1967)*X(100)-JVS(1968)*X(109)-JVS(1969)*X(110)-JVS(1970)*X(128)-JVS(1971)*X(148)-JVS(1972)*X(156)&
             &-JVS(1973)*X(169)-JVS(1974)*X(190)-JVS(1975)*X(192)
  X(198) = X(198)-JVS(1988)*X(89)-JVS(1989)*X(101)-JVS(1990)*X(106)-JVS(1991)*X(107)-JVS(1992)*X(118)-JVS(1993)*X(119)&
             &-JVS(1994)*X(120)-JVS(1995)*X(136)-JVS(1996)*X(138)-JVS(1997)*X(141)-JVS(1998)*X(160)-JVS(1999)*X(167)&
             &-JVS(2000)*X(168)-JVS(2001)*X(169)-JVS(2002)*X(174)-JVS(2003)*X(176)-JVS(2004)*X(179)-JVS(2005)*X(180)&
             &-JVS(2006)*X(181)-JVS(2007)*X(183)-JVS(2008)*X(184)-JVS(2009)*X(185)-JVS(2010)*X(187)-JVS(2011)*X(190)&
             &-JVS(2012)*X(192)-JVS(2013)*X(193)-JVS(2014)*X(197)
  X(199) = X(199)-JVS(2028)*X(77)-JVS(2029)*X(84)-JVS(2030)*X(85)-JVS(2031)*X(115)-JVS(2032)*X(129)-JVS(2033)*X(144)&
             &-JVS(2034)*X(154)-JVS(2035)*X(155)-JVS(2036)*X(170)-JVS(2037)*X(172)-JVS(2038)*X(176)-JVS(2039)*X(178)&
             &-JVS(2040)*X(183)-JVS(2041)*X(185)-JVS(2042)*X(189)-JVS(2043)*X(190)-JVS(2044)*X(192)-JVS(2045)*X(193)&
             &-JVS(2046)*X(194)-JVS(2047)*X(197)-JVS(2048)*X(198)
  X(200) = X(200)-JVS(2064)*X(100)-JVS(2065)*X(109)-JVS(2066)*X(110)-JVS(2067)*X(125)-JVS(2068)*X(156)-JVS(2069)*X(190)&
             &-JVS(2070)*X(192)
  X(201) = X(201)-JVS(2083)*X(70)-JVS(2084)*X(125)-JVS(2085)*X(129)-JVS(2086)*X(131)-JVS(2087)*X(132)-JVS(2088)*X(135)&
             &-JVS(2089)*X(148)-JVS(2090)*X(156)-JVS(2091)*X(173)-JVS(2092)*X(184)-JVS(2093)*X(189)-JVS(2094)*X(190)&
             &-JVS(2095)*X(192)-JVS(2096)*X(197)-JVS(2097)*X(200)
  X(202) = X(202)-JVS(2110)*X(63)-JVS(2111)*X(83)-JVS(2112)*X(88)-JVS(2113)*X(91)-JVS(2114)*X(101)-JVS(2115)*X(103)&
             &-JVS(2116)*X(114)-JVS(2117)*X(121)-JVS(2118)*X(127)-JVS(2119)*X(135)-JVS(2120)*X(144)-JVS(2121)*X(146)&
             &-JVS(2122)*X(150)-JVS(2123)*X(151)-JVS(2124)*X(153)-JVS(2125)*X(154)-JVS(2126)*X(155)-JVS(2127)*X(156)&
             &-JVS(2128)*X(157)-JVS(2129)*X(158)-JVS(2130)*X(160)-JVS(2131)*X(166)-JVS(2132)*X(167)-JVS(2133)*X(168)&
             &-JVS(2134)*X(169)-JVS(2135)*X(170)-JVS(2136)*X(172)-JVS(2137)*X(174)-JVS(2138)*X(176)-JVS(2139)*X(178)&
             &-JVS(2140)*X(179)-JVS(2141)*X(180)-JVS(2142)*X(181)-JVS(2143)*X(182)-JVS(2144)*X(183)-JVS(2145)*X(184)&
             &-JVS(2146)*X(185)-JVS(2147)*X(187)-JVS(2148)*X(188)-JVS(2149)*X(189)-JVS(2150)*X(190)-JVS(2151)*X(191)&
             &-JVS(2152)*X(192)-JVS(2153)*X(193)-JVS(2154)*X(194)-JVS(2155)*X(197)-JVS(2156)*X(198)-JVS(2157)*X(199)&
             &-JVS(2158)*X(200)-JVS(2159)*X(201)
  X(203) = X(203)-JVS(2172)*X(82)-JVS(2173)*X(106)-JVS(2174)*X(111)-JVS(2175)*X(113)-JVS(2176)*X(119)-JVS(2177)*X(120)&
             &-JVS(2178)*X(121)-JVS(2179)*X(128)-JVS(2180)*X(137)-JVS(2181)*X(142)-JVS(2182)*X(145)-JVS(2183)*X(154)&
             &-JVS(2184)*X(156)-JVS(2185)*X(161)-JVS(2186)*X(162)-JVS(2187)*X(163)-JVS(2188)*X(165)-JVS(2189)*X(167)&
             &-JVS(2190)*X(168)-JVS(2191)*X(169)-JVS(2192)*X(172)-JVS(2193)*X(174)-JVS(2194)*X(175)-JVS(2195)*X(178)&
             &-JVS(2196)*X(179)-JVS(2197)*X(181)-JVS(2198)*X(183)-JVS(2199)*X(184)-JVS(2200)*X(186)-JVS(2201)*X(188)&
             &-JVS(2202)*X(189)-JVS(2203)*X(190)-JVS(2204)*X(192)-JVS(2205)*X(193)-JVS(2206)*X(194)-JVS(2207)*X(195)&
             &-JVS(2208)*X(196)-JVS(2209)*X(197)-JVS(2210)*X(198)-JVS(2211)*X(199)-JVS(2212)*X(200)-JVS(2213)*X(201)&
             &-JVS(2214)*X(202)
  X(204) = X(204)-JVS(2226)*X(52)-JVS(2227)*X(57)-JVS(2228)*X(58)-JVS(2229)*X(62)-JVS(2230)*X(66)-JVS(2231)*X(67)&
             &-JVS(2232)*X(68)-JVS(2233)*X(72)-JVS(2234)*X(74)-JVS(2235)*X(75)-JVS(2236)*X(76)-JVS(2237)*X(77)-JVS(2238)&
             &*X(78)-JVS(2239)*X(84)-JVS(2240)*X(85)-JVS(2241)*X(86)-JVS(2242)*X(88)-JVS(2243)*X(89)-JVS(2244)*X(90)&
             &-JVS(2245)*X(95)-JVS(2246)*X(97)-JVS(2247)*X(98)-JVS(2248)*X(99)-JVS(2249)*X(100)-JVS(2250)*X(101)-JVS(2251)&
             &*X(103)-JVS(2252)*X(105)-JVS(2253)*X(106)-JVS(2254)*X(107)-JVS(2255)*X(109)-JVS(2256)*X(110)-JVS(2257)*X(112)&
             &-JVS(2258)*X(115)-JVS(2259)*X(116)-JVS(2260)*X(118)-JVS(2261)*X(119)-JVS(2262)*X(120)-JVS(2263)*X(124)&
             &-JVS(2264)*X(126)-JVS(2265)*X(127)-JVS(2266)*X(128)-JVS(2267)*X(133)-JVS(2268)*X(134)-JVS(2269)*X(137)&
             &-JVS(2270)*X(138)-JVS(2271)*X(139)-JVS(2272)*X(140)-JVS(2273)*X(141)-JVS(2274)*X(144)-JVS(2275)*X(146)&
             &-JVS(2276)*X(147)-JVS(2277)*X(148)-JVS(2278)*X(149)-JVS(2279)*X(150)-JVS(2280)*X(151)-JVS(2281)*X(153)&
             &-JVS(2282)*X(154)-JVS(2283)*X(155)-JVS(2284)*X(156)-JVS(2285)*X(157)-JVS(2286)*X(158)-JVS(2287)*X(159)&
             &-JVS(2288)*X(160)-JVS(2289)*X(161)-JVS(2290)*X(163)-JVS(2291)*X(165)-JVS(2292)*X(166)-JVS(2293)*X(167)&
             &-JVS(2294)*X(168)-JVS(2295)*X(169)-JVS(2296)*X(170)-JVS(2297)*X(172)-JVS(2298)*X(173)-JVS(2299)*X(174)&
             &-JVS(2300)*X(176)-JVS(2301)*X(177)-JVS(2302)*X(178)-JVS(2303)*X(179)-JVS(2304)*X(180)-JVS(2305)*X(181)&
             &-JVS(2306)*X(182)-JVS(2307)*X(183)-JVS(2308)*X(184)-JVS(2309)*X(185)-JVS(2310)*X(186)-JVS(2311)*X(187)&
             &-JVS(2312)*X(188)-JVS(2313)*X(189)-JVS(2314)*X(190)-JVS(2315)*X(191)-JVS(2316)*X(192)-JVS(2317)*X(193)&
             &-JVS(2318)*X(194)-JVS(2319)*X(195)-JVS(2320)*X(196)-JVS(2321)*X(197)-JVS(2322)*X(198)-JVS(2323)*X(199)&
             &-JVS(2324)*X(200)-JVS(2325)*X(201)-JVS(2326)*X(202)-JVS(2327)*X(203)
  X(205) = X(205)-JVS(2338)*X(39)-JVS(2339)*X(40)-JVS(2340)*X(42)-JVS(2341)*X(46)-JVS(2342)*X(52)-JVS(2343)*X(53)&
             &-JVS(2344)*X(55)-JVS(2345)*X(59)-JVS(2346)*X(60)-JVS(2347)*X(63)-JVS(2348)*X(67)-JVS(2349)*X(68)-JVS(2350)&
             &*X(69)-JVS(2351)*X(70)-JVS(2352)*X(71)-JVS(2353)*X(72)-JVS(2354)*X(74)-JVS(2355)*X(75)-JVS(2356)*X(77)&
             &-JVS(2357)*X(78)-JVS(2358)*X(79)-JVS(2359)*X(80)-JVS(2360)*X(82)-JVS(2361)*X(84)-JVS(2362)*X(85)-JVS(2363)&
             &*X(86)-JVS(2364)*X(87)-JVS(2365)*X(88)-JVS(2366)*X(89)-JVS(2367)*X(90)-JVS(2368)*X(91)-JVS(2369)*X(93)&
             &-JVS(2370)*X(94)-JVS(2371)*X(95)-JVS(2372)*X(96)-JVS(2373)*X(97)-JVS(2374)*X(98)-JVS(2375)*X(99)-JVS(2376)&
             &*X(100)-JVS(2377)*X(101)-JVS(2378)*X(102)-JVS(2379)*X(103)-JVS(2380)*X(104)-JVS(2381)*X(105)-JVS(2382)*X(106)&
             &-JVS(2383)*X(107)-JVS(2384)*X(108)-JVS(2385)*X(109)-JVS(2386)*X(110)-JVS(2387)*X(111)-JVS(2388)*X(112)&
             &-JVS(2389)*X(113)-JVS(2390)*X(114)-JVS(2391)*X(115)-JVS(2392)*X(116)-JVS(2393)*X(117)-JVS(2394)*X(118)&
             &-JVS(2395)*X(119)-JVS(2396)*X(120)-JVS(2397)*X(121)-JVS(2398)*X(122)-JVS(2399)*X(124)-JVS(2400)*X(126)&
             &-JVS(2401)*X(127)-JVS(2402)*X(128)-JVS(2403)*X(130)-JVS(2404)*X(133)-JVS(2405)*X(134)-JVS(2406)*X(136)&
             &-JVS(2407)*X(137)-JVS(2408)*X(138)-JVS(2409)*X(139)-JVS(2410)*X(140)-JVS(2411)*X(141)-JVS(2412)*X(142)&
             &-JVS(2413)*X(143)-JVS(2414)*X(144)-JVS(2415)*X(145)-JVS(2416)*X(146)-JVS(2417)*X(147)-JVS(2418)*X(148)&
             &-JVS(2419)*X(149)-JVS(2420)*X(150)-JVS(2421)*X(151)-JVS(2422)*X(152)-JVS(2423)*X(153)-JVS(2424)*X(154)&
             &-JVS(2425)*X(155)-JVS(2426)*X(156)-JVS(2427)*X(157)-JVS(2428)*X(158)-JVS(2429)*X(159)-JVS(2430)*X(160)&
             &-JVS(2431)*X(161)-JVS(2432)*X(162)-JVS(2433)*X(163)-JVS(2434)*X(164)-JVS(2435)*X(165)-JVS(2436)*X(166)&
             &-JVS(2437)*X(167)-JVS(2438)*X(168)-JVS(2439)*X(169)-JVS(2440)*X(170)-JVS(2441)*X(171)-JVS(2442)*X(172)&
             &-JVS(2443)*X(173)-JVS(2444)*X(174)-JVS(2445)*X(175)-JVS(2446)*X(176)-JVS(2447)*X(177)-JVS(2448)*X(178)&
             &-JVS(2449)*X(179)-JVS(2450)*X(180)-JVS(2451)*X(181)-JVS(2452)*X(182)-JVS(2453)*X(183)-JVS(2454)*X(184)&
             &-JVS(2455)*X(185)-JVS(2456)*X(186)-JVS(2457)*X(187)-JVS(2458)*X(188)-JVS(2459)*X(189)-JVS(2460)*X(190)&
             &-JVS(2461)*X(191)-JVS(2462)*X(192)-JVS(2463)*X(193)-JVS(2464)*X(194)-JVS(2465)*X(195)-JVS(2466)*X(196)&
             &-JVS(2467)*X(197)-JVS(2468)*X(198)-JVS(2469)*X(199)-JVS(2470)*X(200)-JVS(2471)*X(201)-JVS(2472)*X(202)&
             &-JVS(2473)*X(203)-JVS(2474)*X(204)
  X(206) = X(206)-JVS(2484)*X(3)-JVS(2485)*X(39)-JVS(2486)*X(40)-JVS(2487)*X(51)-JVS(2488)*X(52)-JVS(2489)*X(54)&
             &-JVS(2490)*X(80)-JVS(2491)*X(92)-JVS(2492)*X(93)-JVS(2493)*X(96)-JVS(2494)*X(102)-JVS(2495)*X(111)-JVS(2496)&
             &*X(113)-JVS(2497)*X(117)-JVS(2498)*X(122)-JVS(2499)*X(123)-JVS(2500)*X(130)-JVS(2501)*X(142)-JVS(2502)*X(143)&
             &-JVS(2503)*X(161)-JVS(2504)*X(162)-JVS(2505)*X(163)-JVS(2506)*X(165)-JVS(2507)*X(175)-JVS(2508)*X(186)&
             &-JVS(2509)*X(188)-JVS(2510)*X(189)-JVS(2511)*X(190)-JVS(2512)*X(192)-JVS(2513)*X(193)-JVS(2514)*X(195)&
             &-JVS(2515)*X(196)-JVS(2516)*X(197)-JVS(2517)*X(198)-JVS(2518)*X(199)-JVS(2519)*X(200)-JVS(2520)*X(201)&
             &-JVS(2521)*X(202)-JVS(2522)*X(203)-JVS(2523)*X(204)-JVS(2524)*X(205)
  X(207) = X(207)-JVS(2533)*X(46)-JVS(2534)*X(52)-JVS(2535)*X(63)-JVS(2536)*X(66)-JVS(2537)*X(70)-JVS(2538)*X(78)&
             &-JVS(2539)*X(83)-JVS(2540)*X(97)-JVS(2541)*X(127)-JVS(2542)*X(135)-JVS(2543)*X(138)-JVS(2544)*X(141)-JVS(2545)&
             &*X(144)-JVS(2546)*X(151)-JVS(2547)*X(152)-JVS(2548)*X(153)-JVS(2549)*X(154)-JVS(2550)*X(155)-JVS(2551)*X(156)&
             &-JVS(2552)*X(157)-JVS(2553)*X(158)-JVS(2554)*X(160)-JVS(2555)*X(166)-JVS(2556)*X(167)-JVS(2557)*X(168)&
             &-JVS(2558)*X(169)-JVS(2559)*X(170)-JVS(2560)*X(171)-JVS(2561)*X(172)-JVS(2562)*X(174)-JVS(2563)*X(176)&
             &-JVS(2564)*X(178)-JVS(2565)*X(179)-JVS(2566)*X(180)-JVS(2567)*X(181)-JVS(2568)*X(183)-JVS(2569)*X(184)&
             &-JVS(2570)*X(185)-JVS(2571)*X(186)-JVS(2572)*X(187)-JVS(2573)*X(188)-JVS(2574)*X(189)-JVS(2575)*X(190)&
             &-JVS(2576)*X(191)-JVS(2577)*X(192)-JVS(2578)*X(193)-JVS(2579)*X(194)-JVS(2580)*X(195)-JVS(2581)*X(196)&
             &-JVS(2582)*X(197)-JVS(2583)*X(198)-JVS(2584)*X(199)-JVS(2585)*X(200)-JVS(2586)*X(201)-JVS(2587)*X(202)&
             &-JVS(2588)*X(203)-JVS(2589)*X(204)-JVS(2590)*X(205)-JVS(2591)*X(206)
  X(208) = X(208)-JVS(2599)*X(56)-JVS(2600)*X(57)-JVS(2601)*X(58)-JVS(2602)*X(62)-JVS(2603)*X(71)-JVS(2604)*X(73)&
             &-JVS(2605)*X(76)-JVS(2606)*X(80)-JVS(2607)*X(95)-JVS(2608)*X(99)-JVS(2609)*X(124)-JVS(2610)*X(125)-JVS(2611)&
             &*X(126)-JVS(2612)*X(129)-JVS(2613)*X(131)-JVS(2614)*X(132)-JVS(2615)*X(133)-JVS(2616)*X(135)-JVS(2617)*X(138)&
             &-JVS(2618)*X(141)-JVS(2619)*X(144)-JVS(2620)*X(146)-JVS(2621)*X(148)-JVS(2622)*X(149)-JVS(2623)*X(151)&
             &-JVS(2624)*X(153)-JVS(2625)*X(154)-JVS(2626)*X(155)-JVS(2627)*X(156)-JVS(2628)*X(157)-JVS(2629)*X(158)&
             &-JVS(2630)*X(159)-JVS(2631)*X(160)-JVS(2632)*X(161)-JVS(2633)*X(163)-JVS(2634)*X(165)-JVS(2635)*X(166)&
             &-JVS(2636)*X(167)-JVS(2637)*X(168)-JVS(2638)*X(169)-JVS(2639)*X(170)-JVS(2640)*X(172)-JVS(2641)*X(173)&
             &-JVS(2642)*X(174)-JVS(2643)*X(176)-JVS(2644)*X(178)-JVS(2645)*X(179)-JVS(2646)*X(180)-JVS(2647)*X(181)&
             &-JVS(2648)*X(183)-JVS(2649)*X(184)-JVS(2650)*X(185)-JVS(2651)*X(186)-JVS(2652)*X(187)-JVS(2653)*X(188)&
             &-JVS(2654)*X(189)-JVS(2655)*X(190)-JVS(2656)*X(192)-JVS(2657)*X(193)-JVS(2658)*X(194)-JVS(2659)*X(195)&
             &-JVS(2660)*X(196)-JVS(2661)*X(197)-JVS(2662)*X(198)-JVS(2663)*X(199)-JVS(2664)*X(200)-JVS(2665)*X(201)&
             &-JVS(2666)*X(202)-JVS(2667)*X(203)-JVS(2668)*X(204)-JVS(2669)*X(205)-JVS(2670)*X(206)-JVS(2671)*X(207)
  X(209) = X(209)-JVS(2678)*X(48)-JVS(2679)*X(49)-JVS(2680)*X(51)-JVS(2681)*X(65)-JVS(2682)*X(66)-JVS(2683)*X(71)&
             &-JVS(2684)*X(72)-JVS(2685)*X(73)-JVS(2686)*X(79)-JVS(2687)*X(80)-JVS(2688)*X(83)-JVS(2689)*X(86)-JVS(2690)&
             &*X(94)-JVS(2691)*X(95)-JVS(2692)*X(99)-JVS(2693)*X(108)-JVS(2694)*X(112)-JVS(2695)*X(116)-JVS(2696)*X(118)&
             &-JVS(2697)*X(121)-JVS(2698)*X(122)-JVS(2699)*X(123)-JVS(2700)*X(124)-JVS(2701)*X(125)-JVS(2702)*X(126)&
             &-JVS(2703)*X(127)-JVS(2704)*X(129)-JVS(2705)*X(130)-JVS(2706)*X(131)-JVS(2707)*X(132)-JVS(2708)*X(133)&
             &-JVS(2709)*X(135)-JVS(2710)*X(136)-JVS(2711)*X(137)-JVS(2712)*X(138)-JVS(2713)*X(141)-JVS(2714)*X(144)&
             &-JVS(2715)*X(145)-JVS(2716)*X(146)-JVS(2717)*X(148)-JVS(2718)*X(149)-JVS(2719)*X(150)-JVS(2720)*X(151)&
             &-JVS(2721)*X(152)-JVS(2722)*X(153)-JVS(2723)*X(154)-JVS(2724)*X(155)-JVS(2725)*X(156)-JVS(2726)*X(157)&
             &-JVS(2727)*X(158)-JVS(2728)*X(159)-JVS(2729)*X(160)-JVS(2730)*X(161)-JVS(2731)*X(162)-JVS(2732)*X(163)&
             &-JVS(2733)*X(164)-JVS(2734)*X(165)-JVS(2735)*X(166)-JVS(2736)*X(167)-JVS(2737)*X(168)-JVS(2738)*X(169)&
             &-JVS(2739)*X(170)-JVS(2740)*X(172)-JVS(2741)*X(173)-JVS(2742)*X(174)-JVS(2743)*X(175)-JVS(2744)*X(176)&
             &-JVS(2745)*X(177)-JVS(2746)*X(178)-JVS(2747)*X(179)-JVS(2748)*X(180)-JVS(2749)*X(181)-JVS(2750)*X(182)&
             &-JVS(2751)*X(183)-JVS(2752)*X(184)-JVS(2753)*X(185)-JVS(2754)*X(186)-JVS(2755)*X(187)-JVS(2756)*X(188)&
             &-JVS(2757)*X(189)-JVS(2758)*X(190)-JVS(2759)*X(191)-JVS(2760)*X(192)-JVS(2761)*X(193)-JVS(2762)*X(194)&
             &-JVS(2763)*X(195)-JVS(2764)*X(196)-JVS(2765)*X(197)-JVS(2766)*X(198)-JVS(2767)*X(199)-JVS(2768)*X(200)&
             &-JVS(2769)*X(201)-JVS(2770)*X(202)-JVS(2771)*X(203)-JVS(2772)*X(204)-JVS(2773)*X(205)-JVS(2774)*X(206)&
             &-JVS(2775)*X(207)-JVS(2776)*X(208)
  X(210) = X(210)-JVS(2782)*X(2)-JVS(2783)*X(64)-JVS(2784)*X(67)-JVS(2785)*X(68)-JVS(2786)*X(69)-JVS(2787)*X(78)&
             &-JVS(2788)*X(79)-JVS(2789)*X(80)-JVS(2790)*X(81)-JVS(2791)*X(87)-JVS(2792)*X(92)-JVS(2793)*X(93)-JVS(2794)&
             &*X(94)-JVS(2795)*X(96)-JVS(2796)*X(97)-JVS(2797)*X(104)-JVS(2798)*X(111)-JVS(2799)*X(113)-JVS(2800)*X(115)&
             &-JVS(2801)*X(117)-JVS(2802)*X(122)-JVS(2803)*X(123)-JVS(2804)*X(130)-JVS(2805)*X(139)-JVS(2806)*X(140)&
             &-JVS(2807)*X(142)-JVS(2808)*X(143)-JVS(2809)*X(146)-JVS(2810)*X(148)-JVS(2811)*X(150)-JVS(2812)*X(156)&
             &-JVS(2813)*X(159)-JVS(2814)*X(161)-JVS(2815)*X(162)-JVS(2816)*X(163)-JVS(2817)*X(165)-JVS(2818)*X(166)&
             &-JVS(2819)*X(171)-JVS(2820)*X(173)-JVS(2821)*X(174)-JVS(2822)*X(175)-JVS(2823)*X(176)-JVS(2824)*X(177)&
             &-JVS(2825)*X(178)-JVS(2826)*X(179)-JVS(2827)*X(180)-JVS(2828)*X(181)-JVS(2829)*X(183)-JVS(2830)*X(184)&
             &-JVS(2831)*X(185)-JVS(2832)*X(186)-JVS(2833)*X(187)-JVS(2834)*X(188)-JVS(2835)*X(189)-JVS(2836)*X(190)&
             &-JVS(2837)*X(191)-JVS(2838)*X(192)-JVS(2839)*X(193)-JVS(2840)*X(195)-JVS(2841)*X(196)-JVS(2842)*X(197)&
             &-JVS(2843)*X(198)-JVS(2844)*X(199)-JVS(2845)*X(200)-JVS(2846)*X(201)-JVS(2847)*X(202)-JVS(2848)*X(203)&
             &-JVS(2849)*X(204)-JVS(2850)*X(205)-JVS(2851)*X(206)-JVS(2852)*X(207)-JVS(2853)*X(208)-JVS(2854)*X(209)
  X(211) = X(211)-JVS(2859)*X(67)-JVS(2860)*X(68)-JVS(2861)*X(78)-JVS(2862)*X(88)-JVS(2863)*X(95)-JVS(2864)*X(98)&
             &-JVS(2865)*X(103)-JVS(2866)*X(105)-JVS(2867)*X(107)-JVS(2868)*X(116)-JVS(2869)*X(119)-JVS(2870)*X(120)&
             &-JVS(2871)*X(121)-JVS(2872)*X(125)-JVS(2873)*X(127)-JVS(2874)*X(128)-JVS(2875)*X(129)-JVS(2876)*X(131)&
             &-JVS(2877)*X(132)-JVS(2878)*X(135)-JVS(2879)*X(137)-JVS(2880)*X(146)-JVS(2881)*X(147)-JVS(2882)*X(148)&
             &-JVS(2883)*X(152)-JVS(2884)*X(153)-JVS(2885)*X(154)-JVS(2886)*X(156)-JVS(2887)*X(159)-JVS(2888)*X(166)&
             &-JVS(2889)*X(173)-JVS(2890)*X(177)-JVS(2891)*X(178)-JVS(2892)*X(179)-JVS(2893)*X(180)-JVS(2894)*X(181)&
             &-JVS(2895)*X(182)-JVS(2896)*X(183)-JVS(2897)*X(184)-JVS(2898)*X(187)-JVS(2899)*X(188)-JVS(2900)*X(189)&
             &-JVS(2901)*X(190)-JVS(2902)*X(191)-JVS(2903)*X(192)-JVS(2904)*X(193)-JVS(2905)*X(194)-JVS(2906)*X(196)&
             &-JVS(2907)*X(197)-JVS(2908)*X(198)-JVS(2909)*X(199)-JVS(2910)*X(200)-JVS(2911)*X(201)-JVS(2912)*X(202)&
             &-JVS(2913)*X(203)-JVS(2914)*X(204)-JVS(2915)*X(205)-JVS(2916)*X(206)-JVS(2917)*X(207)-JVS(2918)*X(208)&
             &-JVS(2919)*X(209)-JVS(2920)*X(210)
  X(212) = X(212)-JVS(2924)*X(66)-JVS(2925)*X(70)-JVS(2926)*X(72)-JVS(2927)*X(76)-JVS(2928)*X(83)-JVS(2929)*X(87)&
             &-JVS(2930)*X(94)-JVS(2931)*X(108)-JVS(2932)*X(117)-JVS(2933)*X(119)-JVS(2934)*X(120)-JVS(2935)*X(121)&
             &-JVS(2936)*X(122)-JVS(2937)*X(123)-JVS(2938)*X(125)-JVS(2939)*X(127)-JVS(2940)*X(128)-JVS(2941)*X(129)&
             &-JVS(2942)*X(130)-JVS(2943)*X(131)-JVS(2944)*X(132)-JVS(2945)*X(133)-JVS(2946)*X(135)-JVS(2947)*X(136)&
             &-JVS(2948)*X(141)-JVS(2949)*X(145)-JVS(2950)*X(147)-JVS(2951)*X(148)-JVS(2952)*X(150)-JVS(2953)*X(154)&
             &-JVS(2954)*X(156)-JVS(2955)*X(159)-JVS(2956)*X(161)-JVS(2957)*X(162)-JVS(2958)*X(163)-JVS(2959)*X(164)&
             &-JVS(2960)*X(165)-JVS(2961)*X(166)-JVS(2962)*X(167)-JVS(2963)*X(168)-JVS(2964)*X(169)-JVS(2965)*X(173)&
             &-JVS(2966)*X(174)-JVS(2967)*X(175)-JVS(2968)*X(177)-JVS(2969)*X(178)-JVS(2970)*X(179)-JVS(2971)*X(180)&
             &-JVS(2972)*X(181)-JVS(2973)*X(182)-JVS(2974)*X(183)-JVS(2975)*X(184)-JVS(2976)*X(186)-JVS(2977)*X(187)&
             &-JVS(2978)*X(188)-JVS(2979)*X(189)-JVS(2980)*X(190)-JVS(2981)*X(191)-JVS(2982)*X(192)-JVS(2983)*X(193)&
             &-JVS(2984)*X(194)-JVS(2985)*X(195)-JVS(2986)*X(196)-JVS(2987)*X(197)-JVS(2988)*X(198)-JVS(2989)*X(199)&
             &-JVS(2990)*X(200)-JVS(2991)*X(201)-JVS(2992)*X(202)-JVS(2993)*X(203)-JVS(2994)*X(204)-JVS(2995)*X(205)&
             &-JVS(2996)*X(206)-JVS(2997)*X(207)-JVS(2998)*X(208)-JVS(2999)*X(209)-JVS(3000)*X(210)-JVS(3001)*X(211)
  X(213) = X(213)-JVS(3004)*X(77)-JVS(3005)*X(117)-JVS(3006)*X(128)-JVS(3007)*X(172)-JVS(3008)*X(183)-JVS(3009)*X(185)&
             &-JVS(3010)*X(190)-JVS(3011)*X(192)-JVS(3012)*X(193)-JVS(3013)*X(194)-JVS(3014)*X(197)-JVS(3015)*X(198)&
             &-JVS(3016)*X(200)-JVS(3017)*X(201)-JVS(3018)*X(202)-JVS(3019)*X(203)-JVS(3020)*X(204)-JVS(3021)*X(205)&
             &-JVS(3022)*X(206)-JVS(3023)*X(207)-JVS(3024)*X(208)-JVS(3025)*X(209)-JVS(3026)*X(210)-JVS(3027)*X(211)&
             &-JVS(3028)*X(212)
  X(213) = X(213)/JVS(3029)
  X(212) = (X(212)-JVS(3003)*X(213))/(JVS(3002))
  X(211) = (X(211)-JVS(2922)*X(212)-JVS(2923)*X(213))/(JVS(2921))
  X(210) = (X(210)-JVS(2856)*X(211)-JVS(2857)*X(212)-JVS(2858)*X(213))/(JVS(2855))
  X(209) = (X(209)-JVS(2778)*X(210)-JVS(2779)*X(211)-JVS(2780)*X(212)-JVS(2781)*X(213))/(JVS(2777))
  X(208) = (X(208)-JVS(2673)*X(209)-JVS(2674)*X(210)-JVS(2675)*X(211)-JVS(2676)*X(212)-JVS(2677)*X(213))/(JVS(2672))
  X(207) = (X(207)-JVS(2593)*X(208)-JVS(2594)*X(209)-JVS(2595)*X(210)-JVS(2596)*X(211)-JVS(2597)*X(212)-JVS(2598)&
             &*X(213))/(JVS(2592))
  X(206) = (X(206)-JVS(2526)*X(207)-JVS(2527)*X(208)-JVS(2528)*X(209)-JVS(2529)*X(210)-JVS(2530)*X(211)-JVS(2531)*X(212)&
             &-JVS(2532)*X(213))/(JVS(2525))
  X(205) = (X(205)-JVS(2476)*X(206)-JVS(2477)*X(207)-JVS(2478)*X(208)-JVS(2479)*X(209)-JVS(2480)*X(210)-JVS(2481)*X(211)&
             &-JVS(2482)*X(212)-JVS(2483)*X(213))/(JVS(2475))
  X(204) = (X(204)-JVS(2329)*X(205)-JVS(2330)*X(206)-JVS(2331)*X(207)-JVS(2332)*X(208)-JVS(2333)*X(209)-JVS(2334)*X(210)&
             &-JVS(2335)*X(211)-JVS(2336)*X(212)-JVS(2337)*X(213))/(JVS(2328))
  X(203) = (X(203)-JVS(2216)*X(204)-JVS(2217)*X(205)-JVS(2218)*X(206)-JVS(2219)*X(207)-JVS(2220)*X(208)-JVS(2221)*X(209)&
             &-JVS(2222)*X(210)-JVS(2223)*X(211)-JVS(2224)*X(212)-JVS(2225)*X(213))/(JVS(2215))
  X(202) = (X(202)-JVS(2161)*X(203)-JVS(2162)*X(204)-JVS(2163)*X(205)-JVS(2164)*X(206)-JVS(2165)*X(207)-JVS(2166)*X(208)&
             &-JVS(2167)*X(209)-JVS(2168)*X(210)-JVS(2169)*X(211)-JVS(2170)*X(212)-JVS(2171)*X(213))/(JVS(2160))
  X(201) = (X(201)-JVS(2099)*X(202)-JVS(2100)*X(203)-JVS(2101)*X(204)-JVS(2102)*X(205)-JVS(2103)*X(206)-JVS(2104)*X(207)&
             &-JVS(2105)*X(208)-JVS(2106)*X(209)-JVS(2107)*X(210)-JVS(2108)*X(211)-JVS(2109)*X(212))/(JVS(2098))
  X(200) = (X(200)-JVS(2072)*X(201)-JVS(2073)*X(202)-JVS(2074)*X(203)-JVS(2075)*X(204)-JVS(2076)*X(205)-JVS(2077)*X(207)&
             &-JVS(2078)*X(208)-JVS(2079)*X(209)-JVS(2080)*X(210)-JVS(2081)*X(211)-JVS(2082)*X(212))/(JVS(2071))
  X(199) = (X(199)-JVS(2050)*X(200)-JVS(2051)*X(201)-JVS(2052)*X(202)-JVS(2053)*X(203)-JVS(2054)*X(204)-JVS(2055)*X(205)&
             &-JVS(2056)*X(206)-JVS(2057)*X(207)-JVS(2058)*X(208)-JVS(2059)*X(209)-JVS(2060)*X(210)-JVS(2061)*X(211)&
             &-JVS(2062)*X(212)-JVS(2063)*X(213))/(JVS(2049))
  X(198) = (X(198)-JVS(2016)*X(200)-JVS(2017)*X(201)-JVS(2018)*X(202)-JVS(2019)*X(203)-JVS(2020)*X(204)-JVS(2021)*X(205)&
             &-JVS(2022)*X(207)-JVS(2023)*X(208)-JVS(2024)*X(209)-JVS(2025)*X(210)-JVS(2026)*X(211)-JVS(2027)*X(212))&
             &/(JVS(2015))
  X(197) = (X(197)-JVS(1977)*X(201)-JVS(1978)*X(202)-JVS(1979)*X(203)-JVS(1980)*X(204)-JVS(1981)*X(205)-JVS(1982)*X(207)&
             &-JVS(1983)*X(208)-JVS(1984)*X(209)-JVS(1985)*X(210)-JVS(1986)*X(211)-JVS(1987)*X(212))/(JVS(1976))
  X(196) = (X(196)-JVS(1950)*X(197)-JVS(1951)*X(198)-JVS(1952)*X(199)-JVS(1953)*X(200)-JVS(1954)*X(201)-JVS(1955)*X(202)&
             &-JVS(1956)*X(203)-JVS(1957)*X(204)-JVS(1958)*X(205)-JVS(1959)*X(206)-JVS(1960)*X(207)-JVS(1961)*X(208)&
             &-JVS(1962)*X(209)-JVS(1963)*X(210)-JVS(1964)*X(211)-JVS(1965)*X(212)-JVS(1966)*X(213))/(JVS(1949))
  X(195) = (X(195)-JVS(1864)*X(196)-JVS(1865)*X(197)-JVS(1866)*X(198)-JVS(1867)*X(199)-JVS(1868)*X(200)-JVS(1869)*X(201)&
             &-JVS(1870)*X(202)-JVS(1871)*X(203)-JVS(1872)*X(204)-JVS(1873)*X(205)-JVS(1874)*X(206)-JVS(1875)*X(207)&
             &-JVS(1876)*X(208)-JVS(1877)*X(209)-JVS(1878)*X(210)-JVS(1879)*X(211)-JVS(1880)*X(212)-JVS(1881)*X(213))&
             &/(JVS(1863))
  X(194) = (X(194)-JVS(1804)*X(197)-JVS(1805)*X(198)-JVS(1806)*X(200)-JVS(1807)*X(201)-JVS(1808)*X(202)-JVS(1809)*X(203)&
             &-JVS(1810)*X(204)-JVS(1811)*X(205)-JVS(1812)*X(206)-JVS(1813)*X(207)-JVS(1814)*X(208)-JVS(1815)*X(209)&
             &-JVS(1816)*X(210)-JVS(1817)*X(211)-JVS(1818)*X(212))/(JVS(1803))
  X(193) = (X(193)-JVS(1753)*X(197)-JVS(1754)*X(198)-JVS(1755)*X(202)-JVS(1756)*X(203)-JVS(1757)*X(204)-JVS(1758)*X(205)&
             &-JVS(1759)*X(207)-JVS(1760)*X(208)-JVS(1761)*X(210)-JVS(1762)*X(212))/(JVS(1752))
  X(192) = (X(192)-JVS(1733)*X(202)-JVS(1734)*X(203)-JVS(1735)*X(204)-JVS(1736)*X(205)-JVS(1737)*X(207)-JVS(1738)*X(208)&
             &-JVS(1739)*X(210)-JVS(1740)*X(212))/(JVS(1732))
  X(191) = (X(191)-JVS(1711)*X(192)-JVS(1712)*X(193)-JVS(1713)*X(197)-JVS(1714)*X(198)-JVS(1715)*X(200)-JVS(1716)*X(201)&
             &-JVS(1717)*X(202)-JVS(1718)*X(203)-JVS(1719)*X(204)-JVS(1720)*X(205)-JVS(1721)*X(206)-JVS(1722)*X(207)&
             &-JVS(1723)*X(208)-JVS(1724)*X(209)-JVS(1725)*X(210)-JVS(1726)*X(211)-JVS(1727)*X(212))/(JVS(1710))
  X(190) = (X(190)-JVS(1665)*X(202)-JVS(1666)*X(203)-JVS(1667)*X(204)-JVS(1668)*X(205)-JVS(1669)*X(207)-JVS(1670)*X(208)&
             &-JVS(1671)*X(210)-JVS(1672)*X(212))/(JVS(1664))
  X(189) = (X(189)-JVS(1649)*X(200)-JVS(1650)*X(202)-JVS(1651)*X(203)-JVS(1652)*X(204)-JVS(1653)*X(205)-JVS(1654)*X(206)&
             &-JVS(1655)*X(207)-JVS(1656)*X(208)-JVS(1657)*X(210)-JVS(1658)*X(212))/(JVS(1648))
  X(188) = (X(188)-JVS(1633)*X(190)-JVS(1634)*X(192)-JVS(1635)*X(193)-JVS(1636)*X(202)-JVS(1637)*X(203)-JVS(1638)*X(204)&
             &-JVS(1639)*X(205)-JVS(1640)*X(206)-JVS(1641)*X(207)-JVS(1642)*X(208)-JVS(1643)*X(210)-JVS(1644)*X(212))&
             &/(JVS(1632))
  X(187) = (X(187)-JVS(1616)*X(197)-JVS(1617)*X(201)-JVS(1618)*X(202)-JVS(1619)*X(203)-JVS(1620)*X(204)-JVS(1621)*X(205)&
             &-JVS(1622)*X(207)-JVS(1623)*X(208)-JVS(1624)*X(209)-JVS(1625)*X(210)-JVS(1626)*X(211)-JVS(1627)*X(212))&
             &/(JVS(1615))
  X(186) = (X(186)-JVS(1597)*X(188)-JVS(1598)*X(189)-JVS(1599)*X(195)-JVS(1600)*X(196)-JVS(1601)*X(199)-JVS(1602)*X(203)&
             &-JVS(1603)*X(204)-JVS(1604)*X(205)-JVS(1605)*X(206)-JVS(1606)*X(207)-JVS(1607)*X(208)-JVS(1608)*X(209)&
             &-JVS(1609)*X(210)-JVS(1610)*X(212)-JVS(1611)*X(213))/(JVS(1596))
  X(185) = (X(185)-JVS(1577)*X(190)-JVS(1578)*X(192)-JVS(1579)*X(193)-JVS(1580)*X(202)-JVS(1581)*X(203)-JVS(1582)*X(204)&
             &-JVS(1583)*X(205)-JVS(1584)*X(207)-JVS(1585)*X(208)-JVS(1586)*X(210)-JVS(1587)*X(212))/(JVS(1576))
  X(184) = (X(184)-JVS(1556)*X(190)-JVS(1557)*X(192)-JVS(1558)*X(202)-JVS(1559)*X(203)-JVS(1560)*X(204)-JVS(1561)*X(205)&
             &-JVS(1562)*X(207)-JVS(1563)*X(208)-JVS(1564)*X(212))/(JVS(1555))
  X(183) = (X(183)-JVS(1543)*X(190)-JVS(1544)*X(202)-JVS(1545)*X(203)-JVS(1546)*X(205)-JVS(1547)*X(207)-JVS(1548)*X(208)&
             &-JVS(1549)*X(212))/(JVS(1542))
  X(182) = (X(182)-JVS(1519)*X(183)-JVS(1520)*X(184)-JVS(1521)*X(187)-JVS(1522)*X(188)-JVS(1523)*X(189)-JVS(1524)*X(190)&
             &-JVS(1525)*X(191)-JVS(1526)*X(192)-JVS(1527)*X(197)-JVS(1528)*X(198)-JVS(1529)*X(200)-JVS(1530)*X(201)&
             &-JVS(1531)*X(202)-JVS(1532)*X(203)-JVS(1533)*X(204)-JVS(1534)*X(205)-JVS(1535)*X(206)-JVS(1536)*X(207)&
             &-JVS(1537)*X(208)-JVS(1538)*X(209)-JVS(1539)*X(210)-JVS(1540)*X(211)-JVS(1541)*X(212))/(JVS(1518))
  X(181) = (X(181)-JVS(1483)*X(197)-JVS(1484)*X(202)-JVS(1485)*X(203)-JVS(1486)*X(204)-JVS(1487)*X(205)-JVS(1488)*X(207)&
             &-JVS(1489)*X(208)-JVS(1490)*X(209)-JVS(1491)*X(212))/(JVS(1482))
  X(180) = (X(180)-JVS(1470)*X(200)-JVS(1471)*X(202)-JVS(1472)*X(203)-JVS(1473)*X(204)-JVS(1474)*X(205)-JVS(1475)*X(207)&
             &-JVS(1476)*X(208)-JVS(1477)*X(210)-JVS(1478)*X(212))/(JVS(1469))
  X(179) = (X(179)-JVS(1460)*X(184)-JVS(1461)*X(192)-JVS(1462)*X(202)-JVS(1463)*X(204)-JVS(1464)*X(205)-JVS(1465)*X(207)&
             &-JVS(1466)*X(208))/(JVS(1459))
  X(178) = (X(178)-JVS(1450)*X(190)-JVS(1451)*X(192)-JVS(1452)*X(203)-JVS(1453)*X(205)-JVS(1454)*X(207)-JVS(1455)&
             &*X(208))/(JVS(1449))
  X(177) = (X(177)-JVS(1434)*X(178)-JVS(1435)*X(179)-JVS(1436)*X(180)-JVS(1437)*X(183)-JVS(1438)*X(184)-JVS(1439)*X(192)&
             &-JVS(1440)*X(201)-JVS(1441)*X(202)-JVS(1442)*X(203)-JVS(1443)*X(204)-JVS(1444)*X(205)-JVS(1445)*X(207)&
             &-JVS(1446)*X(208)-JVS(1447)*X(209)-JVS(1448)*X(211))/(JVS(1433))
  X(176) = (X(176)-JVS(1416)*X(198)-JVS(1417)*X(202)-JVS(1418)*X(203)-JVS(1419)*X(204)-JVS(1420)*X(205)-JVS(1421)*X(207)&
             &-JVS(1422)*X(208)-JVS(1423)*X(212))/(JVS(1415))
  X(175) = (X(175)-JVS(1397)*X(186)-JVS(1398)*X(188)-JVS(1399)*X(189)-JVS(1400)*X(195)-JVS(1401)*X(196)-JVS(1402)*X(199)&
             &-JVS(1403)*X(203)-JVS(1404)*X(204)-JVS(1405)*X(205)-JVS(1406)*X(206)-JVS(1407)*X(207)-JVS(1408)*X(208)&
             &-JVS(1409)*X(209)-JVS(1410)*X(210)-JVS(1411)*X(212))/(JVS(1396))
  X(174) = (X(174)-JVS(1382)*X(202)-JVS(1383)*X(203)-JVS(1384)*X(204)-JVS(1385)*X(205)-JVS(1386)*X(207)-JVS(1387)*X(208)&
             &-JVS(1388)*X(212))/(JVS(1381))
  X(173) = (X(173)-JVS(1368)*X(189)-JVS(1369)*X(197)-JVS(1370)*X(200)-JVS(1371)*X(201)-JVS(1372)*X(203)-JVS(1373)*X(205)&
             &-JVS(1374)*X(208)-JVS(1375)*X(209)-JVS(1376)*X(210)-JVS(1377)*X(211)-JVS(1378)*X(212))/(JVS(1367))
  X(172) = (X(172)-JVS(1355)*X(183)-JVS(1356)*X(194)-JVS(1357)*X(198)-JVS(1358)*X(200)-JVS(1359)*X(202)-JVS(1360)*X(204)&
             &-JVS(1361)*X(205)-JVS(1362)*X(207)-JVS(1363)*X(208)-JVS(1364)*X(209)-JVS(1365)*X(212))/(JVS(1354))
  X(171) = (X(171)-JVS(1324)*X(176)-JVS(1325)*X(178)-JVS(1326)*X(179)-JVS(1327)*X(180)-JVS(1328)*X(181)-JVS(1329)*X(185)&
             &-JVS(1330)*X(187)-JVS(1331)*X(188)-JVS(1332)*X(189)-JVS(1333)*X(190)-JVS(1334)*X(191)-JVS(1335)*X(192)&
             &-JVS(1336)*X(193)-JVS(1337)*X(197)-JVS(1338)*X(201)-JVS(1339)*X(202)-JVS(1340)*X(203)-JVS(1341)*X(204)&
             &-JVS(1342)*X(205)-JVS(1343)*X(206)-JVS(1344)*X(207)-JVS(1345)*X(208)-JVS(1346)*X(209)-JVS(1347)*X(210)&
             &-JVS(1348)*X(211)-JVS(1349)*X(212)-JVS(1350)*X(213))/(JVS(1323))
  X(170) = (X(170)-JVS(1302)*X(178)-JVS(1303)*X(192)-JVS(1304)*X(193)-JVS(1305)*X(202)-JVS(1306)*X(203)-JVS(1307)*X(204)&
             &-JVS(1308)*X(205)-JVS(1309)*X(207)-JVS(1310)*X(208))/(JVS(1301))
  X(169) = (X(169)-JVS(1291)*X(202)-JVS(1292)*X(203)-JVS(1293)*X(204)-JVS(1294)*X(205)-JVS(1295)*X(207)-JVS(1296)*X(208)&
             &-JVS(1297)*X(212))/(JVS(1290))
  X(168) = (X(168)-JVS(1282)*X(202)-JVS(1283)*X(203)-JVS(1284)*X(204)-JVS(1285)*X(205)-JVS(1286)*X(207)-JVS(1287)*X(208)&
             &-JVS(1288)*X(212))/(JVS(1281))
  X(167) = (X(167)-JVS(1269)*X(168)-JVS(1270)*X(202)-JVS(1271)*X(203)-JVS(1272)*X(204)-JVS(1273)*X(205)-JVS(1274)*X(207)&
             &-JVS(1275)*X(208)-JVS(1276)*X(212))/(JVS(1268))
  X(166) = (X(166)-JVS(1259)*X(178)-JVS(1260)*X(192)-JVS(1261)*X(203)-JVS(1262)*X(204)-JVS(1263)*X(205)-JVS(1264)&
             &*X(208))/(JVS(1258))
  X(165) = (X(165)-JVS(1247)*X(186)-JVS(1248)*X(195)-JVS(1249)*X(203)-JVS(1250)*X(204)-JVS(1251)*X(205)-JVS(1252)*X(206)&
             &-JVS(1253)*X(208)-JVS(1254)*X(209)-JVS(1255)*X(212))/(JVS(1246))
  X(164) = (X(164)-JVS(1209)*X(165)-JVS(1210)*X(166)-JVS(1211)*X(167)-JVS(1212)*X(168)-JVS(1213)*X(169)-JVS(1214)*X(174)&
             &-JVS(1215)*X(175)-JVS(1216)*X(177)-JVS(1217)*X(178)-JVS(1218)*X(179)-JVS(1219)*X(180)-JVS(1220)*X(181)&
             &-JVS(1221)*X(182)-JVS(1222)*X(183)-JVS(1223)*X(186)-JVS(1224)*X(187)-JVS(1225)*X(192)-JVS(1226)*X(193)&
             &-JVS(1227)*X(194)-JVS(1228)*X(195)-JVS(1229)*X(196)-JVS(1230)*X(197)-JVS(1231)*X(198)-JVS(1232)*X(199)&
             &-JVS(1233)*X(202)-JVS(1234)*X(203)-JVS(1235)*X(204)-JVS(1236)*X(205)-JVS(1237)*X(206)-JVS(1238)*X(207)&
             &-JVS(1239)*X(208)-JVS(1240)*X(209)-JVS(1241)*X(210)-JVS(1242)*X(212))/(JVS(1208))
  X(163) = (X(163)-JVS(1174)*X(165)-JVS(1175)*X(186)-JVS(1176)*X(203)-JVS(1177)*X(204)-JVS(1178)*X(205)-JVS(1179)*X(208)&
             &-JVS(1180)*X(209)-JVS(1181)*X(212))/(JVS(1173))
  X(162) = (X(162)-JVS(1156)*X(165)-JVS(1157)*X(175)-JVS(1158)*X(186)-JVS(1159)*X(195)-JVS(1160)*X(203)-JVS(1161)*X(204)&
             &-JVS(1162)*X(205)-JVS(1163)*X(206)-JVS(1164)*X(209)-JVS(1165)*X(210))/(JVS(1155))
  X(161) = (X(161)-JVS(1143)*X(163)-JVS(1144)*X(165)-JVS(1145)*X(186)-JVS(1146)*X(203)-JVS(1147)*X(204)-JVS(1148)*X(205)&
             &-JVS(1149)*X(208)-JVS(1150)*X(209)-JVS(1151)*X(212))/(JVS(1142))
  X(160) = (X(160)-JVS(1120)*X(181)-JVS(1121)*X(197)-JVS(1122)*X(202)-JVS(1123)*X(204)-JVS(1124)*X(205)-JVS(1125)*X(207)&
             &-JVS(1126)*X(208)-JVS(1127)*X(212))/(JVS(1119))
  X(159) = (X(159)-JVS(1110)*X(166)-JVS(1111)*X(187)-JVS(1112)*X(192)-JVS(1113)*X(203)-JVS(1114)*X(204)-JVS(1115)*X(205)&
             &-JVS(1116)*X(208))/(JVS(1109))
  X(158) = (X(158)-JVS(1098)*X(185)-JVS(1099)*X(193)-JVS(1100)*X(202)-JVS(1101)*X(204)-JVS(1102)*X(205)-JVS(1103)*X(206)&
             &-JVS(1104)*X(207)-JVS(1105)*X(208)-JVS(1106)*X(210))/(JVS(1097))
  X(157) = (X(157)-JVS(1086)*X(176)-JVS(1087)*X(188)-JVS(1088)*X(202)-JVS(1089)*X(204)-JVS(1090)*X(205)-JVS(1091)*X(206)&
             &-JVS(1092)*X(207)-JVS(1093)*X(208)-JVS(1094)*X(210))/(JVS(1085))
  X(156) = (X(156)-JVS(1080)*X(203)-JVS(1081)*X(205)-JVS(1082)*X(210)-JVS(1083)*X(212))/(JVS(1079))
  X(155) = (X(155)-JVS(1071)*X(189)-JVS(1072)*X(202)-JVS(1073)*X(204)-JVS(1074)*X(205)-JVS(1075)*X(206)-JVS(1076)*X(207)&
             &-JVS(1077)*X(208)-JVS(1078)*X(210))/(JVS(1070))
  X(154) = (X(154)-JVS(1063)*X(183)-JVS(1064)*X(204)-JVS(1065)*X(205)-JVS(1066)*X(208)-JVS(1067)*X(209)-JVS(1068)&
             &*X(212))/(JVS(1062))
  X(153) = (X(153)-JVS(1056)*X(197)-JVS(1057)*X(202)-JVS(1058)*X(204)-JVS(1059)*X(207)-JVS(1060)*X(208)-JVS(1061)&
             &*X(212))/(JVS(1055))
  X(152) = (X(152)-JVS(1041)*X(153)-JVS(1042)*X(154)-JVS(1043)*X(166)-JVS(1044)*X(178)-JVS(1045)*X(183)-JVS(1046)*X(189)&
             &-JVS(1047)*X(192)-JVS(1048)*X(202)-JVS(1049)*X(203)-JVS(1050)*X(204)-JVS(1051)*X(205)-JVS(1052)*X(207)&
             &-JVS(1053)*X(208)-JVS(1054)*X(212))/(JVS(1040))
  X(151) = (X(151)-JVS(1026)*X(185)-JVS(1027)*X(193)-JVS(1028)*X(202)-JVS(1029)*X(204)-JVS(1030)*X(205)-JVS(1031)*X(206)&
             &-JVS(1032)*X(207)-JVS(1033)*X(208)-JVS(1034)*X(210))/(JVS(1025))
  X(150) = (X(150)-JVS(1016)*X(166)-JVS(1017)*X(180)-JVS(1018)*X(192)-JVS(1019)*X(203)-JVS(1020)*X(204)-JVS(1021)*X(205)&
             &-JVS(1022)*X(208))/(JVS(1015))
  X(149) = (X(149)-JVS(1007)*X(166)-JVS(1008)*X(192)-JVS(1009)*X(203)-JVS(1010)*X(204)-JVS(1011)*X(205)-JVS(1012)&
             &*X(208))/(JVS(1006))
  X(148) = (X(148)-JVS(998)*X(156)-JVS(999)*X(201)-JVS(1000)*X(203)-JVS(1001)*X(208)-JVS(1002)*X(209)-JVS(1003)*X(211))&
             &/(JVS(997))
  X(147) = (X(147)-JVS(985)*X(177)-JVS(986)*X(178)-JVS(987)*X(179)-JVS(988)*X(183)-JVS(989)*X(192)-JVS(990)*X(202)&
             &-JVS(991)*X(203)-JVS(992)*X(204)-JVS(993)*X(205)-JVS(994)*X(207)-JVS(995)*X(208)-JVS(996)*X(212))/(JVS(984))
  X(146) = (X(146)-JVS(967)*X(178)-JVS(968)*X(192)-JVS(969)*X(203)-JVS(970)*X(204)-JVS(971)*X(205)-JVS(972)*X(208))&
             &/(JVS(966))
  X(145) = (X(145)-JVS(948)*X(167)-JVS(949)*X(168)-JVS(950)*X(169)-JVS(951)*X(174)-JVS(952)*X(202)-JVS(953)*X(203)&
             &-JVS(954)*X(204)-JVS(955)*X(205)-JVS(956)*X(207)-JVS(957)*X(208)-JVS(958)*X(212))/(JVS(947))
  X(144) = (X(144)-JVS(940)*X(189)-JVS(941)*X(202)-JVS(942)*X(204)-JVS(943)*X(205)-JVS(944)*X(207)-JVS(945)*X(208)&
             &-JVS(946)*X(212))/(JVS(939))
  X(143) = (X(143)-JVS(926)*X(162)-JVS(927)*X(163)-JVS(928)*X(165)-JVS(929)*X(175)-JVS(930)*X(186)-JVS(931)*X(195)&
             &-JVS(932)*X(204)-JVS(933)*X(205)-JVS(934)*X(207)-JVS(935)*X(209)-JVS(936)*X(210)-JVS(937)*X(212))/(JVS(925))
  X(142) = (X(142)-JVS(911)*X(162)-JVS(912)*X(165)-JVS(913)*X(175)-JVS(914)*X(195)-JVS(915)*X(203)-JVS(916)*X(204)&
             &-JVS(917)*X(205)-JVS(918)*X(206)-JVS(919)*X(209))/(JVS(910))
  X(141) = (X(141)-JVS(901)*X(183)-JVS(902)*X(204)-JVS(903)*X(207)-JVS(904)*X(208)-JVS(905)*X(212))/(JVS(900))
  X(140) = (X(140)-JVS(884)*X(146)-JVS(885)*X(150)-JVS(886)*X(159)-JVS(887)*X(166)-JVS(888)*X(173)-JVS(889)*X(174)&
             &-JVS(890)*X(177)-JVS(891)*X(191)-JVS(892)*X(192)-JVS(893)*X(203)-JVS(894)*X(204)-JVS(895)*X(205)-JVS(896)&
             &*X(208)-JVS(897)*X(209)-JVS(898)*X(210)-JVS(899)*X(212))/(JVS(883))
  X(139) = (X(139)-JVS(864)*X(148)-JVS(865)*X(156)-JVS(866)*X(173)-JVS(867)*X(184)-JVS(868)*X(189)-JVS(869)*X(197)&
             &-JVS(870)*X(200)-JVS(871)*X(201)-JVS(872)*X(203)-JVS(873)*X(204)-JVS(874)*X(205)-JVS(875)*X(208)-JVS(876)&
             &*X(209)-JVS(877)*X(210)-JVS(878)*X(211)-JVS(879)*X(212))/(JVS(863))
  X(138) = (X(138)-JVS(850)*X(183)-JVS(851)*X(204)-JVS(852)*X(205)-JVS(853)*X(207)-JVS(854)*X(208))/(JVS(849))
  X(137) = (X(137)-JVS(845)*X(192)-JVS(846)*X(203)-JVS(847)*X(205)-JVS(848)*X(208))/(JVS(844))
  X(136) = (X(136)-JVS(835)*X(167)-JVS(836)*X(168)-JVS(837)*X(174)-JVS(838)*X(202)-JVS(839)*X(204)-JVS(840)*X(205)&
             &-JVS(841)*X(207)-JVS(842)*X(208)-JVS(843)*X(212))/(JVS(834))
  X(135) = (X(135)-JVS(828)*X(200)-JVS(829)*X(201)-JVS(830)*X(203)-JVS(831)*X(208)-JVS(832)*X(209)-JVS(833)*X(211))&
             &/(JVS(827))
  X(134) = (X(134)-JVS(810)*X(144)-JVS(811)*X(151)-JVS(812)*X(155)-JVS(813)*X(158)-JVS(814)*X(160)-JVS(815)*X(168)&
             &-JVS(816)*X(169)-JVS(817)*X(170)-JVS(818)*X(174)-JVS(819)*X(176)-JVS(820)*X(179)-JVS(821)*X(180)-JVS(822)&
             &*X(185)-JVS(823)*X(187)-JVS(824)*X(192)-JVS(825)*X(205)-JVS(826)*X(207))/(JVS(809))
  X(133) = (X(133)-JVS(804)*X(159)-JVS(805)*X(204)-JVS(806)*X(205)-JVS(807)*X(208)-JVS(808)*X(209))/(JVS(803))
  X(132) = (X(132)-JVS(795)*X(184)-JVS(796)*X(197)-JVS(797)*X(201)-JVS(798)*X(203)-JVS(799)*X(208)-JVS(800)*X(209)&
             &-JVS(801)*X(211))/(JVS(794))
  X(131) = (X(131)-JVS(788)*X(184)-JVS(789)*X(201)-JVS(790)*X(203)-JVS(791)*X(208)-JVS(792)*X(209)-JVS(793)*X(211))&
             &/(JVS(787))
  X(130) = (X(130)-JVS(781)*X(161)-JVS(782)*X(163)-JVS(783)*X(205)-JVS(784)*X(208)-JVS(785)*X(209)-JVS(786)*X(212))&
             &/(JVS(780))
  X(129) = (X(129)-JVS(771)*X(189)-JVS(772)*X(201)-JVS(773)*X(203)-JVS(774)*X(208)-JVS(775)*X(209)-JVS(776)*X(211))&
             &/(JVS(770))
  X(128) = (X(128)-JVS(767)*X(203)-JVS(768)*X(205)-JVS(769)*X(212))/(JVS(766))
  X(127) = (X(127)-JVS(761)*X(154)-JVS(762)*X(197)-JVS(763)*X(205)-JVS(764)*X(209)-JVS(765)*X(212))/(JVS(760))
  X(126) = (X(126)-JVS(755)*X(192)-JVS(756)*X(202)-JVS(757)*X(204)-JVS(758)*X(208))/(JVS(754))
  X(125) = (X(125)-JVS(748)*X(156)-JVS(749)*X(201)-JVS(750)*X(203)-JVS(751)*X(208)-JVS(752)*X(209)-JVS(753)*X(211))&
             &/(JVS(747))
  X(124) = (X(124)-JVS(741)*X(179)-JVS(742)*X(202)-JVS(743)*X(203)-JVS(744)*X(204)-JVS(745)*X(205)-JVS(746)*X(208))&
             &/(JVS(740))
  X(123) = (X(123)-JVS(734)*X(130)-JVS(735)*X(161)-JVS(736)*X(163)-JVS(737)*X(209)-JVS(738)*X(212))/(JVS(733))
  X(122) = (X(122)-JVS(729)*X(165)-JVS(730)*X(195)-JVS(731)*X(206)-JVS(732)*X(209))/(JVS(728))
  X(121) = (X(121)-JVS(724)*X(181)-JVS(725)*X(203)-JVS(726)*X(205)-JVS(727)*X(209))/(JVS(723))
  X(120) = (X(120)-JVS(720)*X(203)-JVS(721)*X(205)-JVS(722)*X(212))/(JVS(719))
  X(119) = (X(119)-JVS(716)*X(203)-JVS(717)*X(205)-JVS(718)*X(212))/(JVS(715))
  X(118) = (X(118)-JVS(710)*X(138)-JVS(711)*X(141)-JVS(712)*X(190)-JVS(713)*X(204)-JVS(714)*X(205))/(JVS(709))
  X(117) = (X(117)-JVS(705)*X(205)-JVS(706)*X(206)-JVS(707)*X(210)-JVS(708)*X(212))/(JVS(704))
  X(116) = (X(116)-JVS(698)*X(166)-JVS(699)*X(178)-JVS(700)*X(203)-JVS(701)*X(204)-JVS(702)*X(205)-JVS(703)*X(208))&
             &/(JVS(697))
  X(115) = (X(115)-JVS(691)*X(178)-JVS(692)*X(203)-JVS(693)*X(205)-JVS(694)*X(207)-JVS(695)*X(210)-JVS(696)*X(213))&
             &/(JVS(690))
  X(114) = (X(114)-JVS(684)*X(153)-JVS(685)*X(181)-JVS(686)*X(197)-JVS(687)*X(204)-JVS(688)*X(205)-JVS(689)*X(212))&
             &/(JVS(683))
  X(113) = (X(113)-JVS(679)*X(142)-JVS(680)*X(162)-JVS(681)*X(175)-JVS(682)*X(203))/(JVS(678))
  X(112) = (X(112)-JVS(674)*X(149)-JVS(675)*X(166)-JVS(676)*X(204)-JVS(677)*X(205))/(JVS(673))
  X(111) = (X(111)-JVS(669)*X(142)-JVS(670)*X(162)-JVS(671)*X(175)-JVS(672)*X(203))/(JVS(668))
  X(110) = (X(110)-JVS(665)*X(192)-JVS(666)*X(204)-JVS(667)*X(205))/(JVS(664))
  X(109) = (X(109)-JVS(661)*X(192)-JVS(662)*X(204)-JVS(663)*X(205))/(JVS(660))
  X(108) = (X(108)-JVS(655)*X(136)-JVS(656)*X(145)-JVS(657)*X(203)-JVS(658)*X(205)-JVS(659)*X(212))/(JVS(654))
  X(107) = (X(107)-JVS(649)*X(179)-JVS(650)*X(202)-JVS(651)*X(204)-JVS(652)*X(205)-JVS(653)*X(208))/(JVS(648))
  X(106) = (X(106)-JVS(642)*X(179)-JVS(643)*X(202)-JVS(644)*X(203)-JVS(645)*X(205)-JVS(646)*X(208))/(JVS(641))
  X(105) = (X(105)-JVS(638)*X(179)-JVS(639)*X(204)-JVS(640)*X(205))/(JVS(637))
  X(104) = (X(104)-JVS(629)*X(143)-JVS(630)*X(162)-JVS(631)*X(165)-JVS(632)*X(186)-JVS(633)*X(195)-JVS(634)*X(205)&
             &-JVS(635)*X(207)-JVS(636)*X(210))/(JVS(628))
  X(103) = (X(103)-JVS(623)*X(146)-JVS(624)*X(204)-JVS(625)*X(205)-JVS(626)*X(208))/(JVS(622))
  X(102) = (X(102)-JVS(614)*X(111)-JVS(615)*X(113)-JVS(616)*X(122)-JVS(617)*X(142)-JVS(618)*X(165)-JVS(619)*X(175)&
             &-JVS(620)*X(205)-JVS(621)*X(206))/(JVS(613))
  X(101) = (X(101)-JVS(610)*X(180)-JVS(611)*X(204)-JVS(612)*X(205))/(JVS(609))
  X(100) = (X(100)-JVS(606)*X(192)-JVS(607)*X(204)-JVS(608)*X(205))/(JVS(605))
  X(99) = (X(99)-JVS(601)*X(192)-JVS(602)*X(204)-JVS(603)*X(205)-JVS(604)*X(208))/(JVS(600))
  X(98) = (X(98)-JVS(595)*X(148)-JVS(596)*X(187)-JVS(597)*X(204)-JVS(598)*X(205))/(JVS(594))
  X(97) = (X(97)-JVS(590)*X(204)-JVS(591)*X(205)-JVS(592)*X(207)-JVS(593)*X(210))/(JVS(589))
  X(96) = (X(96)-JVS(586)*X(205)-JVS(587)*X(206)-JVS(588)*X(210))/(JVS(585))
  X(95) = (X(95)-JVS(582)*X(192)-JVS(583)*X(204)-JVS(584)*X(208))/(JVS(581))
  X(94) = (X(94)-JVS(578)*X(195)-JVS(579)*X(209)-JVS(580)*X(212))/(JVS(577))
  X(93) = (X(93)-JVS(573)*X(130)-JVS(574)*X(163)-JVS(575)*X(204)-JVS(576)*X(205))/(JVS(572))
  X(92) = (X(92)-JVS(562)*X(111)-JVS(563)*X(113)-JVS(564)*X(122)-JVS(565)*X(142)-JVS(566)*X(143)-JVS(567)*X(162)&
            &-JVS(568)*X(165)-JVS(569)*X(175)-JVS(570)*X(186)-JVS(571)*X(195))/(JVS(561))
  X(91) = (X(91)-JVS(557)*X(157)-JVS(558)*X(176)-JVS(559)*X(204)-JVS(560)*X(205))/(JVS(556))
  X(90) = (X(90)-JVS(551)*X(124)-JVS(552)*X(126)-JVS(553)*X(185)-JVS(554)*X(204)-JVS(555)*X(205))/(JVS(550))
  X(89) = (X(89)-JVS(546)*X(169)-JVS(547)*X(174)-JVS(548)*X(204)-JVS(549)*X(205))/(JVS(545))
  X(88) = (X(88)-JVS(543)*X(192)-JVS(544)*X(205))/(JVS(542))
  X(87) = (X(87)-JVS(539)*X(205)-JVS(540)*X(210)-JVS(541)*X(212))/(JVS(538))
  X(86) = (X(86)-JVS(535)*X(144)-JVS(536)*X(204)-JVS(537)*X(205))/(JVS(534))
  X(85) = (X(85)-JVS(531)*X(155)-JVS(532)*X(204)-JVS(533)*X(205))/(JVS(530))
  X(84) = (X(84)-JVS(526)*X(154)-JVS(527)*X(172)-JVS(528)*X(204)-JVS(529)*X(205))/(JVS(525))
  X(83) = (X(83)-JVS(521)*X(127)-JVS(522)*X(202)-JVS(523)*X(205)-JVS(524)*X(209))/(JVS(520))
  X(82) = (X(82)-JVS(516)*X(163)-JVS(517)*X(165)-JVS(518)*X(186)-JVS(519)*X(205))/(JVS(515))
  X(81) = (X(81)-JVS(510)*X(165)-JVS(511)*X(186)-JVS(512)*X(205)-JVS(513)*X(207)-JVS(514)*X(210))/(JVS(509))
  X(80) = (X(80)-JVS(506)*X(161)-JVS(507)*X(209))/(JVS(505))
  X(79) = (X(79)-JVS(502)*X(94)-JVS(503)*X(195)-JVS(504)*X(205))/(JVS(501))
  X(78) = (X(78)-JVS(499)*X(205)-JVS(500)*X(210))/(JVS(498))
  X(77) = (X(77)-JVS(495)*X(204)-JVS(496)*X(205)-JVS(497)*X(213))/(JVS(494))
  X(76) = (X(76)-JVS(492)*X(205)-JVS(493)*X(212))/(JVS(491))
  X(75) = (X(75)-JVS(488)*X(158)-JVS(489)*X(204)-JVS(490)*X(205))/(JVS(487))
  X(74) = (X(74)-JVS(484)*X(151)-JVS(485)*X(204)-JVS(486)*X(205))/(JVS(483))
  X(73) = (X(73)-JVS(480)*X(163)-JVS(481)*X(165)-JVS(482)*X(208))/(JVS(479))
  X(72) = (X(72)-JVS(473)*X(204)-JVS(474)*X(205)-JVS(475)*X(209))/(JVS(472))
  X(71) = (X(71)-JVS(468)*X(80)-JVS(469)*X(205)-JVS(470)*X(208)-JVS(471)*X(209))/(JVS(467))
  X(70) = (X(70)-JVS(465)*X(205)-JVS(466)*X(212))/(JVS(464))
  X(69) = (X(69)-JVS(462)*X(186)-JVS(463)*X(205))/(JVS(461))
  X(68) = (X(68)-JVS(459)*X(205)-JVS(460)*X(210))/(JVS(458))
  X(67) = (X(67)-JVS(456)*X(205)-JVS(457)*X(210))/(JVS(455))
  X(66) = (X(66)-JVS(453)*X(207)-JVS(454)*X(209))/(JVS(452))
  X(65) = (X(65)-JVS(447)*X(127)-JVS(448)*X(197)-JVS(449)*X(205)-JVS(450)*X(209)-JVS(451)*X(212))/(JVS(446))
  X(64) = (X(64)-JVS(441)*X(80)-JVS(442)*X(93)-JVS(443)*X(123)-JVS(444)*X(163)-JVS(445)*X(186))/(JVS(440))
  X(63) = (X(63)-JVS(437)*X(202)-JVS(438)*X(204)-JVS(439)*X(205))/(JVS(436))
  X(62) = (X(62)-JVS(432)*X(76)-JVS(433)*X(204)-JVS(434)*X(205)-JVS(435)*X(208))/(JVS(431))
  X(61) = (X(61)-JVS(423)*X(137)-JVS(424)*X(149)-JVS(425)*X(150)-JVS(426)*X(159)-JVS(427)*X(166)-JVS(428)*X(178)&
            &-JVS(429)*X(193)-JVS(430)*X(208))/(JVS(422))
  X(60) = (X(60)-JVS(417)*X(100)-JVS(418)*X(109)-JVS(419)*X(137)-JVS(420)*X(205))/(JVS(416))
  X(59) = (X(59)-JVS(412)*X(100)-JVS(413)*X(109)-JVS(414)*X(137)-JVS(415)*X(205))/(JVS(411))
  X(58) = (X(58)-JVS(408)*X(204)-JVS(409)*X(205)-JVS(410)*X(208))/(JVS(407))
  X(57) = (X(57)-JVS(403)*X(204)-JVS(404)*X(205)-JVS(405)*X(208))/(JVS(402))
  X(56) = (X(56)-JVS(399)*X(161)-JVS(400)*X(208))/(JVS(398))
  X(55) = (X(55)-JVS(395)*X(110)-JVS(396)*X(178)-JVS(397)*X(205))/(JVS(394))
  X(54) = (X(54)-JVS(391)*X(80)-JVS(392)*X(93)-JVS(393)*X(123))/(JVS(390))
  X(53) = (X(53)-JVS(387)*X(161)-JVS(388)*X(204)-JVS(389)*X(205))/(JVS(386))
  X(52) = (X(52)-JVS(385)*X(205))/(JVS(384))
  X(51) = (X(51)-JVS(382)*X(206)-JVS(383)*X(209))/(JVS(381))
  X(50) = (X(50)-JVS(380)*X(205))/(JVS(379))
  X(49) = (X(49)-JVS(377)*X(172)-JVS(378)*X(209))/(JVS(376))
  X(48) = (X(48)-JVS(374)*X(133)-JVS(375)*X(209))/(JVS(373))
  X(47) = (X(47)-JVS(371)*X(73)-JVS(372)*X(163))/(JVS(370))
  X(46) = (X(46)-JVS(369)*X(205))/(JVS(368))
  X(45) = (X(45)-JVS(367)*X(205))/(JVS(366))
  X(44) = (X(44)-JVS(363)*X(108)-JVS(364)*X(136)-JVS(365)*X(145))/(JVS(362))
  X(43) = (X(43)-JVS(361)*X(163))/(JVS(360))
  X(42) = (X(42)-JVS(359)*X(95))/(JVS(358))
  X(41) = (X(41)-JVS(355)*X(149)-JVS(356)*X(166)-JVS(357)*X(208))/(JVS(354))
  X(40) = (X(40)-JVS(353)*X(205))/(JVS(352))
  X(39) = (X(39)-JVS(351)*X(205))/(JVS(350))
  X(38) = (X(38)-JVS(349)*X(73))/(JVS(348))
  X(37) = (X(37)-JVS(335)*X(119)-JVS(336)*X(120)-JVS(337)*X(125)-JVS(338)*X(128)-JVS(339)*X(129)-JVS(340)*X(131)&
            &-JVS(341)*X(132)-JVS(342)*X(135)-JVS(343)*X(148)-JVS(344)*X(173)-JVS(345)*X(203)-JVS(346)*X(204)-JVS(347)&
            &*X(205))/(JVS(334))
  X(36) = (X(36)-JVS(332)*X(205)-JVS(333)*X(210))/(JVS(331))
  X(35) = (X(35)-JVS(322)*X(125)-JVS(323)*X(129)-JVS(324)*X(131)-JVS(325)*X(132)-JVS(326)*X(135)-JVS(327)*X(148)&
            &-JVS(328)*X(173)-JVS(329)*X(201)-JVS(330)*X(205))/(JVS(321))
  X(34) = (X(34)-JVS(312)*X(125)-JVS(313)*X(129)-JVS(314)*X(131)-JVS(315)*X(132)-JVS(316)*X(135)-JVS(317)*X(148)&
            &-JVS(318)*X(173)-JVS(319)*X(205)-JVS(320)*X(211))/(JVS(311))
  X(33) = (X(33)-JVS(264)*X(67)-JVS(265)*X(68)-JVS(266)*X(78)-JVS(267)*X(88)-JVS(268)*X(95)-JVS(269)*X(98)-JVS(270)&
            &*X(103)-JVS(271)*X(105)-JVS(272)*X(107)-JVS(273)*X(116)-JVS(274)*X(119)-JVS(275)*X(120)-JVS(276)*X(121)&
            &-JVS(277)*X(127)-JVS(278)*X(128)-JVS(279)*X(137)-JVS(280)*X(146)-JVS(281)*X(147)-JVS(282)*X(152)-JVS(283)&
            &*X(153)-JVS(284)*X(154)-JVS(285)*X(156)-JVS(286)*X(159)-JVS(287)*X(177)-JVS(288)*X(179)-JVS(289)*X(181)&
            &-JVS(290)*X(182)-JVS(291)*X(184)-JVS(292)*X(187)-JVS(293)*X(188)-JVS(294)*X(189)-JVS(295)*X(191)-JVS(296)&
            &*X(192)-JVS(297)*X(194)-JVS(298)*X(196)-JVS(299)*X(197)-JVS(300)*X(199)-JVS(301)*X(200)-JVS(302)*X(202)&
            &-JVS(303)*X(203)-JVS(304)*X(204)-JVS(305)*X(205)-JVS(306)*X(206)-JVS(307)*X(207)-JVS(308)*X(208)-JVS(309)&
            &*X(210)-JVS(310)*X(212))/(JVS(263))
  X(32) = (X(32)-JVS(199)*X(38)-JVS(200)*X(43)-JVS(201)*X(47)-JVS(202)*X(69)-JVS(203)*X(70)-JVS(204)*X(73)-JVS(205)&
            &*X(76)-JVS(206)*X(80)-JVS(207)*X(82)-JVS(208)*X(87)-JVS(209)*X(93)-JVS(210)*X(94)-JVS(211)*X(106)-JVS(212)&
            &*X(111)-JVS(213)*X(112)-JVS(214)*X(113)-JVS(215)*X(117)-JVS(216)*X(119)-JVS(217)*X(120)-JVS(218)*X(122)&
            &-JVS(219)*X(123)-JVS(220)*X(128)-JVS(221)*X(133)-JVS(222)*X(136)-JVS(223)*X(137)-JVS(224)*X(138)-JVS(225)&
            &*X(141)-JVS(226)*X(142)-JVS(227)*X(143)-JVS(228)*X(145)-JVS(229)*X(147)-JVS(230)*X(150)-JVS(231)*X(154)&
            &-JVS(232)*X(156)-JVS(233)*X(159)-JVS(234)*X(162)-JVS(235)*X(163)-JVS(236)*X(165)-JVS(237)*X(167)-JVS(238)&
            &*X(169)-JVS(239)*X(174)-JVS(240)*X(175)-JVS(241)*X(178)-JVS(242)*X(182)-JVS(243)*X(183)-JVS(244)*X(184)&
            &-JVS(245)*X(186)-JVS(246)*X(189)-JVS(247)*X(190)-JVS(248)*X(193)-JVS(249)*X(194)-JVS(250)*X(195)-JVS(251)&
            &*X(196)-JVS(252)*X(197)-JVS(253)*X(198)-JVS(254)*X(199)-JVS(255)*X(200)-JVS(256)*X(203)-JVS(257)*X(204)&
            &-JVS(258)*X(205)-JVS(259)*X(207)-JVS(260)*X(208)-JVS(261)*X(209)-JVS(262)*X(212))/(JVS(198))
  X(31) = (X(31)-JVS(133)*X(44)-JVS(134)*X(48)-JVS(135)*X(61)-JVS(136)*X(66)-JVS(137)*X(71)-JVS(138)*X(72)-JVS(139)&
            &*X(79)-JVS(140)*X(81)-JVS(141)*X(83)-JVS(142)*X(95)-JVS(143)*X(99)-JVS(144)*X(102)-JVS(145)*X(104)-JVS(146)&
            &*X(108)-JVS(147)*X(124)-JVS(148)*X(125)-JVS(149)*X(126)-JVS(150)*X(127)-JVS(151)*X(129)-JVS(152)*X(130)&
            &-JVS(153)*X(131)-JVS(154)*X(132)-JVS(155)*X(133)-JVS(156)*X(135)-JVS(157)*X(136)-JVS(158)*X(141)-JVS(159)&
            &*X(144)-JVS(160)*X(145)-JVS(161)*X(146)-JVS(162)*X(148)-JVS(163)*X(149)-JVS(164)*X(150)-JVS(165)*X(151)&
            &-JVS(166)*X(153)-JVS(167)*X(154)-JVS(168)*X(155)-JVS(169)*X(157)-JVS(170)*X(158)-JVS(171)*X(160)-JVS(172)&
            &*X(162)-JVS(173)*X(164)-JVS(174)*X(166)-JVS(175)*X(167)-JVS(176)*X(168)-JVS(177)*X(169)-JVS(178)*X(170)&
            &-JVS(179)*X(172)-JVS(180)*X(173)-JVS(181)*X(174)-JVS(182)*X(176)-JVS(183)*X(179)-JVS(184)*X(180)-JVS(185)&
            &*X(181)-JVS(186)*X(185)-JVS(187)*X(187)-JVS(188)*X(190)-JVS(189)*X(192)-JVS(190)*X(202)-JVS(191)*X(204)&
            &-JVS(192)*X(205)-JVS(193)*X(207)-JVS(194)*X(208)-JVS(195)*X(209)-JVS(196)*X(210)-JVS(197)*X(213))/(JVS(132))
  X(30) = (X(30)-JVS(131)*X(182))/(JVS(130))
  X(29) = (X(29)-JVS(128)*X(127)-JVS(129)*X(205))/(JVS(127))
  X(28) = (X(28)-JVS(126)*X(29))/(JVS(125))
  X(27) = (X(27)-JVS(122)*X(55)-JVS(123)*X(59)-JVS(124)*X(60))/(JVS(121))
  X(26) = (X(26)-JVS(120)*X(147))/(JVS(119))
  X(25) = (X(25)-JVS(118)*X(142))/(JVS(117))
  X(24) = (X(24)-JVS(116)*X(142))/(JVS(115))
  X(23) = (X(23)-JVS(106)*X(125)-JVS(107)*X(129)-JVS(108)*X(131)-JVS(109)*X(132)-JVS(110)*X(135)-JVS(111)*X(148)&
            &-JVS(112)*X(173)-JVS(113)*X(201)-JVS(114)*X(205))/(JVS(105))
  X(22) = (X(22)-JVS(103)*X(150)-JVS(104)*X(205))/(JVS(102))
  X(21) = (X(21)-JVS(100)*X(70)-JVS(101)*X(205))/(JVS(99))
  X(20) = (X(20)-JVS(97)*X(62)-JVS(98)*X(208))/(JVS(96))
  X(19) = (X(19)-JVS(94)*X(62)-JVS(95)*X(204))/(JVS(93))
  X(18) = (X(18)-JVS(89)*X(100)-JVS(90)*X(109)-JVS(91)*X(110)-JVS(92)*X(205))/(JVS(88))
  X(17) = (X(17)-JVS(87)*X(18))/(JVS(86))
  X(16) = (X(16)-JVS(84)*X(57)-JVS(85)*X(208))/(JVS(83))
  X(15) = (X(15)-JVS(81)*X(57)-JVS(82)*X(204))/(JVS(80))
  X(14) = (X(14)-JVS(78)*X(156)-JVS(79)*X(212))/(JVS(77))
  X(13) = (X(13)-JVS(75)*X(156)-JVS(76)*X(205))/(JVS(74))
  X(12) = (X(12)-JVS(72)*X(58)-JVS(73)*X(208))/(JVS(71))
  X(11) = (X(11)-JVS(69)*X(58)-JVS(70)*X(204))/(JVS(68))
  X(10) = (X(10)-JVS(60)*X(138)-JVS(61)*X(141)-JVS(62)*X(154)-JVS(63)*X(204)-JVS(64)*X(207)-JVS(65)*X(208)-JVS(66)&
            &*X(209)-JVS(67)*X(212))/(JVS(59))
  X(9) = (X(9)-JVS(58)*X(10))/(JVS(57))
  X(8) = (X(8)-JVS(50)*X(38)-JVS(51)*X(43)-JVS(52)*X(47)-JVS(53)*X(53)-JVS(54)*X(80)-JVS(55)*X(93)-JVS(56)*X(123))&
           &/(JVS(49))
  X(7) = (X(7)-JVS(42)*X(38)-JVS(43)*X(43)-JVS(44)*X(47)-JVS(45)*X(53)-JVS(46)*X(80)-JVS(47)*X(93)-JVS(48)*X(123))&
           &/(JVS(41))
  X(6) = (X(6)-JVS(39)*X(44)-JVS(40)*X(61))/(JVS(38))
  X(5) = (X(5)-JVS(10)*X(76)-JVS(11)*X(88)-JVS(12)*X(98)-JVS(13)*X(106)-JVS(14)*X(116)-JVS(15)*X(124)-JVS(16)*X(127)&
           &-JVS(17)*X(133)-JVS(18)*X(137)-JVS(19)*X(140)-JVS(20)*X(146)-JVS(21)*X(153)-JVS(22)*X(160)-JVS(23)*X(171)&
           &-JVS(24)*X(177)-JVS(25)*X(178)-JVS(26)*X(181)-JVS(27)*X(191)-JVS(28)*X(192)-JVS(29)*X(202)-JVS(30)*X(203)&
           &-JVS(31)*X(204)-JVS(32)*X(205)-JVS(33)*X(207)-JVS(34)*X(208)-JVS(35)*X(210)-JVS(36)*X(211)-JVS(37)*X(212))&
           &/(JVS(9))
  X(4) = (X(4)-JVS(5)*X(38)-JVS(6)*X(43)-JVS(7)*X(47)-JVS(8)*X(53))/(JVS(4))
  X(3) = X(3)/JVS(3)
  X(2) = X(2)/JVS(2)
  X(1) = X(1)/JVS(1)
      
END SUBROUTINE KppSolve

! End of KppSolve function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolveTR - sparse, transposed back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
!      XX        - Vector for output variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolveTR ( JVS, X, XX )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)
! XX - Vector for output variables
  REAL(kind=dp) :: XX(NVAR)

  XX(1) = X(1)/JVS(1)
  XX(2) = X(2)/JVS(2)
  XX(3) = X(3)/JVS(3)
  XX(4) = X(4)/JVS(4)
  XX(5) = X(5)/JVS(9)
  XX(6) = X(6)/JVS(38)
  XX(7) = X(7)/JVS(41)
  XX(8) = X(8)/JVS(49)
  XX(9) = X(9)/JVS(57)
  XX(10) = (X(10)-JVS(58)*XX(9))/(JVS(59))
  XX(11) = X(11)/JVS(68)
  XX(12) = X(12)/JVS(71)
  XX(13) = X(13)/JVS(74)
  XX(14) = X(14)/JVS(77)
  XX(15) = X(15)/JVS(80)
  XX(16) = X(16)/JVS(83)
  XX(17) = X(17)/JVS(86)
  XX(18) = (X(18)-JVS(87)*XX(17))/(JVS(88))
  XX(19) = X(19)/JVS(93)
  XX(20) = X(20)/JVS(96)
  XX(21) = X(21)/JVS(99)
  XX(22) = X(22)/JVS(102)
  XX(23) = X(23)/JVS(105)
  XX(24) = X(24)/JVS(115)
  XX(25) = X(25)/JVS(117)
  XX(26) = X(26)/JVS(119)
  XX(27) = X(27)/JVS(121)
  XX(28) = X(28)/JVS(125)
  XX(29) = (X(29)-JVS(126)*XX(28))/(JVS(127))
  XX(30) = X(30)/JVS(130)
  XX(31) = X(31)/JVS(132)
  XX(32) = X(32)/JVS(198)
  XX(33) = X(33)/JVS(263)
  XX(34) = X(34)/JVS(311)
  XX(35) = X(35)/JVS(321)
  XX(36) = X(36)/JVS(331)
  XX(37) = X(37)/JVS(334)
  XX(38) = (X(38)-JVS(5)*XX(4)-JVS(42)*XX(7)-JVS(50)*XX(8)-JVS(199)*XX(32))/(JVS(348))
  XX(39) = X(39)/JVS(350)
  XX(40) = X(40)/JVS(352)
  XX(41) = X(41)/JVS(354)
  XX(42) = X(42)/JVS(358)
  XX(43) = (X(43)-JVS(6)*XX(4)-JVS(43)*XX(7)-JVS(51)*XX(8)-JVS(200)*XX(32))/(JVS(360))
  XX(44) = (X(44)-JVS(39)*XX(6)-JVS(133)*XX(31))/(JVS(362))
  XX(45) = X(45)/JVS(366)
  XX(46) = X(46)/JVS(368)
  XX(47) = (X(47)-JVS(7)*XX(4)-JVS(44)*XX(7)-JVS(52)*XX(8)-JVS(201)*XX(32))/(JVS(370))
  XX(48) = (X(48)-JVS(134)*XX(31))/(JVS(373))
  XX(49) = X(49)/JVS(376)
  XX(50) = X(50)/JVS(379)
  XX(51) = X(51)/JVS(381)
  XX(52) = X(52)/JVS(384)
  XX(53) = (X(53)-JVS(8)*XX(4)-JVS(45)*XX(7)-JVS(53)*XX(8))/(JVS(386))
  XX(54) = X(54)/JVS(390)
  XX(55) = (X(55)-JVS(122)*XX(27))/(JVS(394))
  XX(56) = X(56)/JVS(398)
  XX(57) = (X(57)-JVS(81)*XX(15)-JVS(84)*XX(16))/(JVS(402))
  XX(58) = (X(58)-JVS(69)*XX(11)-JVS(72)*XX(12))/(JVS(407))
  XX(59) = (X(59)-JVS(123)*XX(27))/(JVS(411))
  XX(60) = (X(60)-JVS(124)*XX(27))/(JVS(416))
  XX(61) = (X(61)-JVS(40)*XX(6)-JVS(135)*XX(31))/(JVS(422))
  XX(62) = (X(62)-JVS(94)*XX(19)-JVS(97)*XX(20))/(JVS(431))
  XX(63) = X(63)/JVS(436)
  XX(64) = X(64)/JVS(440)
  XX(65) = X(65)/JVS(446)
  XX(66) = (X(66)-JVS(136)*XX(31))/(JVS(452))
  XX(67) = (X(67)-JVS(264)*XX(33))/(JVS(455))
  XX(68) = (X(68)-JVS(265)*XX(33))/(JVS(458))
  XX(69) = (X(69)-JVS(202)*XX(32))/(JVS(461))
  XX(70) = (X(70)-JVS(100)*XX(21)-JVS(203)*XX(32))/(JVS(464))
  XX(71) = (X(71)-JVS(137)*XX(31))/(JVS(467))
  XX(72) = (X(72)-JVS(138)*XX(31))/(JVS(472))
  XX(73) = (X(73)-JVS(204)*XX(32)-JVS(349)*XX(38)-JVS(371)*XX(47))/(JVS(479))
  XX(74) = X(74)/JVS(483)
  XX(75) = X(75)/JVS(487)
  XX(76) = (X(76)-JVS(10)*XX(5)-JVS(205)*XX(32)-JVS(432)*XX(62))/(JVS(491))
  XX(77) = X(77)/JVS(494)
  XX(78) = (X(78)-JVS(266)*XX(33))/(JVS(498))
  XX(79) = (X(79)-JVS(139)*XX(31))/(JVS(501))
  XX(80) = (X(80)-JVS(46)*XX(7)-JVS(54)*XX(8)-JVS(206)*XX(32)-JVS(391)*XX(54)-JVS(441)*XX(64)-JVS(468)*XX(71))&
             &/(JVS(505))
  XX(81) = (X(81)-JVS(140)*XX(31))/(JVS(509))
  XX(82) = (X(82)-JVS(207)*XX(32))/(JVS(515))
  XX(83) = (X(83)-JVS(141)*XX(31))/(JVS(520))
  XX(84) = X(84)/JVS(525)
  XX(85) = X(85)/JVS(530)
  XX(86) = X(86)/JVS(534)
  XX(87) = (X(87)-JVS(208)*XX(32))/(JVS(538))
  XX(88) = (X(88)-JVS(11)*XX(5)-JVS(267)*XX(33))/(JVS(542))
  XX(89) = X(89)/JVS(545)
  XX(90) = X(90)/JVS(550)
  XX(91) = X(91)/JVS(556)
  XX(92) = X(92)/JVS(561)
  XX(93) = (X(93)-JVS(47)*XX(7)-JVS(55)*XX(8)-JVS(209)*XX(32)-JVS(392)*XX(54)-JVS(442)*XX(64))/(JVS(572))
  XX(94) = (X(94)-JVS(210)*XX(32)-JVS(502)*XX(79))/(JVS(577))
  XX(95) = (X(95)-JVS(142)*XX(31)-JVS(268)*XX(33)-JVS(359)*XX(42))/(JVS(581))
  XX(96) = X(96)/JVS(585)
  XX(97) = X(97)/JVS(589)
  XX(98) = (X(98)-JVS(12)*XX(5)-JVS(269)*XX(33))/(JVS(594))
  XX(99) = (X(99)-JVS(143)*XX(31))/(JVS(600))
  XX(100) = (X(100)-JVS(89)*XX(18)-JVS(412)*XX(59)-JVS(417)*XX(60))/(JVS(605))
  XX(101) = X(101)/JVS(609)
  XX(102) = (X(102)-JVS(144)*XX(31))/(JVS(613))
  XX(103) = (X(103)-JVS(270)*XX(33))/(JVS(622))
  XX(104) = (X(104)-JVS(145)*XX(31))/(JVS(628))
  XX(105) = (X(105)-JVS(271)*XX(33))/(JVS(637))
  XX(106) = (X(106)-JVS(13)*XX(5)-JVS(211)*XX(32))/(JVS(641))
  XX(107) = (X(107)-JVS(272)*XX(33))/(JVS(648))
  XX(108) = (X(108)-JVS(146)*XX(31)-JVS(363)*XX(44))/(JVS(654))
  XX(109) = (X(109)-JVS(90)*XX(18)-JVS(413)*XX(59)-JVS(418)*XX(60))/(JVS(660))
  XX(110) = (X(110)-JVS(91)*XX(18)-JVS(395)*XX(55))/(JVS(664))
  XX(111) = (X(111)-JVS(212)*XX(32)-JVS(562)*XX(92)-JVS(614)*XX(102))/(JVS(668))
  XX(112) = (X(112)-JVS(213)*XX(32))/(JVS(673))
  XX(113) = (X(113)-JVS(214)*XX(32)-JVS(563)*XX(92)-JVS(615)*XX(102))/(JVS(678))
  XX(114) = X(114)/JVS(683)
  XX(115) = X(115)/JVS(690)
  XX(116) = (X(116)-JVS(14)*XX(5)-JVS(273)*XX(33))/(JVS(697))
  XX(117) = (X(117)-JVS(215)*XX(32))/(JVS(704))
  XX(118) = X(118)/JVS(709)
  XX(119) = (X(119)-JVS(216)*XX(32)-JVS(274)*XX(33)-JVS(335)*XX(37))/(JVS(715))
  XX(120) = (X(120)-JVS(217)*XX(32)-JVS(275)*XX(33)-JVS(336)*XX(37))/(JVS(719))
  XX(121) = (X(121)-JVS(276)*XX(33))/(JVS(723))
  XX(122) = (X(122)-JVS(218)*XX(32)-JVS(564)*XX(92)-JVS(616)*XX(102))/(JVS(728))
  XX(123) = (X(123)-JVS(48)*XX(7)-JVS(56)*XX(8)-JVS(219)*XX(32)-JVS(393)*XX(54)-JVS(443)*XX(64))/(JVS(733))
  XX(124) = (X(124)-JVS(15)*XX(5)-JVS(147)*XX(31)-JVS(551)*XX(90))/(JVS(740))
  XX(125) = (X(125)-JVS(106)*XX(23)-JVS(148)*XX(31)-JVS(312)*XX(34)-JVS(322)*XX(35)-JVS(337)*XX(37))/(JVS(747))
  XX(126) = (X(126)-JVS(149)*XX(31)-JVS(552)*XX(90))/(JVS(754))
  XX(127) = (X(127)-JVS(16)*XX(5)-JVS(128)*XX(29)-JVS(150)*XX(31)-JVS(277)*XX(33)-JVS(447)*XX(65)-JVS(521)*XX(83))&
              &/(JVS(760))
  XX(128) = (X(128)-JVS(220)*XX(32)-JVS(278)*XX(33)-JVS(338)*XX(37))/(JVS(766))
  XX(129) = (X(129)-JVS(107)*XX(23)-JVS(151)*XX(31)-JVS(313)*XX(34)-JVS(323)*XX(35)-JVS(339)*XX(37))/(JVS(770))
  XX(130) = (X(130)-JVS(152)*XX(31)-JVS(573)*XX(93)-JVS(734)*XX(123))/(JVS(780))
  XX(131) = (X(131)-JVS(108)*XX(23)-JVS(153)*XX(31)-JVS(314)*XX(34)-JVS(324)*XX(35)-JVS(340)*XX(37))/(JVS(787))
  XX(132) = (X(132)-JVS(109)*XX(23)-JVS(154)*XX(31)-JVS(315)*XX(34)-JVS(325)*XX(35)-JVS(341)*XX(37))/(JVS(794))
  XX(133) = (X(133)-JVS(17)*XX(5)-JVS(155)*XX(31)-JVS(221)*XX(32)-JVS(374)*XX(48))/(JVS(803))
  XX(134) = X(134)/JVS(809)
  XX(135) = (X(135)-JVS(110)*XX(23)-JVS(156)*XX(31)-JVS(316)*XX(34)-JVS(326)*XX(35)-JVS(342)*XX(37))/(JVS(827))
  XX(136) = (X(136)-JVS(157)*XX(31)-JVS(222)*XX(32)-JVS(364)*XX(44)-JVS(655)*XX(108))/(JVS(834))
  XX(137) = (X(137)-JVS(18)*XX(5)-JVS(223)*XX(32)-JVS(279)*XX(33)-JVS(414)*XX(59)-JVS(419)*XX(60)-JVS(423)*XX(61))&
              &/(JVS(844))
  XX(138) = (X(138)-JVS(60)*XX(10)-JVS(224)*XX(32)-JVS(710)*XX(118))/(JVS(849))
  XX(139) = X(139)/JVS(863)
  XX(140) = (X(140)-JVS(19)*XX(5))/(JVS(883))
  XX(141) = (X(141)-JVS(61)*XX(10)-JVS(158)*XX(31)-JVS(225)*XX(32)-JVS(711)*XX(118))/(JVS(900))
  XX(142) = (X(142)-JVS(116)*XX(24)-JVS(118)*XX(25)-JVS(226)*XX(32)-JVS(565)*XX(92)-JVS(617)*XX(102)-JVS(669)*XX(111)&
              &-JVS(679)*XX(113))/(JVS(910))
  XX(143) = (X(143)-JVS(227)*XX(32)-JVS(566)*XX(92)-JVS(629)*XX(104))/(JVS(925))
  XX(144) = (X(144)-JVS(159)*XX(31)-JVS(535)*XX(86)-JVS(810)*XX(134))/(JVS(939))
  XX(145) = (X(145)-JVS(160)*XX(31)-JVS(228)*XX(32)-JVS(365)*XX(44)-JVS(656)*XX(108))/(JVS(947))
  XX(146) = (X(146)-JVS(20)*XX(5)-JVS(161)*XX(31)-JVS(280)*XX(33)-JVS(623)*XX(103)-JVS(884)*XX(140))/(JVS(966))
  XX(147) = (X(147)-JVS(120)*XX(26)-JVS(229)*XX(32)-JVS(281)*XX(33))/(JVS(984))
  XX(148) = (X(148)-JVS(111)*XX(23)-JVS(162)*XX(31)-JVS(317)*XX(34)-JVS(327)*XX(35)-JVS(343)*XX(37)-JVS(595)*XX(98)&
              &-JVS(864)*XX(139))/(JVS(997))
  XX(149) = (X(149)-JVS(163)*XX(31)-JVS(355)*XX(41)-JVS(424)*XX(61)-JVS(674)*XX(112))/(JVS(1006))
  XX(150) = (X(150)-JVS(103)*XX(22)-JVS(164)*XX(31)-JVS(230)*XX(32)-JVS(425)*XX(61)-JVS(885)*XX(140))/(JVS(1015))
  XX(151) = (X(151)-JVS(165)*XX(31)-JVS(484)*XX(74)-JVS(811)*XX(134))/(JVS(1025))
  XX(152) = (X(152)-JVS(282)*XX(33))/(JVS(1040))
  XX(153) = (X(153)-JVS(21)*XX(5)-JVS(166)*XX(31)-JVS(283)*XX(33)-JVS(684)*XX(114)-JVS(1041)*XX(152))/(JVS(1055))
  XX(154) = (X(154)-JVS(62)*XX(10)-JVS(167)*XX(31)-JVS(231)*XX(32)-JVS(284)*XX(33)-JVS(526)*XX(84)-JVS(761)*XX(127)&
              &-JVS(1042)*XX(152))/(JVS(1062))
  XX(155) = (X(155)-JVS(168)*XX(31)-JVS(531)*XX(85)-JVS(812)*XX(134))/(JVS(1070))
  XX(156) = (X(156)-JVS(75)*XX(13)-JVS(78)*XX(14)-JVS(232)*XX(32)-JVS(285)*XX(33)-JVS(748)*XX(125)-JVS(865)*XX(139)&
              &-JVS(998)*XX(148))/(JVS(1079))
  XX(157) = (X(157)-JVS(169)*XX(31)-JVS(557)*XX(91))/(JVS(1085))
  XX(158) = (X(158)-JVS(170)*XX(31)-JVS(488)*XX(75)-JVS(813)*XX(134))/(JVS(1097))
  XX(159) = (X(159)-JVS(233)*XX(32)-JVS(286)*XX(33)-JVS(426)*XX(61)-JVS(804)*XX(133)-JVS(886)*XX(140))/(JVS(1109))
  XX(160) = (X(160)-JVS(22)*XX(5)-JVS(171)*XX(31)-JVS(814)*XX(134))/(JVS(1119))
  XX(161) = (X(161)-JVS(387)*XX(53)-JVS(399)*XX(56)-JVS(506)*XX(80)-JVS(735)*XX(123)-JVS(781)*XX(130))/(JVS(1142))
  XX(162) = (X(162)-JVS(172)*XX(31)-JVS(234)*XX(32)-JVS(567)*XX(92)-JVS(630)*XX(104)-JVS(670)*XX(111)-JVS(680)*XX(113)&
              &-JVS(911)*XX(142)-JVS(926)*XX(143))/(JVS(1155))
  XX(163) = (X(163)-JVS(235)*XX(32)-JVS(361)*XX(43)-JVS(372)*XX(47)-JVS(444)*XX(64)-JVS(480)*XX(73)-JVS(516)*XX(82)&
              &-JVS(574)*XX(93)-JVS(736)*XX(123)-JVS(782)*XX(130)-JVS(927)*XX(143)-JVS(1143)*XX(161))/(JVS(1173))
  XX(164) = (X(164)-JVS(173)*XX(31))/(JVS(1208))
  XX(165) = (X(165)-JVS(236)*XX(32)-JVS(481)*XX(73)-JVS(510)*XX(81)-JVS(517)*XX(82)-JVS(568)*XX(92)-JVS(618)*XX(102)&
              &-JVS(631)*XX(104)-JVS(729)*XX(122)-JVS(912)*XX(142)-JVS(928)*XX(143)-JVS(1144)*XX(161)-JVS(1156)*XX(162)&
              &-JVS(1174)*XX(163)-JVS(1209)*XX(164))/(JVS(1246))
  XX(166) = (X(166)-JVS(174)*XX(31)-JVS(356)*XX(41)-JVS(427)*XX(61)-JVS(675)*XX(112)-JVS(698)*XX(116)-JVS(887)*XX(140)&
              &-JVS(1007)*XX(149)-JVS(1016)*XX(150)-JVS(1043)*XX(152)-JVS(1110)*XX(159)-JVS(1210)*XX(164))/(JVS(1258))
  XX(167) = (X(167)-JVS(175)*XX(31)-JVS(237)*XX(32)-JVS(835)*XX(136)-JVS(948)*XX(145)-JVS(1211)*XX(164))/(JVS(1268))
  XX(168) = (X(168)-JVS(176)*XX(31)-JVS(815)*XX(134)-JVS(836)*XX(136)-JVS(949)*XX(145)-JVS(1212)*XX(164)-JVS(1269)&
              &*XX(167))/(JVS(1281))
  XX(169) = (X(169)-JVS(177)*XX(31)-JVS(238)*XX(32)-JVS(546)*XX(89)-JVS(816)*XX(134)-JVS(950)*XX(145)-JVS(1213)*XX(164))&
              &/(JVS(1290))
  XX(170) = (X(170)-JVS(178)*XX(31)-JVS(817)*XX(134))/(JVS(1301))
  XX(171) = (X(171)-JVS(23)*XX(5))/(JVS(1323))
  XX(172) = (X(172)-JVS(179)*XX(31)-JVS(377)*XX(49)-JVS(527)*XX(84))/(JVS(1354))
  XX(173) = (X(173)-JVS(112)*XX(23)-JVS(180)*XX(31)-JVS(318)*XX(34)-JVS(328)*XX(35)-JVS(344)*XX(37)-JVS(866)*XX(139)&
              &-JVS(888)*XX(140))/(JVS(1367))
  XX(174) = (X(174)-JVS(181)*XX(31)-JVS(239)*XX(32)-JVS(547)*XX(89)-JVS(818)*XX(134)-JVS(837)*XX(136)-JVS(889)*XX(140)&
              &-JVS(951)*XX(145)-JVS(1214)*XX(164))/(JVS(1381))
  XX(175) = (X(175)-JVS(240)*XX(32)-JVS(569)*XX(92)-JVS(619)*XX(102)-JVS(671)*XX(111)-JVS(681)*XX(113)-JVS(913)*XX(142)&
              &-JVS(929)*XX(143)-JVS(1157)*XX(162)-JVS(1215)*XX(164))/(JVS(1396))
  XX(176) = (X(176)-JVS(182)*XX(31)-JVS(558)*XX(91)-JVS(819)*XX(134)-JVS(1086)*XX(157)-JVS(1324)*XX(171))/(JVS(1415))
  XX(177) = (X(177)-JVS(24)*XX(5)-JVS(287)*XX(33)-JVS(890)*XX(140)-JVS(985)*XX(147)-JVS(1216)*XX(164))/(JVS(1433))
  XX(178) = (X(178)-JVS(25)*XX(5)-JVS(241)*XX(32)-JVS(396)*XX(55)-JVS(428)*XX(61)-JVS(691)*XX(115)-JVS(699)*XX(116)&
              &-JVS(967)*XX(146)-JVS(986)*XX(147)-JVS(1044)*XX(152)-JVS(1217)*XX(164)-JVS(1259)*XX(166)-JVS(1302)*XX(170)&
              &-JVS(1325)*XX(171)-JVS(1434)*XX(177))/(JVS(1449))
  XX(179) = (X(179)-JVS(183)*XX(31)-JVS(288)*XX(33)-JVS(638)*XX(105)-JVS(642)*XX(106)-JVS(649)*XX(107)-JVS(741)*XX(124)&
              &-JVS(820)*XX(134)-JVS(987)*XX(147)-JVS(1218)*XX(164)-JVS(1326)*XX(171)-JVS(1435)*XX(177))/(JVS(1459))
  XX(180) = (X(180)-JVS(184)*XX(31)-JVS(610)*XX(101)-JVS(821)*XX(134)-JVS(1017)*XX(150)-JVS(1219)*XX(164)-JVS(1327)&
              &*XX(171)-JVS(1436)*XX(177))/(JVS(1469))
  XX(181) = (X(181)-JVS(26)*XX(5)-JVS(185)*XX(31)-JVS(289)*XX(33)-JVS(685)*XX(114)-JVS(724)*XX(121)-JVS(1120)*XX(160)&
              &-JVS(1220)*XX(164)-JVS(1328)*XX(171))/(JVS(1482))
  XX(182) = (X(182)-JVS(131)*XX(30)-JVS(242)*XX(32)-JVS(290)*XX(33)-JVS(1221)*XX(164))/(JVS(1518))
  XX(183) = (X(183)-JVS(243)*XX(32)-JVS(850)*XX(138)-JVS(901)*XX(141)-JVS(988)*XX(147)-JVS(1045)*XX(152)-JVS(1063)&
              &*XX(154)-JVS(1222)*XX(164)-JVS(1355)*XX(172)-JVS(1437)*XX(177)-JVS(1519)*XX(182))/(JVS(1542))
  XX(184) = (X(184)-JVS(244)*XX(32)-JVS(291)*XX(33)-JVS(788)*XX(131)-JVS(795)*XX(132)-JVS(867)*XX(139)-JVS(1438)*XX(177)&
              &-JVS(1460)*XX(179)-JVS(1520)*XX(182))/(JVS(1555))
  XX(185) = (X(185)-JVS(186)*XX(31)-JVS(553)*XX(90)-JVS(822)*XX(134)-JVS(1026)*XX(151)-JVS(1098)*XX(158)-JVS(1329)&
              &*XX(171))/(JVS(1576))
  XX(186) = (X(186)-JVS(245)*XX(32)-JVS(445)*XX(64)-JVS(462)*XX(69)-JVS(511)*XX(81)-JVS(518)*XX(82)-JVS(570)*XX(92)&
              &-JVS(632)*XX(104)-JVS(930)*XX(143)-JVS(1145)*XX(161)-JVS(1158)*XX(162)-JVS(1175)*XX(163)-JVS(1223)*XX(164)&
              &-JVS(1247)*XX(165)-JVS(1397)*XX(175))/(JVS(1596))
  XX(187) = (X(187)-JVS(187)*XX(31)-JVS(292)*XX(33)-JVS(596)*XX(98)-JVS(823)*XX(134)-JVS(1111)*XX(159)-JVS(1224)*XX(164)&
              &-JVS(1330)*XX(171)-JVS(1521)*XX(182))/(JVS(1615))
  XX(188) = (X(188)-JVS(293)*XX(33)-JVS(1087)*XX(157)-JVS(1331)*XX(171)-JVS(1398)*XX(175)-JVS(1522)*XX(182)-JVS(1597)&
              &*XX(186))/(JVS(1632))
  XX(189) = (X(189)-JVS(246)*XX(32)-JVS(294)*XX(33)-JVS(771)*XX(129)-JVS(868)*XX(139)-JVS(940)*XX(144)-JVS(1046)*XX(152)&
              &-JVS(1071)*XX(155)-JVS(1332)*XX(171)-JVS(1368)*XX(173)-JVS(1399)*XX(175)-JVS(1523)*XX(182)-JVS(1598)*XX(186))&
              &/(JVS(1648))
  XX(190) = (X(190)-JVS(188)*XX(31)-JVS(247)*XX(32)-JVS(712)*XX(118)-JVS(1333)*XX(171)-JVS(1450)*XX(178)-JVS(1524)&
              &*XX(182)-JVS(1543)*XX(183)-JVS(1556)*XX(184)-JVS(1577)*XX(185)-JVS(1633)*XX(188))/(JVS(1664))
  XX(191) = (X(191)-JVS(27)*XX(5)-JVS(295)*XX(33)-JVS(891)*XX(140)-JVS(1334)*XX(171)-JVS(1525)*XX(182))/(JVS(1710))
  XX(192) = (X(192)-JVS(28)*XX(5)-JVS(189)*XX(31)-JVS(296)*XX(33)-JVS(543)*XX(88)-JVS(582)*XX(95)-JVS(601)*XX(99)&
              &-JVS(606)*XX(100)-JVS(661)*XX(109)-JVS(665)*XX(110)-JVS(755)*XX(126)-JVS(824)*XX(134)-JVS(845)*XX(137)&
              &-JVS(892)*XX(140)-JVS(968)*XX(146)-JVS(989)*XX(147)-JVS(1008)*XX(149)-JVS(1018)*XX(150)-JVS(1047)*XX(152)&
              &-JVS(1112)*XX(159)-JVS(1225)*XX(164)-JVS(1260)*XX(166)-JVS(1303)*XX(170)-JVS(1335)*XX(171)-JVS(1439)*XX(177)&
              &-JVS(1451)*XX(178)-JVS(1461)*XX(179)-JVS(1526)*XX(182)-JVS(1557)*XX(184)-JVS(1578)*XX(185)-JVS(1634)*XX(188)&
              &-JVS(1711)*XX(191))/(JVS(1732))
  XX(193) = (X(193)-JVS(248)*XX(32)-JVS(429)*XX(61)-JVS(1027)*XX(151)-JVS(1099)*XX(158)-JVS(1226)*XX(164)-JVS(1304)&
              &*XX(170)-JVS(1336)*XX(171)-JVS(1579)*XX(185)-JVS(1635)*XX(188)-JVS(1712)*XX(191))/(JVS(1752))
  XX(194) = (X(194)-JVS(249)*XX(32)-JVS(297)*XX(33)-JVS(1227)*XX(164)-JVS(1356)*XX(172))/(JVS(1803))
  XX(195) = (X(195)-JVS(250)*XX(32)-JVS(503)*XX(79)-JVS(571)*XX(92)-JVS(578)*XX(94)-JVS(633)*XX(104)-JVS(730)*XX(122)&
              &-JVS(914)*XX(142)-JVS(931)*XX(143)-JVS(1159)*XX(162)-JVS(1228)*XX(164)-JVS(1248)*XX(165)-JVS(1400)*XX(175)&
              &-JVS(1599)*XX(186))/(JVS(1863))
  XX(196) = (X(196)-JVS(251)*XX(32)-JVS(298)*XX(33)-JVS(1229)*XX(164)-JVS(1401)*XX(175)-JVS(1600)*XX(186)-JVS(1864)&
              &*XX(195))/(JVS(1949))
  XX(197) = (X(197)-JVS(252)*XX(32)-JVS(299)*XX(33)-JVS(448)*XX(65)-JVS(686)*XX(114)-JVS(762)*XX(127)-JVS(796)*XX(132)&
              &-JVS(869)*XX(139)-JVS(1056)*XX(153)-JVS(1121)*XX(160)-JVS(1230)*XX(164)-JVS(1337)*XX(171)-JVS(1369)*XX(173)&
              &-JVS(1483)*XX(181)-JVS(1527)*XX(182)-JVS(1616)*XX(187)-JVS(1713)*XX(191)-JVS(1753)*XX(193)-JVS(1804)*XX(194)&
              &-JVS(1865)*XX(195)-JVS(1950)*XX(196))/(JVS(1976))
  XX(198) = (X(198)-JVS(253)*XX(32)-JVS(1231)*XX(164)-JVS(1357)*XX(172)-JVS(1416)*XX(176)-JVS(1528)*XX(182)-JVS(1714)&
              &*XX(191)-JVS(1754)*XX(193)-JVS(1805)*XX(194)-JVS(1866)*XX(195)-JVS(1951)*XX(196))/(JVS(2015))
  XX(199) = (X(199)-JVS(254)*XX(32)-JVS(300)*XX(33)-JVS(1232)*XX(164)-JVS(1402)*XX(175)-JVS(1601)*XX(186)-JVS(1867)&
              &*XX(195)-JVS(1952)*XX(196))/(JVS(2049))
  XX(200) = (X(200)-JVS(255)*XX(32)-JVS(301)*XX(33)-JVS(828)*XX(135)-JVS(870)*XX(139)-JVS(1358)*XX(172)-JVS(1370)&
              &*XX(173)-JVS(1470)*XX(180)-JVS(1529)*XX(182)-JVS(1649)*XX(189)-JVS(1715)*XX(191)-JVS(1806)*XX(194)-JVS(1868)&
              &*XX(195)-JVS(1953)*XX(196)-JVS(2016)*XX(198)-JVS(2050)*XX(199))/(JVS(2071))
  XX(201) = (X(201)-JVS(113)*XX(23)-JVS(329)*XX(35)-JVS(749)*XX(125)-JVS(772)*XX(129)-JVS(789)*XX(131)-JVS(797)*XX(132)&
              &-JVS(829)*XX(135)-JVS(871)*XX(139)-JVS(999)*XX(148)-JVS(1338)*XX(171)-JVS(1371)*XX(173)-JVS(1440)*XX(177)&
              &-JVS(1530)*XX(182)-JVS(1617)*XX(187)-JVS(1716)*XX(191)-JVS(1807)*XX(194)-JVS(1869)*XX(195)-JVS(1954)*XX(196)&
              &-JVS(1977)*XX(197)-JVS(2017)*XX(198)-JVS(2051)*XX(199)-JVS(2072)*XX(200))/(JVS(2098))
  XX(202) = (X(202)-JVS(29)*XX(5)-JVS(190)*XX(31)-JVS(302)*XX(33)-JVS(437)*XX(63)-JVS(522)*XX(83)-JVS(643)*XX(106)&
              &-JVS(650)*XX(107)-JVS(742)*XX(124)-JVS(756)*XX(126)-JVS(838)*XX(136)-JVS(941)*XX(144)-JVS(952)*XX(145)&
              &-JVS(990)*XX(147)-JVS(1028)*XX(151)-JVS(1048)*XX(152)-JVS(1057)*XX(153)-JVS(1072)*XX(155)-JVS(1088)*XX(157)&
              &-JVS(1100)*XX(158)-JVS(1122)*XX(160)-JVS(1233)*XX(164)-JVS(1270)*XX(167)-JVS(1282)*XX(168)-JVS(1291)*XX(169)&
              &-JVS(1305)*XX(170)-JVS(1339)*XX(171)-JVS(1359)*XX(172)-JVS(1382)*XX(174)-JVS(1417)*XX(176)-JVS(1441)*XX(177)&
              &-JVS(1462)*XX(179)-JVS(1471)*XX(180)-JVS(1484)*XX(181)-JVS(1531)*XX(182)-JVS(1544)*XX(183)-JVS(1558)*XX(184)&
              &-JVS(1580)*XX(185)-JVS(1618)*XX(187)-JVS(1636)*XX(188)-JVS(1650)*XX(189)-JVS(1665)*XX(190)-JVS(1717)*XX(191)&
              &-JVS(1733)*XX(192)-JVS(1755)*XX(193)-JVS(1808)*XX(194)-JVS(1870)*XX(195)-JVS(1955)*XX(196)-JVS(1978)*XX(197)&
              &-JVS(2018)*XX(198)-JVS(2052)*XX(199)-JVS(2073)*XX(200)-JVS(2099)*XX(201))/(JVS(2160))
  XX(203) = (X(203)-JVS(30)*XX(5)-JVS(256)*XX(32)-JVS(303)*XX(33)-JVS(345)*XX(37)-JVS(644)*XX(106)-JVS(657)*XX(108)&
              &-JVS(672)*XX(111)-JVS(682)*XX(113)-JVS(692)*XX(115)-JVS(700)*XX(116)-JVS(716)*XX(119)-JVS(720)*XX(120)&
              &-JVS(725)*XX(121)-JVS(743)*XX(124)-JVS(750)*XX(125)-JVS(767)*XX(128)-JVS(773)*XX(129)-JVS(790)*XX(131)&
              &-JVS(798)*XX(132)-JVS(830)*XX(135)-JVS(846)*XX(137)-JVS(872)*XX(139)-JVS(893)*XX(140)-JVS(915)*XX(142)&
              &-JVS(953)*XX(145)-JVS(969)*XX(146)-JVS(991)*XX(147)-JVS(1000)*XX(148)-JVS(1009)*XX(149)-JVS(1019)*XX(150)&
              &-JVS(1049)*XX(152)-JVS(1080)*XX(156)-JVS(1113)*XX(159)-JVS(1146)*XX(161)-JVS(1160)*XX(162)-JVS(1176)*XX(163)&
              &-JVS(1234)*XX(164)-JVS(1249)*XX(165)-JVS(1261)*XX(166)-JVS(1271)*XX(167)-JVS(1283)*XX(168)-JVS(1292)*XX(169)&
              &-JVS(1306)*XX(170)-JVS(1340)*XX(171)-JVS(1372)*XX(173)-JVS(1383)*XX(174)-JVS(1403)*XX(175)-JVS(1418)*XX(176)&
              &-JVS(1442)*XX(177)-JVS(1452)*XX(178)-JVS(1472)*XX(180)-JVS(1485)*XX(181)-JVS(1532)*XX(182)-JVS(1545)*XX(183)&
              &-JVS(1559)*XX(184)-JVS(1581)*XX(185)-JVS(1602)*XX(186)-JVS(1619)*XX(187)-JVS(1637)*XX(188)-JVS(1651)*XX(189)&
              &-JVS(1666)*XX(190)-JVS(1718)*XX(191)-JVS(1734)*XX(192)-JVS(1756)*XX(193)-JVS(1809)*XX(194)-JVS(1871)*XX(195)&
              &-JVS(1956)*XX(196)-JVS(1979)*XX(197)-JVS(2019)*XX(198)-JVS(2053)*XX(199)-JVS(2074)*XX(200)-JVS(2100)*XX(201)&
              &-JVS(2161)*XX(202))/(JVS(2215))
  XX(204) = (X(204)-JVS(31)*XX(5)-JVS(63)*XX(10)-JVS(70)*XX(11)-JVS(82)*XX(15)-JVS(95)*XX(19)-JVS(191)*XX(31)-JVS(257)&
              &*XX(32)-JVS(304)*XX(33)-JVS(346)*XX(37)-JVS(388)*XX(53)-JVS(403)*XX(57)-JVS(408)*XX(58)-JVS(433)*XX(62)&
              &-JVS(438)*XX(63)-JVS(473)*XX(72)-JVS(485)*XX(74)-JVS(489)*XX(75)-JVS(495)*XX(77)-JVS(528)*XX(84)-JVS(532)&
              &*XX(85)-JVS(536)*XX(86)-JVS(548)*XX(89)-JVS(554)*XX(90)-JVS(559)*XX(91)-JVS(575)*XX(93)-JVS(583)*XX(95)&
              &-JVS(590)*XX(97)-JVS(597)*XX(98)-JVS(602)*XX(99)-JVS(607)*XX(100)-JVS(611)*XX(101)-JVS(624)*XX(103)-JVS(639)&
              &*XX(105)-JVS(651)*XX(107)-JVS(662)*XX(109)-JVS(666)*XX(110)-JVS(676)*XX(112)-JVS(687)*XX(114)-JVS(701)&
              &*XX(116)-JVS(713)*XX(118)-JVS(744)*XX(124)-JVS(757)*XX(126)-JVS(805)*XX(133)-JVS(839)*XX(136)-JVS(851)&
              &*XX(138)-JVS(873)*XX(139)-JVS(894)*XX(140)-JVS(902)*XX(141)-JVS(916)*XX(142)-JVS(932)*XX(143)-JVS(942)&
              &*XX(144)-JVS(954)*XX(145)-JVS(970)*XX(146)-JVS(992)*XX(147)-JVS(1010)*XX(149)-JVS(1020)*XX(150)-JVS(1029)&
              &*XX(151)-JVS(1050)*XX(152)-JVS(1058)*XX(153)-JVS(1064)*XX(154)-JVS(1073)*XX(155)-JVS(1089)*XX(157)-JVS(1101)&
              &*XX(158)-JVS(1114)*XX(159)-JVS(1123)*XX(160)-JVS(1147)*XX(161)-JVS(1161)*XX(162)-JVS(1177)*XX(163)-JVS(1235)&
              &*XX(164)-JVS(1250)*XX(165)-JVS(1262)*XX(166)-JVS(1272)*XX(167)-JVS(1284)*XX(168)-JVS(1293)*XX(169)-JVS(1307)&
              &*XX(170)-JVS(1341)*XX(171)-JVS(1360)*XX(172)-JVS(1384)*XX(174)-JVS(1404)*XX(175)-JVS(1419)*XX(176)-JVS(1443)&
              &*XX(177)-JVS(1463)*XX(179)-JVS(1473)*XX(180)-JVS(1486)*XX(181)-JVS(1533)*XX(182)-JVS(1560)*XX(184)-JVS(1582)&
              &*XX(185)-JVS(1603)*XX(186)-JVS(1620)*XX(187)-JVS(1638)*XX(188)-JVS(1652)*XX(189)-JVS(1667)*XX(190)-JVS(1719)&
              &*XX(191)-JVS(1735)*XX(192)-JVS(1757)*XX(193)-JVS(1810)*XX(194)-JVS(1872)*XX(195)-JVS(1957)*XX(196)-JVS(1980)&
              &*XX(197)-JVS(2020)*XX(198)-JVS(2054)*XX(199)-JVS(2075)*XX(200)-JVS(2101)*XX(201)-JVS(2162)*XX(202)-JVS(2216)&
              &*XX(203))/(JVS(2328))
  XX(205) = (X(205)-JVS(32)*XX(5)-JVS(76)*XX(13)-JVS(92)*XX(18)-JVS(101)*XX(21)-JVS(104)*XX(22)-JVS(114)*XX(23)-JVS(129)&
              &*XX(29)-JVS(192)*XX(31)-JVS(258)*XX(32)-JVS(305)*XX(33)-JVS(319)*XX(34)-JVS(330)*XX(35)-JVS(332)*XX(36)&
              &-JVS(347)*XX(37)-JVS(351)*XX(39)-JVS(353)*XX(40)-JVS(367)*XX(45)-JVS(369)*XX(46)-JVS(380)*XX(50)-JVS(385)&
              &*XX(52)-JVS(389)*XX(53)-JVS(397)*XX(55)-JVS(404)*XX(57)-JVS(409)*XX(58)-JVS(415)*XX(59)-JVS(420)*XX(60)&
              &-JVS(434)*XX(62)-JVS(439)*XX(63)-JVS(449)*XX(65)-JVS(456)*XX(67)-JVS(459)*XX(68)-JVS(463)*XX(69)-JVS(465)&
              &*XX(70)-JVS(469)*XX(71)-JVS(474)*XX(72)-JVS(486)*XX(74)-JVS(490)*XX(75)-JVS(492)*XX(76)-JVS(496)*XX(77)&
              &-JVS(499)*XX(78)-JVS(504)*XX(79)-JVS(512)*XX(81)-JVS(519)*XX(82)-JVS(523)*XX(83)-JVS(529)*XX(84)-JVS(533)&
              &*XX(85)-JVS(537)*XX(86)-JVS(539)*XX(87)-JVS(544)*XX(88)-JVS(549)*XX(89)-JVS(555)*XX(90)-JVS(560)*XX(91)&
              &-JVS(576)*XX(93)-JVS(586)*XX(96)-JVS(591)*XX(97)-JVS(598)*XX(98)-JVS(603)*XX(99)-JVS(608)*XX(100)-JVS(612)&
              &*XX(101)-JVS(620)*XX(102)-JVS(625)*XX(103)-JVS(634)*XX(104)-JVS(640)*XX(105)-JVS(645)*XX(106)-JVS(652)&
              &*XX(107)-JVS(658)*XX(108)-JVS(663)*XX(109)-JVS(667)*XX(110)-JVS(677)*XX(112)-JVS(688)*XX(114)-JVS(693)&
              &*XX(115)-JVS(702)*XX(116)-JVS(705)*XX(117)-JVS(714)*XX(118)-JVS(717)*XX(119)-JVS(721)*XX(120)-JVS(726)&
              &*XX(121)-JVS(745)*XX(124)-JVS(763)*XX(127)-JVS(768)*XX(128)-JVS(783)*XX(130)-JVS(806)*XX(133)-JVS(825)&
              &*XX(134)-JVS(840)*XX(136)-JVS(847)*XX(137)-JVS(852)*XX(138)-JVS(874)*XX(139)-JVS(895)*XX(140)-JVS(917)&
              &*XX(142)-JVS(933)*XX(143)-JVS(943)*XX(144)-JVS(955)*XX(145)-JVS(971)*XX(146)-JVS(993)*XX(147)-JVS(1011)&
              &*XX(149)-JVS(1021)*XX(150)-JVS(1030)*XX(151)-JVS(1051)*XX(152)-JVS(1065)*XX(154)-JVS(1074)*XX(155)-JVS(1081)&
              &*XX(156)-JVS(1090)*XX(157)-JVS(1102)*XX(158)-JVS(1115)*XX(159)-JVS(1124)*XX(160)-JVS(1148)*XX(161)-JVS(1162)&
              &*XX(162)-JVS(1178)*XX(163)-JVS(1236)*XX(164)-JVS(1251)*XX(165)-JVS(1263)*XX(166)-JVS(1273)*XX(167)-JVS(1285)&
              &*XX(168)-JVS(1294)*XX(169)-JVS(1308)*XX(170)-JVS(1342)*XX(171)-JVS(1361)*XX(172)-JVS(1373)*XX(173)-JVS(1385)&
              &*XX(174)-JVS(1405)*XX(175)-JVS(1420)*XX(176)-JVS(1444)*XX(177)-JVS(1453)*XX(178)-JVS(1464)*XX(179)-JVS(1474)&
              &*XX(180)-JVS(1487)*XX(181)-JVS(1534)*XX(182)-JVS(1546)*XX(183)-JVS(1561)*XX(184)-JVS(1583)*XX(185)-JVS(1604)&
              &*XX(186)-JVS(1621)*XX(187)-JVS(1639)*XX(188)-JVS(1653)*XX(189)-JVS(1668)*XX(190)-JVS(1720)*XX(191)-JVS(1736)&
              &*XX(192)-JVS(1758)*XX(193)-JVS(1811)*XX(194)-JVS(1873)*XX(195)-JVS(1958)*XX(196)-JVS(1981)*XX(197)-JVS(2021)&
              &*XX(198)-JVS(2055)*XX(199)-JVS(2076)*XX(200)-JVS(2102)*XX(201)-JVS(2163)*XX(202)-JVS(2217)*XX(203)-JVS(2329)&
              &*XX(204))/(JVS(2475))
  XX(206) = (X(206)-JVS(306)*XX(33)-JVS(382)*XX(51)-JVS(587)*XX(96)-JVS(621)*XX(102)-JVS(706)*XX(117)-JVS(731)*XX(122)&
              &-JVS(918)*XX(142)-JVS(1031)*XX(151)-JVS(1075)*XX(155)-JVS(1091)*XX(157)-JVS(1103)*XX(158)-JVS(1163)*XX(162)&
              &-JVS(1237)*XX(164)-JVS(1252)*XX(165)-JVS(1343)*XX(171)-JVS(1406)*XX(175)-JVS(1535)*XX(182)-JVS(1605)*XX(186)&
              &-JVS(1640)*XX(188)-JVS(1654)*XX(189)-JVS(1721)*XX(191)-JVS(1812)*XX(194)-JVS(1874)*XX(195)-JVS(1959)*XX(196)&
              &-JVS(2056)*XX(199)-JVS(2103)*XX(201)-JVS(2164)*XX(202)-JVS(2218)*XX(203)-JVS(2330)*XX(204)-JVS(2476)*XX(205))&
              &/(JVS(2525))
  XX(207) = (X(207)-JVS(33)*XX(5)-JVS(64)*XX(10)-JVS(193)*XX(31)-JVS(259)*XX(32)-JVS(307)*XX(33)-JVS(453)*XX(66)&
              &-JVS(513)*XX(81)-JVS(592)*XX(97)-JVS(635)*XX(104)-JVS(694)*XX(115)-JVS(826)*XX(134)-JVS(841)*XX(136)-JVS(853)&
              &*XX(138)-JVS(903)*XX(141)-JVS(934)*XX(143)-JVS(944)*XX(144)-JVS(956)*XX(145)-JVS(994)*XX(147)-JVS(1032)&
              &*XX(151)-JVS(1052)*XX(152)-JVS(1059)*XX(153)-JVS(1076)*XX(155)-JVS(1092)*XX(157)-JVS(1104)*XX(158)-JVS(1125)&
              &*XX(160)-JVS(1238)*XX(164)-JVS(1274)*XX(167)-JVS(1286)*XX(168)-JVS(1295)*XX(169)-JVS(1309)*XX(170)-JVS(1344)&
              &*XX(171)-JVS(1362)*XX(172)-JVS(1386)*XX(174)-JVS(1407)*XX(175)-JVS(1421)*XX(176)-JVS(1445)*XX(177)-JVS(1454)&
              &*XX(178)-JVS(1465)*XX(179)-JVS(1475)*XX(180)-JVS(1488)*XX(181)-JVS(1536)*XX(182)-JVS(1547)*XX(183)-JVS(1562)&
              &*XX(184)-JVS(1584)*XX(185)-JVS(1606)*XX(186)-JVS(1622)*XX(187)-JVS(1641)*XX(188)-JVS(1655)*XX(189)-JVS(1669)&
              &*XX(190)-JVS(1722)*XX(191)-JVS(1737)*XX(192)-JVS(1759)*XX(193)-JVS(1813)*XX(194)-JVS(1875)*XX(195)-JVS(1960)&
              &*XX(196)-JVS(1982)*XX(197)-JVS(2022)*XX(198)-JVS(2057)*XX(199)-JVS(2077)*XX(200)-JVS(2104)*XX(201)-JVS(2165)&
              &*XX(202)-JVS(2219)*XX(203)-JVS(2331)*XX(204)-JVS(2477)*XX(205)-JVS(2526)*XX(206))/(JVS(2592))
  XX(208) = (X(208)-JVS(34)*XX(5)-JVS(65)*XX(10)-JVS(73)*XX(12)-JVS(85)*XX(16)-JVS(98)*XX(20)-JVS(194)*XX(31)-JVS(260)&
              &*XX(32)-JVS(308)*XX(33)-JVS(357)*XX(41)-JVS(400)*XX(56)-JVS(405)*XX(57)-JVS(410)*XX(58)-JVS(430)*XX(61)&
              &-JVS(435)*XX(62)-JVS(470)*XX(71)-JVS(482)*XX(73)-JVS(584)*XX(95)-JVS(604)*XX(99)-JVS(626)*XX(103)-JVS(646)&
              &*XX(106)-JVS(653)*XX(107)-JVS(703)*XX(116)-JVS(746)*XX(124)-JVS(751)*XX(125)-JVS(758)*XX(126)-JVS(774)&
              &*XX(129)-JVS(784)*XX(130)-JVS(791)*XX(131)-JVS(799)*XX(132)-JVS(807)*XX(133)-JVS(831)*XX(135)-JVS(842)&
              &*XX(136)-JVS(848)*XX(137)-JVS(854)*XX(138)-JVS(875)*XX(139)-JVS(896)*XX(140)-JVS(904)*XX(141)-JVS(945)&
              &*XX(144)-JVS(957)*XX(145)-JVS(972)*XX(146)-JVS(995)*XX(147)-JVS(1001)*XX(148)-JVS(1012)*XX(149)-JVS(1022)&
              &*XX(150)-JVS(1033)*XX(151)-JVS(1053)*XX(152)-JVS(1060)*XX(153)-JVS(1066)*XX(154)-JVS(1077)*XX(155)-JVS(1093)&
              &*XX(157)-JVS(1105)*XX(158)-JVS(1116)*XX(159)-JVS(1126)*XX(160)-JVS(1149)*XX(161)-JVS(1179)*XX(163)-JVS(1239)&
              &*XX(164)-JVS(1253)*XX(165)-JVS(1264)*XX(166)-JVS(1275)*XX(167)-JVS(1287)*XX(168)-JVS(1296)*XX(169)-JVS(1310)&
              &*XX(170)-JVS(1345)*XX(171)-JVS(1363)*XX(172)-JVS(1374)*XX(173)-JVS(1387)*XX(174)-JVS(1408)*XX(175)-JVS(1422)&
              &*XX(176)-JVS(1446)*XX(177)-JVS(1455)*XX(178)-JVS(1466)*XX(179)-JVS(1476)*XX(180)-JVS(1489)*XX(181)-JVS(1537)&
              &*XX(182)-JVS(1548)*XX(183)-JVS(1563)*XX(184)-JVS(1585)*XX(185)-JVS(1607)*XX(186)-JVS(1623)*XX(187)-JVS(1642)&
              &*XX(188)-JVS(1656)*XX(189)-JVS(1670)*XX(190)-JVS(1723)*XX(191)-JVS(1738)*XX(192)-JVS(1760)*XX(193)-JVS(1814)&
              &*XX(194)-JVS(1876)*XX(195)-JVS(1961)*XX(196)-JVS(1983)*XX(197)-JVS(2023)*XX(198)-JVS(2058)*XX(199)-JVS(2078)&
              &*XX(200)-JVS(2105)*XX(201)-JVS(2166)*XX(202)-JVS(2220)*XX(203)-JVS(2332)*XX(204)-JVS(2478)*XX(205)-JVS(2527)&
              &*XX(206)-JVS(2593)*XX(207))/(JVS(2672))
  XX(209) = (X(209)-JVS(66)*XX(10)-JVS(195)*XX(31)-JVS(261)*XX(32)-JVS(375)*XX(48)-JVS(378)*XX(49)-JVS(383)*XX(51)&
              &-JVS(450)*XX(65)-JVS(454)*XX(66)-JVS(471)*XX(71)-JVS(475)*XX(72)-JVS(507)*XX(80)-JVS(524)*XX(83)-JVS(579)&
              &*XX(94)-JVS(727)*XX(121)-JVS(732)*XX(122)-JVS(737)*XX(123)-JVS(752)*XX(125)-JVS(764)*XX(127)-JVS(775)*XX(129)&
              &-JVS(785)*XX(130)-JVS(792)*XX(131)-JVS(800)*XX(132)-JVS(808)*XX(133)-JVS(832)*XX(135)-JVS(876)*XX(139)&
              &-JVS(897)*XX(140)-JVS(919)*XX(142)-JVS(935)*XX(143)-JVS(1002)*XX(148)-JVS(1067)*XX(154)-JVS(1150)*XX(161)&
              &-JVS(1164)*XX(162)-JVS(1180)*XX(163)-JVS(1240)*XX(164)-JVS(1254)*XX(165)-JVS(1346)*XX(171)-JVS(1364)*XX(172)&
              &-JVS(1375)*XX(173)-JVS(1409)*XX(175)-JVS(1447)*XX(177)-JVS(1490)*XX(181)-JVS(1538)*XX(182)-JVS(1608)*XX(186)&
              &-JVS(1624)*XX(187)-JVS(1724)*XX(191)-JVS(1815)*XX(194)-JVS(1877)*XX(195)-JVS(1962)*XX(196)-JVS(1984)*XX(197)&
              &-JVS(2024)*XX(198)-JVS(2059)*XX(199)-JVS(2079)*XX(200)-JVS(2106)*XX(201)-JVS(2167)*XX(202)-JVS(2221)*XX(203)&
              &-JVS(2333)*XX(204)-JVS(2479)*XX(205)-JVS(2528)*XX(206)-JVS(2594)*XX(207)-JVS(2673)*XX(208))/(JVS(2777))
  XX(210) = (X(210)-JVS(35)*XX(5)-JVS(196)*XX(31)-JVS(309)*XX(33)-JVS(333)*XX(36)-JVS(457)*XX(67)-JVS(460)*XX(68)&
              &-JVS(500)*XX(78)-JVS(514)*XX(81)-JVS(540)*XX(87)-JVS(588)*XX(96)-JVS(593)*XX(97)-JVS(636)*XX(104)-JVS(695)&
              &*XX(115)-JVS(707)*XX(117)-JVS(877)*XX(139)-JVS(898)*XX(140)-JVS(936)*XX(143)-JVS(1034)*XX(151)-JVS(1078)&
              &*XX(155)-JVS(1082)*XX(156)-JVS(1094)*XX(157)-JVS(1106)*XX(158)-JVS(1165)*XX(162)-JVS(1241)*XX(164)-JVS(1347)&
              &*XX(171)-JVS(1376)*XX(173)-JVS(1410)*XX(175)-JVS(1477)*XX(180)-JVS(1539)*XX(182)-JVS(1586)*XX(185)-JVS(1609)&
              &*XX(186)-JVS(1625)*XX(187)-JVS(1643)*XX(188)-JVS(1657)*XX(189)-JVS(1671)*XX(190)-JVS(1725)*XX(191)-JVS(1739)&
              &*XX(192)-JVS(1761)*XX(193)-JVS(1816)*XX(194)-JVS(1878)*XX(195)-JVS(1963)*XX(196)-JVS(1985)*XX(197)-JVS(2025)&
              &*XX(198)-JVS(2060)*XX(199)-JVS(2080)*XX(200)-JVS(2107)*XX(201)-JVS(2168)*XX(202)-JVS(2222)*XX(203)-JVS(2334)&
              &*XX(204)-JVS(2480)*XX(205)-JVS(2529)*XX(206)-JVS(2595)*XX(207)-JVS(2674)*XX(208)-JVS(2778)*XX(209))&
              &/(JVS(2855))
  XX(211) = (X(211)-JVS(36)*XX(5)-JVS(320)*XX(34)-JVS(753)*XX(125)-JVS(776)*XX(129)-JVS(793)*XX(131)-JVS(801)*XX(132)&
              &-JVS(833)*XX(135)-JVS(878)*XX(139)-JVS(1003)*XX(148)-JVS(1348)*XX(171)-JVS(1377)*XX(173)-JVS(1448)*XX(177)&
              &-JVS(1540)*XX(182)-JVS(1626)*XX(187)-JVS(1726)*XX(191)-JVS(1817)*XX(194)-JVS(1879)*XX(195)-JVS(1964)*XX(196)&
              &-JVS(1986)*XX(197)-JVS(2026)*XX(198)-JVS(2061)*XX(199)-JVS(2081)*XX(200)-JVS(2108)*XX(201)-JVS(2169)*XX(202)&
              &-JVS(2223)*XX(203)-JVS(2335)*XX(204)-JVS(2481)*XX(205)-JVS(2530)*XX(206)-JVS(2596)*XX(207)-JVS(2675)*XX(208)&
              &-JVS(2779)*XX(209)-JVS(2856)*XX(210))/(JVS(2921))
  XX(212) = (X(212)-JVS(37)*XX(5)-JVS(67)*XX(10)-JVS(79)*XX(14)-JVS(262)*XX(32)-JVS(310)*XX(33)-JVS(451)*XX(65)-JVS(466)&
              &*XX(70)-JVS(493)*XX(76)-JVS(541)*XX(87)-JVS(580)*XX(94)-JVS(659)*XX(108)-JVS(689)*XX(114)-JVS(708)*XX(117)&
              &-JVS(718)*XX(119)-JVS(722)*XX(120)-JVS(738)*XX(123)-JVS(765)*XX(127)-JVS(769)*XX(128)-JVS(786)*XX(130)&
              &-JVS(843)*XX(136)-JVS(879)*XX(139)-JVS(899)*XX(140)-JVS(905)*XX(141)-JVS(937)*XX(143)-JVS(946)*XX(144)&
              &-JVS(958)*XX(145)-JVS(996)*XX(147)-JVS(1054)*XX(152)-JVS(1061)*XX(153)-JVS(1068)*XX(154)-JVS(1083)*XX(156)&
              &-JVS(1127)*XX(160)-JVS(1151)*XX(161)-JVS(1181)*XX(163)-JVS(1242)*XX(164)-JVS(1255)*XX(165)-JVS(1276)*XX(167)&
              &-JVS(1288)*XX(168)-JVS(1297)*XX(169)-JVS(1349)*XX(171)-JVS(1365)*XX(172)-JVS(1378)*XX(173)-JVS(1388)*XX(174)&
              &-JVS(1411)*XX(175)-JVS(1423)*XX(176)-JVS(1478)*XX(180)-JVS(1491)*XX(181)-JVS(1541)*XX(182)-JVS(1549)*XX(183)&
              &-JVS(1564)*XX(184)-JVS(1587)*XX(185)-JVS(1610)*XX(186)-JVS(1627)*XX(187)-JVS(1644)*XX(188)-JVS(1658)*XX(189)&
              &-JVS(1672)*XX(190)-JVS(1727)*XX(191)-JVS(1740)*XX(192)-JVS(1762)*XX(193)-JVS(1818)*XX(194)-JVS(1880)*XX(195)&
              &-JVS(1965)*XX(196)-JVS(1987)*XX(197)-JVS(2027)*XX(198)-JVS(2062)*XX(199)-JVS(2082)*XX(200)-JVS(2109)*XX(201)&
              &-JVS(2170)*XX(202)-JVS(2224)*XX(203)-JVS(2336)*XX(204)-JVS(2482)*XX(205)-JVS(2531)*XX(206)-JVS(2597)*XX(207)&
              &-JVS(2676)*XX(208)-JVS(2780)*XX(209)-JVS(2857)*XX(210)-JVS(2922)*XX(211))/(JVS(3002))
  XX(213) = (X(213)-JVS(197)*XX(31)-JVS(497)*XX(77)-JVS(696)*XX(115)-JVS(1350)*XX(171)-JVS(1611)*XX(186)-JVS(1881)&
              &*XX(195)-JVS(1966)*XX(196)-JVS(2063)*XX(199)-JVS(2171)*XX(202)-JVS(2225)*XX(203)-JVS(2337)*XX(204)-JVS(2483)&
              &*XX(205)-JVS(2532)*XX(206)-JVS(2598)*XX(207)-JVS(2677)*XX(208)-JVS(2781)*XX(209)-JVS(2858)*XX(210)-JVS(2923)&
              &*XX(211)-JVS(3003)*XX(212))/(JVS(3029))
  XX(213) = XX(213)
  XX(212) = XX(212)-JVS(3028)*XX(213)
  XX(211) = XX(211)-JVS(3001)*XX(212)-JVS(3027)*XX(213)
  XX(210) = XX(210)-JVS(2920)*XX(211)-JVS(3000)*XX(212)-JVS(3026)*XX(213)
  XX(209) = XX(209)-JVS(2854)*XX(210)-JVS(2919)*XX(211)-JVS(2999)*XX(212)-JVS(3025)*XX(213)
  XX(208) = XX(208)-JVS(2776)*XX(209)-JVS(2853)*XX(210)-JVS(2918)*XX(211)-JVS(2998)*XX(212)-JVS(3024)*XX(213)
  XX(207) = XX(207)-JVS(2671)*XX(208)-JVS(2775)*XX(209)-JVS(2852)*XX(210)-JVS(2917)*XX(211)-JVS(2997)*XX(212)-JVS(3023)&
              &*XX(213)
  XX(206) = XX(206)-JVS(2591)*XX(207)-JVS(2670)*XX(208)-JVS(2774)*XX(209)-JVS(2851)*XX(210)-JVS(2916)*XX(211)-JVS(2996)&
              &*XX(212)-JVS(3022)*XX(213)
  XX(205) = XX(205)-JVS(2524)*XX(206)-JVS(2590)*XX(207)-JVS(2669)*XX(208)-JVS(2773)*XX(209)-JVS(2850)*XX(210)-JVS(2915)&
              &*XX(211)-JVS(2995)*XX(212)-JVS(3021)*XX(213)
  XX(204) = XX(204)-JVS(2474)*XX(205)-JVS(2523)*XX(206)-JVS(2589)*XX(207)-JVS(2668)*XX(208)-JVS(2772)*XX(209)-JVS(2849)&
              &*XX(210)-JVS(2914)*XX(211)-JVS(2994)*XX(212)-JVS(3020)*XX(213)
  XX(203) = XX(203)-JVS(2327)*XX(204)-JVS(2473)*XX(205)-JVS(2522)*XX(206)-JVS(2588)*XX(207)-JVS(2667)*XX(208)-JVS(2771)&
              &*XX(209)-JVS(2848)*XX(210)-JVS(2913)*XX(211)-JVS(2993)*XX(212)-JVS(3019)*XX(213)
  XX(202) = XX(202)-JVS(2214)*XX(203)-JVS(2326)*XX(204)-JVS(2472)*XX(205)-JVS(2521)*XX(206)-JVS(2587)*XX(207)-JVS(2666)&
              &*XX(208)-JVS(2770)*XX(209)-JVS(2847)*XX(210)-JVS(2912)*XX(211)-JVS(2992)*XX(212)-JVS(3018)*XX(213)
  XX(201) = XX(201)-JVS(2159)*XX(202)-JVS(2213)*XX(203)-JVS(2325)*XX(204)-JVS(2471)*XX(205)-JVS(2520)*XX(206)-JVS(2586)&
              &*XX(207)-JVS(2665)*XX(208)-JVS(2769)*XX(209)-JVS(2846)*XX(210)-JVS(2911)*XX(211)-JVS(2991)*XX(212)-JVS(3017)&
              &*XX(213)
  XX(200) = XX(200)-JVS(2097)*XX(201)-JVS(2158)*XX(202)-JVS(2212)*XX(203)-JVS(2324)*XX(204)-JVS(2470)*XX(205)-JVS(2519)&
              &*XX(206)-JVS(2585)*XX(207)-JVS(2664)*XX(208)-JVS(2768)*XX(209)-JVS(2845)*XX(210)-JVS(2910)*XX(211)-JVS(2990)&
              &*XX(212)-JVS(3016)*XX(213)
  XX(199) = XX(199)-JVS(2157)*XX(202)-JVS(2211)*XX(203)-JVS(2323)*XX(204)-JVS(2469)*XX(205)-JVS(2518)*XX(206)-JVS(2584)&
              &*XX(207)-JVS(2663)*XX(208)-JVS(2767)*XX(209)-JVS(2844)*XX(210)-JVS(2909)*XX(211)-JVS(2989)*XX(212)
  XX(198) = XX(198)-JVS(2048)*XX(199)-JVS(2156)*XX(202)-JVS(2210)*XX(203)-JVS(2322)*XX(204)-JVS(2468)*XX(205)-JVS(2517)&
              &*XX(206)-JVS(2583)*XX(207)-JVS(2662)*XX(208)-JVS(2766)*XX(209)-JVS(2843)*XX(210)-JVS(2908)*XX(211)-JVS(2988)&
              &*XX(212)-JVS(3015)*XX(213)
  XX(197) = XX(197)-JVS(2014)*XX(198)-JVS(2047)*XX(199)-JVS(2096)*XX(201)-JVS(2155)*XX(202)-JVS(2209)*XX(203)-JVS(2321)&
              &*XX(204)-JVS(2467)*XX(205)-JVS(2516)*XX(206)-JVS(2582)*XX(207)-JVS(2661)*XX(208)-JVS(2765)*XX(209)-JVS(2842)&
              &*XX(210)-JVS(2907)*XX(211)-JVS(2987)*XX(212)-JVS(3014)*XX(213)
  XX(196) = XX(196)-JVS(2208)*XX(203)-JVS(2320)*XX(204)-JVS(2466)*XX(205)-JVS(2515)*XX(206)-JVS(2581)*XX(207)-JVS(2660)&
              &*XX(208)-JVS(2764)*XX(209)-JVS(2841)*XX(210)-JVS(2906)*XX(211)-JVS(2986)*XX(212)
  XX(195) = XX(195)-JVS(1948)*XX(196)-JVS(2207)*XX(203)-JVS(2319)*XX(204)-JVS(2465)*XX(205)-JVS(2514)*XX(206)-JVS(2580)&
              &*XX(207)-JVS(2659)*XX(208)-JVS(2763)*XX(209)-JVS(2840)*XX(210)-JVS(2985)*XX(212)
  XX(194) = XX(194)-JVS(1947)*XX(196)-JVS(2046)*XX(199)-JVS(2154)*XX(202)-JVS(2206)*XX(203)-JVS(2318)*XX(204)-JVS(2464)&
              &*XX(205)-JVS(2579)*XX(207)-JVS(2658)*XX(208)-JVS(2762)*XX(209)-JVS(2905)*XX(211)-JVS(2984)*XX(212)-JVS(3013)&
              &*XX(213)
  XX(193) = XX(193)-JVS(1802)*XX(194)-JVS(1862)*XX(195)-JVS(1946)*XX(196)-JVS(2013)*XX(198)-JVS(2045)*XX(199)-JVS(2153)&
              &*XX(202)-JVS(2205)*XX(203)-JVS(2317)*XX(204)-JVS(2463)*XX(205)-JVS(2513)*XX(206)-JVS(2578)*XX(207)-JVS(2657)&
              &*XX(208)-JVS(2761)*XX(209)-JVS(2839)*XX(210)-JVS(2904)*XX(211)-JVS(2983)*XX(212)-JVS(3012)*XX(213)
  XX(192) = XX(192)-JVS(1751)*XX(193)-JVS(1801)*XX(194)-JVS(1861)*XX(195)-JVS(1945)*XX(196)-JVS(1975)*XX(197)-JVS(2012)&
              &*XX(198)-JVS(2044)*XX(199)-JVS(2070)*XX(200)-JVS(2095)*XX(201)-JVS(2152)*XX(202)-JVS(2204)*XX(203)-JVS(2316)&
              &*XX(204)-JVS(2462)*XX(205)-JVS(2512)*XX(206)-JVS(2577)*XX(207)-JVS(2656)*XX(208)-JVS(2760)*XX(209)-JVS(2838)&
              &*XX(210)-JVS(2903)*XX(211)-JVS(2982)*XX(212)-JVS(3011)*XX(213)
  XX(191) = XX(191)-JVS(1860)*XX(195)-JVS(1944)*XX(196)-JVS(2151)*XX(202)-JVS(2315)*XX(204)-JVS(2461)*XX(205)-JVS(2576)&
              &*XX(207)-JVS(2759)*XX(209)-JVS(2837)*XX(210)-JVS(2902)*XX(211)-JVS(2981)*XX(212)
  XX(190) = XX(190)-JVS(1709)*XX(191)-JVS(1750)*XX(193)-JVS(1800)*XX(194)-JVS(1859)*XX(195)-JVS(1943)*XX(196)-JVS(1974)&
              &*XX(197)-JVS(2011)*XX(198)-JVS(2043)*XX(199)-JVS(2069)*XX(200)-JVS(2094)*XX(201)-JVS(2150)*XX(202)-JVS(2203)&
              &*XX(203)-JVS(2314)*XX(204)-JVS(2460)*XX(205)-JVS(2511)*XX(206)-JVS(2575)*XX(207)-JVS(2655)*XX(208)-JVS(2758)&
              &*XX(209)-JVS(2836)*XX(210)-JVS(2901)*XX(211)-JVS(2980)*XX(212)-JVS(3010)*XX(213)
  XX(189) = XX(189)-JVS(1708)*XX(191)-JVS(1799)*XX(194)-JVS(1858)*XX(195)-JVS(1942)*XX(196)-JVS(2042)*XX(199)-JVS(2093)&
              &*XX(201)-JVS(2149)*XX(202)-JVS(2202)*XX(203)-JVS(2313)*XX(204)-JVS(2459)*XX(205)-JVS(2510)*XX(206)-JVS(2574)&
              &*XX(207)-JVS(2654)*XX(208)-JVS(2757)*XX(209)-JVS(2835)*XX(210)-JVS(2900)*XX(211)-JVS(2979)*XX(212)
  XX(188) = XX(188)-JVS(1707)*XX(191)-JVS(1857)*XX(195)-JVS(1941)*XX(196)-JVS(2148)*XX(202)-JVS(2201)*XX(203)-JVS(2312)&
              &*XX(204)-JVS(2458)*XX(205)-JVS(2509)*XX(206)-JVS(2573)*XX(207)-JVS(2653)*XX(208)-JVS(2756)*XX(209)-JVS(2834)&
              &*XX(210)-JVS(2899)*XX(211)-JVS(2978)*XX(212)
  XX(187) = XX(187)-JVS(1706)*XX(191)-JVS(1798)*XX(194)-JVS(1856)*XX(195)-JVS(1940)*XX(196)-JVS(2010)*XX(198)-JVS(2147)&
              &*XX(202)-JVS(2311)*XX(204)-JVS(2457)*XX(205)-JVS(2572)*XX(207)-JVS(2652)*XX(208)-JVS(2755)*XX(209)-JVS(2833)&
              &*XX(210)-JVS(2898)*XX(211)-JVS(2977)*XX(212)
  XX(186) = XX(186)-JVS(1855)*XX(195)-JVS(1939)*XX(196)-JVS(2200)*XX(203)-JVS(2310)*XX(204)-JVS(2456)*XX(205)-JVS(2508)&
              &*XX(206)-JVS(2571)*XX(207)-JVS(2651)*XX(208)-JVS(2754)*XX(209)-JVS(2832)*XX(210)-JVS(2976)*XX(212)
  XX(185) = XX(185)-JVS(1631)*XX(188)-JVS(1749)*XX(193)-JVS(1797)*XX(194)-JVS(1854)*XX(195)-JVS(1938)*XX(196)-JVS(2009)&
              &*XX(198)-JVS(2041)*XX(199)-JVS(2146)*XX(202)-JVS(2309)*XX(204)-JVS(2455)*XX(205)-JVS(2570)*XX(207)-JVS(2650)&
              &*XX(208)-JVS(2753)*XX(209)-JVS(2831)*XX(210)-JVS(3009)*XX(213)
  XX(184) = XX(184)-JVS(1575)*XX(185)-JVS(1705)*XX(191)-JVS(1796)*XX(194)-JVS(1853)*XX(195)-JVS(1937)*XX(196)-JVS(2008)&
              &*XX(198)-JVS(2092)*XX(201)-JVS(2145)*XX(202)-JVS(2199)*XX(203)-JVS(2308)*XX(204)-JVS(2454)*XX(205)-JVS(2569)&
              &*XX(207)-JVS(2649)*XX(208)-JVS(2752)*XX(209)-JVS(2830)*XX(210)-JVS(2897)*XX(211)-JVS(2975)*XX(212)
  XX(183) = XX(183)-JVS(1663)*XX(190)-JVS(1704)*XX(191)-JVS(1748)*XX(193)-JVS(1795)*XX(194)-JVS(1852)*XX(195)-JVS(1936)&
              &*XX(196)-JVS(2007)*XX(198)-JVS(2040)*XX(199)-JVS(2144)*XX(202)-JVS(2198)*XX(203)-JVS(2307)*XX(204)-JVS(2453)&
              &*XX(205)-JVS(2568)*XX(207)-JVS(2648)*XX(208)-JVS(2751)*XX(209)-JVS(2829)*XX(210)-JVS(2896)*XX(211)-JVS(2974)&
              &*XX(212)-JVS(3008)*XX(213)
  XX(182) = XX(182)-JVS(2143)*XX(202)-JVS(2306)*XX(204)-JVS(2452)*XX(205)-JVS(2750)*XX(209)-JVS(2895)*XX(211)-JVS(2973)&
              &*XX(212)
  XX(181) = XX(181)-JVS(1703)*XX(191)-JVS(1794)*XX(194)-JVS(1851)*XX(195)-JVS(1935)*XX(196)-JVS(2006)*XX(198)-JVS(2142)&
              &*XX(202)-JVS(2197)*XX(203)-JVS(2305)*XX(204)-JVS(2451)*XX(205)-JVS(2567)*XX(207)-JVS(2647)*XX(208)-JVS(2749)&
              &*XX(209)-JVS(2828)*XX(210)-JVS(2894)*XX(211)-JVS(2972)*XX(212)
  XX(180) = XX(180)-JVS(1517)*XX(182)-JVS(1793)*XX(194)-JVS(1850)*XX(195)-JVS(1934)*XX(196)-JVS(2005)*XX(198)-JVS(2141)&
              &*XX(202)-JVS(2304)*XX(204)-JVS(2450)*XX(205)-JVS(2566)*XX(207)-JVS(2646)*XX(208)-JVS(2748)*XX(209)-JVS(2827)&
              &*XX(210)-JVS(2893)*XX(211)-JVS(2971)*XX(212)
  XX(179) = XX(179)-JVS(1516)*XX(182)-JVS(1574)*XX(185)-JVS(1702)*XX(191)-JVS(1792)*XX(194)-JVS(1849)*XX(195)-JVS(1933)&
              &*XX(196)-JVS(2004)*XX(198)-JVS(2140)*XX(202)-JVS(2196)*XX(203)-JVS(2303)*XX(204)-JVS(2449)*XX(205)-JVS(2565)&
              &*XX(207)-JVS(2645)*XX(208)-JVS(2747)*XX(209)-JVS(2826)*XX(210)-JVS(2892)*XX(211)-JVS(2970)*XX(212)
  XX(178) = XX(178)-JVS(1515)*XX(182)-JVS(1554)*XX(184)-JVS(1573)*XX(185)-JVS(1701)*XX(191)-JVS(1747)*XX(193)-JVS(1791)&
              &*XX(194)-JVS(1848)*XX(195)-JVS(1932)*XX(196)-JVS(2039)*XX(199)-JVS(2139)*XX(202)-JVS(2195)*XX(203)-JVS(2302)&
              &*XX(204)-JVS(2448)*XX(205)-JVS(2564)*XX(207)-JVS(2644)*XX(208)-JVS(2746)*XX(209)-JVS(2825)*XX(210)-JVS(2891)&
              &*XX(211)-JVS(2969)*XX(212)
  XX(177) = XX(177)-JVS(1847)*XX(195)-JVS(1931)*XX(196)-JVS(2301)*XX(204)-JVS(2447)*XX(205)-JVS(2745)*XX(209)-JVS(2824)&
              &*XX(210)-JVS(2890)*XX(211)-JVS(2968)*XX(212)
  XX(176) = XX(176)-JVS(1514)*XX(182)-JVS(1700)*XX(191)-JVS(1746)*XX(193)-JVS(1790)*XX(194)-JVS(1846)*XX(195)-JVS(1930)&
              &*XX(196)-JVS(2003)*XX(198)-JVS(2038)*XX(199)-JVS(2138)*XX(202)-JVS(2300)*XX(204)-JVS(2446)*XX(205)-JVS(2563)&
              &*XX(207)-JVS(2643)*XX(208)-JVS(2744)*XX(209)-JVS(2823)*XX(210)
  XX(175) = XX(175)-JVS(1595)*XX(186)-JVS(1845)*XX(195)-JVS(2194)*XX(203)-JVS(2445)*XX(205)-JVS(2507)*XX(206)-JVS(2743)&
              &*XX(209)-JVS(2822)*XX(210)-JVS(2967)*XX(212)
  XX(174) = XX(174)-JVS(1572)*XX(185)-JVS(1630)*XX(188)-JVS(1699)*XX(191)-JVS(1789)*XX(194)-JVS(1844)*XX(195)-JVS(1929)&
              &*XX(196)-JVS(2002)*XX(198)-JVS(2137)*XX(202)-JVS(2193)*XX(203)-JVS(2299)*XX(204)-JVS(2444)*XX(205)-JVS(2562)&
              &*XX(207)-JVS(2642)*XX(208)-JVS(2742)*XX(209)-JVS(2821)*XX(210)-JVS(2966)*XX(212)
  XX(173) = XX(173)-JVS(1843)*XX(195)-JVS(1928)*XX(196)-JVS(2091)*XX(201)-JVS(2298)*XX(204)-JVS(2443)*XX(205)-JVS(2641)&
              &*XX(208)-JVS(2741)*XX(209)-JVS(2820)*XX(210)-JVS(2889)*XX(211)-JVS(2965)*XX(212)
  XX(172) = XX(172)-JVS(1927)*XX(196)-JVS(2037)*XX(199)-JVS(2136)*XX(202)-JVS(2192)*XX(203)-JVS(2297)*XX(204)-JVS(2442)&
              &*XX(205)-JVS(2561)*XX(207)-JVS(2640)*XX(208)-JVS(2740)*XX(209)-JVS(3007)*XX(213)
  XX(171) = XX(171)-JVS(1842)*XX(195)-JVS(2441)*XX(205)-JVS(2560)*XX(207)-JVS(2819)*XX(210)
  XX(170) = XX(170)-JVS(1322)*XX(171)-JVS(1571)*XX(185)-JVS(1745)*XX(193)-JVS(1788)*XX(194)-JVS(1926)*XX(196)-JVS(2036)&
              &*XX(199)-JVS(2135)*XX(202)-JVS(2296)*XX(204)-JVS(2440)*XX(205)-JVS(2559)*XX(207)-JVS(2639)*XX(208)-JVS(2739)&
              &*XX(209)
  XX(169) = XX(169)-JVS(1570)*XX(185)-JVS(1647)*XX(189)-JVS(1698)*XX(191)-JVS(1787)*XX(194)-JVS(1925)*XX(196)-JVS(1973)&
              &*XX(197)-JVS(2001)*XX(198)-JVS(2134)*XX(202)-JVS(2191)*XX(203)-JVS(2295)*XX(204)-JVS(2439)*XX(205)-JVS(2558)&
              &*XX(207)-JVS(2638)*XX(208)-JVS(2738)*XX(209)-JVS(2964)*XX(212)
  XX(168) = XX(168)-JVS(1697)*XX(191)-JVS(1786)*XX(194)-JVS(1924)*XX(196)-JVS(2000)*XX(198)-JVS(2133)*XX(202)-JVS(2190)&
              &*XX(203)-JVS(2294)*XX(204)-JVS(2438)*XX(205)-JVS(2557)*XX(207)-JVS(2637)*XX(208)-JVS(2737)*XX(209)-JVS(2963)&
              &*XX(212)
  XX(167) = XX(167)-JVS(1280)*XX(168)-JVS(1696)*XX(191)-JVS(1785)*XX(194)-JVS(1923)*XX(196)-JVS(1999)*XX(198)-JVS(2132)&
              &*XX(202)-JVS(2189)*XX(203)-JVS(2293)*XX(204)-JVS(2437)*XX(205)-JVS(2556)*XX(207)-JVS(2636)*XX(208)-JVS(2736)&
              &*XX(209)-JVS(2962)*XX(212)
  XX(166) = XX(166)-JVS(1300)*XX(170)-JVS(1321)*XX(171)-JVS(1432)*XX(177)-JVS(1513)*XX(182)-JVS(1695)*XX(191)-JVS(1784)&
              &*XX(194)-JVS(1841)*XX(195)-JVS(1922)*XX(196)-JVS(2131)*XX(202)-JVS(2292)*XX(204)-JVS(2436)*XX(205)-JVS(2555)&
              &*XX(207)-JVS(2635)*XX(208)-JVS(2735)*XX(209)-JVS(2818)*XX(210)-JVS(2888)*XX(211)-JVS(2961)*XX(212)
  XX(165) = XX(165)-JVS(1395)*XX(175)-JVS(1594)*XX(186)-JVS(1840)*XX(195)-JVS(2188)*XX(203)-JVS(2291)*XX(204)-JVS(2435)&
              &*XX(205)-JVS(2506)*XX(206)-JVS(2634)*XX(208)-JVS(2734)*XX(209)-JVS(2817)*XX(210)-JVS(2960)*XX(212)
  XX(164) = XX(164)-JVS(2434)*XX(205)-JVS(2733)*XX(209)-JVS(2959)*XX(212)
  XX(163) = XX(163)-JVS(1207)*XX(164)-JVS(1245)*XX(165)-JVS(1394)*XX(175)-JVS(1593)*XX(186)-JVS(1839)*XX(195)-JVS(2187)&
              &*XX(203)-JVS(2290)*XX(204)-JVS(2433)*XX(205)-JVS(2505)*XX(206)-JVS(2633)*XX(208)-JVS(2732)*XX(209)-JVS(2816)&
              &*XX(210)-JVS(2958)*XX(212)
  XX(162) = XX(162)-JVS(1206)*XX(164)-JVS(1393)*XX(175)-JVS(1592)*XX(186)-JVS(1838)*XX(195)-JVS(2186)*XX(203)-JVS(2432)&
              &*XX(205)-JVS(2504)*XX(206)-JVS(2731)*XX(209)-JVS(2815)*XX(210)-JVS(2957)*XX(212)
  XX(161) = XX(161)-JVS(1172)*XX(163)-JVS(1205)*XX(164)-JVS(1244)*XX(165)-JVS(2185)*XX(203)-JVS(2289)*XX(204)-JVS(2431)&
              &*XX(205)-JVS(2503)*XX(206)-JVS(2632)*XX(208)-JVS(2730)*XX(209)-JVS(2814)*XX(210)-JVS(2956)*XX(212)
  XX(160) = XX(160)-JVS(1204)*XX(164)-JVS(1320)*XX(171)-JVS(1694)*XX(191)-JVS(1783)*XX(194)-JVS(1921)*XX(196)-JVS(1998)&
              &*XX(198)-JVS(2130)*XX(202)-JVS(2288)*XX(204)-JVS(2430)*XX(205)-JVS(2554)*XX(207)-JVS(2631)*XX(208)-JVS(2729)&
              &*XX(209)
  XX(159) = XX(159)-JVS(1203)*XX(164)-JVS(1319)*XX(171)-JVS(1512)*XX(182)-JVS(1693)*XX(191)-JVS(1837)*XX(195)-JVS(1920)&
              &*XX(196)-JVS(2287)*XX(204)-JVS(2429)*XX(205)-JVS(2630)*XX(208)-JVS(2728)*XX(209)-JVS(2813)*XX(210)-JVS(2887)&
              &*XX(211)-JVS(2955)*XX(212)
  XX(158) = XX(158)-JVS(1318)*XX(171)-JVS(1629)*XX(188)-JVS(1782)*XX(194)-JVS(1919)*XX(196)-JVS(2129)*XX(202)-JVS(2286)&
              &*XX(204)-JVS(2428)*XX(205)-JVS(2553)*XX(207)-JVS(2629)*XX(208)-JVS(2727)*XX(209)
  XX(157) = XX(157)-JVS(1317)*XX(171)-JVS(1511)*XX(182)-JVS(1692)*XX(191)-JVS(1918)*XX(196)-JVS(2128)*XX(202)-JVS(2285)&
              &*XX(204)-JVS(2427)*XX(205)-JVS(2552)*XX(207)-JVS(2628)*XX(208)-JVS(2726)*XX(209)
  XX(156) = XX(156)-JVS(1366)*XX(173)-JVS(1468)*XX(180)-JVS(1614)*XX(187)-JVS(1646)*XX(189)-JVS(1662)*XX(190)-JVS(1691)&
              &*XX(191)-JVS(1731)*XX(192)-JVS(1836)*XX(195)-JVS(1917)*XX(196)-JVS(1972)*XX(197)-JVS(2068)*XX(200)-JVS(2090)&
              &*XX(201)-JVS(2127)*XX(202)-JVS(2184)*XX(203)-JVS(2284)*XX(204)-JVS(2426)*XX(205)-JVS(2551)*XX(207)-JVS(2627)&
              &*XX(208)-JVS(2725)*XX(209)-JVS(2812)*XX(210)-JVS(2886)*XX(211)-JVS(2954)*XX(212)
  XX(155) = XX(155)-JVS(1316)*XX(171)-JVS(1690)*XX(191)-JVS(1781)*XX(194)-JVS(1916)*XX(196)-JVS(2035)*XX(199)-JVS(2126)&
              &*XX(202)-JVS(2283)*XX(204)-JVS(2425)*XX(205)-JVS(2550)*XX(207)-JVS(2626)*XX(208)-JVS(2724)*XX(209)
  XX(154) = XX(154)-JVS(1353)*XX(172)-JVS(1510)*XX(182)-JVS(1689)*XX(191)-JVS(1915)*XX(196)-JVS(2034)*XX(199)-JVS(2125)&
              &*XX(202)-JVS(2183)*XX(203)-JVS(2282)*XX(204)-JVS(2424)*XX(205)-JVS(2549)*XX(207)-JVS(2625)*XX(208)-JVS(2723)&
              &*XX(209)-JVS(2885)*XX(211)-JVS(2953)*XX(212)
  XX(153) = XX(153)-JVS(1118)*XX(160)-JVS(1315)*XX(171)-JVS(1481)*XX(181)-JVS(1509)*XX(182)-JVS(1744)*XX(193)-JVS(1780)&
              &*XX(194)-JVS(1914)*XX(196)-JVS(2124)*XX(202)-JVS(2281)*XX(204)-JVS(2423)*XX(205)-JVS(2548)*XX(207)-JVS(2624)&
              &*XX(208)-JVS(2722)*XX(209)-JVS(2884)*XX(211)
  XX(152) = XX(152)-JVS(1508)*XX(182)-JVS(1913)*XX(196)-JVS(2422)*XX(205)-JVS(2547)*XX(207)-JVS(2721)*XX(209)-JVS(2883)&
              &*XX(211)
  XX(151) = XX(151)-JVS(1314)*XX(171)-JVS(1779)*XX(194)-JVS(1912)*XX(196)-JVS(2123)*XX(202)-JVS(2280)*XX(204)-JVS(2421)&
              &*XX(205)-JVS(2546)*XX(207)-JVS(2623)*XX(208)-JVS(2720)*XX(209)
  XX(150) = XX(150)-JVS(1202)*XX(164)-JVS(1431)*XX(177)-JVS(1507)*XX(182)-JVS(1835)*XX(195)-JVS(1911)*XX(196)-JVS(2122)&
              &*XX(202)-JVS(2279)*XX(204)-JVS(2420)*XX(205)-JVS(2719)*XX(209)-JVS(2811)*XX(210)-JVS(2952)*XX(212)
  XX(149) = XX(149)-JVS(1014)*XX(150)-JVS(1108)*XX(159)-JVS(1201)*XX(164)-JVS(1257)*XX(166)-JVS(1299)*XX(170)-JVS(1430)&
              &*XX(177)-JVS(1688)*XX(191)-JVS(1778)*XX(194)-JVS(1910)*XX(196)-JVS(2278)*XX(204)-JVS(2419)*XX(205)-JVS(2622)&
              &*XX(208)-JVS(2718)*XX(209)
  XX(148) = XX(148)-JVS(1613)*XX(187)-JVS(1687)*XX(191)-JVS(1834)*XX(195)-JVS(1909)*XX(196)-JVS(1971)*XX(197)-JVS(2089)&
              &*XX(201)-JVS(2277)*XX(204)-JVS(2418)*XX(205)-JVS(2621)*XX(208)-JVS(2717)*XX(209)-JVS(2810)*XX(210)-JVS(2882)&
              &*XX(211)-JVS(2951)*XX(212)
  XX(147) = XX(147)-JVS(1200)*XX(164)-JVS(1908)*XX(196)-JVS(2276)*XX(204)-JVS(2417)*XX(205)-JVS(2881)*XX(211)-JVS(2950)&
              &*XX(212)
  XX(146) = XX(146)-JVS(983)*XX(147)-JVS(1429)*XX(177)-JVS(1506)*XX(182)-JVS(1686)*XX(191)-JVS(1833)*XX(195)-JVS(1907)&
              &*XX(196)-JVS(2121)*XX(202)-JVS(2275)*XX(204)-JVS(2416)*XX(205)-JVS(2620)*XX(208)-JVS(2716)*XX(209)-JVS(2809)&
              &*XX(210)-JVS(2880)*XX(211)
  XX(145) = XX(145)-JVS(1199)*XX(164)-JVS(1685)*XX(191)-JVS(1777)*XX(194)-JVS(2182)*XX(203)-JVS(2415)*XX(205)-JVS(2715)&
              &*XX(209)-JVS(2949)*XX(212)
  XX(144) = XX(144)-JVS(1039)*XX(152)-JVS(1313)*XX(171)-JVS(1776)*XX(194)-JVS(1906)*XX(196)-JVS(2033)*XX(199)-JVS(2120)&
              &*XX(202)-JVS(2274)*XX(204)-JVS(2414)*XX(205)-JVS(2545)*XX(207)-JVS(2619)*XX(208)-JVS(2714)*XX(209)
  XX(143) = XX(143)-JVS(1392)*XX(175)-JVS(1591)*XX(186)-JVS(1832)*XX(195)-JVS(2413)*XX(205)-JVS(2502)*XX(206)-JVS(2808)&
              &*XX(210)
  XX(142) = XX(142)-JVS(1154)*XX(162)-JVS(1198)*XX(164)-JVS(1391)*XX(175)-JVS(1831)*XX(195)-JVS(2181)*XX(203)-JVS(2412)&
              &*XX(205)-JVS(2501)*XX(206)-JVS(2807)*XX(210)
  XX(141) = XX(141)-JVS(982)*XX(147)-JVS(1038)*XX(152)-JVS(1661)*XX(190)-JVS(1743)*XX(193)-JVS(1775)*XX(194)-JVS(1905)&
              &*XX(196)-JVS(1997)*XX(198)-JVS(2273)*XX(204)-JVS(2411)*XX(205)-JVS(2544)*XX(207)-JVS(2618)*XX(208)-JVS(2713)&
              &*XX(209)-JVS(2948)*XX(212)
  XX(140) = XX(140)-JVS(1830)*XX(195)-JVS(2272)*XX(204)-JVS(2410)*XX(205)-JVS(2806)*XX(210)
  XX(139) = XX(139)-JVS(1829)*XX(195)-JVS(2271)*XX(204)-JVS(2409)*XX(205)-JVS(2805)*XX(210)
  XX(138) = XX(138)-JVS(981)*XX(147)-JVS(1037)*XX(152)-JVS(1660)*XX(190)-JVS(1742)*XX(193)-JVS(1774)*XX(194)-JVS(1904)&
              &*XX(196)-JVS(1996)*XX(198)-JVS(2270)*XX(204)-JVS(2408)*XX(205)-JVS(2543)*XX(207)-JVS(2617)*XX(208)-JVS(2712)&
              &*XX(209)
  XX(137) = XX(137)-JVS(882)*XX(140)-JVS(965)*XX(146)-JVS(1005)*XX(149)-JVS(1013)*XX(150)-JVS(1036)*XX(152)-JVS(1107)&
              &*XX(159)-JVS(1197)*XX(164)-JVS(1553)*XX(184)-JVS(1903)*XX(196)-JVS(2180)*XX(203)-JVS(2269)*XX(204)-JVS(2407)&
              &*XX(205)-JVS(2711)*XX(209)-JVS(2879)*XX(211)
  XX(136) = XX(136)-JVS(1196)*XX(164)-JVS(1684)*XX(191)-JVS(1995)*XX(198)-JVS(2406)*XX(205)-JVS(2710)*XX(209)-JVS(2947)&
              &*XX(212)
  XX(135) = XX(135)-JVS(862)*XX(139)-JVS(1505)*XX(182)-JVS(2088)*XX(201)-JVS(2119)*XX(202)-JVS(2542)*XX(207)-JVS(2616)&
              &*XX(208)-JVS(2709)*XX(209)-JVS(2878)*XX(211)-JVS(2946)*XX(212)
  XX(134) = XX(134)-JVS(1773)*XX(194)-JVS(2268)*XX(204)-JVS(2405)*XX(205)
  XX(133) = XX(133)-JVS(881)*XX(140)-JVS(1312)*XX(171)-JVS(1504)*XX(182)-JVS(1683)*XX(191)-JVS(1902)*XX(196)-JVS(2267)&
              &*XX(204)-JVS(2404)*XX(205)-JVS(2615)*XX(208)-JVS(2708)*XX(209)-JVS(2945)*XX(212)
  XX(132) = XX(132)-JVS(861)*XX(139)-JVS(1503)*XX(182)-JVS(2087)*XX(201)-JVS(2614)*XX(208)-JVS(2707)*XX(209)-JVS(2877)&
              &*XX(211)-JVS(2944)*XX(212)
  XX(131) = XX(131)-JVS(860)*XX(139)-JVS(1428)*XX(177)-JVS(1682)*XX(191)-JVS(2086)*XX(201)-JVS(2613)*XX(208)-JVS(2706)&
              &*XX(209)-JVS(2876)*XX(211)-JVS(2943)*XX(212)
  XX(130) = XX(130)-JVS(1141)*XX(161)-JVS(1171)*XX(163)-JVS(1195)*XX(164)-JVS(2403)*XX(205)-JVS(2500)*XX(206)-JVS(2705)&
              &*XX(209)-JVS(2804)*XX(210)-JVS(2942)*XX(212)
  XX(129) = XX(129)-JVS(859)*XX(139)-JVS(1311)*XX(171)-JVS(2032)*XX(199)-JVS(2085)*XX(201)-JVS(2612)*XX(208)-JVS(2704)&
              &*XX(209)-JVS(2875)*XX(211)-JVS(2941)*XX(212)
  XX(128) = XX(128)-JVS(858)*XX(139)-JVS(880)*XX(140)-JVS(1267)*XX(167)-JVS(1279)*XX(168)-JVS(1289)*XX(169)-JVS(1414)&
              &*XX(176)-JVS(1645)*XX(189)-JVS(1901)*XX(196)-JVS(1970)*XX(197)-JVS(2179)*XX(203)-JVS(2266)*XX(204)-JVS(2402)&
              &*XX(205)-JVS(2874)*XX(211)-JVS(2940)*XX(212)-JVS(3006)*XX(213)
  XX(127) = XX(127)-JVS(1681)*XX(191)-JVS(1900)*XX(196)-JVS(2118)*XX(202)-JVS(2265)*XX(204)-JVS(2401)*XX(205)-JVS(2541)&
              &*XX(207)-JVS(2703)*XX(209)-JVS(2873)*XX(211)-JVS(2939)*XX(212)
  XX(126) = XX(126)-JVS(980)*XX(147)-JVS(1194)*XX(164)-JVS(1427)*XX(177)-JVS(1502)*XX(182)-JVS(1569)*XX(185)-JVS(1680)&
              &*XX(191)-JVS(1772)*XX(194)-JVS(2264)*XX(204)-JVS(2400)*XX(205)-JVS(2611)*XX(208)-JVS(2702)*XX(209)
  XX(125) = XX(125)-JVS(857)*XX(139)-JVS(2067)*XX(200)-JVS(2084)*XX(201)-JVS(2610)*XX(208)-JVS(2701)*XX(209)-JVS(2872)&
              &*XX(211)-JVS(2938)*XX(212)
  XX(124) = XX(124)-JVS(1193)*XX(164)-JVS(1568)*XX(185)-JVS(1771)*XX(194)-JVS(2263)*XX(204)-JVS(2399)*XX(205)-JVS(2609)&
              &*XX(208)-JVS(2700)*XX(209)
  XX(123) = XX(123)-JVS(779)*XX(130)-JVS(1140)*XX(161)-JVS(1170)*XX(163)-JVS(1192)*XX(164)-JVS(2499)*XX(206)-JVS(2699)&
              &*XX(209)-JVS(2803)*XX(210)-JVS(2937)*XX(212)
  XX(122) = XX(122)-JVS(909)*XX(142)-JVS(1191)*XX(164)-JVS(1243)*XX(165)-JVS(1828)*XX(195)-JVS(2398)*XX(205)-JVS(2498)&
              &*XX(206)-JVS(2698)*XX(209)-JVS(2802)*XX(210)-JVS(2936)*XX(212)
  XX(121) = XX(121)-JVS(1480)*XX(181)-JVS(1679)*XX(191)-JVS(1899)*XX(196)-JVS(2117)*XX(202)-JVS(2178)*XX(203)-JVS(2397)&
              &*XX(205)-JVS(2697)*XX(209)-JVS(2871)*XX(211)-JVS(2935)*XX(212)
  XX(120) = XX(120)-JVS(856)*XX(139)-JVS(1266)*XX(167)-JVS(1278)*XX(168)-JVS(1380)*XX(174)-JVS(1413)*XX(176)-JVS(1770)&
              &*XX(194)-JVS(1994)*XX(198)-JVS(2177)*XX(203)-JVS(2262)*XX(204)-JVS(2396)*XX(205)-JVS(2870)*XX(211)-JVS(2934)&
              &*XX(212)
  XX(119) = XX(119)-JVS(855)*XX(139)-JVS(1265)*XX(167)-JVS(1277)*XX(168)-JVS(1379)*XX(174)-JVS(1412)*XX(176)-JVS(1769)&
              &*XX(194)-JVS(1993)*XX(198)-JVS(2176)*XX(203)-JVS(2261)*XX(204)-JVS(2395)*XX(205)-JVS(2869)*XX(211)-JVS(2933)&
              &*XX(212)
  XX(118) = XX(118)-JVS(1659)*XX(190)-JVS(1741)*XX(193)-JVS(1768)*XX(194)-JVS(1992)*XX(198)-JVS(2260)*XX(204)-JVS(2394)&
              &*XX(205)-JVS(2696)*XX(209)
  XX(117) = XX(117)-JVS(1190)*XX(164)-JVS(1390)*XX(175)-JVS(1827)*XX(195)-JVS(2393)*XX(205)-JVS(2497)*XX(206)-JVS(2801)&
              &*XX(210)-JVS(2932)*XX(212)-JVS(3005)*XX(213)
  XX(116) = XX(116)-JVS(1898)*XX(196)-JVS(2259)*XX(204)-JVS(2392)*XX(205)-JVS(2695)*XX(209)-JVS(2868)*XX(211)
  XX(115) = XX(115)-JVS(1826)*XX(195)-JVS(2031)*XX(199)-JVS(2258)*XX(204)-JVS(2391)*XX(205)-JVS(2800)*XX(210)
  XX(114) = XX(114)-JVS(1117)*XX(160)-JVS(1479)*XX(181)-JVS(1897)*XX(196)-JVS(2116)*XX(202)-JVS(2390)*XX(205)
  XX(113) = XX(113)-JVS(908)*XX(142)-JVS(1153)*XX(162)-JVS(1189)*XX(164)-JVS(2175)*XX(203)-JVS(2389)*XX(205)-JVS(2496)&
              &*XX(206)-JVS(2799)*XX(210)
  XX(112) = XX(112)-JVS(1004)*XX(149)-JVS(1256)*XX(166)-JVS(1298)*XX(170)-JVS(1767)*XX(194)-JVS(2257)*XX(204)-JVS(2388)&
              &*XX(205)-JVS(2694)*XX(209)
  XX(111) = XX(111)-JVS(907)*XX(142)-JVS(1152)*XX(162)-JVS(1188)*XX(164)-JVS(2174)*XX(203)-JVS(2387)*XX(205)-JVS(2495)&
              &*XX(206)-JVS(2798)*XX(210)
  XX(110) = XX(110)-JVS(964)*XX(146)-JVS(1458)*XX(179)-JVS(1552)*XX(184)-JVS(1730)*XX(192)-JVS(1896)*XX(196)-JVS(1969)&
              &*XX(197)-JVS(2066)*XX(200)-JVS(2256)*XX(204)-JVS(2386)*XX(205)
  XX(109) = XX(109)-JVS(963)*XX(146)-JVS(1457)*XX(179)-JVS(1551)*XX(184)-JVS(1729)*XX(192)-JVS(1895)*XX(196)-JVS(1968)&
              &*XX(197)-JVS(2065)*XX(200)-JVS(2255)*XX(204)-JVS(2385)*XX(205)
  XX(108) = XX(108)-JVS(1187)*XX(164)-JVS(1678)*XX(191)-JVS(2384)*XX(205)-JVS(2693)*XX(209)-JVS(2931)*XX(212)
  XX(107) = XX(107)-JVS(1677)*XX(191)-JVS(1991)*XX(198)-JVS(2254)*XX(204)-JVS(2383)*XX(205)-JVS(2867)*XX(211)
  XX(106) = XX(106)-JVS(739)*XX(124)-JVS(1990)*XX(198)-JVS(2173)*XX(203)-JVS(2253)*XX(204)-JVS(2382)*XX(205)
  XX(105) = XX(105)-JVS(647)*XX(107)-JVS(1426)*XX(177)-JVS(1456)*XX(179)-JVS(1501)*XX(182)-JVS(1676)*XX(191)-JVS(2252)&
              &*XX(204)-JVS(2381)*XX(205)-JVS(2866)*XX(211)
  XX(104) = XX(104)-JVS(924)*XX(143)-JVS(2380)*XX(205)-JVS(2797)*XX(210)
  XX(103) = XX(103)-JVS(1500)*XX(182)-JVS(1894)*XX(196)-JVS(2115)*XX(202)-JVS(2251)*XX(204)-JVS(2379)*XX(205)-JVS(2865)&
              &*XX(211)
  XX(102) = XX(102)-JVS(906)*XX(142)-JVS(2378)*XX(205)-JVS(2494)*XX(206)
  XX(101) = XX(101)-JVS(1425)*XX(177)-JVS(1467)*XX(180)-JVS(1499)*XX(182)-JVS(1893)*XX(196)-JVS(1989)*XX(198)-JVS(2114)&
              &*XX(202)-JVS(2250)*XX(204)-JVS(2377)*XX(205)
  XX(100) = XX(100)-JVS(962)*XX(146)-JVS(1550)*XX(184)-JVS(1728)*XX(192)-JVS(1892)*XX(196)-JVS(1967)*XX(197)-JVS(2064)&
              &*XX(200)-JVS(2249)*XX(204)-JVS(2376)*XX(205)
  XX(99) = XX(99)-JVS(979)*XX(147)-JVS(1498)*XX(182)-JVS(2248)*XX(204)-JVS(2375)*XX(205)-JVS(2608)*XX(208)-JVS(2692)&
             &*XX(209)
  XX(98) = XX(98)-JVS(1612)*XX(187)-JVS(1675)*XX(191)-JVS(1891)*XX(196)-JVS(2247)*XX(204)-JVS(2374)*XX(205)-JVS(2864)&
             &*XX(211)
  XX(97) = XX(97)-JVS(1825)*XX(195)-JVS(1890)*XX(196)-JVS(2246)*XX(204)-JVS(2373)*XX(205)-JVS(2540)*XX(207)-JVS(2796)&
             &*XX(210)
  XX(96) = XX(96)-JVS(1024)*XX(151)-JVS(1096)*XX(158)-JVS(1389)*XX(175)-JVS(1824)*XX(195)-JVS(2372)*XX(205)-JVS(2493)&
             &*XX(206)-JVS(2795)*XX(210)
  XX(95) = XX(95)-JVS(978)*XX(147)-JVS(1497)*XX(182)-JVS(2245)*XX(204)-JVS(2371)*XX(205)-JVS(2607)*XX(208)-JVS(2691)&
             &*XX(209)-JVS(2863)*XX(211)
  XX(94) = XX(94)-JVS(923)*XX(143)-JVS(1186)*XX(164)-JVS(1823)*XX(195)-JVS(2370)*XX(205)-JVS(2690)*XX(209)-JVS(2794)&
             &*XX(210)-JVS(2930)*XX(212)
  XX(93) = XX(93)-JVS(1139)*XX(161)-JVS(1169)*XX(163)-JVS(2369)*XX(205)-JVS(2492)*XX(206)-JVS(2793)*XX(210)
  XX(92) = XX(92)-JVS(2491)*XX(206)-JVS(2792)*XX(210)
  XX(91) = XX(91)-JVS(1084)*XX(157)-JVS(1496)*XX(182)-JVS(1889)*XX(196)-JVS(2113)*XX(202)-JVS(2368)*XX(205)
  XX(90) = XX(90)-JVS(1567)*XX(185)-JVS(1766)*XX(194)-JVS(2244)*XX(204)-JVS(2367)*XX(205)
  XX(89) = XX(89)-JVS(1566)*XX(185)-JVS(1765)*XX(194)-JVS(1988)*XX(198)-JVS(2243)*XX(204)-JVS(2366)*XX(205)
  XX(88) = XX(88)-JVS(599)*XX(99)-JVS(977)*XX(147)-JVS(1424)*XX(177)-JVS(1495)*XX(182)-JVS(1674)*XX(191)-JVS(1888)&
             &*XX(196)-JVS(2112)*XX(202)-JVS(2242)*XX(204)-JVS(2365)*XX(205)-JVS(2862)*XX(211)
  XX(87) = XX(87)-JVS(1185)*XX(164)-JVS(1565)*XX(185)-JVS(1822)*XX(195)-JVS(2364)*XX(205)-JVS(2791)*XX(210)-JVS(2929)&
             &*XX(212)
  XX(86) = XX(86)-JVS(938)*XX(144)-JVS(1035)*XX(152)-JVS(1764)*XX(194)-JVS(2241)*XX(204)-JVS(2363)*XX(205)-JVS(2689)&
             &*XX(209)
  XX(85) = XX(85)-JVS(1069)*XX(155)-JVS(1673)*XX(191)-JVS(1887)*XX(196)-JVS(2030)*XX(199)-JVS(2240)*XX(204)-JVS(2362)&
             &*XX(205)
  XX(84) = XX(84)-JVS(1352)*XX(172)-JVS(2029)*XX(199)-JVS(2239)*XX(204)-JVS(2361)*XX(205)
  XX(83) = XX(83)-JVS(2111)*XX(202)-JVS(2539)*XX(207)-JVS(2688)*XX(209)-JVS(2928)*XX(212)
  XX(82) = XX(82)-JVS(922)*XX(143)-JVS(1590)*XX(186)-JVS(2172)*XX(203)-JVS(2360)*XX(205)
  XX(81) = XX(81)-JVS(627)*XX(104)-JVS(1589)*XX(186)-JVS(2790)*XX(210)
  XX(80) = XX(80)-JVS(778)*XX(130)-JVS(1138)*XX(161)-JVS(2359)*XX(205)-JVS(2490)*XX(206)-JVS(2606)*XX(208)-JVS(2687)&
             &*XX(209)-JVS(2789)*XX(210)
  XX(79) = XX(79)-JVS(921)*XX(143)-JVS(2358)*XX(205)-JVS(2686)*XX(209)-JVS(2788)*XX(210)
  XX(78) = XX(78)-JVS(1821)*XX(195)-JVS(2238)*XX(204)-JVS(2357)*XX(205)-JVS(2538)*XX(207)-JVS(2787)*XX(210)-JVS(2861)&
             &*XX(211)
  XX(77) = XX(77)-JVS(2028)*XX(199)-JVS(2237)*XX(204)-JVS(2356)*XX(205)-JVS(3004)*XX(213)
  XX(76) = XX(76)-JVS(976)*XX(147)-JVS(1494)*XX(182)-JVS(1886)*XX(196)-JVS(2236)*XX(204)-JVS(2605)*XX(208)-JVS(2927)&
             &*XX(212)
  XX(75) = XX(75)-JVS(1095)*XX(158)-JVS(1628)*XX(188)-JVS(2235)*XX(204)-JVS(2355)*XX(205)
  XX(74) = XX(74)-JVS(1023)*XX(151)-JVS(1763)*XX(194)-JVS(2234)*XX(204)-JVS(2354)*XX(205)
  XX(73) = XX(73)-JVS(1137)*XX(161)-JVS(1168)*XX(163)-JVS(2604)*XX(208)-JVS(2685)*XX(209)
  XX(72) = XX(72)-JVS(2233)*XX(204)-JVS(2353)*XX(205)-JVS(2684)*XX(209)-JVS(2926)*XX(212)
  XX(71) = XX(71)-JVS(2352)*XX(205)-JVS(2603)*XX(208)-JVS(2683)*XX(209)
  XX(70) = XX(70)-JVS(1184)*XX(164)-JVS(1885)*XX(196)-JVS(2083)*XX(201)-JVS(2351)*XX(205)-JVS(2537)*XX(207)-JVS(2925)&
             &*XX(212)
  XX(69) = XX(69)-JVS(508)*XX(81)-JVS(920)*XX(143)-JVS(1588)*XX(186)-JVS(2350)*XX(205)-JVS(2786)*XX(210)
  XX(68) = XX(68)-JVS(1820)*XX(195)-JVS(2232)*XX(204)-JVS(2349)*XX(205)-JVS(2785)*XX(210)-JVS(2860)*XX(211)
  XX(67) = XX(67)-JVS(1819)*XX(195)-JVS(2231)*XX(204)-JVS(2348)*XX(205)-JVS(2784)*XX(210)-JVS(2859)*XX(211)
  XX(66) = XX(66)-JVS(1884)*XX(196)-JVS(2230)*XX(204)-JVS(2536)*XX(207)-JVS(2682)*XX(209)-JVS(2924)*XX(212)
  XX(65) = XX(65)-JVS(759)*XX(127)-JVS(2681)*XX(209)
  XX(64) = XX(64)-JVS(1136)*XX(161)-JVS(2783)*XX(210)
  XX(63) = XX(63)-JVS(2110)*XX(202)-JVS(2347)*XX(205)-JVS(2535)*XX(207)
  XX(62) = XX(62)-JVS(2229)*XX(204)-JVS(2602)*XX(208)
  XX(61) = XX(61)-JVS(1183)*XX(164)
  XX(60) = XX(60)-JVS(961)*XX(146)-JVS(2346)*XX(205)
  XX(59) = XX(59)-JVS(960)*XX(146)-JVS(2345)*XX(205)
  XX(58) = XX(58)-JVS(2228)*XX(204)-JVS(2601)*XX(208)
  XX(57) = XX(57)-JVS(2227)*XX(204)-JVS(2600)*XX(208)
  XX(56) = XX(56)-JVS(777)*XX(130)-JVS(1135)*XX(161)-JVS(2599)*XX(208)
  XX(55) = XX(55)-JVS(959)*XX(146)-JVS(2344)*XX(205)
  XX(54) = XX(54)-JVS(1134)*XX(161)-JVS(2489)*XX(206)
  XX(53) = XX(53)-JVS(1133)*XX(161)-JVS(2343)*XX(205)
  XX(52) = XX(52)-JVS(2226)*XX(204)-JVS(2342)*XX(205)-JVS(2488)*XX(206)-JVS(2534)*XX(207)
  XX(51) = XX(51)-JVS(2487)*XX(206)-JVS(2680)*XX(209)
  XX(50) = XX(50)-JVS(401)*XX(57)-JVS(975)*XX(147)-JVS(1493)*XX(182)-JVS(1883)*XX(196)
  XX(49) = XX(49)-JVS(1351)*XX(172)-JVS(2679)*XX(209)
  XX(48) = XX(48)-JVS(802)*XX(133)-JVS(2678)*XX(209)
  XX(47) = XX(47)-JVS(478)*XX(73)-JVS(1167)*XX(163)
  XX(46) = XX(46)-JVS(1132)*XX(161)-JVS(2341)*XX(205)-JVS(2533)*XX(207)
  XX(45) = XX(45)-JVS(406)*XX(58)-JVS(974)*XX(147)-JVS(1882)*XX(196)
  XX(44) = XX(44)-JVS(1182)*XX(164)
  XX(43) = XX(43)-JVS(477)*XX(73)-JVS(1131)*XX(161)-JVS(1166)*XX(163)
  XX(42) = XX(42)-JVS(973)*XX(147)-JVS(1492)*XX(182)-JVS(2340)*XX(205)
  XX(41) = XX(41)-JVS(421)*XX(61)
  XX(40) = XX(40)-JVS(2339)*XX(205)-JVS(2486)*XX(206)
  XX(39) = XX(39)-JVS(2338)*XX(205)-JVS(2485)*XX(206)
  XX(38) = XX(38)-JVS(476)*XX(73)
  XX(37) = XX(37)
  XX(36) = XX(36)
  XX(35) = XX(35)
  XX(34) = XX(34)
  XX(33) = XX(33)
  XX(32) = XX(32)
  XX(31) = XX(31)
  XX(30) = XX(30)
  XX(29) = XX(29)
  XX(28) = XX(28)
  XX(27) = XX(27)
  XX(26) = XX(26)
  XX(25) = XX(25)
  XX(24) = XX(24)
  XX(23) = XX(23)
  XX(22) = XX(22)
  XX(21) = XX(21)
  XX(20) = XX(20)
  XX(19) = XX(19)
  XX(18) = XX(18)
  XX(17) = XX(17)
  XX(16) = XX(16)
  XX(15) = XX(15)
  XX(14) = XX(14)
  XX(13) = XX(13)
  XX(12) = XX(12)
  XX(11) = XX(11)
  XX(10) = XX(10)
  XX(9) = XX(9)
  XX(8) = XX(8)
  XX(7) = XX(7)
  XX(6) = XX(6)
  XX(5) = XX(5)
  XX(4) = XX(4)
  XX(3) = XX(3)-JVS(1130)*XX(161)-JVS(2484)*XX(206)
  XX(2) = XX(2)-JVS(1129)*XX(161)-JVS(2782)*XX(210)
  XX(1) = XX(1)-JVS(1128)*XX(161)
      
END SUBROUTINE KppSolveTR

! End of KppSolveTR function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! BLAS_UTIL - BLAS-LIKE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!--------------------------------------------------------------
!
! BLAS/LAPACK-like subroutines used by the integration algorithms
! It is recommended to replace them by calls to the optimized
!      BLAS/LAPACK library for your machine
!
!  (C) Adrian Sandu, Aug. 2004
!      Virginia Polytechnic Institute and State University
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE WCOPY(N,X,incX,Y,incY)
!--------------------------------------------------------------
!     copies a vector, x, to a vector, y:  y <- x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL  SCOPY(N,X,1,Y,1)   or   CALL  DCOPY(N,X,1,Y,1)
!--------------------------------------------------------------
!     USE gckpp_Precision
      
      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N)

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = X(i)
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i) = X(i)
        Y(i + 1) = X(i + 1)
        Y(i + 2) = X(i + 2)
        Y(i + 3) = X(i + 3)
        Y(i + 4) = X(i + 4)
        Y(i + 5) = X(i + 5)
        Y(i + 6) = X(i + 6)
        Y(i + 7) = X(i + 7)
      END DO

      END SUBROUTINE WCOPY


!--------------------------------------------------------------
      SUBROUTINE WAXPY(N,Alpha,X,incX,Y,incY)
!--------------------------------------------------------------
!     constant times a vector plus a vector: y <- y + Alpha*x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SAXPY(N,Alpha,X,1,Y,1) or  CALL DAXPY(N,Alpha,X,1,Y,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N),Alpha
      REAL(kind=dp), PARAMETER :: ZERO = 0.0_dp

      IF (Alpha .EQ. ZERO) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,4)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = Y(i) + Alpha*X(i)
        END DO
        IF( N .LT. 4 ) RETURN
      END IF
      MP1 = M + 1
      DO i = MP1,N,4
        Y(i) = Y(i) + Alpha*X(i)
        Y(i + 1) = Y(i + 1) + Alpha*X(i + 1)
        Y(i + 2) = Y(i + 2) + Alpha*X(i + 2)
        Y(i + 3) = Y(i + 3) + Alpha*X(i + 3)
      END DO
      
      END SUBROUTINE WAXPY



!--------------------------------------------------------------
      SUBROUTINE WSCAL(N,Alpha,X,incX)
!--------------------------------------------------------------
!     constant times a vector: x(1:N) <- Alpha*x(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SSCAL(N,Alpha,X,1) or  CALL DSCAL(N,Alpha,X,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,M,MP1,N
      REAL(kind=dp)  :: X(N),Alpha
      REAL(kind=dp), PARAMETER  :: ZERO=0.0_dp, ONE=1.0_dp

      IF (Alpha .EQ. ONE) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,5)
      IF( M .NE. 0 ) THEN
        IF (Alpha .EQ. (-ONE)) THEN
          DO i = 1,M
            X(i) = -X(i)
          END DO
        ELSEIF (Alpha .EQ. ZERO) THEN
          DO i = 1,M
            X(i) = ZERO
          END DO
        ELSE
          DO i = 1,M
            X(i) = Alpha*X(i)
          END DO
        END IF
        IF( N .LT. 5 ) RETURN
      END IF
      MP1 = M + 1
      IF (Alpha .EQ. (-ONE)) THEN
        DO i = MP1,N,5
          X(i)     = -X(i)
          X(i + 1) = -X(i + 1)
          X(i + 2) = -X(i + 2)
          X(i + 3) = -X(i + 3)
          X(i + 4) = -X(i + 4)
        END DO
      ELSEIF (Alpha .EQ. ZERO) THEN
        DO i = MP1,N,5
          X(i)     = ZERO
          X(i + 1) = ZERO
          X(i + 2) = ZERO
          X(i + 3) = ZERO
          X(i + 4) = ZERO
        END DO
      ELSE
        DO i = MP1,N,5
          X(i)     = Alpha*X(i)
          X(i + 1) = Alpha*X(i + 1)
          X(i + 2) = Alpha*X(i + 2)
          X(i + 3) = Alpha*X(i + 3)
          X(i + 4) = Alpha*X(i + 4)
        END DO
      END IF

      END SUBROUTINE WSCAL

!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WLAMCH( C )
!--------------------------------------------------------------
!     returns epsilon machine
!     after LAPACK
!     replace this by the function from the optimized LAPACK implementation:
!          CALL SLAMCH('E') or CALL DLAMCH('E')
!--------------------------------------------------------------
!      USE gckpp_Precision

      CHARACTER ::  C
      INTEGER    :: i
      REAL(kind=dp), SAVE  ::  Eps
      REAL(kind=dp)  ::  Suma
      REAL(kind=dp), PARAMETER  ::  ONE=1.0_dp, HALF=0.5_dp
      LOGICAL, SAVE   ::  First=.TRUE.

!$OMP THREADPRIVATE( Eps, First )      

      IF (First) THEN
        First = .FALSE.
        Eps = HALF**(16)
        DO i = 17, 80
          Eps = Eps*HALF
          CALL WLAMCH_ADD(ONE,Eps,Suma)
          IF (Suma.LE.ONE) GOTO 10
        END DO
        PRINT*,'ERROR IN WLAMCH. EPS < ',Eps
        RETURN
10      Eps = Eps*2
        i = i-1      
      END IF

      WLAMCH = Eps

      END FUNCTION WLAMCH
     
      SUBROUTINE WLAMCH_ADD( A, B, Suma )
!      USE gckpp_Precision
      
      REAL(kind=dp) A, B, Suma
      Suma = A + B

      END SUBROUTINE WLAMCH_ADD
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE SET2ZERO(N,Y)
!--------------------------------------------------------------
!     copies zeros into the vector y:  y <- 0
!     after BLAS
!--------------------------------------------------------------
      
      INTEGER ::  i,M,MP1,N
      REAL(kind=dp) ::  Y(N)
      REAL(kind=dp), PARAMETER :: ZERO = 0.0d0

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = ZERO
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i)     = ZERO
        Y(i + 1) = ZERO
        Y(i + 2) = ZERO
        Y(i + 3) = ZERO
        Y(i + 4) = ZERO
        Y(i + 5) = ZERO
        Y(i + 6) = ZERO
        Y(i + 7) = ZERO
      END DO

      END SUBROUTINE SET2ZERO


!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WDOT (N, DX, incX, DY, incY) 
!--------------------------------------------------------------
!     dot produce: wdot = x(1:N)*y(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SDOT(N,X,1,Y,1) or  CALL DDOT(N,X,1,Y,1)
!--------------------------------------------------------------
!      USE messy_mecca_kpp_Precision
!--------------------------------------------------------------
      IMPLICIT NONE
      INTEGER :: N, incX, incY
      REAL(kind=dp) :: DX(N), DY(N) 

      INTEGER :: i, IX, IY, M, MP1, NS
                                 
      WDOT = 0.0D0 
      IF (N .LE. 0) RETURN 
      IF (incX .EQ. incY) IF (incX-1) 5,20,60 
!                                                                       
!     Code for unequal or nonpositive increments.                       
!                                                                       
    5 IX = 1 
      IY = 1 
      IF (incX .LT. 0) IX = (-N+1)*incX + 1 
      IF (incY .LT. 0) IY = (-N+1)*incY + 1 
      DO i = 1,N 
        WDOT = WDOT + DX(IX)*DY(IY) 
        IX = IX + incX 
        IY = IY + incY 
      END DO 
      RETURN 
!                                                                       
!     Code for both increments equal to 1.                              
!                                                                       
!     Clean-up loop so remaining vector length is a multiple of 5.      
!                                                                       
   20 M = MOD(N,5) 
      IF (M .EQ. 0) GO TO 40 
      DO i = 1,M 
         WDOT = WDOT + DX(i)*DY(i) 
      END DO 
      IF (N .LT. 5) RETURN 
   40 MP1 = M + 1 
      DO i = MP1,N,5 
          WDOT = WDOT + DX(i)*DY(i) + DX(i+1)*DY(i+1) + DX(i+2)*DY(i+2) +  &
                   DX(i+3)*DY(i+3) + DX(i+4)*DY(i+4)                   
      END DO 
      RETURN 
!                                                                       
!     Code for equal, positive, non-unit increments.                    
!                                                                       
   60 NS = N*incX 
      DO i = 1,NS,incX 
        WDOT = WDOT + DX(i)*DY(i) 
      END DO 

      END FUNCTION WDOT                                          


!--------------------------------------------------------------
      SUBROUTINE WADD(N,X,Y,Z)
!--------------------------------------------------------------
!     adds two vectors: z <- x + y
!     BLAS - like
!--------------------------------------------------------------
!     USE gckpp_Precision
      
      INTEGER :: i, M, MP1, N
      REAL(kind=dp) :: X(N),Y(N),Z(N)

      IF (N.LE.0) RETURN

      M = MOD(N,5)
      IF( M /= 0 ) THEN
         DO i = 1,M
            Z(i) = X(i) + Y(i)
         END DO
         IF( N < 5 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,5
         Z(i)     = X(i)     + Y(i)
         Z(i + 1) = X(i + 1) + Y(i + 1)
         Z(i + 2) = X(i + 2) + Y(i + 2)
         Z(i + 3) = X(i + 3) + Y(i + 3)
         Z(i + 4) = X(i + 4) + Y(i + 4)
      END DO

      END SUBROUTINE WADD
      
      
      
!--------------------------------------------------------------
      SUBROUTINE WGEFA(N,A,Ipvt,info)
!--------------------------------------------------------------
!     WGEFA FACTORS THE MATRIX A (N,N) BY
!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!     LINPACK - LIKE 
!--------------------------------------------------------------
!
      INTEGER       :: N,Ipvt(N),info
      REAL(kind=dp) :: A(N,N)
      REAL(kind=dp) :: t, dmax, da
      INTEGER       :: j,k,l
      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0

      info = 0

size: IF (n > 1) THEN
      
col:  DO k = 1, n-1

!        find l = pivot index
!        l = idamax(n-k+1,A(k,k),1) + k - 1
         l = k; dmax = abs(A(k,k))
         DO j = k+1,n
            da = ABS(A(j,k))
            IF (da > dmax) THEN
              l = j; dmax = da
            END IF
         END DO
         Ipvt(k) = l

!        zero pivot implies this column already triangularized
         IF (ABS(A(l,k)) < TINY(ZERO)) THEN
            info = k
            return
         ELSE   
            IF (l /= k) THEN
               t = A(l,k); A(l,k) = A(k,k); A(k,k) = t
            END IF
            t = -ONE/A(k,k)
            CALL WSCAL(n-k,t,A(k+1,k),1)
            DO j = k+1, n
               t = A(l,j)
               IF (l /= k) THEN
                  A(l,j) = A(k,j); A(k,j) = t
               END IF
               CALL WAXPY(n-k,t,A(k+1,k),1,A(k+1,j),1)
            END DO         
         END IF
         
       END DO col
       
      END IF size
      
      Ipvt(N) = N
      IF (ABS(A(N,N)) == ZERO) info = N
      
      END SUBROUTINE WGEFA


!--------------------------------------------------------------
      SUBROUTINE WGESL(Trans,N,A,Ipvt,b)
!--------------------------------------------------------------
!     WGESL solves the system
!     a * x = b  or  trans(a) * x = b
!     using the factors computed by WGEFA.
!
!     Trans      = 'N'   to solve  A*x = b ,
!                = 'T'   to solve  transpose(A)*x = b
!     LINPACK - LIKE 
!--------------------------------------------------------------

      INTEGER       :: N,Ipvt(N)
      CHARACTER     :: trans
      REAL(kind=dp) :: A(N,N),b(N)
      REAL(kind=dp) :: t
      INTEGER       :: k,kb,l

      
      SELECT CASE (Trans)

      CASE ('n','N')  !  Solve  A * x = b

!        first solve  L*y = b
         IF (n >= 2) THEN
          DO k = 1, n-1
            l = Ipvt(k)
            t = b(l)
            IF (l /= k) THEN
               b(l) = b(k)
               b(k) = t
            END IF
            CALL WAXPY(n-k,t,a(k+1,k),1,b(k+1),1)
          END DO
         END IF
!        now solve  U*x = y
         DO kb = 1, n
            k = n + 1 - kb
            b(k) = b(k)/a(k,k)
            t = -b(k)
            CALL WAXPY(k-1,t,a(1,k),1,b(1),1)
         END DO
      
      CASE ('t','T')  !  Solve transpose(A) * x = b

!        first solve  trans(U)*y = b
         DO k = 1, n
            t = WDOT(k-1,a(1,k),1,b(1),1)
            b(k) = (b(k) - t)/a(k,k)
         END DO
!        now solve trans(L)*x = y
         IF (n >= 2) THEN
         DO kb = 1, n-1
            k = n - kb
            b(k) = b(k) + WDOT(n-k,a(k+1,k),1,b(k+1),1)
            l = Ipvt(k)
            IF (l /= k) THEN
               t = b(l); b(l) = b(k); b(k) = t
            END IF
         END DO
         END IF
   
      END SELECT

      END SUBROUTINE WGESL
! End of BLAS_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE gckpp_LinearAlgebra

