! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Auxiliary Routines File
! 
! Generated by KPP-2.2.4_gc symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : gckpp_Util.f90
! Time                 : Thu Jul 19 13:05:43 2018
! Working directory    : /n/home05/msulprizio/GC/Code.Dev/KPP/Standard
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_Util

  USE gckpp_Parameters
  IMPLICIT NONE

CONTAINS



! User INLINED Utility Functions

! End INLINED Utility Functions

! Utility Functions from KPP_HOME/util/util
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! UTIL - Utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! ****************************************************************
!                            
! InitSaveData - Opens the data file for writing
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE InitSaveData ()

      USE gckpp_Parameters

      open(10, file='gckpp.dat')

      END SUBROUTINE InitSaveData

! End of InitSaveData function
! ****************************************************************

! ****************************************************************
!                            
! SaveData - Write LOOKAT species in the data file 
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE SaveData ()

      USE gckpp_Global
      USE gckpp_Monitor

      INTEGER i

      WRITE(10,999) (TIME-TSTART)/3600.D0,  &
                   (C(LOOKAT(i))/CFACTOR, i=1,NLOOKAT)
999   FORMAT(E24.16,100(1X,E24.16))

      END SUBROUTINE SaveData

! End of SaveData function
! ****************************************************************

! ****************************************************************
!                            
! CloseSaveData - Close the data file 
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE CloseSaveData ()

      USE gckpp_Parameters

      CLOSE(10)

      END SUBROUTINE CloseSaveData

! End of CloseSaveData function
! ****************************************************************

! ****************************************************************
!                            
! GenerateMatlab - Generates MATLAB file to load the data file 
!   Parameters : 
!                It will have a character string to prefix each 
!                species name with.                                                 
!
! ****************************************************************

      SUBROUTINE GenerateMatlab ( PREFIX )

      USE gckpp_Parameters
      USE gckpp_Global
      USE gckpp_Monitor

      
      CHARACTER(LEN=8) PREFIX 
      INTEGER i

      open(20, file='gckpp.m')
      write(20,*) 'load gckpp.dat;'
      write(20,990) PREFIX
990   FORMAT(A1,'c = gckpp;')
      write(20,*) 'clear gckpp;'
      write(20,991) PREFIX, PREFIX
991   FORMAT(A1,'t=',A1,'c(:,1);')
      write(20,992) PREFIX
992   FORMAT(A1,'c(:,1)=[];')

      do i=1,NLOOKAT
        write(20,993) PREFIX, SPC_NAMES(LOOKAT(i)), PREFIX, i
993     FORMAT(A1,A6,' = ',A1,'c(:,',I2,');')
      end do
      
      CLOSE(20)

      END SUBROUTINE GenerateMatlab

! End of GenerateMatlab function
! ****************************************************************


! End Utility Functions from KPP_HOME/util/util
! End of UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Shuffle_user2kpp - function to copy concentrations from USER to KPP
!   Arguments :
!      V_USER    - Concentration of variable species in USER's order
!      V         - Concentrations of variable species (local)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Shuffle_user2kpp ( V_USER, V )

! V_USER - Concentration of variable species in USER's order
  REAL(kind=dp) :: V_USER(NVAR)
! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)

  V(164) = V_USER(1)
  V(201) = V_USER(2)
  V(194) = V_USER(3)
  V(4) = V_USER(4)
  V(216) = V_USER(5)
  V(104) = V_USER(6)
  V(177) = V_USER(7)
  V(115) = V_USER(8)
  V(171) = V_USER(9)
  V(42) = V_USER(10)
  V(222) = V_USER(11)
  V(116) = V_USER(12)
  V(108) = V_USER(13)
  V(210) = V_USER(14)
  V(64) = V_USER(15)
  V(51) = V_USER(16)
  V(144) = V_USER(17)
  V(125) = V_USER(18)
  V(122) = V_USER(19)
  V(137) = V_USER(21)
  V(109) = V_USER(22)
  V(52) = V_USER(23)
  V(53) = V_USER(24)
  V(54) = V_USER(25)
  V(55) = V_USER(26)
  V(56) = V_USER(27)
  V(57) = V_USER(28)
  V(80) = V_USER(29)
  V(75) = V_USER(30)
  V(1) = V_USER(31)
  V(2) = V_USER(32)
  V(3) = V_USER(33)
  V(214) = V_USER(34)
  V(197) = V_USER(35)
  V(94) = V_USER(36)
  V(156) = V_USER(37)
  V(43) = V_USER(38)
  V(93) = V_USER(39)
  V(44) = V_USER(40)
  V(151) = V_USER(41)
  V(73) = V_USER(42)
  V(77) = V_USER(43)
  V(227) = V_USER(44)
  V(149) = V_USER(45)
  V(79) = V_USER(46)
  V(83) = V_USER(47)
  V(199) = V_USER(48)
  V(233) = V_USER(49)
  V(96) = V_USER(50)
  V(220) = V_USER(51)
  V(5) = V_USER(52)
  V(38) = V_USER(53)
  V(39) = V_USER(54)
  V(120) = V_USER(55)
  V(110) = V_USER(56)
  V(140) = V_USER(57)
  V(92) = V_USER(58)
  V(130) = V_USER(59)
  V(131) = V_USER(60)
  V(204) = V_USER(61)
  V(81) = V_USER(62)
  V(155) = V_USER(63)
  V(192) = V_USER(64)
  V(158) = V_USER(65)
  V(143) = V_USER(66)
  V(58) = V_USER(67)
  V(45) = V_USER(68)
  V(46) = V_USER(69)
  V(235) = V_USER(70)
  V(176) = V_USER(71)
  V(208) = V_USER(72)
  V(224) = V_USER(73)
  V(117) = V_USER(74)
  V(202) = V_USER(75)
  V(189) = V_USER(76)
  V(82) = V_USER(77)
  V(84) = V_USER(78)
  V(85) = V_USER(79)
  V(87) = V_USER(80)
  V(225) = V_USER(81)
  V(170) = V_USER(82)
  V(71) = V_USER(83)
  V(97) = V_USER(84)
  V(190) = V_USER(85)
  V(95) = V_USER(86)
  V(232) = V_USER(87)
  V(186) = V_USER(88)
  V(196) = V_USER(89)
  V(111) = V_USER(90)
  V(119) = V_USER(91)
  V(107) = V_USER(92)
  V(113) = V_USER(93)
  V(178) = V_USER(94)
  V(147) = V_USER(95)
  V(40) = V_USER(96)
  V(47) = V_USER(97)
  V(37) = V_USER(98)
  V(112) = V_USER(99)
  V(59) = V_USER(100)
  V(74) = V_USER(101)
  V(65) = V_USER(102)
  V(66) = V_USER(103)
  V(60) = V_USER(104)
  V(157) = V_USER(105)
  V(28) = V_USER(106)
  V(76) = V_USER(107)
  V(6) = V_USER(108)
  V(205) = V_USER(109)
  V(133) = V_USER(110)
  V(61) = V_USER(111)
  V(184) = V_USER(112)
  V(86) = V_USER(113)
  V(138) = V_USER(114)
  V(67) = V_USER(115)
  V(141) = V_USER(116)
  V(7) = V_USER(117)
  V(8) = V_USER(118)
  V(198) = V_USER(119)
  V(9) = V_USER(120)
  V(10) = V_USER(121)
  V(167) = V_USER(122)
  V(154) = V_USER(123)
  V(152) = V_USER(124)
  V(123) = V_USER(125)
  V(174) = V_USER(126)
  V(150) = V_USER(127)
  V(187) = V_USER(128)
  V(191) = V_USER(129)
  V(169) = V_USER(130)
  V(185) = V_USER(131)
  V(11) = V_USER(132)
  V(12) = V_USER(133)
  V(142) = V_USER(134)
  V(180) = V_USER(135)
  V(13) = V_USER(136)
  V(14) = V_USER(137)
  V(15) = V_USER(138)
  V(16) = V_USER(139)
  V(18) = V_USER(140)
  V(17) = V_USER(141)
  V(19) = V_USER(142)
  V(20) = V_USER(143)
  V(215) = V_USER(144)
  V(181) = V_USER(145)
  V(145) = V_USER(146)
  V(172) = V_USER(147)
  V(166) = V_USER(148)
  V(126) = V_USER(149)
  V(175) = V_USER(150)
  V(72) = V_USER(151)
  V(218) = V_USER(154)
  V(213) = V_USER(155)
  V(163) = V_USER(156)
  V(200) = V_USER(157)
  V(160) = V_USER(158)
  V(118) = V_USER(159)
  V(139) = V_USER(160)
  V(221) = V_USER(161)
  V(41) = V_USER(162)
  V(148) = V_USER(163)
  V(162) = V_USER(164)
  V(124) = V_USER(165)
  V(78) = V_USER(166)
  V(209) = V_USER(167)
  V(127) = V_USER(168)
  V(21) = V_USER(169)
  V(134) = V_USER(170)
  V(135) = V_USER(171)
  V(217) = V_USER(172)
  V(159) = V_USER(173)
  V(153) = V_USER(174)
  V(68) = V_USER(175)
  V(62) = V_USER(176)
  V(132) = V_USER(177)
  V(193) = V_USER(178)
  V(223) = V_USER(179)
  V(230) = V_USER(180)
  V(229) = V_USER(181)
  V(136) = V_USER(182)
  V(228) = V_USER(183)
  V(226) = V_USER(184)
  V(231) = V_USER(185)
  V(98) = V_USER(186)
  V(69) = V_USER(187)
  V(234) = V_USER(188)
  V(88) = V_USER(189)
  V(182) = V_USER(190)
  V(183) = V_USER(191)
  V(99) = V_USER(193)
  V(188) = V_USER(194)
  V(105) = V_USER(195)
  V(48) = V_USER(196)
  V(168) = V_USER(198)
  V(101) = V_USER(199)
  V(49) = V_USER(200)
  V(161) = V_USER(201)
  V(211) = V_USER(202)
  V(102) = V_USER(203)
  V(165) = V_USER(204)
  V(22) = V_USER(205)
  V(173) = V_USER(206)
  V(207) = V_USER(207)
  V(206) = V_USER(208)
  V(106) = V_USER(209)
  V(89) = V_USER(210)
  V(90) = V_USER(211)
  V(212) = V_USER(212)
  V(179) = V_USER(213)
  V(203) = V_USER(214)
  V(128) = V_USER(215)
  V(121) = V_USER(216)
  V(129) = V_USER(217)
  V(146) = V_USER(218)
  V(100) = V_USER(219)
  V(219) = V_USER(220)
  V(103) = V_USER(221)
  V(23) = V_USER(222)
  V(24) = V_USER(223)
  V(25) = V_USER(224)
  V(26) = V_USER(225)
  V(27) = V_USER(226)
  V(29) = V_USER(227)
  V(50) = V_USER(228)
  V(63) = V_USER(229)
  V(195) = V_USER(230)
  V(114) = V_USER(231)
  V(91) = V_USER(232)
  V(70) = V_USER(233)
      
END SUBROUTINE Shuffle_user2kpp

! End of Shuffle_user2kpp function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Shuffle_kpp2user - function to restore concentrations from KPP to USER
!   Arguments :
!      V         - Concentrations of variable species (local)
!      V_USER    - Concentration of variable species in USER's order
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Shuffle_kpp2user ( V, V_USER )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! V_USER - Concentration of variable species in USER's order
  REAL(kind=dp) :: V_USER(NVAR)

  V_USER(1) = V(164)
  V_USER(2) = V(201)
  V_USER(3) = V(194)
  V_USER(4) = V(4)
  V_USER(5) = V(216)
  V_USER(6) = V(104)
  V_USER(7) = V(177)
  V_USER(8) = V(115)
  V_USER(9) = V(171)
  V_USER(10) = V(42)
  V_USER(11) = V(222)
  V_USER(12) = V(116)
  V_USER(13) = V(108)
  V_USER(14) = V(210)
  V_USER(15) = V(64)
  V_USER(16) = V(51)
  V_USER(17) = V(144)
  V_USER(18) = V(125)
  V_USER(19) = V(122)
  V_USER(21) = V(137)
  V_USER(22) = V(109)
  V_USER(23) = V(52)
  V_USER(24) = V(53)
  V_USER(25) = V(54)
  V_USER(26) = V(55)
  V_USER(27) = V(56)
  V_USER(28) = V(57)
  V_USER(29) = V(80)
  V_USER(30) = V(75)
  V_USER(31) = V(1)
  V_USER(32) = V(2)
  V_USER(33) = V(3)
  V_USER(34) = V(214)
  V_USER(35) = V(197)
  V_USER(36) = V(94)
  V_USER(37) = V(156)
  V_USER(38) = V(43)
  V_USER(39) = V(93)
  V_USER(40) = V(44)
  V_USER(41) = V(151)
  V_USER(42) = V(73)
  V_USER(43) = V(77)
  V_USER(44) = V(227)
  V_USER(45) = V(149)
  V_USER(46) = V(79)
  V_USER(47) = V(83)
  V_USER(48) = V(199)
  V_USER(49) = V(233)
  V_USER(50) = V(96)
  V_USER(51) = V(220)
  V_USER(52) = V(5)
  V_USER(53) = V(38)
  V_USER(54) = V(39)
  V_USER(55) = V(120)
  V_USER(56) = V(110)
  V_USER(57) = V(140)
  V_USER(58) = V(92)
  V_USER(59) = V(130)
  V_USER(60) = V(131)
  V_USER(61) = V(204)
  V_USER(62) = V(81)
  V_USER(63) = V(155)
  V_USER(64) = V(192)
  V_USER(65) = V(158)
  V_USER(66) = V(143)
  V_USER(67) = V(58)
  V_USER(68) = V(45)
  V_USER(69) = V(46)
  V_USER(70) = V(235)
  V_USER(71) = V(176)
  V_USER(72) = V(208)
  V_USER(73) = V(224)
  V_USER(74) = V(117)
  V_USER(75) = V(202)
  V_USER(76) = V(189)
  V_USER(77) = V(82)
  V_USER(78) = V(84)
  V_USER(79) = V(85)
  V_USER(80) = V(87)
  V_USER(81) = V(225)
  V_USER(82) = V(170)
  V_USER(83) = V(71)
  V_USER(84) = V(97)
  V_USER(85) = V(190)
  V_USER(86) = V(95)
  V_USER(87) = V(232)
  V_USER(88) = V(186)
  V_USER(89) = V(196)
  V_USER(90) = V(111)
  V_USER(91) = V(119)
  V_USER(92) = V(107)
  V_USER(93) = V(113)
  V_USER(94) = V(178)
  V_USER(95) = V(147)
  V_USER(96) = V(40)
  V_USER(97) = V(47)
  V_USER(98) = V(37)
  V_USER(99) = V(112)
  V_USER(100) = V(59)
  V_USER(101) = V(74)
  V_USER(102) = V(65)
  V_USER(103) = V(66)
  V_USER(104) = V(60)
  V_USER(105) = V(157)
  V_USER(106) = V(28)
  V_USER(107) = V(76)
  V_USER(108) = V(6)
  V_USER(109) = V(205)
  V_USER(110) = V(133)
  V_USER(111) = V(61)
  V_USER(112) = V(184)
  V_USER(113) = V(86)
  V_USER(114) = V(138)
  V_USER(115) = V(67)
  V_USER(116) = V(141)
  V_USER(117) = V(7)
  V_USER(118) = V(8)
  V_USER(119) = V(198)
  V_USER(120) = V(9)
  V_USER(121) = V(10)
  V_USER(122) = V(167)
  V_USER(123) = V(154)
  V_USER(124) = V(152)
  V_USER(125) = V(123)
  V_USER(126) = V(174)
  V_USER(127) = V(150)
  V_USER(128) = V(187)
  V_USER(129) = V(191)
  V_USER(130) = V(169)
  V_USER(131) = V(185)
  V_USER(132) = V(11)
  V_USER(133) = V(12)
  V_USER(134) = V(142)
  V_USER(135) = V(180)
  V_USER(136) = V(13)
  V_USER(137) = V(14)
  V_USER(138) = V(15)
  V_USER(139) = V(16)
  V_USER(140) = V(18)
  V_USER(141) = V(17)
  V_USER(142) = V(19)
  V_USER(143) = V(20)
  V_USER(144) = V(215)
  V_USER(145) = V(181)
  V_USER(146) = V(145)
  V_USER(147) = V(172)
  V_USER(148) = V(166)
  V_USER(149) = V(126)
  V_USER(150) = V(175)
  V_USER(151) = V(72)
  V_USER(154) = V(218)
  V_USER(155) = V(213)
  V_USER(156) = V(163)
  V_USER(157) = V(200)
  V_USER(158) = V(160)
  V_USER(159) = V(118)
  V_USER(160) = V(139)
  V_USER(161) = V(221)
  V_USER(162) = V(41)
  V_USER(163) = V(148)
  V_USER(164) = V(162)
  V_USER(165) = V(124)
  V_USER(166) = V(78)
  V_USER(167) = V(209)
  V_USER(168) = V(127)
  V_USER(169) = V(21)
  V_USER(170) = V(134)
  V_USER(171) = V(135)
  V_USER(172) = V(217)
  V_USER(173) = V(159)
  V_USER(174) = V(153)
  V_USER(175) = V(68)
  V_USER(176) = V(62)
  V_USER(177) = V(132)
  V_USER(178) = V(193)
  V_USER(179) = V(223)
  V_USER(180) = V(230)
  V_USER(181) = V(229)
  V_USER(182) = V(136)
  V_USER(183) = V(228)
  V_USER(184) = V(226)
  V_USER(185) = V(231)
  V_USER(186) = V(98)
  V_USER(187) = V(69)
  V_USER(188) = V(234)
  V_USER(189) = V(88)
  V_USER(190) = V(182)
  V_USER(191) = V(183)
  V_USER(193) = V(99)
  V_USER(194) = V(188)
  V_USER(195) = V(105)
  V_USER(196) = V(48)
  V_USER(198) = V(168)
  V_USER(199) = V(101)
  V_USER(200) = V(49)
  V_USER(201) = V(161)
  V_USER(202) = V(211)
  V_USER(203) = V(102)
  V_USER(204) = V(165)
  V_USER(205) = V(22)
  V_USER(206) = V(173)
  V_USER(207) = V(207)
  V_USER(208) = V(206)
  V_USER(209) = V(106)
  V_USER(210) = V(89)
  V_USER(211) = V(90)
  V_USER(212) = V(212)
  V_USER(213) = V(179)
  V_USER(214) = V(203)
  V_USER(215) = V(128)
  V_USER(216) = V(121)
  V_USER(217) = V(129)
  V_USER(218) = V(146)
  V_USER(219) = V(100)
  V_USER(220) = V(219)
  V_USER(221) = V(103)
  V_USER(222) = V(23)
  V_USER(223) = V(24)
  V_USER(224) = V(25)
  V_USER(225) = V(26)
  V_USER(226) = V(27)
  V_USER(227) = V(29)
  V_USER(228) = V(50)
  V_USER(229) = V(63)
  V_USER(230) = V(195)
  V_USER(231) = V(114)
  V_USER(232) = V(91)
  V_USER(233) = V(70)
      
END SUBROUTINE Shuffle_kpp2user

! End of Shuffle_kpp2user function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! GetMass - compute total mass of selected atoms
!   Arguments :
!      CL        - Concentration of all species (local)
!      Mass      - value of mass balance
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE GetMass ( CL, Mass )

! CL - Concentration of all species (local)
  REAL(kind=dp) :: CL(NSPEC)
! Mass - value of mass balance
  REAL(kind=dp) :: Mass(1)

      
END SUBROUTINE GetMass

! End of GetMass function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! ComputeFamilies - function to calculate user-defined Prod/Loss families
!   Arguments :
!      V         - Concentrations of variable species (local)
!      FAM       - Accumulated user-defined prod/loss families.
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE ComputeFamilies ( V, FAM )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! FAM - Accumulated user-defined prod/loss families.
  REAL(kind=dp) :: FAM(NFAM)


! Computation of prod/loss families
  FAM(1) = V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(32)+V(32)&
             &+V(30)+V(30)+0.96*V(32)+0.21*V(30)+1.78*V(30)+0.36*V(30)+V(30)+V(30)+V(32)+0.15*V(30)+0.15*V(30)+0.15*V(32)&
             &+0.81*V(32)+V(32)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+2*V(30)+V(30)+V(30)+V(30)+V(32)&
             &+V(30)+1.394*V(30)+V(30)+1.58*V(30)+1.01*V(30)+V(30)+1.15*V(30)+0.15*V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)&
             &+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+V(30)+0.82*V(30)+0.78*V(30)+V(30)+2&
             &*V(30)+0.5*V(30)+V(30)+0.5*V(30)+V(30)+V(30)+V(30)+2*V(30)+V(30)+V(30)+2*V(30)+V(30)+0.3*V(30)+V(30)+V(30)&
             &+V(30)+0.4*V(30)+V(30)+V(30)+V(30)
  FAM(2) = V(31)+V(31)+V(31)+V(31)+V(31)+2*V(31)+V(31)+V(31)+V(31)+1.4*V(31)+1.04*V(31)+1.04*V(31)+0.0599999*V(31)+0.04&
             &*V(31)+V(31)+0.106*V(31)+0.04*V(31)+0.34*V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)&
             &+V(31)+V(31)+1.5*V(31)+V(31)+V(31)+2*V(31)+0.64*V(31)+V(31)+V(31)+2*V(31)+2*V(31)+V(31)+V(31)+V(31)+V(31)&
             &+V(31)+V(31)+V(31)+V(35)+V(35)+V(35)+2*V(31)+V(31)+V(31)+2*V(31)+V(31)+2*V(31)+2*V(31)+V(31)+V(31)+2*V(31)&
             &+V(31)+0.67*V(31)+0.65*V(31)+0.56*V(31)+0.17*V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+2*V(31)+2*V(31)+2*V(31)+2&
             &*V(31)+2*V(31)+2*V(31)+2*V(31)+2*V(31)+0.9*V(31)+0.9*V(31)+0.388*V(31)+V(31)+V(31)+2*V(31)+V(31)+V(31)+V(31)+2&
             &*V(31)+2*V(31)+V(31)+2*V(31)+V(31)+V(31)+V(31)+2*V(31)+2*V(31)+0.5*V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)&
             &+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+2*V(31)+2*V(31)+2*V(31)+3&
             &*V(31)+3*V(31)+3*V(31)+4*V(31)+4*V(31)+4*V(31)+V(31)+V(31)+2*V(31)+2*V(31)+V(31)+V(31)+V(31)+V(31)+V(31)+V(31)&
             &+V(31)+V(31)+2*V(31)+V(31)+2*V(31)+V(31)+V(31)+2*V(31)
  FAM(3) = V(32)+V(32)+0.05*V(32)+0.728*V(32)+V(32)+0.5*V(32)+V(32)+V(32)+0.5*V(32)+0.075*V(32)+0.29*V(32)+0.33*V(32)&
             &+0.595*V(32)+0.375*V(32)+0.39*V(32)+0.56*V(32)+V(32)+0.03*V(32)+0.505*V(32)+V(32)+2*V(32)+V(32)+2*V(32)+V(32)&
             &+0.5*V(32)+0.495*V(32)+0.56*V(32)+0.625*V(32)+0.5*V(32)+0.6*V(32)+0.678*V(32)+0.89*V(32)+0.09*V(32)+0.857&
             &*V(32)+0.5*V(32)+0.21*V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+V(32)+0.09*V(32)+1.5*V(32)+0.14*V(36)+0.14&
             &*V(36)+0.14*V(36)+0.5*V(32)+0.55*V(32)+V(32)+V(32)+V(32)+0.88*V(32)+V(32)+V(32)+V(32)+V(32)+2*V(32)+2*V(32)&
             &+V(32)+V(32)+V(32)+V(32)+V(32)+0.67*V(32)+0.5*V(32)+0.5*V(32)+V(32)+V(32)+V(32)+1.89*V(32)
  FAM(4) = V(33)+V(33)+V(33)+V(33)+V(33)+V(33)+V(33)+V(33)
  FAM(5) = V(34)+V(34)+V(34)+V(34)+V(34)+V(34)+V(34)+V(34)
  FAM(6) = V(35)+V(35)+V(35)+V(35)+V(35)
  FAM(7) = V(36)+V(36)+V(36)+V(36)+V(36)+V(36)+V(36)+V(36)+V(36)+0.02*V(36)+0.02*V(36)+0.02*V(36)
      
END SUBROUTINE ComputeFamilies

! End of ComputeFamilies function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! Get_OHreactivity - returns the OH reactivity
! The OH reactivity is defined as the inverse of its lifetime.
! This routine was auto-generated using script OHreact_parser.py.
! Generated on 2018-08-09
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Get_OHreactivity ( CC, RR, OHreact )

! CC - Concentrations of species (local)
  REAL(kind=dp) :: CC(NSPEC)
! RR - reaction rates (local)
  REAL(kind=dp) :: RR(NREACT)
! OHreact - OH reactivity [s-1]
  REAL(kind=dp) :: OHreact

  OHreact = RR(2)*CC(224) + 2*RR(6) + 2*RR(7) + RR(8)*CC(233) + RR(9)*CC(173) &
          + RR(12)*CC(232) + RR(13)*CC(151) + RR(18)*CC(122) + RR(19)*CC(122) + RR(20)*CC(114) &
          + RR(21)*CC(114) + RR(22)*CC(213) + RR(23)*CC(225) + RR(24)*CC(189) + RR(25)*CC(226) &
          + RR(26)*CC(95) + RR(29)*CC(93) + RR(32)*CC(228) + RR(35)*CC(177) + RR(36)*CC(235) &
          + RR(39)*CC(214) + RR(44)*CC(135) + RR(46)*CC(108) + RR(47)*CC(108) + RR(50)*CC(102) &
          + RR(75)*CC(196) + RR(82)*CC(205) + RR(83)*CC(193) + RR(84)*CC(210) + RR(94)*CC(199) &
          + RR(108)*CC(211) + RR(124)*CC(128) + RR(125)*CC(146) + RR(134)*CC(209) + RR(136)*CC(134) &
          + RR(137)*CC(140) + RR(139)*CC(28) + RR(140)*CC(191) + RR(141)*CC(191) + RR(143)*CC(157) &
          + RR(144)*CC(198) + RR(147)*CC(174) + RR(148)*CC(215) + RR(149)*CC(212) + RR(150)*CC(206) &
          + RR(151)*CC(206) + RR(166)*CC(142) + RR(167)*CC(142) + RR(168)*CC(100) + RR(169)*CC(80) &
          + RR(170)*CC(86) + RR(171)*CC(87) + RR(172)*CC(104) + RR(173)*CC(98) + RR(174)*CC(99) &
          + RR(175)*CC(129) + RR(176)*CC(120) + RR(177)*CC(130) + RR(178)*CC(129) + RR(179)*CC(120) &
          + RR(180)*CC(130) + RR(181)*CC(18) + RR(182)*CC(63) + RR(183)*CC(64) + RR(184)*CC(58) &
          + RR(187)*CC(110) + RR(188)*CC(113) + RR(189)*CC(126) + RR(190)*CC(126) + RR(191)*CC(125) &
          + RR(192)*CC(125) + RR(200)*CC(70) + RR(239)*CC(90) + RR(240)*CC(90) + RR(242)*CC(217) &
          + RR(246)*CC(218) + RR(251)*CC(115) + RR(254)*CC(208) + RR(263)*CC(74) + RR(264)*CC(78) &
          + RR(265)*CC(92) + RR(277)*CC(234) + RR(278)*CC(220) + RR(283)*CC(67) + RR(318)*CC(147) &
          + RR(320)*CC(227) + RR(321)*CC(227) + RR(322)*CC(96) + RR(323)*CC(76) + RR(324)*CC(219) &
          + RR(325)*CC(195) + RR(326)*CC(79) + RR(327)*CC(197) + RR(328)*CC(91) + RR(329)*CC(72) &
          + RR(330)*CC(77) + RR(331)*CC(36) + RR(332)*CC(89) + RR(333)*CC(83) + RR(334)*CC(84) &
          + RR(335)*CC(82) + RR(400)*CC(149) + RR(401)*CC(69) + RR(402)*CC(111) + RR(409)*CC(42) &
          + RR(410)*CC(200) + RR(414)*CC(190) + RR(415)*CC(150) + RR(420)*CC(123) + RR(421)*CC(158) &
          + RR(422)*CC(172) + RR(427)*CC(119) + RR(431)*CC(117) + RR(436)*CC(127) + RR(437)*CC(164) &
          + RR(477)*CC(41) + RR(478)*CC(48) + RR(479)*CC(88) + RR(487)*CC(132) + RR(488)*CC(133) &
          + RR(498)*CC(139) + RR(506)*CC(103) + RR(520)*CC(148) + RR(521)*CC(160) + RR(525)*CC(118) &
          + RR(526)*CC(112) + RR(527)*CC(105)

END SUBROUTINE Get_OHreactivity
! End of Get_OHreactivity subroutine 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

END MODULE gckpp_Util
