################################################################################
#
# skiff-init-squashfs
#
################################################################################

SKIFF_INIT_SQUASHFS_INSTALL_IMAGES = YES

SKIFF_INIT_SQUASHFS_CFLAGS = $(TARGET_CFLAGS) -static \
	-DSKIFF_INIT_PROC='$(BR2_PACKAGE_SKIFF_INIT_SQUASHFS_INIT_PROC)'

ifneq ($(BR2_PACKAGE_SKIFF_INIT_SQUASHFS_BIND_HOST_DIRS),)
SKIFF_INIT_SQUASHFS_CFLAGS += \
	-DBIND_HOST_DIRS='$(BR2_PACKAGE_SKIFF_INIT_SQUASHFS_BIND_HOST_DIRS)'
endif

ifeq ($(BR2_PACKAGE_SKIFF_INIT_SQUASHFS_BIND_ROOT_MNT),y)
SKIFF_INIT_SQUASHFS_CFLAGS += -DBIND_ROOT_MNT
endif

ifneq ($(BR2_PACKAGE_SKIFF_INIT_SQUASHFS_CHROOT_TARGET),y)
SKIFF_INIT_SQUASHFS_CFLAGS += -DNO_CHROOT_TARGET
endif

ifneq ($(BR2_PACKAGE_SKIFF_INIT_SQUASHFS_MOUNT_PROC),y)
SKIFF_INIT_SQUASHFS_CFLAGS += -DNO_MOUNT_PROC
endif

ifneq ($(BR2_PACKAGE_SKIFF_INIT_SQUASHFS_MOUNT_SYS),y)
SKIFF_INIT_SQUASHFS_CFLAGS += -DNO_MOUNT_SYS
endif

ifeq ($(BR2_PACKAGE_SKIFF_INIT_SQUASHFS_MOUNT_SYS_RBIND),y)
SKIFF_INIT_SQUASHFS_CFLAGS += -DMOUNT_SYS_RBIND
endif

ifeq ($(BR2_PACKAGE_SKIFF_INIT_SQUASHFS_NO_MOVE_MOUNTPOINT_ROOT),y)
SKIFF_INIT_SQUASHFS_CFLAGS += -DNO_MOVE_MOUNTPOINT_ROOT
endif

ifeq ($(BR2_PACKAGE_SKIFF_INIT_SQUASHFS_NO_RESIZE_PERSIST),y)
SKIFF_INIT_SQUASHFS_CFLAGS += -DNO_RESIZE_PERSIST
endif

ifeq ($(BR2_PACKAGE_SKIFF_INIT_SQUASHFS_ROOT_AS_PERSIST),y)
SKIFF_INIT_SQUASHFS_CFLAGS += -DROOT_AS_PERSIST
endif

ifeq ($(BR2_PACKAGE_SKIFF_INIT_SQUASHFS_ROOT_MAKE_SHARED),y)
SKIFF_INIT_SQUASHFS_CFLAGS += -DROOT_MAKE_SHARED
endif

ifeq ($(BR2_PACKAGE_SKIFF_INIT_SQUASHFS_WRITE_SKIFF_INIT_PID),y)
SKIFF_INIT_SQUASHFS_CFLAGS += -DWRITE_SKIFF_INIT_PID
endif

define SKIFF_INIT_SQUASHFS_BUILD_CMDS
	$(TARGET_CC) $(SKIFF_INIT_SQUASHFS_CFLAGS) -o $(@D)/skiff-init-squashfs \
		$(SKIFF_INIT_SQUASHFS_PKGDIR)/skiff-init-squashfs.c
endef

define SKIFF_INIT_SQUASHFS_INSTALL_IMAGES_CMDS
	mkdir -p $(BINARIES_DIR)/skiff-init
	$(INSTALL) -m 755 -D $(@D)/skiff-init-squashfs \
		$(BINARIES_DIR)/skiff-init/skiff-init-squashfs
endef

$(eval $(generic-package))
