---
sort: 13
---
# seqfu qual

*qual* allows to detect the range of qualities
of a FASTQ file, returning the possible encodings

```text
Usage: qual [options] [<FASTQ>...] 

Quickly check the quality of input files returning
the detected encoding and the profile of quality
scores

Options:
  -m, --max INT          Check the first INT reads [default: 2000]
  -l, --maxlen INT       Maximum read length [default: 300]
  -p, --profile          Quality profile per position
  -c, --colorbars        Print graphical average quality profile
  -v, --verbose          Verbose output
  --help                 Show this help
```

## Example

Check if a set of files is likely in Illumina 1.8 encoding:

```
seqfu qual data/primers/*

data/primers/16Snano_R1.fq.gz   40.0    71.0    Sanger;Illumina-1.8;    66.37+/-8.63
data/primers/16Snano_R2.fq.gz   35.0    71.0    Sanger;Illumina-1.8;    65.05+/-9.54
data/primers/16S_R1.fq.gz       40.0    71.0    Sanger;Illumina-1.8;    66.26+/-8.62
data/primers/16S_R2.fq.gz       35.0    71.0    Sanger;Illumina-1.8;    64.72+/-9.72
data/primers/artificial.fa.gz   0.0     0.0     Invalid Range   0.00+/-0.00
data/primers/artificial.fq.gz   73.0    73.0    Illumina-1.3;Sanger;Illumina-1.5;Solexa;Illumina-1.8;   73.00+/-0.00
data/primers/art_R1.fq.gz       73.0    73.0    Illumina-1.3;Sanger;Illumina-1.5;Solexa;Illumina-1.8;   73.00+/-0.00
data/primers/art_R2.fq.gz       73.0    73.0    Illumina-1.3;Sanger;Illumina-1.5;Solexa;Illumina-1.8;   73.00+/-0.00
```

The artifical datasets (`art*`) were designed to be compatible with most encodings,
while the `16S*` files are real Illumina 1.8 sequences.

## Output

For each file a 4 column string is printed:
* filename
* minimum quality value (no offset is used)
* maximum quality value (no offset)
* possible encoding
* Mean, StDev of the quality value (no offset)

## Per base statistics

With the `--profile` option tabular overview of the quality scores per
nucleotide position of the read is printed:

```text
#data/primers/16Snano_R1.fq.gz  40.0    71.0    Sanger;Illumina-1.8;    66.37+/-8.63
#Pos    Min     Max     Mean    StDev   Skewness
0       27.0    34.0    33.95   0.50    -12.36
1       27.0    34.0    33.97   0.46    -14.78
2       11.0    34.0    33.73   2.28    -9.08
3       23.0    34.0    33.92   0.76    -13.09
4       31.0    34.0    33.99   0.20    -15.20
5       28.0    38.0    37.76   0.86    -7.20
6       10.0    38.0    36.26   3.98    -4.89
...
298     7.0     37.0    26.34   10.34   -0.58
299     7.0     37.0    25.62   11.23   -0.55
300     7.0     37.0    21.29   9.26    -0.09
```
## Graphical summary

With the `--colorbar` option a graphical (Unicode) colored histogram of the _average_
quality _per base position_ is printed after each file.

![View]({{site.baseurl}}/img/qual.png)