!
!    Copyright 2014, 2015, 2017, 2018, 2020, 2021 Guy Munhoven
!
!    This file is part of µXML.
!
!    µXML is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    µXML is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with µXML.  If not, see <https://www.gnu.org/licenses/>.
!


#include <modmxm.h>
!=======================================================================
 SUBROUTINE XMLCOCOGEN_LOADDB(c_xmlbaselist,                           &
    xml_compofiles, xml_procsfiles, xml_equilfiles)
!=======================================================================

USE MOD_XMLCOCOGEN
USE MODMXM_GENERAL
USE MODMXM_STKXE
USE MODMXM_STKMX
USE MODMXM_STRUCTLOAD

IMPLICIT NONE

! Argument list variables
! -----------------------

CHARACTER(LEN=*) :: c_xmlbaselist
TYPE(xfs_list), POINTER :: xml_compofiles
TYPE(xfs_list), POINTER :: xml_procsfiles
TYPE(xfs_list), POINTER :: xml_equilfiles


! Local variables
! ----------------

#ifdef DEBUG
INTEGER, PARAMETER :: jp_stddbg = (MXM_STDDBG)
#endif


CHARACTER(LEN=p_maxlen_eltname)  :: c_eltname
CHARACTER(LEN=p_maxlen_attname)  :: c_attname
CHARACTER(LEN=p_maxlen_attcntt)  :: c_attcntt


TYPE(stack_xmlevents), POINTER :: stkxe_baselist
TYPE(stack_minixml), POINTER   :: stkmx_baselist
TYPE(stkxe_ptr), DIMENSION(:), POINTER :: stkxep_solutsystlists
TYPE(stkmx_ptr), DIMENSION(:), POINTER :: stkmxp_solutsystlists
TYPE(stack_xmlevents), POINTER :: stkxe_solutsystlist
TYPE(stack_minixml), POINTER   :: stkmx_solutsystlist
INTEGER :: n_maxlen_eltname
INTEGER :: n_maxlen_attname
INTEGER :: n_maxlen_attcont

TYPE(stack_xmlevents), POINTER :: stkxe_work
TYPE(stack_minixml), POINTER   :: stkmx_composition
TYPE(stack_minixml), POINTER   :: stkmx_solute
TYPE(stack_minixml), POINTER   :: stkmx_solid
TYPE(stack_minixml), POINTER   :: stkmx_solutsyst
TYPE(stack_minixml), POINTER   :: stkmx_member
TYPE(stack_minixml), POINTER   :: stkmx_processes
TYPE(stack_minixml), POINTER   :: stkmx_process
TYPE(stack_minixml), POINTER   :: stkmx_equilibria
TYPE(stack_minixml), POINTER   :: stkmx_equilibrium
TYPE(stkmx_ptr), DIMENSION(:), POINTER   :: stkmxp_composition
TYPE(stkmx_ptr), DIMENSION(:), POINTER   :: stkmxp_solutes
TYPE(stkmx_ptr), DIMENSION(:), POINTER   :: stkmxp_solids
TYPE(stkmx_ptr), DIMENSION(:), POINTER   :: stkmxp_solutsysts
TYPE(stkmx_ptr), DIMENSION(:), POINTER   :: stkmxp_members
TYPE(stkmx_ptr), DIMENSION(:), POINTER   :: stkmxp_processes
TYPE(stkmx_ptr), DIMENSION(:), POINTER   :: stkmxp_process
TYPE(stkmx_ptr), DIMENSION(:), POINTER   :: stkmxp_equilibria
TYPE(stkmx_ptr), DIMENSION(:), POINTER   :: stkmxp_equilibrium
INTEGER :: n_composition

INTEGER :: i_child, n_children
INTEGER :: n_maxdepth, n_order
INTEGER :: i_solutsyst, n_solutsysts
INTEGER :: i_solute,    n_solutes
INTEGER :: i_solid,     n_solids
INTEGER :: i_proc,      n_procs
INTEGER :: i_equil,     n_equils
INTEGER :: i_att,       n_atts
INTEGER :: i_order, i_ordersolsyst
TYPE(stack_recchunks), POINTER :: stkrc_eltname
TYPE(stack_recchunks), POINTER :: stkrc_attcntt
CHARACTER(LEN=p_maxlen_filename) :: c_xmlfilename
INTEGER :: nlen_returned

TYPE(xfs_list), POINTER :: xml_compofilewk
TYPE(xfs_list), POINTER :: xml_procsfilewk
TYPE(xfs_list), POINTER :: xml_equilfilewk
TYPE(xfs_list), POINTER :: xfs_test, xfs_testnext, xfs_work
INTEGER :: n_xmlcompofiles
INTEGER :: n_xmlprocsfiles
INTEGER :: n_xmlequilfiles
INTEGER :: i_ordermin



! Operations
! ----------------------------------------------------------------------


                 ! Get the events list of the base file
stkxe_baselist => XMLSTRUCT(c_xmlbaselist, &
                            n_maxlen_eltname, n_maxlen_attname, n_maxlen_attcont)

! Could check here if maxlen's do not exceed currently adopted parameterizations

                 ! and read in the data
stkmx_baselist => XMLLOAD(c_xmlbaselist, stkxe_baselist, n_maxdepth)


                 ! 1. get the <Composition> element and
                 !    1.1 parse for the <Solute> elements
                 !    1.2 parse for the <Solid> elements
                 !    1.2 parse for the <SoluteSystem> elements and
                 !        resolve them
                 !
                 ! 2. get the <Processes> element (if any)
                 !
                 ! 3. get the <Equilibria>element (if any)


                 !=============!
                 ! Composition !
                 !=============!

                 ! Initialize the list of files to read in for the
                 ! composition
NULLIFY(xml_compofiles)
n_xmlcompofiles = 0

stkmxp_composition => STKMX_getElementNodeByName(stkmx_baselist, cp_composition)


WRITE(*,'()')

IF (ASSOCIATED(stkmxp_composition)) THEN

  n_composition = SIZE(stkmxp_composition)

  IF (n_composition /= 1) THEN
    WRITE(*,'("Found ",I0, " <'//cp_composition//'> elements -")') n_composition
    WRITE(*,'("there can be one at most. Aborting!")')
    CALL ABORT()
  ENDIF

  WRITE(*,'("Found one <'//cp_composition//'> element.")')

  ! Now create the XFS_LIST for the XML composition files
  xml_compofiles => XFSL_createRoot()
  xml_compofilewk => xml_compofiles


  stkmx_composition => stkmxp_composition(1)%ptr


  ! Solutes

  stkmxp_solutes => STKMX_getElementNodeByName(stkmx_composition, cp_solute)

  WRITE(*,'()')

  IF (ASSOCIATED(stkmxp_solutes)) THEN
    n_solutes = SIZE(stkmxp_solutes)
    IF (n_solutes == 1) THEN
      WRITE(*,'("<'//cp_composition//'> has 1 <'//cp_solute//'> child element")')
    ELSE
      WRITE(*,'("<'//cp_composition//'> has ", I0, " <'//cp_solute//'> child elements")') n_solutes
    ENDIF
  ELSE
    n_solutes = 0
    WRITE(*,'("<'//cp_composition//'> has no <'//cp_solute//'> child element.")')
  ENDIF

  DO i_solute = 1, n_solutes
    stkmx_solute => stkmxp_solutes(i_solute)%ptr
    i_att = STKMX_getAttIdxByName(stkmx_solute, cp_file)
    IF (i_att > 0) THEN
      stkrc_attcntt => STKMX_getAttcnttByIdx(stkmx_solute, i_att)
      CALL STKRC_copyStkrcToStr(stkrc_attcntt, c_xmlfilename, nlen_returned)
      WRITE(*,'(" <'//cp_solute//'> ", I0, ": file=""",A,"""")') &
        i_solute, TRIM(c_xmlfilename)

      IF (n_xmlcompofiles /= 0) THEN
        xfs_work => xml_compofilewk
        xml_compofilewk => XFSL_addNode(xfs_work)
      ENDIF
      xml_compofilewk%fname = c_xmlfilename
      xml_compofilewk%c_type = cp_solute
      i_att = STKMX_getAttIdxByName(stkmx_solute, cp_order)
      IF (i_att > 0) THEN
        stkrc_attcntt => STKMX_getAttcnttByIdx(stkmx_solute, i_att)
        CALL STKRC_copyStkrcToStr(stkrc_attcntt, c_attcntt, nlen_returned)
        READ(c_attcntt,*) i_order
        xml_compofilewk%i_order = i_order
      ELSE
        WRITE(*,'(" <'//cp_solute//'> ", I0, ": ""'//cp_order//'"" attribute not found")') i_solute
      ENDIF

      xml_compofilewk%i_system = 0 ! not part of a system

      n_xmlcompofiles = n_xmlcompofiles + 1

    ELSE
      WRITE(*,'(" <'//cp_solute//'> ", I0, ": ""'//cp_file//'"" attribute not found")') i_solute
    ENDIF
  ENDDO


  ! Solids

  WRITE(*,'()')
  stkmxp_solids => STKMX_getElementNodeByName(stkmx_composition, cp_solid)

  IF (ASSOCIATED(stkmxp_solids)) THEN
    n_solids = SIZE(stkmxp_solids)
    IF (n_solids == 1) THEN
      WRITE(*,'("<'//cp_composition//'> has 1 <'//cp_solid//'> child element")')
    ELSE
      WRITE(*,'("<'//cp_composition//'> has ", I0, " <'//cp_solid//'> child elements")') n_solids
    ENDIF
  ELSE
    n_solids = 0
    WRITE(*,'("<'//cp_composition//'> has no <'//cp_solid//'> child element.")')
  ENDIF

  DO i_solid = 1, n_solids
    stkmx_solid => stkmxp_solids(i_solid)%ptr
    i_att = STKMX_getAttIdxByName(stkmx_solid, cp_file)
    IF (i_att > 0) THEN
      stkrc_attcntt => STKMX_getAttcnttByIdx(stkmx_solid, i_att)
      CALL STKRC_copyStkrcToStr(stkrc_attcntt, c_xmlfilename, nlen_returned)
      WRITE(*,'(" <'//cp_solid//'> ", I0, ": file=""",A,"""")') &
        i_solid, TRIM(c_xmlfilename)

      IF (n_xmlcompofiles /= 0) THEN
        xfs_work => xml_compofilewk
        xml_compofilewk => XFSL_addNode(xfs_work)
      ENDIF
      xml_compofilewk%fname = c_xmlfilename
      xml_compofilewk%c_type = cp_solid
      i_att = STKMX_getAttIdxByName(stkmx_solid, cp_order)
      IF (i_att > 0) THEN
        stkrc_attcntt => STKMX_getAttcnttByIdx(stkmx_solid, i_att)
        CALL STKRC_copyStkrcToStr(stkrc_attcntt, c_attcntt, nlen_returned)
        READ(c_attcntt,*) i_order
        xml_compofilewk%i_order = i_order
      ELSE
        WRITE(*,'(" <'//cp_solid//'> ", I0, ": ""'//cp_order//'"" attribute missing")') i_solid
      ENDIF

      xml_compofilewk%i_system = 0 ! not part of a system

      n_xmlcompofiles = n_xmlcompofiles + 1

    ELSE
      WRITE(*,'(" <'//cp_solid//'> ", I0, ": ""'//cp_file//'"" attribute missing")') i_solid
    ENDIF
  ENDDO


  ! Solute systems

  WRITE(*,'()')
  stkmxp_solutsysts => STKMX_getElementNodeByName(stkmx_composition, cp_solutesystem)

  IF (ASSOCIATED(stkmxp_solutsysts)) THEN
    n_solutsysts = SIZE(stkmxp_solutsysts)
    IF (n_solutsysts == 1) THEN
      WRITE(*,'("<'//cp_composition//'> has 1 <'//cp_solutesystem//'> child element")')
    ELSE
      WRITE(*,'("<'//cp_composition//'> has ",I0, " <'//cp_solutesystem//'> child elements")') n_solutsysts
    ENDIF
                 ! Allocate space to hold the STKXE and STKMX of each solutelist file
    ALLOCATE(stkxep_solutsystlists(n_solutsysts))
    ALLOCATE(stkmxp_solutsystlists(n_solutsysts))
  ELSE
    n_solutsysts = 0
    WRITE(*,'("<'//cp_composition//'> has no <'//cp_solutesystem//'> child element.")')
  ENDIF

  DO i_solutsyst = 1, n_solutsysts
    stkmx_solutsyst => stkmxp_solutsysts(i_solutsyst)%ptr
    i_att = STKMX_getAttIdxByName(stkmx_solutsyst, cp_file)
    IF (i_att > 0) THEN
      stkrc_attcntt => STKMX_getAttcnttByIdx(stkmx_solutsyst, i_att)
      CALL STKRC_copyStkrcToStr(stkrc_attcntt, c_xmlfilename, nlen_returned)

      IF (n_xmlcompofiles /= 0) THEN
        xfs_work => xml_compofilewk
        xml_compofilewk => XFSL_addNode(xfs_work)
      ENDIF
      xml_compofilewk%fname = c_xmlfilename
      xml_compofilewk%c_type = cp_solutesystem

      i_att = STKMX_getAttIdxByName(stkmx_solutsyst, cp_order)
      IF (i_att > 0) THEN
        stkrc_attcntt => STKMX_getAttcnttByIdx(stkmx_solutsyst, i_att)
        CALL STKRC_copyStkrcToStr(stkrc_attcntt, c_attcntt, nlen_returned)
        READ(c_attcntt,*) i_ordersolsyst
        xml_compofilewk%i_order = i_ordersolsyst
      ELSE
        i_order = -1
        WRITE(*,'(" <'//cp_solutesystem//'> ", I0, ": ""'//cp_order//'"" attribute missing")') i_solutsyst
      ENDIF

      xml_compofilewk%i_system = i_solutsyst ! yes, this one is part of a system

      n_xmlcompofiles = n_xmlcompofiles + 1


      WRITE(*,'(" <'//cp_solutesystem//'> ", I0, ": resolving file=""",A,"""")') &
        i_solutsyst, TRIM(c_xmlfilename)

      stkxep_solutsystlists(i_solutsyst)%ptr &
        => XMLSTRUCT(c_xmlfilename, n_maxlen_eltname, n_maxlen_attname, n_maxlen_attcont)
      stkxe_solutsystlist => stkxep_solutsystlists(i_solutsyst)%ptr

      stkmxp_solutsystlists(i_solutsyst)%ptr &
        => XMLLOAD(c_xmlfilename, stkxe_solutsystlist, n_maxdepth)
      stkmx_solutsystlist => stkmxp_solutsystlists(i_solutsyst)%ptr

      stkmxp_members => STKMX_getElementNodeByName(stkmx_solutsystlist, cp_composition)

      IF (ASSOCIATED(stkmxp_members)) THEN

        n_composition = SIZE(stkmxp_members)

        IF (n_composition /= 1) THEN
          WRITE(*,'("  Found ", I0, " <'//cp_composition//'> elements -")') n_composition
          WRITE(*,'("  there can be one at most. Aborting!")')
          CALL ABORT()
        ENDIF

        WRITE(*,'("  Found one <'//cp_composition//'> element.")')

        stkmx_member => stkmxp_members(1)%ptr

        DEALLOCATE(stkmxp_solutes)
        NULLIFY(stkmxp_solutes)

        stkmxp_solutes => STKMX_getElementNodeByName(stkmx_member, cp_solute)

        IF (ASSOCIATED(stkmxp_solutes)) THEN
          n_solutes = SIZE(stkmxp_solutes)
          IF (n_solutes == 1) THEN
            WRITE(*,'("  <'//cp_composition//'> has 1 <'//cp_solute//'> child element")')
          ELSE
            WRITE(*,'("  <'//cp_composition//'> has ",I0, " <'//cp_solute//'> child element(s)")') n_solutes
          ENDIF
        ELSE
          n_solutes = 0
          WRITE(*,'("  <'//cp_composition//'> has no <'//cp_solute//'> child element.")')
        ENDIF

        DO i_solute = 1, n_solutes
          stkmx_solute => stkmxp_solutes(i_solute)%ptr
          i_att = STKMX_getAttIdxByName(stkmx_solute, cp_file)
          IF (i_att > 0) THEN
            stkrc_attcntt => STKMX_getAttcnttByIdx(stkmx_solute, i_att)
            CALL STKRC_copyStkrcToStr(stkrc_attcntt, c_xmlfilename, nlen_returned)
            WRITE(*,'("  <'//cp_solute//'> ", I0, ": file=""",A,"""")') &
              i_solute, TRIM(c_xmlfilename)

            IF (n_xmlcompofiles /= 0) THEN
              xfs_work => xml_compofilewk
              xml_compofilewk => XFSL_addNode(xfs_work)
            ENDIF
            xml_compofilewk%fname = c_xmlfilename
            xml_compofilewk%c_type = cp_solute

            i_att = STKMX_getAttIdxByName(stkmx_solute, cp_order)
            IF (i_att > 0) THEN
              stkrc_attcntt => STKMX_getAttcnttByIdx(stkmx_solute, i_att)
              CALL STKRC_copyStkrcToStr(stkrc_attcntt, c_attcntt, nlen_returned)
              READ(c_attcntt,*) i_order
              xml_compofilewk%i_order = i_ordersolsyst + i_order
            ELSE
              i_order = -1
              xml_compofilewk%i_order = i_ordersolsyst
              WRITE(*,'("  <'//cp_solute//'> ", I0, ": ""'//cp_order//'"" attribute missing")') i_solute
            ENDIF

            xml_compofilewk%i_system = i_solutsyst ! yes, this one is part of a system

            n_xmlcompofiles = n_xmlcompofiles + 1

          ELSE
            WRITE(*,'("  <'//cp_solute//'> ", I0, ": ""'//cp_file//'"" attribute not found")') i_solute
          ENDIF
        ENDDO

      ELSE

        WRITE(*,'("No <'//cp_composition//'> element found.")')

      ENDIF

    ELSE
      WRITE(*,'(" <'//cp_solutesystem//'> ", I0, ": ""'//cp_file//'"" attribute not found")') i_solute
    ENDIF
  ENDDO


ELSE
  WRITE(*,'("No <'//cp_composition//'> element found.")')

ENDIF

WRITE(*,'()')

                 ! Done with the composition file list
NULLIFY(xml_compofilewk)


                 !===========!
                 ! Processes !
                 !===========!

                 ! Initialize the list of files to read in for the
                 ! process descriptions

NULLIFY(xml_procsfiles)
n_xmlprocsfiles = 0

stkmxp_processes => STKMX_getElementNodeByName(stkmx_baselist, cp_processes)

WRITE(*,'()')

IF (ASSOCIATED(stkmxp_processes)) THEN

  n_procs = SIZE(stkmxp_processes)

  IF (n_procs /= 1) THEN
    WRITE(*,'("Found ", I0, " <'//cp_processes//'> elements -")') n_procs
    WRITE(*,'("there can be one at most. Aborting!")')
    CALL ABORT()
  ENDIF

  WRITE(*,'("Found one <'//cp_processes//'> element.")')


  ! Now create the XFS_LIST for the XML process files
  xml_procsfiles => XFSL_createRoot()
  xml_procsfilewk => xml_procsfiles


  stkmx_processes => stkmxp_processes(1)%ptr

  ! Individual <"//cp_process//"> descriptions

  stkmxp_process => STKMX_getElementNodeByName(stkmx_processes, cp_process)

  WRITE(*,'()')

  IF (ASSOCIATED(stkmxp_process)) THEN
    n_procs = SIZE(stkmxp_process)
    IF (n_procs == 1) THEN
      WRITE(*,'("<'//cp_processes//'> has 1 <'//cp_process//'> child element")')
    ELSE
      WRITE(*,'("<'//cp_processes//'> has ", I0, " <'//cp_process//'> child elements")') n_procs
    ENDIF
  ELSE
    n_procs = 0
    WRITE(*,'("<'//cp_processes//'> has no <'//cp_process//'> child element.")')
  ENDIF

  DO i_proc = 1, n_procs
    stkmx_process => stkmxp_process(i_proc)%ptr
    i_att = STKMX_getAttIdxByName(stkmx_process, cp_file)
    IF (i_att > 0) THEN
      stkrc_attcntt => STKMX_getAttcnttByIdx(stkmx_process, i_att)
      CALL STKRC_copyStkrcToStr(stkrc_attcntt, c_xmlfilename, nlen_returned)
      WRITE(*,'(" <'//cp_process//'> ", I0, ": file=""",A,"""")') &
        i_proc, TRIM(c_xmlfilename)

      IF (n_xmlprocsfiles /= 0) THEN
        xfs_work => xml_procsfilewk
        xml_procsfilewk => XFSL_addNode(xfs_work)
      ENDIF
      xml_procsfilewk%fname = c_xmlfilename
      xml_procsfilewk%c_type = 'Process'

      n_xmlprocsfiles = n_xmlprocsfiles + 1

    ELSE
      WRITE(*,'(" <'//cp_process//'> ", I0, ": ""'//cp_file//'"" attribute not found")') i_proc
    ENDIF

  ENDDO

ENDIF

WRITE(*,'()')

                 ! Done with the process file list
NULLIFY(xml_procsfilewk)


                 !============!
                 ! Equilibria !
                 !============!

                 ! Initialize the list of files to read in for the
                 ! equilibrium descriptions

NULLIFY(xml_equilfiles)
n_xmlequilfiles = 0

stkmxp_equilibria => STKMX_getElementNodeByName(stkmx_baselist, cp_equilibria)

WRITE(*,'()')

IF (ASSOCIATED(stkmxp_equilibria)) THEN

  n_equils = SIZE(stkmxp_equilibria)

  IF (n_equils /= 1) THEN
    WRITE(*,'("Found ",I0, " <'//cp_equilibria//'> elements -")') n_equils
    WRITE(*,'("there can be one at most. Aborting!")')
    CALL ABORT()
  ENDIF

  WRITE(*,'("Found one <'//cp_equilibria//'> element.")')


  ! Now create the XFS_LIST for the XML equilibrium files
  xml_equilfiles => XFSL_createRoot()
  xml_equilfilewk => xml_equilfiles


  stkmx_equilibria => stkmxp_equilibria(1)%ptr


  ! Individual <Equilibrium> descriptions

  stkmxp_equilibrium => STKMX_getElementNodeByName(stkmx_equilibria, cp_equilibrium)

  WRITE(*,'()')

  IF (ASSOCIATED(stkmxp_equilibrium)) THEN
    n_equils = SIZE(stkmxp_equilibrium)
    IF (n_equils == 1) THEN
      WRITE(*,'("<'//cp_equilibria//'> has 1 <'//cp_equilibrium//'> child element")')
    ELSE
      WRITE(*,'("<<'//cp_equilibria//'> has ", I0, " <'//cp_equilibrium//'> child elements")') n_equils
    ENDIF
  ELSE
    n_equils = 0
    WRITE(*,'("<'//cp_equilibria//'> has no <'//cp_equilibrium//'> child element.")')
  ENDIF

  DO i_equil = 1, n_equils
    stkmx_equilibrium => stkmxp_equilibrium(i_equil)%ptr
    i_att = STKMX_getAttIdxByName(stkmx_equilibrium, cp_file)
    IF (i_att > 0) THEN
      stkrc_attcntt => STKMX_getAttcnttByIdx(stkmx_equilibrium, i_att)
      CALL STKRC_copyStkrcToStr(stkrc_attcntt, c_xmlfilename, nlen_returned)
      WRITE(*,'(" <'//cp_equilibrium//'> ", I0, ": file=""", A, """")') &
        i_equil, TRIM(c_xmlfilename)

      IF (n_xmlequilfiles /= 0) THEN
        xfs_work => xml_equilfilewk
        xml_equilfilewk => XFSL_addNode(xfs_work)
      ENDIF
      xml_equilfilewk%fname = c_xmlfilename
      xml_equilfilewk%c_type = 'Equilibrium'

      n_xmlequilfiles = n_xmlequilfiles + 1

    ELSE
      WRITE(*,'(" <'//cp_equilibrium//'> ", I0, ": ""'//cp_file//'"" attribute not found")') i_equil
    ENDIF

  ENDDO

ENDIF

                 ! Done with the equilibrium file list
NULLIFY(xml_equilfilewk)

WRITE(*,'()')
WRITE(*,'("Number of files in each category:")')

WRITE(*,'(" Composition files: ", I0)')  n_xmlcompofiles
WRITE(*,'(" Process files: ", I0)')      n_xmlprocsfiles
WRITE(*,'(" Equilibrium files: ", I0)')  n_xmlequilfiles


IF (n_xmlcompofiles /= 0) THEN
  WRITE(*,'()')
  WRITE(*,'()')
  WRITE(*,'("Composition files")')
  WRITE(*,'("-----------------")')
  WRITE(*,'()')
  WRITE(*,'("Unsorted list")')


  xml_compofilewk => xml_compofiles

  DO

    WRITE(*,'("fname = """, A, """, order = ", I0)') &
      TRIM(xml_compofilewk%fname), xml_compofilewk%i_order
    IF (ASSOCIATED(xml_compofilewk%next)) THEN
      xml_compofilewk => xml_compofilewk%next
    ELSE
      EXIT
    ENDIF

  ENDDO



                 ! Sort the list by increasing %i_order

  i_ordermin = xml_compofiles%i_order

  IF (ASSOCIATED(xml_compofiles%next)) THEN
    xfs_test => xml_compofiles%next
  ELSE
    NULLIFY(xfs_test)
  ENDIF


  DO WHILE(ASSOCIATED(xfs_test))

    IF (ASSOCIATED(xfs_test%next)) THEN
      xfs_testnext => xfs_test%next
    ELSE
      NULLIFY(xfs_testnext)
    ENDIF

    i_order = xfs_test%i_order

    IF (i_order < i_ordermin) THEN
                 ! The current <xfs_test> provisionally becomes the root
      i_ordermin = i_order

      ! unlink xfs_test from its %prev and its %next:
      ! - forward link the %prev of xfs_test to the %next of xfs_test
      ! - backward link the %next of xfs_test to the %prev of xfs_test
      IF (ASSOCIATED(xfs_testnext)) THEN
        xfs_test%prev%next => xfs_testnext
        xfs_testnext%prev  => xfs_test%prev
      ELSE
        NULLIFY(xfs_test%prev%next)
      ENDIF

      ! Forward link the current xml_test to xml_compofiles
      ! and backward link the current xml_compofiles to xml_test
      xml_compofiles%prev => xfs_test
      xfs_test%next => xml_compofiles
      ! Then substitute the xml_compofiles with the current xml_test
      xml_compofiles => xfs_test
      ! and nullify its %prev
      NULLIFY(xml_compofiles%prev)

    ELSE

                 ! i_order is greater than the lowest value encountered
                 ! so far and will have to be inserted somewhere after
                 ! the root node.

                 ! If xfs_test%prev has an %i_order that is greater
                 ! than i_order, then proceed to the tests, else
                 ! there is nothing to do
      xfs_work => xfs_test%prev

      IF (xfs_work%i_order > i_order) THEN

        DO WHILE(ASSOCIATED(xfs_work%prev))
          xfs_work => xfs_work%prev
          IF(xfs_work%i_order > i_order) THEN
            CYCLE
          ELSE
            ! the current <xfs_test> needs to be inserted
            ! between xfs_work and xfs_work%next

            ! unlink xfs_test from its %prev and its %next:
            ! - forward link the %prev of xfs_test to the %next of xfs_test
            ! - backward link the %next of xfs_test to the %prev of xfs_test
            IF (ASSOCIATED(xfs_testnext)) THEN
              xfs_test%prev%next => xfs_testnext
              xfs_testnext%prev  => xfs_test%prev
            ELSE
              NULLIFY(xfs_test%prev%next)
            ENDIF

            ! insert xfs_test between xfs_work and xfs_work%next:
            ! - forward link xfs_test to xfs_work%next and xfs_work to xfs_test and
            ! - backward link xfs_work%next to xfs_test and xfs_test to xfs_work
            xfs_test%next => xfs_work%next
            xfs_test%prev => xfs_work
            xfs_test%next%prev => xfs_test
            xfs_test%prev%next => xfs_test

            ! and we are done
            EXIT
          ENDIF
        ENDDO

      ENDIF

    ENDIF

    xfs_test => xfs_testnext

  ENDDO



  xml_compofilewk => xml_compofiles
  WRITE(*,'()')
  WRITE(*,'("Sorted list")')


  DO

    WRITE(*,'("fname = """, A, """, order = ", I0)') &
      TRIM(xml_compofilewk%fname), xml_compofilewk%i_order
    IF (ASSOCIATED(xml_compofilewk%next)) THEN
      xml_compofilewk => xml_compofilewk%next
    ELSE
      EXIT
    ENDIF

  ENDDO

ENDIF


IF (n_xmlprocsfiles /= 0) THEN
  WRITE(*,'()')
  WRITE(*,'()')
  WRITE(*,'("Process files")')
  WRITE(*,'("-------------")')
  WRITE(*,'()')


  xml_procsfilewk => xml_procsfiles

  DO

    WRITE(*,'("fname = """, A, """")') TRIM(xml_procsfilewk%fname)
    IF (ASSOCIATED(xml_procsfilewk%next)) THEN
      xml_procsfilewk => xml_procsfilewk%next
    ELSE
      EXIT
    ENDIF

  ENDDO

ENDIF


IF (n_xmlequilfiles /= 0) THEN
  WRITE(*,'()')
  WRITE(*,'()')
  WRITE(*,'("Equilibrium files")')
  WRITE(*,'("-----------------")')
  WRITE(*,'()')


  xml_equilfilewk => xml_equilfiles

  DO

    WRITE(*,'("fname = """, A, """")') TRIM(xml_equilfilewk%fname)
    IF (ASSOCIATED(xml_equilfilewk%next)) THEN
      xml_equilfilewk => xml_equilfilewk%next
    ELSE
      EXIT
    ENDIF

  ENDDO

ENDIF



! Read in the data

WRITE(*,'()')
IF (n_xmlcompofiles /= 0) THEN
  WRITE(*,'("Reading in the composition files")')

  xfs_work => xml_compofiles

  DO

    WRITE(*,'(" - file """, A, """")') TRIM(xfs_work%fname)
#   ifdef DEBUG
    WRITE(jp_stddbg,'(" - file """, A, """")') TRIM(xfs_work%fname)
#   endif
    xfs_work%xe => XMLSTRUCT(xfs_work%fname, &
      n_maxlen_eltname, n_maxlen_attname, n_maxlen_attcont)

    xfs_work%mx => XMLLOAD(xfs_work%fname, xfs_work%xe, n_maxdepth)

    IF (ASSOCIATED(xfs_work%next)) THEN
      xfs_work => xfs_work%next
    ELSE
      EXIT
    ENDIF

  ENDDO

ELSE

  WRITE(*,'("No composition files registered")')

ENDIF


WRITE(*,'()')
IF (n_xmlprocsfiles /= 0) THEN
  WRITE(*,'("Reading in the process files")')

  xfs_work => xml_procsfiles

  DO

    WRITE(*,'(" - file """, A, """")') TRIM(xfs_work%fname)
#  ifdef DEBUG
    WRITE(jp_stddbg,'(" - file """, A, """")') TRIM(xfs_work%fname)
#  endif
    xfs_work%xe => XMLSTRUCT(xfs_work%fname, &
      n_maxlen_eltname, n_maxlen_attname, n_maxlen_attcont)

    xfs_work%mx => XMLLOAD(xfs_work%fname, xfs_work%xe, n_maxdepth)

    IF (ASSOCIATED(xfs_work%next)) THEN
      xfs_work => xfs_work%next
    ELSE
      EXIT
    ENDIF

  ENDDO

ELSE

  WRITE(*,'("No process files registered")')

ENDIF


WRITE(*,'()')
IF (n_xmlequilfiles /= 0) THEN
  WRITE(*,'("Reading in the equilibrium files")')

  xfs_work => xml_equilfiles

  DO

    WRITE(*,'(" - file """, A, """")') TRIM(xfs_work%fname)
#  ifdef DEBUG
    WRITE(jp_stddbg,'(" - file """, A, """")') TRIM(xfs_work%fname)
#  endif
    xfs_work%xe => XMLSTRUCT(xfs_work%fname, &
      n_maxlen_eltname, n_maxlen_attname, n_maxlen_attcont)

    xfs_work%mx => XMLLOAD(xfs_work%fname, xfs_work%xe, n_maxdepth)

    IF (ASSOCIATED(xfs_work%next)) THEN
      xfs_work => xfs_work%next
    ELSE
      EXIT
    ENDIF

  ENDDO

ELSE

  WRITE(*,'("No equilibrium files registered")')

ENDIF


!CALL XFSL_dumpList(xml_compofiles, 99)
!WRITE(99,'()')
!WRITE(99,'()')
!CALL XFSL_dumpList(xml_procsfiles, 99)
!WRITE(99,'()')
!WRITE(99,'()')
!CALL XFSL_dumpList(xml_equilfiles, 99)


RETURN

!===============================================================================
 END SUBROUTINE XMLCOCOGEN_LOADDB
!===============================================================================
