!
!    Copyright 2014, 2015, 2017, 2018, 2020, 2021 Guy Munhoven
!
!    This file is part of µXML.
!
!    µXML is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    µXML is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with µXML.  If not, see <https://www.gnu.org/licenses/>.
!


!===============================================================================
 MODULE MOD_XMLCOCOGEN
!===============================================================================

USE MODMXM_STKXE, ONLY: stack_xmlevents
USE MODMXM_STKMX, ONLY: stack_minixml

IMPLICIT NONE


INTEGER, PARAMETER :: p_maxlen_eltname  = 31
INTEGER, PARAMETER :: p_maxlen_attname  = 31
INTEGER, PARAMETER :: p_maxlen_attcntt  = 1023
INTEGER, PARAMETER :: p_maxlen_filename = 4095


! Element-tag names in the µXML files
CHARACTER(LEN=*), PARAMETER :: cp_composition  = 'Composition'
CHARACTER(LEN=*), PARAMETER :: cp_solute       = 'Solute'
CHARACTER(LEN=*), PARAMETER :: cp_solutesystem = 'SoluteSystem'
CHARACTER(LEN=*), PARAMETER :: cp_solid        = 'Solid'
CHARACTER(LEN=*), PARAMETER :: cp_equilibria   = 'Equilibria'
CHARACTER(LEN=*), PARAMETER :: cp_equilibrium  = 'Equilibrium'
CHARACTER(LEN=*), PARAMETER :: cp_processes    = 'Processes'
CHARACTER(LEN=*), PARAMETER :: cp_process      = 'Process'

! Element attribute names in the µXML file
CHARACTER(LEN=*), PARAMETER :: cp_file         = 'file'
CHARACTER(LEN=*), PARAMETER :: cp_order        = 'order'


! µXML description File-name and Stack List (double-linked)
TYPE xfs_list
  CHARACTER(LEN=p_maxlen_filename) :: fname
  CHARACTER(LEN=p_maxlen_eltname)  :: c_type
  INTEGER                          :: i_order
  INTEGER                          :: i_system
  TYPE(stack_xmlevents), POINTER   :: xe
  TYPE(stack_minixml),   POINTER   :: mx
  TYPE(xfs_list),        POINTER   :: prev
  TYPE(xfs_list),        POINTER   :: next
END TYPE


CONTAINS

!-----------------------------------------------------------------------
 FUNCTION XFSL_createRoot() RESULT(xfs_list_root)
!-----------------------------------------------------------------------

IMPLICIT NONE

TYPE(xfs_list), POINTER :: xfs_list_root

NULLIFY(xfs_list_root)
ALLOCATE(xfs_list_root)
NULLIFY(xfs_list_root%prev)

CALL XFSL_initNode(xfs_list_root)

RETURN
!-----------------------------------------------------------------------
END FUNCTION XFSL_createRoot
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
 FUNCTION XFSL_addNode(xfs_list_node) RESULT(xfs_list_newnode)
!-----------------------------------------------------------------------

IMPLICIT NONE

TYPE(xfs_list), POINTER :: xfs_list_node
TYPE(xfs_list), POINTER :: xfs_list_newnode

IF (ASSOCIATED(xfs_list_node)) THEN
  IF (.NOT. ASSOCIATED(xfs_list_node%next)) THEN
    ALLOCATE(xfs_list_node%next)
    xfs_list_newnode      => xfs_list_node%next
    xfs_list_newnode%prev => xfs_list_node
    CALL XFSL_initNode(xfs_list_newnode)
  ELSE
    WRITE(*,*) '[add_xfs_list_node]: <xfs_list_node> has already a %next node -- Aborting!'
  CALL ABORT()

  ENDIF
ELSE
  WRITE(*,*) '[add_xfs_list_node]: <xfs_list_node> not yet ASSOCIATEd -- Aborting!'
  CALL ABORT()
ENDIF
  
RETURN

!-----------------------------------------------------------------------
END FUNCTION XFSL_addNode
!-----------------------------------------------------------------------


!-----------------------------------------------------------------------
 SUBROUTINE XFSL_initNode(xfs_list_node)
!-----------------------------------------------------------------------

IMPLICIT NONE

TYPE(xfs_list), POINTER :: xfs_list_node

IF (ASSOCIATED(xfs_list_node)) THEN
  xfs_list_node%fname    = '/dev/null'
  xfs_list_node%c_type   = 'Unknown'
  xfs_list_node%i_order  = -1
  xfs_list_node%i_system = -1
  NULLIFY(xfs_list_node%xe)
  NULLIFY(xfs_list_node%mx)
  NULLIFY(xfs_list_node%next)
ELSE
  WRITE(*,*) '[XFSL_initNode]: <xfs_list_node> not yet ASSOCIATEd -- Aborting!'
  CALL ABORT()
ENDIF

RETURN
  
!-----------------------------------------------------------------------
END SUBROUTINE XFSL_initNode
!-----------------------------------------------------------------------




!-----------------------------------------------------------------------
 SUBROUTINE XFSL_dumpList(xfs_list_node, iunit)
!-----------------------------------------------------------------------

IMPLICIT NONE

TYPE(xfs_list), POINTER :: xfs_list_node
INTEGER, INTENT(IN), OPTIONAL :: iunit
TYPE(xfs_list), POINTER :: xfs_work

IF (ASSOCIATED(xfs_list_node)) THEN

  xfs_work => xfs_list_node
  
  DO WHILE(ASSOCIATED(xfs_work))

    IF (PRESENT(iunit)) THEN
      WRITE(iunit, '(" %fname = <", A, ">")') TRIM(xfs_work%fname)
      WRITE(iunit, '(" %c_type = <", A, ">")') TRIM(xfs_work%c_type)
      WRITE(iunit, '(" %i_order = ", I0)') xfs_work%i_order
      WRITE(iunit, '(" %i_system = ", I0)') xfs_work%i_system
      IF (ASSOCIATED(xfs_work%xe)) THEN
        WRITE(iunit, '(" %xe is associated")')
      ELSE
        WRITE(iunit, '(" %xe => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%xe)) THEN
        WRITE(iunit, '(" %mx is associated")')
      ELSE
        WRITE(iunit, '(" %mx => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%prev)) THEN
        WRITE(iunit, '(" %prev is associated")')
      ELSE
        WRITE(iunit, '(" %prev => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%next)) THEN
        WRITE(iunit, '(" %next is associated")')
      ELSE
        WRITE(iunit, '(" %next => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%next)) THEN
        WRITE(iunit, '("#")')
      ENDIF

    ELSE
    
      WRITE(*, '(" %fname = <", A, ">")') TRIM(xfs_work%fname)
      WRITE(*, '(" %c_type = <", A, ">")') TRIM(xfs_work%c_type)
      WRITE(*, '(" %i_order = ", I0)') xfs_work%i_order
      WRITE(*, '(" %i_system = ", I0)') xfs_work%i_system
      IF (ASSOCIATED(xfs_work%xe)) THEN
        WRITE(*, '(" %xe is associated")')
      ELSE
        WRITE(*, '(" %xe => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%xe)) THEN
        WRITE(*, '(" %mx is associated")')
      ELSE
        WRITE(*, '(" %mx => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%prev)) THEN
        WRITE(*, '(" %prev is associated")')
      ELSE
        WRITE(*, '(" %prev => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%next)) THEN
        WRITE(*, '(" %next is associated")')
      ELSE
        WRITE(*, '(" %next => NULL")')
      ENDIF
      IF (ASSOCIATED(xfs_work%next)) THEN
        WRITE(*, '("#")')
      ENDIF
    ENDIF

    xfs_work => xfs_work%next

  ENDDO

ELSE

  IF (PRESENT(iunit)) THEN
    WRITE(iunit, '(" => NULL ")')
  ELSE
    WRITE(*, '(" => NULL ")')
  ENDIF

ENDIF

RETURN
  
!-----------------------------------------------------------------------
END SUBROUTINE XFSL_dumpList
!-----------------------------------------------------------------------


!===============================================================================
 END MODULE MOD_XMLCOCOGEN
!===============================================================================
