% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonalPlot.R
\name{seasonalPlot}
\alias{seasonalPlot}
\title{Seasonal plots with quantiles for LFMC data}
\usage{
seasonalPlot(
  speciesCode = 1,
  siteCode = 1,
  period = "Fortnight",
  MOutliers = T,
  AOutliers = F,
  plotCurrentYear = F
)
}
\arguments{
\item{speciesCode}{Integer indicating the species code.}

\item{siteCode}{Integer or a list indicating site codes.}

\item{period}{String indicating if LFMC values are shown by month or fortnight.}

\item{MOutliers}{Logical indicating if manually identified outliers are excluded.}

\item{AOutliers}{Logical indicating if additive outliers are excluded.}

\item{plotCurrentYear}{Logical indicating if data from the last two years are shown.}
}
\value{
A seasonal plot of an specific species-site request.
}
\description{
Seasonal plots with quantiles for LFMC data
}
\examples{
\dontrun{
   setDBpath("../data/lfmc.sqlite")
   seasonalPlot(speciesCode = 1, siteCode = 5, period = "Month")
}

}
