% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/populateLFMC.R
\name{populateLFMC}
\alias{populateLFMC}
\title{Populate LFMC data}
\usage{
populateLFMC(
  lfmc,
  dateIni = NULL,
  dateFin = NULL,
  dateFormat = "\%Y-\%m-\%d",
  varmapping = c(Date = "DATA", SamplingSiteCode = "CODI_PARCELA", SpeciesCode =
    "CODI_ESPECIE", SampleCode = "NUM_MOSTRA", FreshMass = "PES_FRESC", DryMass =
    "PES_SEC", DryStem = "PES_TIGES", DryLeaf = "PES_FULLES", PhenologyCode =
    "fenologia", Notes = "Observacions"),
  overwrite = FALSE,
  outlierSearch = F
)
}
\arguments{
\item{lfmc}{The data frame from which LFMC records are to be read.}

\item{dateIni}{String to indicate the earliest date to import (using format in \code{dateFormat}).}

\item{dateFin}{String to indicate the latest date to import (using format in \code{dateFormat}).}

\item{dateFormat}{String with date format (see \code{\link{as.Date}}).}

\item{varmapping}{Named vector of variable mappings (see details).}

\item{overwrite}{Whether or not to overwrite existing records. LFMC records are uniquely identified
with field 'SampleCode'.}

\item{outlierSearch}{Logical to indicate if outliers search routine is run}
}
\description{
Fills LFMC records from a data frame
}
\details{
Mapping should be provided at least for 'Date', 'SamplingSiteCode', 'SampleCode' and 'SpeciesCode'.
Variables 'LFMC' and 'LeafStemRatio' are by default calculated from imported values. Variable for 'Date' can be of class \code{\link{Date}} or
a string. In the latter case date strings are expected to be in \code{dateFormat}.

Records with missing 'SampleCode' are discarded. Records already existing in the database (i.e. records
corresponding to existing 'SampleCode' values) are also discarded, unless \code{overwrite = TRUE}. This
allows adding only new records even if the input data frame contains records already existing in the database.
}
\examples{
\dontrun{
# Initiate data base

initDB("../lfmc", overwrite = T)

# Parse records from file "2019.xlsx"

lfmc = openxlsx::read.xlsx("../LFMC_spif/2019.xlsx")
lfmc$DATA = openxlsx::convertToDate(lfmc$DATA)
populate_lfmc(lfmc)


# Parse records from another file using another (identity) mapping
varmapping2 = c("Date" = "DATA", "SamplingSiteCode"  = "CODI_PARCELA",
                "SampleCode" = "NUM_MOSTRA", "SpeciesCode" = "CODI_ESPECIE",
                "FreshMass" = "PES_FRESC", "DryMass" = "PES_SEC",
                "DryStem" = "PES_TIGES", "DryLeaf" = "PES_FULLES",
                "Notes" = "Observacions")
lfmc2 = openxlsx::read.xlsx("../LFMC_spif/2019.xlsx")
lfmc2$Date = openxlsx::convertToDate(lfmc2$Date)
populateLFMC(lfmc2, varmapping = varmapping2)
}

}
