% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlierSearch.R
\name{outlierSearch}
\alias{outlierSearch}
\title{Search outliers in LFMC data}
\usage{
outlierSearch(lfmc_db, plotImpute = F, plotOutlier = F)
}
\arguments{
\item{lfmc_db}{LFMC database connection}

\item{plotImpute}{Whether or not plot imputations by site_species series}

\item{plotOutlier}{Whether or not plot outliers by site_species series}
}
\description{
Routine for search and flagg outliers in LFMC data
}
\details{
Outlier search is carried out only for LFMC series with more than 15 years of data.
The parameters for the ARIMA model fitted to detect outliers by LFMC series are read from 'arimaParameters.rda'.
Delta parameter for TC was specified as 0.5 for Q. coccifera and 0.7 for the other species.
}
\examples{
\dontrun{
LFMC::setDBpath("lfmc.sqlite")
lfmc_db <- DBI::dbConnect(RSQLite::SQLite(), get("lfmcdbfile"))
outlierSearch(lfmc_db)
dbDisconnect(lfmc_db)
}

}
