#!/bin/bash

argc=$# 
argv=("$@") 
if [ $argc -lt 3 ]; then
   echo "Error: You must specify the path of the file with the residuals, the mask and the output path. Optionally the number of iterations and the alpha"
   echo " ./compute_cluster_size.sh <residuals_file> <mask_file> <output_path> [<num_iterations> <alpha>]"
   exit 
fi 


input_file="${argv[0]}"
mask="${argv[1]}"
out_path="${argv[2]}"

num_iter="10000"
alpha=0.05
if [ $argc -gt 3 ]; then
  num_iter="${argv[3]}"
fi
if [ $argc -gt 4 ]; then
  alpha="${argv[4]}"
fi


#For each residual files compute the smoothing
mkdir -p ${out_path}/tmp
cp ${input_file} ${out_path}/tmp/data.nii.gz

if [ -f "${out_path}/3dFWHMx.txt" ]; then
   rm ${out_path}/3dFWHMx.txt 
fi
if [ -f "${out_path}/acf.txt" ]; then
   rm ${out_path}/acf.txt 
fi


fslsplit ${out_path}/tmp/data.nii.gz ${out_path}/tmp/subj_
imgs=( ${out_path}/tmp/subj_* )
for img in ${imgs[*]}
do
  3dFWHMx -mask ${mask} -input ${img} -out ${out_path}/tmp/tmp.txt -acf NULL > ${out_path}/tmp/tmp_acf.txt
  cat ${out_path}/tmp/tmp.txt >> ${out_path}/FWHMx.txt
  cat ${out_path}/tmp/tmp_acf.txt | sed -n 2p >> ${out_path}/acf.txt
  rm ${out_path}/tmp/tmp.txt ${out_path}/tmp/tmp_acf.txt
done

######################  ACF  ######################

#Compute mean acf
xs=$( awk '{sum+=$1}END{print sum/NR}' ${out_path}/acf.txt )
ys=$( awk '{sum+=$2}END{print sum/NR}' ${out_path}/acf.txt )
zs=$( awk '{sum+=$3}END{print sum/NR}' ${out_path}/acf.txt )
echo "$xs $ys $zs"

#Compute cluster size for multiple test comparison
3dClustSim -acf $xs $ys $zs -athr 0.05 -iter 10000 -mask $mask -prefix ${out_path}/acf


######################  FWHM  ######################


#Compute mean smooth
xs=$( awk '{sum+=$1}END{print sum/NR}' ${out_path}/FWHMx.txt )
ys=$( awk '{sum+=$2}END{print sum/NR}' ${out_path}/FWHMx.txt )
zs=$( awk '{sum+=$3}END{print sum/NR}' ${out_path}/FWHMx.txt )
ms=$( echo|awk '{ print ('$xs'+'$ys'+'$zs')/3 }' )

3dClustSim -fwhm ${ms} -athr ${alpha} -iter ${num_iter} -mask $mask -prefix ${out_path}/fwhmx
   

rm -r ${out_path}/tmp
