function ttest_glm_new(data_file,mask_file,design_matrix_file,contrast_file,indx_variables_mean_center,out_path)


if exist(data_file)==0
  error('Data file does not exist: %s',data_file);
end
if exist(mask_file)==0
  error('Mask file does not exist: %s',mask_file);
end
if exist(design_matrix_file)==0
  error('Design file does not exist: %s',design_matrix_file);
end
if exist(contrast_file)==0
  error('Contrast file does not exist: %s',contrast_file);
end

X=load(design_matrix_file);
contrast=load(contrast_file);

%Threshold for clusters
p_thr=[0.05 0.02 0.01 0.005 0.002 0.001 0.0005 0.0002 0.0001];

%load data_file
[hdrd data]=read_nii(data_file);
[xdim,ydim,zdim,nvols]=size(data);
if nvols~=size(X,1)
    nvols
    size(X,1)
  error('The number of volumes of data file and the number of rows of the design matrix do not match');
end
if size(X,2)~=size(contrast,2)
  error('The number of variables in the design matrix do not match with the number of variabels in contrast file');
end


%Compute the glm
[hdr mask]=read_nii(mask_file);
if (xdim~=size(mask,1)) || (ydim~=size(mask,2))  || (zdim~=size(mask,3))
   error('The data and mask dimensions do not match');
end

%Convert data to 2D
mask=reshape(mask,[],1);
mask_indx=find(mask>0);
num_voxels_mask=length(mask_indx);
data=reshape(data,[],nvols);
%data=data(mask_indx,:);
y=data(mask_indx,:)';
%clear data;


%Remove rows with nan values
indx_nan=find(isnan(X));
[rows,~]=ind2sub(size(X),indx_nan);
if length(rows)>0
  rows=unique(rows);
  X(rows,:)=[];
  y(rows,:)=[];
  data(:,rows)=[];
  nvols=size(data,2);
  hdrd.image_dimension.dim(5)=nvols;
end
indx_nan=find(isnan(y));
y(indx_nan)=0;
%[rows,~]=ind2sub(size(y),indx_nan);
%if length(rows)>0
%  rows=unique(rows);
%  X(rows,:)=[];
%  y(rows,:)=[];
%  data(:,rows)=[];
%  nvols=size(data,2);
%  hdrd.image_dimension.dim(5)=nvols;
%end
clear rows indx_nan;


%Mean center desired variables
for i=1:length(indx_variables_mean_center)
   X(:,indx_variables_mean_center(i))=zscore(X(:,indx_variables_mean_center(i)));
end

df=size(X,1)-size(X,2);
bethas = pinv(X) * y; %bethas = inv(X'*X)*X' * y;
predicted_values = X * bethas;
residuals=y-predicted_values;
mean_squared_error=sum((residuals).^2)/df;

%Save residuals
if exist(out_path)==0
   mkdir(out_path);
end
img=zeros(size(data));
img(mask_indx,:)=residuals';
img=reshape(img,xdim,ydim,zdim,nvols);
save_nii(hdrd,img,sprintf('%s/residuals.nii.gz',out_path));

%hipotesis testing
hdr.image_dimension.datatype=64; %change data type to save as float64
for i=1:size(contrast,1)
  c=contrast(i,:);
  if exist(sprintf('%s/t%.2d',out_path,i))==0
    mkdir(sprintf('%s/t%.2d',out_path,i));
  end
%  if exist(sprintf('%s/t%.2d/corrected_voxel_level',out_path,i))==0
%    mkdir(sprintf('%s/t%.2d/corrected_voxel_level',out_path,i));
%  end
%  if exist(sprintf('%s/t%.2d/uncorrected_clusters',out_path,i))==0
%    mkdir(sprintf('%s/t%.2d/uncorrected_clusters',out_path,i));
%  end

  %compute t-test
  standard_error=sqrt(mean_squared_error.*(c*inv(X'*X)*c'));
  t_stat=(c*bethas)./standard_error;
  img=zeros(size(mask));
  img(mask_indx)=t_stat; 
  img=reshape(img,[xdim,ydim,zdim]);  
  save_nii(hdr,img,sprintf('%s/t%.2d/tstat.nii.gz',out_path,i));
  
   
  %%%%%%%%%%%%%%%%%%%%% 1 Tailed Ttest Positive %%%%%%%%%%%%%%%%%%%%%
  %Uncorrected Pvalues
  pvals=(1-tcdf(t_stat,df));
  indx1=find(pvals>1); 
  pvals(indx1)=pvals(indx1)-1;
  img=zeros(size(mask));
  img(mask_indx)=1-pvals; 
  img=reshape(img,[xdim,ydim,zdim]);  
  save_nii(hdr,img,sprintf('%s/t%.2d/uncorrected_pvals_1tailed_positive.nii.gz',out_path,i));

  %Uncorrected clusters
%  for pt=1:length(p_thr)
%    pthr=p_thr(pt);
%	if  exist('bwlabeln')>0
%		[clt,num_clt] = bwlabeln(double(img>=(1-pthr)));
%    else	
%	    [clt,num_clt]=extract_clusters(double(img>=(1-pthr)));
%	end
%    if num_clt>0
%       str=num2str(pthr); [~, rem]=strtok(str,'.');
%       save_nii(hdr,clt,sprintf('%s/t%.2d/uncorrected_clusters/1tailed_pos_%s.nii.gz',out_path,i,rem(2:end))); 
%    end
%  end
%  
%  %Bonferroni
%  img=zeros(size(mask));
%  img(mask_indx)=1-(pvals.*num_voxels_mask); 
%  img(find(img<0))=0;
%  img=reshape(img,[xdim,ydim,zdim]);  
%  save_nii(hdr,img,sprintf('%s/t%.2d/corrected_voxel_level/bonferroni_1tailed_positive.nii.gz',out_path,i));
%
%  %FDR
%  [sp,idx]=sort(pvals',1); spvalid=~isnan(sp);
%  indx_spvalid=find(spvalid>0);  n1=length(indx_spvalid);
%  qt=min(1,n1*sp(spvalid)./(1:n1)');
%  min1=nan;
%  q=ones(length(mask_indx),1);
%  for n=n1:-1:1,
%    min1=min(min1,qt(n));
%    q(idx(indx_spvalid(n)))=min1;
%  end
%  img=zeros(size(mask));
%  img(mask_indx)=1-q; 
%  img=reshape(img,[xdim,ydim,zdim]);  
%  save_nii(hdr,img,sprintf('%s/t%.2d/corrected_voxel_level/FDR_1tailed_positive.nii.gz',out_path,i));

  
  %%%%%%%%%%%%%%%%%%%%% 1 Tailed Ttest Negative %%%%%%%%%%%%%%%%%%%%%
  %Uncorrected Pvalues
  pvals=(1-tcdf((-1)*t_stat,df));
  indx1=find(pvals>1); 
  pvals(indx1)=pvals(indx1)-1;
  img=zeros(size(mask));
  img(mask_indx)=1-pvals; 
  img=reshape(img,[xdim,ydim,zdim]);  
  save_nii(hdr,img,sprintf('%s/t%.2d/uncorrected_pvals_1tailed_negative.nii.gz',out_path,i));
  
%  %Uncorrected clusters
%  for pt=1:length(p_thr)
%    pthr=p_thr(pt);
%	if  exist('bwlabeln')>0
%       [clt,num_clt] = bwlabeln(double(img>=(1-pthr))); 
%	else
%	   [clt,num_clt]=extract_clusters(double(img>=(1-pthr)));
%	end
%    if num_clt>0
%       str=num2str(pthr); [~, rem]=strtok(str,'.');
%       save_nii(hdr,clt,sprintf('%s/t%.2d/uncorrected_clusters/1tailed_neg_%s.nii.gz',out_path,i,rem(2:end))); 
%    end
%  end
%  
%  %Bonferroni
%  img=zeros(size(mask));
%  img(mask_indx)=1-(pvals.*num_voxels_mask); 
%  img(find(img<0))=0;
%  img=reshape(img,[xdim,ydim,zdim]);  
%  save_nii(hdr,img,sprintf('%s/t%.2d/corrected_voxel_level/bonferroni_1tailed_negative.nii.gz',out_path,i));
%
%  %FDR
%  [sp,idx]=sort(pvals',1); spvalid=~isnan(sp);
%  indx_spvalid=find(spvalid>0);  n1=length(indx_spvalid);
%  qt=min(1,n1*sp(spvalid)./(1:n1)');
%  min1=nan;
%  q=ones(length(mask_indx),1);
%  for n=n1:-1:1,
%    min1=min(min1,qt(n));
%    q(idx(indx_spvalid(n)))=min1;
%  end
%  img=zeros(size(mask));
%  img(mask_indx)=1-q; 
%  img=reshape(img,[xdim,ydim,zdim]);  
%  save_nii(hdr,img,sprintf('%s/t%.2d/corrected_voxel_level/FDR_1tailed_negative.nii.gz',out_path,i));
  
  
  
  %%%%%%%%%%%%%%%%%%%%%% 2 Tailed Ttest %%%%%%%%%%%%%%%%%%%%%%
  %Uncorrected Pvalues
  pvals=2*(1-tcdf(abs(t_stat),df));
  img=zeros(size(mask));
  img(mask_indx)=1-pvals; 
  img=reshape(img,[xdim,ydim,zdim]);  
  save_nii(hdr,img,sprintf('%s/t%.2d/uncorrected_pvals_2tailed.nii.gz',out_path,i));
  imgs=img;   imgs(mask_indx(find(t_stat<0)))=0;
  save_nii(hdr,imgs,sprintf('%s/t%.2d/uncorrected_pvals_2tailed_pos.nii.gz',out_path,i));
  imgs=img;   imgs(mask_indx(find(t_stat>0)))=0;
  save_nii(hdr,imgs,sprintf('%s/t%.2d/uncorrected_pvals_2tailed_neg.nii.gz',out_path,i));
  
  %Uncorrected clusters
%  for pt=1:length(p_thr)
%    pthr=p_thr(pt);
%	if  exist('bwlabeln')>0
%       [clt,num_clt] = bwlabeln(double(img>=(1-pthr))); 
%	else
%	   [clt,num_clt]=extract_clusters(double(img>=(1-pthr)));
%	end
%    if num_clt>0
%       str=num2str(pthr); [~, rem]=strtok(str,'.');
%       save_nii(hdr,clt,sprintf('%s/t%.2d/uncorrected_clusters/2tailed_%s.nii.gz',out_path,i,rem(2:end))); 
%    end
%	imgs=img;
%	imgs(mask_indx(find(t_stat<0)))=0;
%	if  exist('bwlabeln')>0
%	   [clt,num_clt] = bwlabeln(double(imgs>=(1-pthr)));  
%	else
%	   [clt,num_clt]=extract_clusters(double(imgs>=(1-pthr)));
%	end
%    if num_clt>0
%       str=num2str(pthr); [~, rem]=strtok(str,'.');
%       save_nii(hdr,clt,sprintf('%s/t%.2d/uncorrected_clusters/2tailed_pos_%s.nii.gz',out_path,i,rem(2:end))); 
%    end
%	imgs=img;
%	imgs(mask_indx(find(t_stat>0)))=0;
%	if  exist('bwlabeln')>0
%	   [clt,num_clt] = bwlabeln(double(imgs>=(1-pthr))); 
%	else
%	   [clt,num_clt]=extract_clusters(double(imgs>=(1-pthr)));
%	end
%    if num_clt>0
%       str=num2str(pthr); [~, rem]=strtok(str,'.');
%       save_nii(hdr,clt,sprintf('%s/t%.2d/uncorrected_clusters/2tailed_neg_%s.nii.gz',out_path,i,rem(2:end))); 
%    end
%  end
  
%  %Bonferroni
%  img=zeros(size(mask));
%  img(mask_indx)=1-(pvals.*num_voxels_mask); 
%  img(find(img<0))=0;
%  img=reshape(img,[xdim,ydim,zdim]);  
%  save_nii(hdr,img,sprintf('%s/t%.2d/corrected_voxel_level/bonferroni_2tailed.nii.gz',out_path,i));
%  imgs=img;  imgs(mask_indx(find(t_stat<0)))=0;
%  save_nii(hdr,imgs,sprintf('%s/t%.2d/corrected_voxel_level/bonferroni_2tailed_pos.nii.gz',out_path,i));
%  imgs=img;  imgs(mask_indx(find(t_stat>0)))=0;
%  save_nii(hdr,imgs,sprintf('%s/t%.2d/corrected_voxel_level/bonferroni_2tailed_neg.nii.gz',out_path,i));

%  %FDR
%  [sp,idx]=sort(pvals',1); spvalid=~isnan(sp);
%  indx_spvalid=find(spvalid>0);  n1=length(indx_spvalid);
%  qt=min(1,n1*sp(spvalid)./(1:n1)');
%  min1=nan;
%  q=ones(length(mask_indx),1);
%  for n=n1:-1:1,
%    min1=min(min1,qt(n));
%    q(idx(indx_spvalid(n)))=min1;
%  end
%  img=zeros(size(mask));
%  img(mask_indx)=1-q; 
%  img=reshape(img,[xdim,ydim,zdim]);  
%  save_nii(hdr,img,sprintf('%s/t%.2d/corrected_voxel_level/FDR_2tailed.nii.gz',out_path,i));
%  imgs=img;   imgs(mask_indx(find(t_stat<0)))=0;
%  save_nii(hdr,imgs,sprintf('%s/t%.2d/corrected_voxel_level/FDR_2tailed_pos.nii.gz',out_path,i));
%  imgs=img;   imgs(mask_indx(find(t_stat>0)))=0;
%  save_nii(hdr,imgs,sprintf('%s/t%.2d/corrected_voxel_level/FDR_2tailed_neg.nii.gz',out_path,i));
  
  
end


