function cluster_correction_new(tstat_path,clust_sim_path)

results_path=[ tstat_path '/corrected_clusters_montecarlo' ];
if exist(results_path)==0
  mkdir(results_path);
end

%%%%%%%%%%%%%%%%%%%%% fwhmx: 1 Tailed Ttest positive %%%%%%%%%%%%%%%%%%%%%

if ( (exist([clust_sim_path '/fwhmx.NN2_1sided.1D'])>0) && (exist([tstat_path '/uncorrected_pvals_1tailed_positive.nii.gz'])>0) )

   %Read cluster sizes
   clust_size=[];
   fid=fopen([clust_sim_path '/fwhmx.NN2_1sided.1D']);
   tline=fgets(fid);
   while ischar(tline)
     if  ~strncmpi(tline,'#',1)
       clust_size=[clust_size; str2num(tline)];
     end
     tline=fgets(fid);  
   end
   clust_size(:,2)=floor(clust_size(:,2));
   fclose(fid);
   
   %Read pvals
   [hdr pvals]=read_nii([tstat_path '/uncorrected_pvals_1tailed_positive.nii.gz']);
   
   %Compute clusters for different pvalue leves and a combination of all
   clusters=zeros(size(pvals)); 
   for i=1:size(clust_size,1)
      if  exist('bwlabeln')>0
        [clust,numc] = bwlabeln(double(pvals>=(1-clust_size(i,1)))); 
      else
        [clust,numc]=extract_clusters(double(pvals>=(1-clust_size(i,1)))); %Extract clusters
      end
      cont=0;
	  clustersi=zeros(size(pvals));
	  for c=1:numc
	    indxc=find(clust==c);
		c_size=length(indxc);
		if c_size>clust_size(i,2)
		  cont=cont+1;
		  clustersi(indxc)=cont;
		end
	  end
	  if cont>0
	     [~,pname]=strtok(num2str(clust_size(i,1)),'.');
	     save_nii(hdr,clustersi,[results_path '/1tailed_fwhmx_pos_' pname(2:end) '.nii.gz' ]);
	  end
	  clusters=clusters+clustersi;
   end

	if  exist('bwlabeln')>0
   [clusters,numc] = bwlabeln(double(clusters>0));   
	else
   [clusters,numc]=extract_clusters(double(clusters>0));
	end
   save_nii(hdr,clusters,[results_path '/1tailed_fwhmx_pos.nii.gz' ]);
   

end



%%%%%%%%%%%%%%%%%%%%% acf: 1 Tailed Ttest positive %%%%%%%%%%%%%%%%%%%%%

if ( (exist([clust_sim_path '/acf.NN2_1sided.1D'])>0) && (exist([tstat_path '/uncorrected_pvals_1tailed_positive.nii.gz'])>0) )

   %Read cluster sizes
   clust_size=[];
   fid=fopen([clust_sim_path '/acf.NN2_1sided.1D']);
   tline=fgets(fid);
   while ischar(tline)
     if  ~strncmpi(tline,'#',1)
       clust_size=[clust_size; str2num(tline)];
     end
     tline=fgets(fid);  
   end
   clust_size(:,2)=floor(clust_size(:,2));
   fclose(fid);
   
   %Read pvals
   [hdr pvals]=read_nii([tstat_path '/uncorrected_pvals_1tailed_positive.nii.gz']);
   
   %Compute clusters for different pvalue leves and a combination of all
   clusters=zeros(size(pvals)); 
   for i=1:size(clust_size,1)
	if  exist('bwlabeln')>0
      [clust,numc] = bwlabeln(double(pvals>=(1-clust_size(i,1)))); 
     else
      [clust,numc]=extract_clusters(double(pvals>=(1-clust_size(i,1)))); %Extract clusters
      end
	  cont=0;
	  clustersi=zeros(size(pvals));
	  for c=1:numc
	    indxc=find(clust==c);
		c_size=length(indxc);
		if c_size>clust_size(i,2)
		  cont=cont+1;
		  clustersi(indxc)=cont;
		end
	  end
	  if cont>0
	     [~,pname]=strtok(num2str(clust_size(i,1)),'.');
	     save_nii(hdr,clustersi,[results_path '/1tailed_acf_pos_' pname(2:end) '.nii.gz' ]);
	  end
	  clusters=clusters+clustersi;
   end
    if  exist('bwlabeln')>0
   [clusters,numc] = bwlabeln(double(clusters>0));   
    else 
   [clusters,numc]=extract_clusters(double(clusters>0));
    end
   save_nii(hdr,clusters,[results_path '/1tailed_acf_pos.nii.gz' ]);
   

end


%%%%%%%%%%%%%%%%%%%%% fwhmx: 1 Tailed Ttest negative %%%%%%%%%%%%%%%%%%%%%

if ( (exist([clust_sim_path '/fwhmx.NN2_1sided.1D'])>0) && (exist([tstat_path '/uncorrected_pvals_1tailed_negative.nii.gz'])>0) )

   %Read cluster sizes
   clust_size=[];
   fid=fopen([clust_sim_path '/fwhmx.NN2_1sided.1D']);
   tline=fgets(fid);
   while ischar(tline)
     if  ~strncmpi(tline,'#',1)
       clust_size=[clust_size; str2num(tline)];
     end
     tline=fgets(fid);  
   end
   clust_size(:,2)=floor(clust_size(:,2));
   fclose(fid);
   
   %Read pvals
   [hdr pvals]=read_nii([tstat_path '/uncorrected_pvals_1tailed_negative.nii.gz']);
   
   %Compute clusters for different pvalue leves and a combination of all
   clusters=zeros(size(pvals)); 
   for i=1:size(clust_size,1)
      if  exist('bwlabeln')>0
      [clust,numc] = bwlabeln(double(pvals>=(1-clust_size(i,1)))); 
      else 
      [clust,numc]=extract_clusters(double(pvals>=(1-clust_size(i,1)))); %Extract clusters
      end
	  cont=0;
	  clustersi=zeros(size(pvals));
	  for c=1:numc
	    indxc=find(clust==c);
		c_size=length(indxc);
		if c_size>clust_size(i,2)
		  cont=cont+1;
		  clustersi(indxc)=cont;
		end
	  end
	  if cont>0
	     [~,pname]=strtok(num2str(clust_size(i,1)),'.');
	     save_nii(hdr,clustersi,[results_path '/1tailed_fwhmx_neg_' pname(2:end) '.nii.gz' ]);
	  end
	  clusters=clusters+clustersi;
   end
   if  exist('bwlabeln')>0 
   [clusters,numc] = bwlabeln(double(clusters>0)); 
    else 
   [clusters,numc]=extract_clusters(double(clusters>0));
    end
   save_nii(hdr,clusters,[results_path '/1tailed_fwhmx_neg.nii.gz' ]);
   

end



%%%%%%%%%%%%%%%%%%%%% acf: 1 Tailed Ttest negative %%%%%%%%%%%%%%%%%%%%%

if ( (exist([clust_sim_path '/acf.NN2_1sided.1D'])>0) && (exist([tstat_path '/uncorrected_pvals_1tailed_negative.nii.gz'])>0) )

   %Read cluster sizes
   clust_size=[];
   fid=fopen([clust_sim_path '/acf.NN2_1sided.1D']);
   tline=fgets(fid);
   while ischar(tline)
     if  ~strncmpi(tline,'#',1)
       clust_size=[clust_size; str2num(tline)];
     end
     tline=fgets(fid);  
   end
   clust_size(:,2)=floor(clust_size(:,2));
   fclose(fid);
   
   %Read pvals
   [hdr pvals]=read_nii([tstat_path '/uncorrected_pvals_1tailed_negative.nii.gz']);
   
   %Compute clusters for different pvalue leves and a combination of all
   clusters=zeros(size(pvals)); 
   for i=1:size(clust_size,1)
       if  exist('bwlabeln')>0
      [clust,numc] = bwlabeln(double(pvals>=(1-clust_size(i,1)))); 
      else 
      [clust,numc]=extract_clusters(double(pvals>=(1-clust_size(i,1)))); %Extract clusters
      end
	  cont=0;
	  clustersi=zeros(size(pvals));
	  for c=1:numc
	    indxc=find(clust==c);
		c_size=length(indxc);
		if c_size>clust_size(i,2)
		  cont=cont+1;
		  clustersi(indxc)=cont;
		end
	  end
	  if cont>0
	     [~,pname]=strtok(num2str(clust_size(i,1)),'.');
	     save_nii(hdr,clustersi,[results_path '/1tailed_acf_neg_' pname(2:end) '.nii.gz' ]);
	  end
	  clusters=clusters+clustersi;
   end
   if  exist('bwlabeln')>0
   [clusters,numc] = bwlabeln(double(clusters>0)); 
   else 
   [clusters,numc]=extract_clusters(double(clusters>0));
   end
   save_nii(hdr,clusters,[results_path '/1tailed_acf_neg.nii.gz' ]);
   

end



%%%%%%%%%%%%%%%%%%%%% fwhmx: 2 Tailed Ttest positive %%%%%%%%%%%%%%%%%%%%%

if ( (exist([clust_sim_path '/fwhmx.NN2_bisided.1D'])>0) && (exist([tstat_path '/uncorrected_pvals_2tailed_pos.nii.gz'])>0) )

   %Read cluster sizes
   clust_size=[];
   fid=fopen([clust_sim_path '/fwhmx.NN2_bisided.1D']);
   tline=fgets(fid);
   while ischar(tline)
     if  ~strncmpi(tline,'#',1)
       clust_size=[clust_size; str2num(tline)];
     end
     tline=fgets(fid);  
   end
   clust_size(:,2)=floor(clust_size(:,2));
   fclose(fid);
   
   %Read pvals
   [hdr pvals]=read_nii([tstat_path '/uncorrected_pvals_2tailed_pos.nii.gz']);
   
   %Compute clusters for different pvalue leves and a combination of all
   clusters=zeros(size(pvals)); 
   for i=1:size(clust_size,1)
      if  exist('bwlabeln')>0
      [clust,numc] = bwlabeln(double(pvals>=(1-clust_size(i,1))));  
      else 
      [clust,numc]=extract_clusters(double(pvals>=(1-clust_size(i,1)))); %Extract clusters
      end
	  cont=0;
	  clustersi=zeros(size(pvals));
	  for c=1:numc
	    indxc=find(clust==c);
		c_size=length(indxc);
		if c_size>clust_size(i,2)
		  cont=cont+1;
		  clustersi(indxc)=cont;
		end
	  end
	  if cont>0
	     [~,pname]=strtok(num2str(clust_size(i,1)),'.');
	     save_nii(hdr,clustersi,[results_path '/2tailed_fwhmx_pos_' pname(2:end) '.nii.gz' ]);
	  end
	  clusters=clusters+clustersi;
   end
   if  exist('bwlabeln')>0
   [clusters,numc] = bwlabeln(double(clusters>0));  
   else 
   [clusters,numc]=extract_clusters(double(clusters>0));
   end
   save_nii(hdr,clusters,[results_path '/2tailed_fwhmx_pos.nii.gz' ]);
   

end



%%%%%%%%%%%%%%%%%%%%% acf: 2 Tailed Ttest positive %%%%%%%%%%%%%%%%%%%%%

if ( (exist([clust_sim_path '/acf.NN2_bisided.1D'])>0) && (exist([tstat_path '/uncorrected_pvals_2tailed_pos.nii.gz'])>0) )

   %Read cluster sizes
   clust_size=[];
   fid=fopen([clust_sim_path '/acf.NN2_bisided.1D']);
   tline=fgets(fid);
   while ischar(tline)
     if  ~strncmpi(tline,'#',1)
       clust_size=[clust_size; str2num(tline)];
     end
     tline=fgets(fid);  
   end
   clust_size(:,2)=floor(clust_size(:,2));
   fclose(fid);
   
   %Read pvals
   [hdr pvals]=read_nii([tstat_path '/uncorrected_pvals_2tailed_pos.nii.gz']);
   
   %Compute clusters for different pvalue leves and a combination of all
   clusters=zeros(size(pvals)); 
   for i=1:size(clust_size,1)
       if  exist('bwlabeln')>0
      [clust,numc] = bwlabeln(double(pvals>=(1-clust_size(i,1))));  
      else 
      [clust,numc]=extract_clusters(double(pvals>=(1-clust_size(i,1)))); %Extract clusters
      end
	  cont=0;
	  clustersi=zeros(size(pvals));
	  for c=1:numc
	    indxc=find(clust==c);
		c_size=length(indxc);
		if c_size>clust_size(i,2)
		  cont=cont+1;
		  clustersi(indxc)=cont;
		end
	  end
	  if cont>0
	     [~,pname]=strtok(num2str(clust_size(i,1)),'.');
	     save_nii(hdr,clustersi,[results_path '/2tailed_acf_pos_' pname(2:end) '.nii.gz' ]);
	  end
	  clusters=clusters+clustersi;
   end
    if  exist('bwlabeln')>0
   [clusters,numc] = bwlabeln(double(clusters>0));  
   else 
   [clusters,numc]=extract_clusters(double(clusters>0));
   end
   save_nii(hdr,clusters,[results_path '/2tailed_acf_pos.nii.gz' ]);
   

end


%%%%%%%%%%%%%%%%%%%%% fwhmx: 2 Tailed Ttest negative %%%%%%%%%%%%%%%%%%%%%

if ( (exist([clust_sim_path '/fwhmx.NN2_bisided.1D'])>0) && (exist([tstat_path '/uncorrected_pvals_2tailed_neg.nii.gz'])>0) )

   %Read cluster sizes
   clust_size=[];
   fid=fopen([clust_sim_path '/fwhmx.NN2_bisided.1D']);
   tline=fgets(fid);
   while ischar(tline)
     if  ~strncmpi(tline,'#',1)
       clust_size=[clust_size; str2num(tline)];
     end
     tline=fgets(fid);  
   end
   clust_size(:,2)=floor(clust_size(:,2));
   fclose(fid);
   
   %Read pvals
   [hdr pvals]=read_nii([tstat_path '/uncorrected_pvals_2tailed_neg.nii.gz']);
   
   %Compute clusters for different pvalue leves and a combination of all
   clusters=zeros(size(pvals)); 
   for i=1:size(clust_size,1)
       if  exist('bwlabeln')>0
      [clust,numc] = bwlabeln(double(pvals>=(1-clust_size(i,1))));  
      else 
      [clust,numc]=extract_clusters(double(pvals>=(1-clust_size(i,1)))); %Extract clusters
      end
	  cont=0;
	  clustersi=zeros(size(pvals));
	  for c=1:numc
	    indxc=find(clust==c);
		c_size=length(indxc);
		if c_size>clust_size(i,2)
		  cont=cont+1;
		  clustersi(indxc)=cont;
		end
	  end
	  if cont>0
	     [~,pname]=strtok(num2str(clust_size(i,1)),'.');
	     save_nii(hdr,clustersi,[results_path '/2tailed_fwhmx_neg_' pname(2:end) '.nii.gz' ]);
	  end
	  clusters=clusters+clustersi;
   end
    if  exist('bwlabeln')>0
   [clusters,numc] = bwlabeln(double(clusters>0));  
    else 
   [clusters,numc]=extract_clusters(double(clusters>0));
    end
   save_nii(hdr,clusters,[results_path '/2tailed_fwhmx_neg.nii.gz' ]);
   

end



%%%%%%%%%%%%%%%%%%%%% acf: 2 Tailed Ttest positive %%%%%%%%%%%%%%%%%%%%%

if ( (exist([clust_sim_path '/acf.NN2_bisided.1D'])>0) && (exist([tstat_path '/uncorrected_pvals_2tailed_neg.nii.gz'])>0) )

   %Read cluster sizes
   clust_size=[];
   fid=fopen([clust_sim_path '/acf.NN2_bisided.1D']);
   tline=fgets(fid);
   while ischar(tline)
     if  ~strncmpi(tline,'#',1)
       clust_size=[clust_size; str2num(tline)];
     end
     tline=fgets(fid);  
   end
   clust_size(:,2)=floor(clust_size(:,2));
   fclose(fid);
   
   %Read pvals
   [hdr pvals]=read_nii([tstat_path '/uncorrected_pvals_2tailed_neg.nii.gz']);
   
   %Compute clusters for different pvalue leves and a combination of all
   clusters=zeros(size(pvals)); 
   for i=1:size(clust_size,1)
      if  exist('bwlabeln')>0
      [clust,numc] = bwlabeln(double(pvals>=(1-clust_size(i,1))));  
      else 
      [clust,numc]=extract_clusters(double(pvals>=(1-clust_size(i,1)))); %Extract clusters
      end
	  cont=0;
	  clustersi=zeros(size(pvals));
	  for c=1:numc
	    indxc=find(clust==c);
		c_size=length(indxc);
		if c_size>clust_size(i,2)
		  cont=cont+1;
		  clustersi(indxc)=cont;
		end
	  end
	  if cont>0
	     [~,pname]=strtok(num2str(clust_size(i,1)),'.');
	     save_nii(hdr,clustersi,[results_path '/2tailed_acf_neg_' pname(2:end) '.nii.gz' ]);
	  end
	  clusters=clusters+clustersi;
   end
      if  exist('bwlabeln')>0
   [clusters,numc] = bwlabeln(double(clusters>0));  
      else 
   [clusters,numc]=extract_clusters(double(clusters>0));
      end
   save_nii(hdr,clusters,[results_path '/2tailed_acf_neg.nii.gz' ]);
   

end
