%This script generates a group mask to use in the stepwise connectivity
addpath([  'matlab' ]);

data_path=''; %path of the dparsfa folder (data_DPARSF/FunImgRCWSFB)
user_file_list=''; %txt file cointaining all the subjects name (the ones used in DPARSF)
gray_matter_mask_file=''; %grey matter file mask path


%Load subject names and session numbers
subject={}; num_subjects=0;
fid = fopen(user_file_list); %txt file cointaining all the subjects name
tline = fgetl(fid); 
while ischar(tline)
    num_subjects=num_subjects+1;
    subject{num_subjects}=tline;
    tline = fgetl(fid); 
end
fclose(fid);



%Read mask
[hdr mask]=read_nii(gray_matter_mask_file); %load gray matter mask in 5 mm
indx_mask=find(reshape(mask,[],1)>0);
indx_outmask=find(reshape(mask,[],1)==0);
mask_prob_map=zeros(size(mask));


for u=1:length(subject)

    fprintf('%s [%.2d/%d]\n',subject{u},u,length(subject));
    fmri_file=[ data_path '/FunImgRCWSFB/' subject{u} '/' subject{u} '_4DVolume_brain.nii']; %load images created by DPARSFA preprocessing
    if exist(fmri_file)==0
       fprintf(' Files does not exist: %s\n',fmri_file);
       continue;
    end
    [hdri img]=read_nii(fmri_file);
    [xdim,ydim,zdim,tdim]=size(img);
    if ( size(img,1)~=size(mask,1) |  size(img,2)~=size(mask,2)  |  size(img,3)~=size(mask,3) )
       error('Subject %s is not in the same space as template',subject{u}); 
    end
    img=reshape(img,[],tdim);
    img(indx_outmask,:)=0;
    m=std(img');
    
    %Mask the data
    m=double(abs(m)>0.1);
    m=reshape(m,[xdim ydim zdim]);
    mask_prob_map=mask_prob_map+m;

    clear  img  hdri m;
end


%Save probabilty mask
mask_prob_map=mask_prob_map./length(subject);
save_nii(hdr,mask_prob_map,'prob_mask_new.nii.gz');
save_nii(hdr,double(mask_prob_map>0.75),'prob_mask_new_75bin.nii.gz');
