%Combine stepwise maps
addpath('matlab') %path of different matlab script

data_path=''; %data path with stepwise results (results_path of compute_stepwise.m script)
user_file_list=''; %txt file cointaining all the subjects name (the ones used in DPARSF)
gray_matter_mask_file=''; %define the path and the name of the gray matter mask (to generate a group mask you can use dparsfa_mask_data.m)
results_path=''; %Path to store results
num_steps=4;% number of steps (in our study steps=4)
region_name={'midbrain'}; %name of different seed regions


%Load subject names and session numbers
subject={}; num_subjects=0;
fid = fopen(user_file_list); %txt file cointaining all the subjects name
tline = fgetl(fid); 
while ischar(tline)
    num_subjects=num_subjects+1;
    subject{num_subjects}=tline;
    tline = fgetl(fid); 
end
fclose(fid);


 %load gray matter file to mask data
[hdr mask]=read_nii(gray_matter_mask_file);
[dimx,dimy,dimz]=size(mask);
mask_indx=find(reshape(mask,[],1)>0);
num_rois=length(mask_indx);


for region=1:length(region_name) %different region

     for s=1:num_subjects 
           filename=[ data_path '/' region_name{region} '/steps/' subject{s} '_step1_z.nii.gz'  ];
           
           if exist(filename, 'file')==0 % check if it is present
               fprintf(' No file found %s\n',filename);
               continue;
           end

            for i=1:num_steps
                filename=[ data_path '/' region_name{region} '/steps/' subject{s} '_step' num2str(i) '_z.nii.gz'  ];
                 [hdr_step mask_step]=read_nii(filename);
                  mask_step=mask_step(mask_indx);

                  %save data in a vector
                  eval(['rmask_step' num2str(i) '=mask_step;']);

            end
            clear rmask_step;

            r_mask_allsteps=zeros(num_rois,1);
            for j=1:num_rois
                voxel_step(1,1)=double(rmask_step1(j));
                voxel_step(2,1)=double(rmask_step2(j));
                voxel_step(3,1)=double(rmask_step3(j));
                voxel_step(4,1)=double(rmask_step4(j));

                if voxel_step(:,1)==0
                    r_mask_allsteps(j,1)=0;
                else 
                    [max_value,index]=nanmax(voxel_step);
                    r_mask_allsteps(j,1)=index;
                end

                clear voxel_step max_value index
            end

            img=zeros(dimx,dimy,dimz);
            img(mask_indx)=r_mask_allsteps;
            save_nii(hdr_step,img,[ results_path '/' subject{s} '_allsteps.nii.gz']);
     

    end

end