%Compute individual subjects stepwise connectivity from a seed region
addpath('matlab');

data_path=''; %path of data after preprocessing
user_file_list=''; %txt file cointaining all the subjects name (the ones used in DPARSF)
gray_matter_mask_file=''; %define the path and the name of the gray matter mask (to generate a group mask you can use dparsfa_mask_data.m)
results_path=''; %Path to store results
num_steps=4;% number of steps (in our study steps=4)
q_fdr=0.05; %FDR correction threshold

regions_name={'midbrain'}; %name of different seed regions
seed_mask_file={'midbrain.nii.gz'}; %path and name of the seed regions in nifti


%Load subject names and session numbers
subject={}; num_subjects=0;
fid = fopen(user_file_list); %txt file cointaining all the subjects name
tline = fgetl(fid); 
while ischar(tline)
    num_subjects=num_subjects+1;
    subject{num_subjects}=tline;
    tline = fgetl(fid); 
end
fclose(fid);


%Load grey matter mask
[hdr mask]=read_nii(gray_matter_mask_file);
[dimx,dimy,dimz]=size(mask);
mask_indx=find(reshape(mask,[],1)>0);
num_rois=length(mask_indx);


for region=1:length(regions_name)

    %Read seed mask
    [hdrs seed]=read_nii(seed_mask_file{region});

    if ( size(seed,1)~=dimx | size(seed,2)~=dimy | size(seed,3)~=dimz )
        error('The seed file and mask are not in the same resolution');
    end

    seed=reshape(seed,[],1); %convert 1d
    seed=seed(mask_indx);
    indx_seed=find(seed>0);

    if length(indx_seed)==0
       error('No seed or seed outside the mask');
    end

    mkdir([ results_path '/' regions_name{region} '/steps']); %create an output directory
    mkdir([ results_path '/fc_matrix']); %create an output directory
    
    fprintf('%s [%.2d/%.2d]\n',regions_name{region},region,length(regions_name));
    for i=1:num_subjects

       
       fprintf(' %s [%.2d/%.2d]\n',subject{i},i,num_subjects);
       
       fmri_file=[ data_path '/FunImgRCWSFB/' subject{i} '/' subject{i} '_4DVolume_brain.nii']; %load images created by DPARSFA preprocessing
       if exist(fmri_file)==0
           fprintf(' Files does not exist: %s\n',fmri_file);
           continue;
       end
       
       [hdrf img]=read_nii(fmri_file);
       num_tp=size(img,4);
       
       %Compute fc matrix
       img=reshape(img,[],num_tp); %convert to 2d
       img=img(mask_indx,:); %mask the data
       [fc,pvals]=corr(img');
       fc(1:(1+num_rois):end)=0; %diagonal to zero
       fc= 0.5 * log( ( 1 + fc)./( 1 - fc) ); %fisher
       fc(find(isnan(fc) | isinf(fc)))=0;
       fc_=fc;  fc_(find(fc_<0))=0;
       indx=find(fc_>0);
       [n_signif,indx_signif]=fdr(pvals(indx),q_fdr,'original','mean');
       fdr_matrix=zeros(size(pvals));
       fdr_matrix(indx(indx_signif))=1;
       fdr_matrix=uint8(fdr_matrix);
       save([ results_path '/fc_matrix/' subject{i} '.mat'],'fc','q_fdr','fdr_matrix');
      
       % Run the next two rows only if you already computed the fc matrices
       % (from line 65 to 78)
       %load([ results_path '/fc_matrix/' subject{i} '.mat']); 
       %fc_=fc;  fc_(find(fc_<0))=0;

       % Compute Stepwise
       m=size(fc,1); 
       adj=fc.*double(fdr_matrix); 
       adj=(adj - min(adj(:)))./ (max(adj(:)) - min(adj(:))); %normalize
       adj(1:(m+1):end)=0; %diagonal to zero
       step1=adj;
       img=zeros(dimx,dimy,dimz);
       if length(indx_seed)>1
            vec=sum(step1(indx_seed,:));
       else
           vec=step1(indx_seed,:);
       end
       vec(vec==0)=NaN;
       img(mask_indx)=vec;
       img(mask_indx(~isnan(img(mask_indx))))=zscore(img(mask_indx(~isnan(img(mask_indx)))));
       save_nii(hdr,img,[ results_path '/' regions_name{region} '/steps/' subject{i} '_step1_z.nii.gz' ]);


           adjp=step1;

           for s=2:num_steps
              adj=adjp*step1;
              adj=(adj - min(adj(:)))./ (max(adj(:)) - min(adj(:))); %normalize
              adj(1:(m+1):end)=0; %diagonal to zero
              img=zeros(dimx,dimy,dimz);
              if length(indx_seed)>1
                    vec=sum(adj(indx_seed,:));
              else
                  vec=adj(indx_seed,:);
              end
              vec(vec==0)=NaN;
              img(mask_indx)=vec;
              img(mask_indx(~isnan(img(mask_indx))))=zscore(img(mask_indx(~isnan(img(mask_indx)))));
              save_nii(hdr,img,[ results_path '/' regions_name{region} '/steps/' subject{i} '_step' num2str(s) '_z.nii.gz' ]);
              adjp=adj;	  
           end

           clear fc fdr_matrix adj adjp step1 img vec

    end
    
    clear hdrs seed indx_seed

end