addpath('matlab');
%This script will compute the statistical analysis and compute monte carlo
%simulation with AFNI software to correct for multiple comparisons

data_path=''; %Data path where the images for the statistical are
files_names=''; %Path to txt file where the  names of nifti files in data_path to be used in the statistical analysis
design_matrix_file=''; %Txt path with the design matrix 
contrast_file=''; %Txt path with the contrast
mask_file=''; %Mask fike path indicating the voxels where the statistical analysis will be applied
indx_variables_mean_center=[]; %If we want to mean center columns of the design matrix specify them here 
out_path='';
permutation_testing=0; % if set to 1 it will also compute fsl randomise permutation analysis to correct for multiple comparisons



%%%%%%% Code starts here

%Create data file
if exist(out_path)~=0
   system(['rm -r ' out_path]);   
end
mkdir(out_path);
if exist(files_names)==0
    error('File containing filenames does not exist: %s',files_names);
end

%Read user file
subjects={}; num_subjects=0;
fid = fopen(files_names);
tline = fgetl(fid);
while ischar(tline)
    num_subjects=num_subjects+1;
    subjects{num_subjects}=tline;
    tline = fgetl(fid);
end
fclose(fid);

%Create a 4d file
fprintf('Concatenating images...\n');
if exist(mask_file)==0
    error('Mask file does not exist. %s',mask_file);
end
[hdr mask]=read_nii(mask_file);
data=zeros([size(mask) num_subjects]);
for i=1:num_subjects
   if exist([data_path '/' subjects{i} '.nii.gz' ])==0
       error('Can not find %s subject data file. %s',subjects{i},[data_path '/' subjects{i} '.nii.gz' ]);
   end
   [hdri img]=read_nii([data_path '/' subjects{i} '.nii.gz' ]);
   
   if ( size(img,1)~=size(data,1) | size(img,2)~=size(data,2) | size(img,3)~=size(data,3) )
       error('The resolution of the mask and %s data file is not the same',subjects{i});
   end
   if size(img,4)~=1
       error('The %s subject data file has more than one volumes (n=%d)',subjects{i},size(img,4));
   end
   data(:,:,:,i)=img;
end
hdrn=hdr;
hdrn.image_dimension.datatype=64;
hdrn.image_dimension.dim(1)=4; hdrn.image_dimension.dim(5)=num_subjects;
hdrn.image_dimension.pixdim(5)=1;
save_nii(hdrn,data,[out_path '/data.nii.gz']);
clear data hdrn fid hdr mask hdri i img tline;

%Copy rest of the files to the result folder
copyfile(mask_file,[out_path '/mask.nii.gz']);
copyfile(design_matrix_file,[out_path '/design_matrix.txt']);
copyfile(contrast_file,[out_path '/contrast.txt']);


%Compute statistics
fprintf('Computing the statistics...\n');
ttest_glm_new([out_path '/data.nii.gz'],mask_file,design_matrix_file,contrast_file,indx_variables_mean_center,[out_path '/parametric_test']);



% Monte carlo simulation for cluster size
fprintf('Monte carlo simulation for cluster size multiple comparison correction...\n');
system([  'scripts/compute_cluster_size.sh ' out_path '/parametric_test/residuals.nii.gz ' mask_file ' ' out_path '/parametric_test/clust_size']);



%Apply cluster size correction
c=load(contrast_file);
num_contrast=size(c,1);
clear c;
for c=1:num_contrast
    cluster_correction_new(sprintf('%s/parametric_test/t%.2d',out_path,c),[out_path '/parametric_test/clust_size']);
end


% COmpute FSL randomize
if permutation_testing==1
   if exist([out_path '/nonparametric_test'])==0
      mkdir([out_path '/nonparametric_test']); 
   end
   
   %Create design matrix
   system(['Text2Vest ' design_matrix_file ' ' out_path '/nonparametric_test/design.mat' ]);
   
   %Create contrast file
   c=load(contrast_file);
   num_contrast=size(c,1);
   for i=1:num_contrast
      ci=-1*c(i,:);
      if any(sum(abs(c-ci),2)==0)
          continue;
      end
      c=[c; ci];
   end
   fid=fopen([out_path '/nonparametric_test/contrast.txt'],'w');
   for i=1:size(c,1)
       for j=1:size(c,2)
          fprintf(fid,'%d ',c(i,j));
       end
       fprintf(fid,'\n');
   end
   fclose(fid);
   system(['Text2Vest ' out_path '/nonparametric_test/contrast.txt ' out_path '/nonparametric_test/contrast.mat' ]);
   
   system(['randomise -i ' out_path '/data.nii.gz -m ' mask_file ' -o ' out_path '/nonparametric_test/fsl -d ' out_path '/nonparametric_test/design.mat -t ' out_path '/nonparametric_test/contrast.mat -T -n 5000' ])
   system(['randomise -i ' out_path '/data.nii.gz -m ' mask_file ' -o ' out_path '/nonparametric_test/fslc -d ' out_path '/nonparametric_test/design.mat -t ' out_path '/nonparametric_test/contrast.mat -c 2.3 -n 5000' ])
   

end