from ovito.io import import_file, export_file
from ovito.modifiers import SelectTypeModifier, ClusterAnalysisModifier
import numpy as np

ind = 0;
pipeline = import_file("fast.gsd")
pipeline.modifiers.append(SelectTypeModifier(property='Particle Type', types={'A'}))
pipeline.modifiers.append(ClusterAnalysisModifier(neighbor_mode=ClusterAnalysisModifier.NeighborMode.Bonding, only_selected=True, unwrap_particles=True, sort_by_size=True))
for frame in range(0, pipeline.source.num_frames + 1, 10):
	data = pipeline.compute(frame)
	cluster_sizes = np.bincount(data.particles['Cluster'])
	#remove first value which is always ridiculous for some reason
	cluster_sizes = cluster_sizes[1:-1]
	output_filepath = "cluster_sizes.%i.txt" % ind
	ind += 1
	np.savetxt(output_filepath, cluster_sizes)


