;--------------------------------------------------------------------------------------
;
;  October 2020
;  Script associated to publication:
;  "Sensitivity of precipitation and temperature over Mount Kenya area to
;   physics parameterization options in a high-resolution model simulation
;   performed with WRFV3.8.1"
;  Authors: M. Messmer, S.j. González-Rojí, C.C. Raible and T.F. Stocker
; 
; 
;  Creative Commons Licence: Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)
;--------------------------------------------------------------------------------------
begin

  dom     = getenv("DOM")    ;get domain number you would like to plot
  country = getenv("COU")    ;give country name you would like to plot, so that filenames are properly named
  setting = getenv("SET")    ;provide parent grid and number of nests, used for naming the input files
  nr_doms = getenv("NDOM")   ;provide number of domains in total, used for naming the input files
  era5_r  = getenv("E5_R")   ;filename of ERA5 precipitation
  alt_r   = getenv("ALT_R")  ;alternative data for precipitation, i.e., TRMM
  alt_r2  = getenv("ALT_R2") ;alternative data for precipitation, i.e., IMERG
  alt_r3  = getenv("ALT_R3") ;alternative data for precipitation, i.e., CHIRPS
  wrf_f   = getenv("WRF")
  alt_setting = getenv("ALT");add naming convention, just used to finde the proper file

  files_RR = systemfunc("ls RR-D0"+dom+"-ERA5-"+country+"-"+setting+"-*-"+nr_doms+"-2008-monthlysum.nc")
  dd = dimsizes(files_RR)

  in = addfile(files_RR(0),"r")
  vv = in->prc
  t_d = dimsizes(vv)
  t_dim = dimsizes(t_d)
  dSizes = getfiledimsizes(in)

  if (t_dim .eq. 4) then
    ntime = t_d(0)
    nlat  = t_d(2)
    nlon  = t_d(3)
  else if (t_dim .eq.3) then
    ntime = t_d(0)
    nlat  = t_d(1)
    nlon  = t_d(2)
  end if
  end if
 
  experiment = (/"ERA5","AltData","AltData2","Alt","Cumulus3-1Way","Cumulus3","S.America","Europe","NoCumulus"/)
  RR = new((/9,ntime,nlat,nlon/),float)
  if (dd .eq.5) then
    mi = 5
  else
    mi = 6
  end if
  do i = 0,dimsizes(experiment)-mi 
    if (t_dim .eq. 4) then
      in = addfile(files_RR(i),"r")
      lat = in->lat
      lon = in->lon
      RR(i+4,:,:,:) = tofloat(in->prc)
    else if (t_dim .eq. 3) then
      in = addfile(files_RR(i),"r")
      lat = in->lat
      lon = in->lon
      RR(i+4,:,:,:) = tofloat(in->prc)
    end if
    end if 
  end do

  in = addfile(era5_r,"r")
  RR(0,:,:,:) = tofloat(in->var1(0:11,:,:))
  in = addfile(alt_r,"r")
  RR(1,:,:,:) = tofloat(in->PR(0:11,:,:))
  in = addfile(alt_r2,"r")
  RR(2,:,:,:) = tofloat(in->PR(0:11,:,:))
  in = addfile(alt_r3,"r")
  RR(3,:,:,:) = tofloat(in->precip(0:11,:,:))
  print(""+min(RR(0,:,:,:))+"  "+avg(RR(0,:,:,:))+"  "+max(RR(0,:,:,:)))
  print(""+min(RR(1,:,:,:))+"  "+avg(RR(1,:,:,:))+"  "+max(RR(1,:,:,:)))
  print(""+min(RR(2,:,:,:))+"  "+avg(RR(2,:,:,:))+"  "+max(RR(2,:,:,:)))
  print(""+min(RR(8,:,:,:))+"  "+avg(RR(8,:,:,:))+"  "+max(RR(8,:,:,:)))
  in = addfile(wrf_f,"r")

  wks  = gsn_open_wks("pdf","RR_annualcycle_"+country+"_2008_D0"+dom+"_"+alt_setting)
  gsn_define_colormap(wks,"parameterization")

  exp_name  = (/"ERA5","TRMM","IMERG","CHIRPS","Cumulus3-1Way","Cumulus3","South America","Europe","No Cumulus"/)
  exp_label = (/7,6,5,4,8,0,2,1,3/)

  rr = dim_avg_n(RR,(/2,3/))
  rr_yr = dim_sum_n(rr,1)
  printVarSummary(rr_yr)

  mon = (/"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"/)
  print(""+rr(3,3)+"  "+rr(2,3)+"  "+rr(1,3))
  res                  = True
  res@gsnMaximize      = True
  res@gsnPaperOrientation = "Landscape"
  res@vpHeightF        = 0.4      
  res@vpWidthF         = 0.8
  res@xyDashPattern    = 0                        
  res@xyLineThicknessF = 3.0
  res@xyLineColors     = (/2,3,4,5,6,7,8,9,10/) 
  res@trXMinF          = 1
  res@trXMaxF          = 12
  res@trYMinF          = 0
  res@trYMaxF          = 220
  res@tmXBMode         = "Explicit"
  res@tmXBValues       = ispan(1,12,1)
  res@tmXBLabels       = mon
  res@tmXBLabelFontHeightF = 0.012
  res@pmLegendDisplayMode    = "Always"
  res@xyExplicitLabels       = exp_name
  res@lgJustification        = "TopCenter"
  res@lgLabelFontHeightF     = 0.015     ; Change the font size

  plot  = gsn_csm_xy(wks,ispan(1,12,1),rr,res) 

  resa                       = True
  resa@gsnFrame              = False                
  resa@gsnXYBarChart         = True                 
  resa@gsnXYBarChartBarWidth = 0.95                 
  resa@gsnXYBarChartColors   = (/2,3,4,5,6,7,8,9,10/)
  resa@gsnXYBarChartColors   = (/9,8,7,6,10,2,4,3,5/)
  resa@tmXBOn                = False                
  resa@trYMinF               = 0                    
  resa@trYMaxF               = 1200                    
  resa@trXMinF               = 0                    
  resa@trXMaxF               = 10                    
  resa@vpWidthF              = 0.8
  resa@vpHeightF             = 0.4 
  
  x = ispan(1,9,1)
  rr_sort = rr_yr 
  exp_label = (/7,6,5,4,8,0,2,1,3/)
  rr_sort = rr_yr(exp_label)
  print(""+rr_sort+"  "+rr_yr)
  plota = gsn_csm_xy(wks,x,rr_sort,resa)

  txres                     = True                 ; text mods desired
  txres@txFontHeightF       = 0.018                ; default size is HUGE!
  txres@txAngleF            = 90.                  ; text angle
  txres@txJust              = "CenterLeft"         ; puts text on top of bars
  txres@txFont              = "helvetica-bold"
  txres@txFontColor         = "white"

  do m = 0,8
    txres@txFontHeightF = 0.018                ; default size is HUGE!
    txres@txAngleF      = 90.                  ; text angle
    txres@txFont        = "helvetica-bold"
    txres@txFontColor   = "white"
    txres@txJust        = "CenterLeft"         ; puts text on top of bars
    n = exp_label(m)
    gsn_text(wks,plota,exp_name(n),m+1,15,txres) ; add labels
    txres@txAngleF      = 0.  
    txres@txFontHeightF = 0.015
    txres@txFont        = "helvetica"
    txres@txFontColor   = "black"
    txres@txJust        = "TopCenter"         ; puts text on top of bars
    gsn_text(wks,plota,sprintf("%5.0f",rr_sort(m)),m+1,rr_sort(m)+100,txres) ; add labels
  end do
  frame(wks)

end
