#------------------------------------------------------
#
#    October 2020
#    Script associated to publication:
#    "Sensitivity of precipitation and temperature over Mount Kenya area to 
#     physics parameterization options in a high-resolution modelsimulation 
#     performed with WRFV3.8.1"
#    Authors: M. Messmer, S.J. Gonzlez-Roj, C.C. Raible and T.F. Stocker
#
#
#    Creative Commons License: Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)
#------------------------------------------------------


useIMERG=TRUE

#--------------------------------------------------------
#   Read nearest Data
#--------------------------------------------------------

nearestCETRAD <- read.table(file="../Data_CETRAD/nearest_SetUp9km_3Doms_d03.dat",header=T, sep = ";")
nearestWMO <- read.table(file="../Data_WMO/nearest_SetUp9km_3Doms_d03.dat",header=T, sep = ";")
nearestGeoDay <- read.table(file="../Data_Geography/2008/nearest_SetUp9km_3Doms_d03_Daily.txt",header=T, sep = ";")
nearestGeoMon <- read.table(file="../Data_Geography/2008/nearest_SetUp9km_3Doms_d03_Monthly.txt",header=T, sep = ";")


#--------------------------------------------------------
#   Read Data Experiments and ERA5 from WMO
#--------------------------------------------------------


wmoERA5 <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-ERA5-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
wmoERA5 <- wmoERA5[-length(wmoERA5$year),]
wmoIMERG <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-IMERG-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
wmoTRMM <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-TRMM-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
wmoNoCumulus <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-NoCumulus-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
wmoCHIRPS <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-CHIRPS-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")

wmoMarcelo <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-Marcelo-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
wmoCumulus3 <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-Cumulus3-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
wmoCumulus3OneWay <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-Cumulus3-1Way-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
wmoMartina <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-Martina-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")



#--------------------------------------------------------
#   Read Data Experiments and ERA5 from CETRAD
#--------------------------------------------------------


cetradERA5 <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-ERA5-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
cetradERA5 <- cetradERA5[-length(cetradERA5$year),]
cetradIMERG <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-IMERG-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
cetradTRMM <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-TRMM-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
cetradNoCumulus <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-NoCumulus-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
cetradCHIRPS <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-CHIRPS-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")

cetradMarcelo <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-Marcelo-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
cetradCumulus3 <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-Cumulus3-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
cetradCumulus3OneWay <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-Cumulus3-1Way-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
cetradMartina <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-Martina-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")


#--------------------------------------------------------
#   Read Data Experiments and ERA5 from GEO DAILY
#--------------------------------------------------------

geoDayERA5 <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-ERA5-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoDayERA5 <- geoDayERA5[-length(geoDayERA5$year),]
geoDayIMERG <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-IMERG-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoDayTRMM <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-TRMM-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoDayNoCumulus <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-NoCumulus-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoDayCHIRPS <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-CHIRPS-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")

geoDayMarcelo <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-Marcelo-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoDayCumulus3 <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-Cumulus3-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoDayCumulus3OneWay <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-Cumulus3-1Way-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoDayMartina <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-Martina-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")

#--------------------------------------------------------
#   Read Data Experiments and ERA5 from GEO MONTHLY
#--------------------------------------------------------

geoMonERA5 <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-ERA5-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoMonERA5 <- geoMonERA5[-length(geoMonERA5$year),]
geoMonIMERG <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-IMERG-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoMonTRMM <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-TRMM-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoMonNoCumulus <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-NoCumulus-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoMonCHIRPS <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-CHIRPS-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")

geoMonMarcelo <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-Marcelo-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoMonCumulus3 <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-Cumulus3-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoMonCumulus3OneWay <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-Cumulus3-1Way-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoMonMartina <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-Martina-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")


library(RNetCDF)
library(plotrix)
library (akima)


#--------------------------------
#
# Plots for all the stations
#
#--------------------------------

wmoTargets <- rep(NA, length(wmoMartina$V3))

for (i in 1:length(nearestWMO$stID)) {
  
  
  #i=1
  statID <- nearestWMO$stID[i]
  StatName <- as.character(nearestWMO$Name[i])
  WMO <- open.nc(sprintf("../Data_WMO/%s_daily_2008.nc",StatName), write=FALSE)
  
  Prec <- var.get.nc(WMO,'rr')
  
  if (StatName=="Nyeri"){
    # We need to delete the outlier with more than 200 mm in one day
     Prec[114]<-NA
  }
  

  #--------------------------------
  #   Cogemos los datos temporales y los pasamos a modo tabla
  #--------------------------------
  
  tvals=var.get.nc(WMO,"time")
  iyear=c()
  imonth=c()
  # This does NOT work unless you have already installed udunits2!!
  utinit.nc()
  tstring=att.get.nc(WMO,"time","units")
  tdates=utcal.nc(tstring,tvals)
  
  
  Prec <- cbind(tdates[,1:3],Prec)
  Prec <- as.data.frame(Prec)
  
  # Copy the NA structure
  
  indexNA <- is.na(Prec$Prec)
  is.na(wmoMarcelo[,i+3]) <- indexNA
  is.na(wmoERA5[,i+3]) <- indexNA
  is.na(wmoCumulus3[,i+3]) <- indexNA
  is.na(wmoCumulus3OneWay[,i+3]) <- indexNA
  is.na(wmoMartina[,i+3]) <- indexNA
  is.na(wmoIMERG[,i+3]) <- indexNA
  is.na(wmoTRMM[,i+3]) <- indexNA
  is.na(wmoNoCumulus[,i+3]) <- indexNA
  is.na(wmoCHIRPS[,i+3]) <- indexNA
  
  
  
  wmoTargets <- cbind(wmoTargets,Prec$Prec)
  
}

wmoObs <- cbind(wmoMarcelo[,c(1:3)],wmoTargets[,-c(1)])

# Monthly

ObsMonthlyWmo <- aggregate(wmoObs[,-c(1:3)],list(month=wmoObs$month,year=wmoObs$year),
                            sum, na.rm=TRUE) 
MarceloMonthlyWmo <- aggregate(wmoMarcelo[,-c(1:3)],list(month=wmoMarcelo$month,year=wmoMarcelo$year),
                            sum, na.rm=TRUE) 
ERA5MonthlyWmo <- aggregate(wmoERA5[,-c(1:3)],list(month=wmoERA5$month,year=wmoERA5$year),
                         sum, na.rm=TRUE) 
Cumulus3MonthlyWmo <- aggregate(wmoCumulus3[,-c(1:3)],list(month=wmoCumulus3$month,year=wmoCumulus3$year),
                              sum, na.rm=TRUE) 
Cumulus3OneWayMonthlyWmo <- aggregate(wmoCumulus3OneWay[,-c(1:3)],list(month=wmoCumulus3OneWay$month,year=wmoCumulus3OneWay$year),
                                    sum, na.rm=TRUE) 
MartinaMonthlyWmo <- aggregate(wmoMartina[,-c(1:3)],list(month=wmoMartina$month,year=wmoMartina$year),
                            sum, na.rm=TRUE) 
IMERGMonthlyWmo <- aggregate(wmoIMERG[,-c(1:3)],list(month=wmoIMERG$month,year=wmoIMERG$year),
                          sum, na.rm=TRUE) 
TRMMMonthlyWmo <- aggregate(wmoTRMM[,-c(1:3)],list(month=wmoTRMM$month,year=wmoTRMM$year),
                         sum, na.rm=TRUE) 
NoCumulusMonthlyWmo <- aggregate(wmoNoCumulus[,-c(1:3)],list(month=wmoNoCumulus$month,year=wmoNoCumulus$year),
                              sum, na.rm=TRUE) 
CHIRPSMonthlyWmo <- aggregate(wmoCHIRPS[,-c(1:3)],list(month=wmoCHIRPS$month,year=wmoCHIRPS$year),
                                 sum, na.rm=TRUE) 


# Now we add the ones from CETRAD
#-------------------------------------------------

cetradTargets <- rep(NA, length(cetradMartina$V3))

for (i in 1:length(nearestCETRAD$stID)) {
  
  #i=1
  statID <- nearestCETRAD$stID[i]
  StatName <- as.character(nearestCETRAD$Name[i])
  
  if(StatName=="Archers Post"){
    FileIn <- "../Data_CETRAD/Data_Daily/RR-2008-ARCHERS_POST.txt"
    StatNameSave <- "Archers_Post"
  } else if(StatName=="Kalalu"){
    FileIn <- "../Data_CETRAD/Data_Daily/RR-2008-KALALU_(NRM).txt"
    StatNameSave <- "Kalalu"
  } else if(StatName=="Munyaka"){
    FileIn <- "../Data_CETRAD/Data_Daily/RR-2008-MUNYAKA_(NRM).txt"
    StatNameSave <- "Munyaka"
  } else if(StatName=="Naro Moru Gate Stn"){
    FileIn <- "../Data_CETRAD/Data_Daily/RR-2008-NARO_MORU_GATE_STN.txt"
    StatNameSave <- "Naro_Moru_Gate_Stn"
  } else if(StatName=="Naru Moru Met Stn"){
    FileIn <- "../Data_CETRAD/Data_Daily/RR-2008-NARO_MORU_MET_STN.txt"
    StatNameSave <- "Naro_Moru_Met_Stn"
  }
  
  PrecCETRAD <- read.table(FileIn, sep = ";", header = T)
  
  # Copy the NA structure
  
  indexNA <- is.na(PrecCETRAD$Prec)
  is.na(cetradMarcelo[,i+3]) <- indexNA
  is.na(cetradMartina[,i+3]) <- indexNA
  is.na(cetradCumulus3[,i+3]) <- indexNA
  is.na(cetradCumulus3OneWay[,i+3]) <- indexNA
  is.na(cetradERA5[,i+3]) <- indexNA
  is.na(cetradIMERG[,i+3]) <- indexNA
  is.na(cetradTRMM[,i+3]) <- indexNA
  is.na(cetradNoCumulus[,i+3]) <- indexNA
  is.na(cetradCHIRPS[,i+3]) <- indexNA
  
  cetradTargets <- cbind(cetradTargets,PrecCETRAD$Prec)
  
}

cetradObs <- cbind(cetradMarcelo[,c(1:3)],cetradTargets[,-c(1)])


# Monthly means

MarceloMonthlyCetrad <- aggregate(cetradMarcelo[,-c(1:3)],list(month=cetradMarcelo$month,year=cetradMarcelo$year),
                            sum, na.rm=TRUE) 
MartinaMonthlyCetrad <- aggregate(cetradMartina[,-c(1:3)],list(month=cetradMartina$month,year=cetradMartina$year),
                            sum, na.rm=TRUE) 
Cumulus3MonthlyCetrad <- aggregate(cetradCumulus3[,-c(1:3)],list(month=cetradCumulus3$month,year=cetradCumulus3$year),
                              sum, na.rm=TRUE) 
Cumulus3OneWayMonthlyCetrad <- aggregate(cetradCumulus3OneWay[,-c(1:3)],list(month=cetradCumulus3OneWay$month,year=cetradCumulus3OneWay$year),
                                    sum, na.rm=TRUE) 
ERA5MonthlyCetrad <- aggregate(cetradERA5[,-c(1:3)],list(month=cetradERA5$month,year=cetradERA5$year),
                         sum, na.rm=TRUE) 
IMERGMonthlyCetrad <- aggregate(cetradIMERG[,-c(1:3)],list(month=cetradIMERG$month,year=cetradIMERG$year),
                          sum, na.rm=TRUE) 

ObsMonthlyCetrad <- aggregate(cetradObs[,-c(1:3)],list(month=cetradObs$month,year=cetradObs$year),
                           sum, na.rm=TRUE) 
TRMMMonthlyCetrad <- aggregate(cetradTRMM[,-c(1:3)],list(month=cetradTRMM$month,year=cetradTRMM$year),
                         sum, na.rm=TRUE) 
NoCumulusMonthlyCetrad <- aggregate(cetradNoCumulus[,-c(1:3)],list(month=cetradNoCumulus$month,year=cetradNoCumulus$year),
                              sum, na.rm=TRUE) 
CHIRPSMonthlyCetrad <- aggregate(cetradCHIRPS[,-c(1:3)],list(month=cetradCHIRPS$month,year=cetradCHIRPS$year),
                                    sum, na.rm=TRUE) 



# Now we add the ones from Geography Daily
#-------------------------------------------------

geoDayTargets <- rep(NA, length(geoDayMartina$V3))

for (i in 1:length(nearestGeoDay$stID)) {
  
  #i=1
  statPath <- nearestGeoDay$stID[i]
  StatName <- as.character(nearestGeoDay$Name[i])
  
  PrecgeoDay <- read.table(sprintf("../Data_Geography/2008/%s",statPath), sep = " ", header = T)
  
  # Copy the NA structure
  
  indexNA <- is.na(PrecgeoDay$rr)
  is.na(geoDayMarcelo[,i+3]) <- indexNA
  is.na(geoDayMartina[,i+3]) <- indexNA
  is.na(geoDayCumulus3[,i+3]) <- indexNA
  is.na(geoDayCumulus3OneWay[,i+3]) <- indexNA
  is.na(geoDayERA5[,i+3]) <- indexNA
  is.na(geoDayIMERG[,i+3]) <- indexNA
  is.na(geoDayTRMM[,i+3]) <- indexNA
  is.na(geoDayNoCumulus[,i+3]) <- indexNA
  is.na(geoDayCHIRPS[,i+3]) <- indexNA
  
  
  geoDayTargets <- cbind(geoDayTargets,PrecgeoDay$rr)
  
}

geoDayObs <- cbind(geoDayMarcelo[,c(1:3)],geoDayTargets[,-c(1)])


# Monthly means

MarceloMonthlygeoDay <- aggregate(geoDayMarcelo[,-c(1:3)],list(month=geoDayMarcelo$month,year=geoDayMarcelo$year),
                                  sum, na.rm=TRUE) 
MartinaMonthlygeoDay <- aggregate(geoDayMartina[,-c(1:3)],list(month=geoDayMartina$month,year=geoDayMartina$year),
                                  sum, na.rm=TRUE) 
Cumulus3MonthlygeoDay <- aggregate(geoDayCumulus3[,-c(1:3)],list(month=geoDayCumulus3$month,year=geoDayCumulus3$year),
                                   sum, na.rm=TRUE) 
Cumulus3OneWayMonthlygeoDay <- aggregate(geoDayCumulus3OneWay[,-c(1:3)],list(month=geoDayCumulus3OneWay$month,year=geoDayCumulus3OneWay$year),
                                         sum, na.rm=TRUE) 
ERA5MonthlygeoDay <- aggregate(geoDayERA5[,-c(1:3)],list(month=geoDayERA5$month,year=geoDayERA5$year),
                               sum, na.rm=TRUE) 
IMERGMonthlygeoDay <- aggregate(geoDayIMERG[,-c(1:3)],list(month=geoDayIMERG$month,year=geoDayIMERG$year),
                                sum, na.rm=TRUE) 
NoCumulusMonthlygeoDay <- aggregate(geoDayNoCumulus[,-c(1:3)],list(month=geoDayNoCumulus$month,year=geoDayNoCumulus$year),
                                sum, na.rm=TRUE) 
CHIRPSMonthlygeoDay <- aggregate(geoDayCHIRPS[,-c(1:3)],list(month=geoDayCHIRPS$month,year=geoDayCHIRPS$year),
                                    sum, na.rm=TRUE) 

ObsMonthlygeoDay <- aggregate(geoDayObs[,-c(1:3)],list(month=geoDayObs$month,year=geoDayObs$year),
                              sum, na.rm=TRUE) 
TRMMMonthlygeoDay <- aggregate(geoDayTRMM[,-c(1:3)],list(month=geoDayTRMM$month,year=geoDayTRMM$year),
                               sum, na.rm=TRUE) 


# Now we add the ones from Geography Monthly
#-------------------------------------------------

geoMonTargets <- rep(NA, length(geoMonMartina$V3))

for (i in 1:length(nearestGeoMon$stID)) {
  
  #i=1
  statPath <- nearestGeoMon$stID[i]
  StatName <- as.character(nearestGeoMon$Name[i])
  
  PrecgeoMon <- read.table(sprintf("../Data_Geography/2008/%s",statPath), sep = " ", header = T)
  
  # Copy the NA structure
  
  indexNA <- is.na(PrecgeoMon$rr)
  is.na(geoMonMarcelo[,i+3]) <- indexNA
  is.na(geoMonMartina[,i+3]) <- indexNA
  is.na(geoMonCumulus3[,i+3]) <- indexNA
  is.na(geoMonCumulus3OneWay[,i+3]) <- indexNA
  is.na(geoMonERA5[,i+3]) <- indexNA
  is.na(geoMonIMERG[,i+3]) <- indexNA
  is.na(geoMonTRMM[,i+3]) <- indexNA
  is.na(geoMonNoCumulus[,i+3]) <- indexNA
  is.na(geoMonCHIRPS[,i+3]) <- indexNA
  
  
  geoMonTargets <- cbind(geoMonTargets,PrecgeoMon$rr)
  
}

geoMonObs <- cbind(geoMonMarcelo[,c(1:3)],geoMonTargets[,-c(1)])


# Monthly means

MarceloMonthlygeoMon <- aggregate(geoMonMarcelo[,-c(1:3)],list(month=geoMonMarcelo$month,year=geoMonMarcelo$year),
                                  sum, na.rm=TRUE) 
MartinaMonthlygeoMon <- aggregate(geoMonMartina[,-c(1:3)],list(month=geoMonMartina$month,year=geoMonMartina$year),
                                  sum, na.rm=TRUE) 
Cumulus3MonthlygeoMon <- aggregate(geoMonCumulus3[,-c(1:3)],list(month=geoMonCumulus3$month,year=geoMonCumulus3$year),
                                   sum, na.rm=TRUE) 
Cumulus3OneWayMonthlygeoMon <- aggregate(geoMonCumulus3OneWay[,-c(1:3)],list(month=geoMonCumulus3OneWay$month,year=geoMonCumulus3OneWay$year),
                                         sum, na.rm=TRUE) 
ERA5MonthlygeoMon <- aggregate(geoMonERA5[,-c(1:3)],list(month=geoMonERA5$month,year=geoMonERA5$year),
                               sum, na.rm=TRUE) 
IMERGMonthlygeoMon <- aggregate(geoMonIMERG[,-c(1:3)],list(month=geoMonIMERG$month,year=geoMonIMERG$year),
                                sum, na.rm=TRUE) 
NoCumulusMonthlygeoMon <- aggregate(geoMonNoCumulus[,-c(1:3)],list(month=geoMonNoCumulus$month,year=geoMonNoCumulus$year),
                                sum, na.rm=TRUE) 
CHIRPSMonthlygeoMon <- aggregate(geoMonCHIRPS[,-c(1:3)],list(month=geoMonCHIRPS$month,year=geoMonCHIRPS$year),
                                    sum, na.rm=TRUE) 

ObsMonthlygeoMon <- aggregate(geoMonObs[,-c(1:3)],list(month=geoMonObs$month,year=geoMonObs$year),
                              sum, na.rm=TRUE) 
TRMMMonthlygeoMon <- aggregate(geoMonTRMM[,-c(1:3)],list(month=geoMonTRMM$month,year=geoMonTRMM$year),
                               sum, na.rm=TRUE) 





#Create the Monthly Tables for the chosen stations

MarceloMonthly <- cbind(MarceloMonthlyWmo, MarceloMonthlyCetrad[,-c(1:2)], MarceloMonthlygeoDay[,-c(1:2)], MarceloMonthlygeoMon[,-c(1:2)])
MartinaMonthly <- cbind(MartinaMonthlyWmo, MartinaMonthlyCetrad[,-c(1:2)], MartinaMonthlygeoDay[,-c(1:2)], MartinaMonthlygeoMon[,-c(1:2)])
Cumulus3Monthly <- cbind(Cumulus3MonthlyWmo, Cumulus3MonthlyCetrad[,-c(1:2)], MarceloMonthlygeoDay[,-c(1:2)], MarceloMonthlygeoMon[,-c(1:2)])
Cumulus3OneWayMonthly <- cbind(Cumulus3OneWayMonthlyWmo, Cumulus3OneWayMonthlyCetrad[,-c(1:2)], Cumulus3MonthlygeoDay[,-c(1:2)], MarceloMonthlygeoMon[,-c(1:2)])
ERA5Monthly <- cbind(ERA5MonthlyWmo, ERA5MonthlyCetrad[,-c(1:2)], ERA5MonthlygeoDay[,-c(1:2)], ERA5MonthlygeoMon[,-c(1:2)])
IMERGMonthly <- cbind(IMERGMonthlyWmo, IMERGMonthlyCetrad[,-c(1:2)], IMERGMonthlygeoDay[,-c(1:2)], IMERGMonthlygeoMon[,-c(1:2)])
ObsMonthly <- cbind(ObsMonthlyWmo, ObsMonthlyCetrad[,-c(1:2)], ObsMonthlygeoDay[,-c(1:2)], ObsMonthlygeoMon[,-c(1:2)])
TRMMMonthly <- cbind(TRMMMonthlyWmo, TRMMMonthlyCetrad[,-c(1:2)], TRMMMonthlygeoDay[,-c(1:2)], TRMMMonthlygeoMon[,-c(1:2)])
NoCumulusMonthly <- cbind(NoCumulusMonthlyWmo, NoCumulusMonthlyCetrad[,-c(1:2)], NoCumulusMonthlygeoDay[,-c(1:2)], NoCumulusMonthlygeoMon[,-c(1:2)])
CHIRPSMonthly <- cbind(CHIRPSMonthlyWmo, CHIRPSMonthlyCetrad[,-c(1:2)], CHIRPSMonthlygeoDay[,-c(1:2)], CHIRPSMonthlygeoMon[,-c(1:2)])

colnames(MarceloMonthly) <- c("month", "year",as.character(nearestWMO$Name), 
                              as.character(nearestCETRAD$Name),
                              as.character(nearestGeoDay$Name),
                              as.character(nearestGeoMon$Name))
colnames(MartinaMonthly) <- c("month", "year",as.character(nearestWMO$Name), 
                              as.character(nearestCETRAD$Name),
                              as.character(nearestGeoDay$Name),
                              as.character(nearestGeoMon$Name))
colnames(Cumulus3Monthly) <- c("month", "year",as.character(nearestWMO$Name), 
                               as.character(nearestCETRAD$Name),
                               as.character(nearestGeoDay$Name),
                               as.character(nearestGeoMon$Name))
colnames(Cumulus3OneWayMonthly) <- c("month", "year",as.character(nearestWMO$Name), 
                                     as.character(nearestCETRAD$Name),
                                     as.character(nearestGeoDay$Name),
                                     as.character(nearestGeoMon$Name))
colnames(ERA5Monthly) <- c("month", "year",as.character(nearestWMO$Name), 
                           as.character(nearestCETRAD$Name),
                           as.character(nearestGeoDay$Name),
                           as.character(nearestGeoMon$Name))
colnames(IMERGMonthly) <- c("month", "year",as.character(nearestWMO$Name), 
                            as.character(nearestCETRAD$Name),
                            as.character(nearestGeoDay$Name),
                            as.character(nearestGeoMon$Name))
colnames(ObsMonthly) <- c("month", "year",as.character(nearestWMO$Name), 
                          as.character(nearestCETRAD$Name),
                          as.character(nearestGeoDay$Name),
                          as.character(nearestGeoMon$Name))
colnames(TRMMMonthly) <- c("month", "year",as.character(nearestWMO$Name), 
                           as.character(nearestCETRAD$Name),
                           as.character(nearestGeoDay$Name),
                           as.character(nearestGeoMon$Name))
colnames(NoCumulusMonthly) <- c("month", "year",as.character(nearestWMO$Name), 
                            as.character(nearestCETRAD$Name),
                            as.character(nearestGeoDay$Name),
                            as.character(nearestGeoMon$Name))
colnames(CHIRPSMonthly) <- c("month", "year",as.character(nearestWMO$Name), 
                                as.character(nearestCETRAD$Name),
                                as.character(nearestGeoDay$Name),
                                as.character(nearestGeoMon$Name))


# Calculate the pattern correlations
dataCor <- data.frame(Month=integer(),
                      Martina=double(),Marcelo=double(),Cumulus3=double(),Cumulus3OneWay=double(),
                      NoCumulus=double(),ERA5=double(),IMERG=double(),TRMM=double(),CHIRPS=double())
dataPvalue <-data.frame(Month=integer(),
                        Martina=double(),Marcelo=double(),Cumulus3=double(),Cumulus3OneWay=double(),
                        NoCumulus=double(),ERA5=double(),IMERG=double(),TRMM=double(),CHIRPS=double())

for (i in 1:12) {
  
  #Save the Month
  dataCor[i,'Month'] <- i
  dataPvalue[i,'Month'] <- i
  
  #Save the Cor and P-value for Martina
  test <- cor.test(x = as.numeric(ObsMonthly[i,-c(1,2)]),y=as.numeric(MartinaMonthly[i,-c(1,2)]),method = "spearman"  )
  dataCor[i,'Martina'] <- test$estimate
  dataPvalue[i,'Martina'] <- test$p.value

  #Save the Cor and P-value for Marcelo
  test <- cor.test(x = as.numeric(ObsMonthly[i,-c(1,2)]),y=as.numeric(MarceloMonthly[i,-c(1,2)]), method = "spearman" )
  dataCor[i,'Marcelo'] <- test$estimate
  dataPvalue[i,'Marcelo'] <- test$p.value
  
  #Save the Cor and P-value for Cumulus3
  test <- cor.test(x = as.numeric(ObsMonthly[i,-c(1,2)]),y=as.numeric(Cumulus3Monthly[i,-c(1,2)]),method = "spearman"  )
  dataCor[i,'Cumulus3'] <- test$estimate
  dataPvalue[i,'Cumulus3'] <- test$p.value
  
  #Save the Cor and P-value for Cumulus3OneWay
  test <- cor.test(x = as.numeric(ObsMonthly[i,-c(1,2)]),y=as.numeric(Cumulus3OneWayMonthly[i,-c(1,2)]),method = "spearman"  )
  dataCor[i,'Cumulus3OneWay'] <- test$estimate
  dataPvalue[i,'Cumulus3OneWay'] <- test$p.value
  
  #Save the Cor and P-value for NoCumulus
  test <- cor.test(x = as.numeric(ObsMonthly[i,-c(1,2)]),y=as.numeric(NoCumulusMonthly[i,-c(1,2)]),method = "spearman"  )
  dataCor[i,'NoCumulus'] <- test$estimate
  dataPvalue[i,'NoCumulus'] <- test$p.value
  
  #Save the Cor and P-value for ERA5
  test <- cor.test(x = as.numeric(ObsMonthly[i,-c(1,2)]),y=as.numeric(ERA5Monthly[i,-c(1,2)]),method = "spearman"  )
  dataCor[i,'ERA5'] <- test$estimate
  dataPvalue[i,'ERA5'] <- test$p.value
  
  #Save the Cor and P-value for IMERG
  test <- cor.test(x = as.numeric(ObsMonthly[i,-c(1,2)]),y=as.numeric(IMERGMonthly[i,-c(1,2)]),method = "spearman"  )
  dataCor[i,'IMERG'] <- test$estimate
  dataPvalue[i,'IMERG'] <- test$p.value
  
  #Save the Cor and P-value for TRMM
  test <- cor.test(x = as.numeric(ObsMonthly[i,-c(1,2)]),y=as.numeric(TRMMMonthly[i,-c(1,2)]),method = "spearman"  )
  dataCor[i,'TRMM'] <- test$estimate
  dataPvalue[i,'TRMM'] <- test$p.value
  
  #Save the Cor and P-value for CHIRPS
  test <- cor.test(x = as.numeric(ObsMonthly[i,-c(1,2)]),y=as.numeric(CHIRPSMonthly[i,-c(1,2)]),method = "spearman"  )
  dataCor[i,'CHIRPS'] <- test$estimate
  dataPvalue[i,'CHIRPS'] <- test$p.value
  
}


# Save both tables

write.table(x = dataCor,file = "./PatternCorrelationStations/DataCors_SetUp9km_3Doms_d03_usingSpearman.txt",row.names = F,col.names = T,sep = ";")
write.table(x = dataPvalue,file = "./PatternCorrelationStations/DataPValues_SetUp9km_3Doms_d03_usingSpearman.txt",row.names = F,col.names = T,sep = ";")



