#------------------------------------------------------
#
#    October 2020
#    Script associated to publication:
#    "Sensitivity of precipitation and temperature over Mount Kenya area to 
#     physics parameterization options in a high-resolution modelsimulation 
#     performed with WRFV3.8.1"
#    Authors: M. Messmer, S.J. Gonzlez-Roj, C.C. Raible and T.F. Stocker
#
#
#    Creative Commons License: Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)
#------------------------------------------------------

# Do we have to include IMERG

useIMERG=TRUE

#--------------------------------------------------------
#   Read nearest Data
#--------------------------------------------------------
 
nearestCETRAD <- read.table(file="../Data_CETRAD/nearest_SetUp9km_3Doms_d03.dat",header=T, sep = ";")
nearestWMO <- read.table(file="../Data_WMO/nearest_SetUp9km_3Doms_d03.dat",header=T, sep = ";")
nearestGeoDay <- read.table(file="../Data_Geography/2008/nearest_SetUp9km_3Doms_d03_Daily.txt",header=T, sep = ";")
nearestGeoMon <- read.table(file="../Data_Geography/2008/nearest_SetUp9km_3Doms_d03_Monthly.txt",header=T, sep = ";")


#--------------------------------------------------------
#   Read Data Experiments and ERA5 from WMO
#--------------------------------------------------------


wmoERA5 <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-ERA5-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
wmoERA5 <- wmoERA5[-length(wmoERA5$year),]
wmoIMERG <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-IMERG-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
wmoTRMM <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-TRMM-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
wmoNoCumulus <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-NoCumulus-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
wmoCHIRPS <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-CHIRPS-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")

wmoMarcelo <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-Marcelo-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
wmoCumulus3 <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-Cumulus3-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
wmoCumulus3OneWay <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-Cumulus3-1Way-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
wmoMartina <- read.table(file = "../Data_WMO/DataTables/ERA5-Kenya-Present-Martina-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")



#--------------------------------------------------------
#   Read Data Experiments and ERA5 from CETRAD
#--------------------------------------------------------


cetradERA5 <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-ERA5-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
cetradERA5 <- cetradERA5[-length(cetradERA5$year),]
cetradIMERG <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-IMERG-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
cetradTRMM <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-TRMM-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
cetradNoCumulus <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-NoCumulus-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
cetradCHIRPS <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-CHIRPS-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")

cetradMarcelo <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-Marcelo-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
cetradCumulus3 <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-Cumulus3-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
cetradCumulus3OneWay <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-Cumulus3-1Way-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
cetradMartina <- read.table(file = "../Data_CETRAD/DataTables/ERA5-Kenya-Present-Martina-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")

#--------------------------------------------------------
#   Read Data Experiments and ERA5 from GEO DAILY
#--------------------------------------------------------

geoDayERA5 <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-ERA5-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoDayERA5 <- geoDayERA5[-length(geoDayERA5$year),]
geoDayIMERG <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-IMERG-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoDayTRMM <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-TRMM-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoDayNoCumulus <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-NoCumulus-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoDayCHIRPS <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-CHIRPS-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")

geoDayMarcelo <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-Marcelo-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoDayCumulus3 <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-Cumulus3-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoDayCumulus3OneWay <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-Cumulus3-1Way-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoDayMartina <- read.table(file = "../Data_Geography/2008/DataTables_Daily/ERA5-Kenya-Present-Martina-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")

#--------------------------------------------------------
#   Read Data Experiments and ERA5 from GEO MONTHLY
#--------------------------------------------------------

geoMonERA5 <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-ERA5-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoMonERA5 <- geoMonERA5[-length(geoMonERA5$year),]
geoMonIMERG <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-IMERG-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoMonTRMM <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-TRMM-3Doms-New/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoMonNoCumulus <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-NoCumulus-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoMonCHIRPS <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-CHIRPS-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")

geoMonMarcelo <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-Marcelo-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoMonCumulus3 <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-Cumulus3-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoMonCumulus3OneWay <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-Cumulus3-1Way-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")
geoMonMartina <- read.table(file = "../Data_Geography/2008/DataTables_Monthly/ERA5-Kenya-Present-Martina-3Doms/DataTable_RR_Daily_D03.txt", header = T, sep = ";")


library(RNetCDF)
library(plotrix)
library (akima)


#Defined the vectors to hold the Cors, Sds and RMSEs from the data
TotalStations=length(nearestCETRAD$stID)+length(nearestWMO$stID)+length(nearestGeoDay$stID)+length(nearestGeoMon$stID)
corObsMartina=vector(length = TotalStations)
corObsMarcelo=vector(length = TotalStations)
corObsCum3=vector(length = TotalStations)
corObsCum31Way=vector(length = TotalStations)
corObsERA5=vector(length = TotalStations)
corObsIMERG=vector(length = TotalStations)
corObsTRMM=vector(length = TotalStations)
corObsNoCumulus=vector(length = TotalStations)
corObsCHIRPS=vector(length = TotalStations)

sdObs=vector(length = TotalStations)
sdMartina=vector(length = TotalStations)
sdMarcelo=vector(length = TotalStations)
sdCum3=vector(length = TotalStations)
sdCum31Way=vector(length = TotalStations)
sdERA5=vector(length = TotalStations)
sdIMERG=vector(length = TotalStations)
sdTRMM=vector(length = TotalStations)
sdNoCumulus=vector(length = TotalStations)
sdCHIRPS=vector(length = TotalStations)

sdNormMartina=vector(length = TotalStations)
sdNormMarcelo=vector(length = TotalStations)
sdNormCum3=vector(length = TotalStations)
sdNormCum31Way=vector(length = TotalStations)
sdNormERA5=vector(length = TotalStations)
sdNormIMERG=vector(length = TotalStations)
sdNormTRMM=vector(length = TotalStations)
sdNormNoCumulus=vector(length = TotalStations)
sdNormCHIRPS=vector(length = TotalStations)

RMSEObsMartina=vector(length = TotalStations)
RMSEObsMarcelo=vector(length = TotalStations)
RMSEObsCum3=vector(length = TotalStations)
RMSEObsCum31Way=vector(length = TotalStations)
RMSEObsERA5=vector(length = TotalStations)
RMSEObsIMERG=vector(length = TotalStations)
RMSEObsTRMM=vector(length = TotalStations)
RMSEObsNoCumulus=vector(length = TotalStations)
RMSEObsCHIRPS=vector(length = TotalStations)

RMSENormObsMartina=vector(length = TotalStations)
RMSENormObsMarcelo=vector(length = TotalStations)
RMSENormObsCum3=vector(length = TotalStations)
RMSENormObsCum31Way=vector(length = TotalStations)
RMSENormObsERA5=vector(length = TotalStations)
RMSENormObsIMERG=vector(length = TotalStations)
RMSENormObsTRMM=vector(length = TotalStations)
RMSENormObsNoCumulus=vector(length = TotalStations)
RMSENormObsCHIRPS=vector(length = TotalStations)


# Start Plotting the First Station WMO
i=1
statID <- nearestWMO$stID[i]
StatName <- as.character(nearestWMO$Name[i])
WMO <- open.nc(sprintf("../Data_WMO/%s_daily_2008.nc",StatName), write=FALSE)

Prec <- var.get.nc(WMO,'rr')

if (StatName=="Nyeri"){
  # We need to delete the outlier with more than 200 mm in one day
  Prec[114]<-NA
}


#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(WMO,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(WMO,"time","units")
tdates=utcal.nc(tstring,tvals)


Prec <- cbind(tdates[,1:3],Prec)
Prec <- as.data.frame(Prec)

# Copy the NA structure

indexNA <- is.na(Prec$Prec)
is.na(wmoMarcelo[,i+3]) <- indexNA
is.na(wmoERA5[,i+3]) <- indexNA
is.na(wmoCumulus3[,i+3]) <- indexNA
is.na(wmoCumulus3OneWay[,i+3]) <- indexNA
is.na(wmoMartina[,i+3]) <- indexNA


# Monthly

PrecMonthly <- aggregate(Prec[,4],list(month=Prec$month,year=Prec$year),
                         sum, na.rm=TRUE) 
MarceloMonthly <- aggregate(wmoMarcelo[,-c(1:3)],list(month=wmoMarcelo$month,year=wmoMarcelo$year),
                            sum, na.rm=TRUE) 
ERA5Monthly <- aggregate(wmoERA5[,-c(1:3)],list(month=wmoERA5$month,year=wmoERA5$year),
                         sum, na.rm=TRUE) 
Cumulus3Monthly <- aggregate(wmoCumulus3[,-c(1:3)],list(month=wmoCumulus3$month,year=wmoCumulus3$year),
                              sum, na.rm=TRUE) 
Cumulus3OneWayMonthly <- aggregate(wmoCumulus3OneWay[,-c(1:3)],list(month=wmoCumulus3OneWay$month,year=wmoCumulus3OneWay$year),
                                    sum, na.rm=TRUE) 
MartinaMonthly <- aggregate(wmoMartina[,-c(1:3)],list(month=wmoMartina$month,year=wmoMartina$year),
                            sum, na.rm=TRUE) 


TargetERA5 <- ERA5Monthly[,i+2]
TargetMarcelo <- MarceloMonthly[,i+2]
TargetCumulus3 <- Cumulus3Monthly[,i+2]
TargetCumulus3OneWay <- Cumulus3OneWayMonthly[,i+2]
TargetMartina <- MartinaMonthly[,i+2]
TargetPrec <- PrecMonthly[,3]



# calculate the scores independently
# correlations 
corObsMarcelo[i] <- cor(x=TargetPrec,y=TargetMarcelo,use = "everything",method='pearson')
corObsCum3[i] <- cor(x=TargetPrec,y=TargetCumulus3,use = "everything",method='pearson')
corObsMartina[i] <- cor(x=TargetPrec,y=TargetMartina,use = "everything",method='pearson')
corObsERA5[i] <- cor(x=TargetPrec,y=TargetERA5,use = "everything",method='pearson')
corObsCum31Way[i] <- cor(x=TargetPrec,y=TargetCumulus3OneWay,use = "everything",method='pearson')

#Standard Deviations
sdObs[i] <- sd(TargetPrec)
sdMarcelo[i] <- sd(TargetMarcelo)
sdCum3[i] <- sd(TargetCumulus3)
sdMartina[i] <- sd(TargetMartina)
sdERA5[i] <- sd(TargetERA5)
sdCum31Way[i] <- sd(TargetCumulus3OneWay)

#Standard Deviations - Normalized
sdNormMarcelo[i] <- sd(TargetMarcelo)/sd(TargetPrec)
sdNormCum3[i] <- sd(TargetCumulus3)/sd(TargetPrec)
sdNormMartina[i] <- sd(TargetMartina)/sd(TargetPrec)
sdNormERA5[i] <- sd(TargetERA5)/sd(TargetPrec)
sdNormCum31Way[i] <- sd(TargetCumulus3OneWay)/sd(TargetPrec)

#RMSEs
xprime <- TargetPrec - mean(TargetPrec, na.rm = TRUE)
yprime <- TargetMarcelo - mean(TargetMarcelo, na.rm = TRUE)
RMSEObsMarcelo[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
yprime <- TargetCumulus3 - mean(TargetCumulus3, na.rm = TRUE)
RMSEObsCum3[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
yprime <- TargetMartina - mean(TargetMartina, na.rm = TRUE)
RMSEObsMartina[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
yprime <- TargetERA5 - mean(TargetERA5, na.rm = TRUE)
RMSEObsERA5[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
yprime <- TargetCumulus3OneWay - mean(TargetCumulus3OneWay, na.rm = TRUE)
RMSEObsCum31Way[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))

#RMSEs - normalized
RMSENormObsMarcelo[i] <- RMSEObsMarcelo[i]/sd(TargetPrec)
RMSENormObsMartina[i] <- RMSEObsMartina[i]/sd(TargetPrec)
RMSENormObsCum3[i] <- RMSEObsCum3[i]/sd(TargetPrec)
RMSENormObsCum31Way[i] <- RMSEObsCum31Way[i]/sd(TargetPrec)
RMSENormObsERA5[i] <- RMSEObsERA5[i]/sd(TargetPrec)

if(useIMERG==TRUE){
  is.na(wmoIMERG[,i+3]) <- indexNA
  IMERGMonthly <- aggregate(wmoIMERG[,-c(1:3)],list(month=wmoIMERG$month,year=wmoIMERG$year),
                            sum, na.rm=TRUE) 
  TargetIMERG <- IMERGMonthly[,i+2]
  corObsIMERG[i] <- cor(x=TargetPrec,y=TargetIMERG,use = "everything",method='pearson')
  sdIMERG[i] <- sd(TargetIMERG)
  sdNormIMERG[i] <- sd(TargetIMERG)/sd(TargetPrec)
  yprime <- TargetIMERG - mean(TargetIMERG, na.rm = TRUE)
  RMSEObsIMERG[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  RMSENormObsIMERG[i] <- RMSEObsIMERG[i]/sd(TargetPrec)
  
  is.na(wmoTRMM[,i+3]) <- indexNA
  TRMMMonthly <- aggregate(wmoTRMM[,-c(1:3)],list(month=wmoTRMM$month,year=wmoTRMM$year),
                            sum, na.rm=TRUE) 
  TargetTRMM <- TRMMMonthly[,i+2]
  corObsTRMM[i] <- cor(x=TargetPrec,y=TargetTRMM,use = "everything",method='pearson')
  sdTRMM[i] <- sd(TargetTRMM)
  sdNormTRMM[i] <- sd(TargetTRMM)/sd(TargetPrec)
  yprime <- TargetTRMM - mean(TargetTRMM, na.rm = TRUE)
  RMSEObsTRMM[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  RMSENormObsTRMM[i] <- RMSEObsTRMM[i]/sd(TargetPrec)
  
  
  
  is.na(wmoNoCumulus[,i+3]) <- indexNA
  NoCumulusMonthly <- aggregate(wmoNoCumulus[,-c(1:3)],list(month=wmoNoCumulus$month,year=wmoNoCumulus$year),
                           sum, na.rm=TRUE) 
  TargetNoCumulus <- NoCumulusMonthly[,i+2]
  corObsNoCumulus[i] <- cor(x=TargetPrec,y=TargetNoCumulus,use = "everything",method='pearson')
  sdNoCumulus[i] <- sd(TargetNoCumulus)
  sdNormNoCumulus[i] <- sd(TargetNoCumulus)/sd(TargetPrec)
  yprime <- TargetNoCumulus - mean(TargetNoCumulus, na.rm = TRUE)
  RMSEObsNoCumulus[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  RMSENormObsNoCumulus[i] <- RMSEObsNoCumulus[i]/sd(TargetPrec)

  
  is.na(wmoCHIRPS[,i+3]) <- indexNA
  CHIRPSMonthly <- aggregate(wmoCHIRPS[,-c(1:3)],list(month=wmoCHIRPS$month,year=wmoCHIRPS$year),
                                sum, na.rm=TRUE) 
  TargetCHIRPS <- CHIRPSMonthly[,i+2]
  corObsCHIRPS[i] <- cor(x=TargetPrec,y=TargetCHIRPS,use = "everything",method='pearson')
  sdCHIRPS[i] <- sd(TargetCHIRPS)
  sdNormCHIRPS[i] <- sd(TargetCHIRPS)/sd(TargetPrec)
  yprime <- TargetCHIRPS - mean(TargetCHIRPS, na.rm = TRUE)
  RMSEObsCHIRPS[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  RMSENormObsCHIRPS[i] <- RMSEObsCHIRPS[i]/sd(TargetPrec)
}

for (i in 2:length(nearestWMO$stID)) {
  
  
  #i=1
  statID <- nearestWMO$stID[i]
  StatName <- as.character(nearestWMO$Name[i])
  WMO <- open.nc(sprintf("../Data_WMO/%s_daily_2008.nc",StatName), write=FALSE)
  
  Prec <- var.get.nc(WMO,'rr')
  
  if (StatName=="Nyeri"){
    # We need to delete the outlier with more than 200 mm in one day
    Prec[114]<-NA
  }
  
  
  #--------------------------------
  #   Cogemos los datos temporales y los pasamos a modo tabla
  #--------------------------------
  
  tvals=var.get.nc(WMO,"time")
  iyear=c()
  imonth=c()
  # This does NOT work unless you have already installed udunits2!!
  utinit.nc()
  tstring=att.get.nc(WMO,"time","units")
  tdates=utcal.nc(tstring,tvals)
  
  
  Prec <- cbind(tdates[,1:3],Prec)
  Prec <- as.data.frame(Prec)
  
  # Copy the NA structure
  
  indexNA <- is.na(Prec$Prec)
  is.na(wmoMarcelo[,i+3]) <- indexNA
  is.na(wmoERA5[,i+3]) <- indexNA
  is.na(wmoCumulus3[,i+3]) <- indexNA
  is.na(wmoCumulus3OneWay[,i+3]) <- indexNA
  is.na(wmoMartina[,i+3]) <- indexNA
  
  
  # Monthly
  
  PrecMonthly <- aggregate(Prec[,4],list(month=Prec$month,year=Prec$year),
                           sum, na.rm=TRUE) 
  MarceloMonthly <- aggregate(wmoMarcelo[,-c(1:3)],list(month=wmoMarcelo$month,year=wmoMarcelo$year),
                              sum, na.rm=TRUE) 
  ERA5Monthly <- aggregate(wmoERA5[,-c(1:3)],list(month=wmoERA5$month,year=wmoERA5$year),
                           sum, na.rm=TRUE) 
  Cumulus3Monthly <- aggregate(wmoCumulus3[,-c(1:3)],list(month=wmoCumulus3$month,year=wmoCumulus3$year),
                                sum, na.rm=TRUE) 
  Cumulus3OneWayMonthly <- aggregate(wmoCumulus3OneWay[,-c(1:3)],list(month=wmoCumulus3OneWay$month,year=wmoCumulus3OneWay$year),
                                      sum, na.rm=TRUE) 
  MartinaMonthly <- aggregate(wmoMartina[,-c(1:3)],list(month=wmoMartina$month,year=wmoMartina$year),
                              sum, na.rm=TRUE) 
  
  
  TargetERA5 <- ERA5Monthly[,i+2]
  TargetMarcelo <- MarceloMonthly[,i+2]
  TargetCumulus3 <- Cumulus3Monthly[,i+2]
  TargetCumulus3OneWay <- Cumulus3OneWayMonthly[,i+2]
  TargetMartina <- MartinaMonthly[,i+2]
  TargetPrec <- PrecMonthly[,3]
  
  
  
  
  # calculate the scores independently
  # correlations 
  corObsMarcelo[i] <- cor(x=TargetPrec,y=TargetMarcelo,use = "everything",method='pearson')
  corObsCum3[i] <- cor(x=TargetPrec,y=TargetCumulus3,use = "everything",method='pearson')
  corObsMartina[i] <- cor(x=TargetPrec,y=TargetMartina,use = "everything",method='pearson')
  corObsERA5[i] <- cor(x=TargetPrec,y=TargetERA5,use = "everything",method='pearson')
  corObsCum31Way[i] <- cor(x=TargetPrec,y=TargetCumulus3OneWay,use = "everything",method='pearson')
  
  #Standard Deviations
  sdObs[i] <- sd(TargetPrec)
  sdMarcelo[i] <- sd(TargetMarcelo)
  sdCum3[i] <- sd(TargetCumulus3)
  sdMartina[i] <- sd(TargetMartina)
  sdERA5[i] <- sd(TargetERA5)
  sdCum31Way[i] <- sd(TargetCumulus3OneWay)
  
  #Standard Deviations - Normalized
  sdNormMarcelo[i] <- sd(TargetMarcelo)/sd(TargetPrec)
  sdNormCum3[i] <- sd(TargetCumulus3)/sd(TargetPrec)
  sdNormMartina[i] <- sd(TargetMartina)/sd(TargetPrec)
  sdNormERA5[i] <- sd(TargetERA5)/sd(TargetPrec)
  sdNormCum31Way[i] <- sd(TargetCumulus3OneWay)/sd(TargetPrec)
  
  #RMSEs
  xprime <- TargetPrec - mean(TargetPrec, na.rm = TRUE)
  yprime <- TargetMarcelo - mean(TargetMarcelo, na.rm = TRUE)
  RMSEObsMarcelo[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetCumulus3 - mean(TargetCumulus3, na.rm = TRUE)
  RMSEObsCum3[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetMartina - mean(TargetMartina, na.rm = TRUE)
  RMSEObsMartina[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetERA5 - mean(TargetERA5, na.rm = TRUE)
  RMSEObsERA5[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetCumulus3OneWay - mean(TargetCumulus3OneWay, na.rm = TRUE)
  RMSEObsCum31Way[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  
  #RMSEs - normalized
  RMSENormObsMarcelo[i] <- RMSEObsMarcelo[i]/sd(TargetPrec)
  RMSENormObsMartina[i] <- RMSEObsMartina[i]/sd(TargetPrec)
  RMSENormObsCum3[i] <- RMSEObsCum3[i]/sd(TargetPrec)
  RMSENormObsCum31Way[i] <- RMSEObsCum31Way[i]/sd(TargetPrec)
  RMSENormObsERA5[i] <- RMSEObsERA5[i]/sd(TargetPrec)
  
  if(useIMERG==TRUE){
    is.na(wmoIMERG[,i+3]) <- indexNA
    IMERGMonthly <- aggregate(wmoIMERG[,-c(1:3)],list(month=wmoIMERG$month,year=wmoIMERG$year),
                              sum, na.rm=TRUE) 
    TargetIMERG <- IMERGMonthly[,i+2]
    corObsIMERG[i] <- cor(x=TargetPrec,y=TargetIMERG,use = "everything",method='pearson')
    sdIMERG[i] <- sd(TargetIMERG)
    sdNormIMERG[i] <- sd(TargetIMERG)/sd(TargetPrec)
    yprime <- TargetIMERG - mean(TargetIMERG, na.rm = TRUE)
    RMSEObsIMERG[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsIMERG[i] <- RMSEObsIMERG[i]/sd(TargetPrec)
    
    is.na(wmoTRMM[,i+3]) <- indexNA
    TRMMMonthly <- aggregate(wmoTRMM[,-c(1:3)],list(month=wmoTRMM$month,year=wmoTRMM$year),
                              sum, na.rm=TRUE) 
    TargetTRMM <- TRMMMonthly[,i+2]
    corObsTRMM[i] <- cor(x=TargetPrec,y=TargetTRMM,use = "everything",method='pearson')
    sdTRMM[i] <- sd(TargetTRMM)
    sdNormTRMM[i] <- sd(TargetTRMM)/sd(TargetPrec)
    yprime <- TargetTRMM - mean(TargetTRMM, na.rm = TRUE)
    RMSEObsTRMM[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsTRMM[i] <- RMSEObsTRMM[i]/sd(TargetPrec)
    
    
    is.na(wmoNoCumulus[,i+3]) <- indexNA
    NoCumulusMonthly <- aggregate(wmoNoCumulus[,-c(1:3)],list(month=wmoNoCumulus$month,year=wmoNoCumulus$year),
                             sum, na.rm=TRUE) 
    TargetNoCumulus <- NoCumulusMonthly[,i+2]
    corObsNoCumulus[i] <- cor(x=TargetPrec,y=TargetNoCumulus,use = "everything",method='pearson')
    sdNoCumulus[i] <- sd(TargetNoCumulus)
    sdNormNoCumulus[i] <- sd(TargetNoCumulus)/sd(TargetPrec)
    yprime <- TargetNoCumulus - mean(TargetNoCumulus, na.rm = TRUE)
    RMSEObsNoCumulus[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsNoCumulus[i] <- RMSEObsNoCumulus[i]/sd(TargetPrec)
    
    
    is.na(wmoCHIRPS[,i+3]) <- indexNA
    CHIRPSMonthly <- aggregate(wmoCHIRPS[,-c(1:3)],list(month=wmoCHIRPS$month,year=wmoCHIRPS$year),
                                  sum, na.rm=TRUE) 
    TargetCHIRPS <- CHIRPSMonthly[,i+2]
    corObsCHIRPS[i] <- cor(x=TargetPrec,y=TargetCHIRPS,use = "everything",method='pearson')
    sdCHIRPS[i] <- sd(TargetCHIRPS)
    sdNormCHIRPS[i] <- sd(TargetCHIRPS)/sd(TargetPrec)
    yprime <- TargetCHIRPS - mean(TargetCHIRPS, na.rm = TRUE)
    RMSEObsCHIRPS[i] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsCHIRPS[i] <- RMSEObsCHIRPS[i]/sd(TargetPrec)
    
  }
  
}


# Now we add the ones from CETRAD
#-------------------------------------------------


for (i in 1:length(nearestCETRAD$stID)) {
  
  #i=1
  statID <- nearestCETRAD$stID[i]
  StatName <- as.character(nearestCETRAD$Name[i])
  
  if(StatName=="Archers Post"){
    FileIn <- "../Data_CETRAD/Data_Daily/RR-2008-ARCHERS_POST.txt"
    StatNameSave <- "Archers_Post"
  } else if(StatName=="Kalalu"){
    FileIn <- "../Data_CETRAD/Data_Daily/RR-2008-KALALU_(NRM).txt"
    StatNameSave <- "Kalalu"
  } else if(StatName=="Munyaka"){
    FileIn <- "../Data_CETRAD/Data_Daily/RR-2008-MUNYAKA_(NRM).txt"
    StatNameSave <- "Munyaka"
  } else if(StatName=="Naro Moru Gate Stn"){
    FileIn <- "../Data_CETRAD/Data_Daily/RR-2008-NARO_MORU_GATE_STN.txt"
    StatNameSave <- "Naro_Moru_Gate_Stn"
  } else if(StatName=="Naru Moru Met Stn"){
    FileIn <- "../Data_CETRAD/Data_Daily/RR-2008-NARO_MORU_MET_STN.txt"
    StatNameSave <- "Naro_Moru_Met_Stn"
  }
  
  PrecCETRAD <- read.table(FileIn, sep = ";", header = T)
  PrecCETRAD <- as.data.frame(PrecCETRAD)
  
  # Copy the NA structure
  
  indexNA <- is.na(PrecCETRAD$Prec)
  is.na(cetradMarcelo[,i+3]) <- indexNA
  is.na(cetradERA5[,i+3]) <- indexNA
  is.na(cetradCumulus3[,i+3]) <- indexNA
  is.na(cetradCumulus3OneWay[,i+3]) <- indexNA
  is.na(cetradMartina[,i+3]) <- indexNA
  
  # Monthly means
  
  MarceloMonthly <- aggregate(cetradMarcelo[,-c(1:3)],list(month=cetradMarcelo$month,year=cetradMarcelo$year),
                              sum, na.rm=TRUE) 
  MartinaMonthly <- aggregate(cetradMartina[,-c(1:3)],list(month=cetradMartina$month,year=cetradMartina$year),
                              sum, na.rm=TRUE) 
  Cumulus3Monthly <- aggregate(cetradCumulus3[,-c(1:3)],list(month=cetradCumulus3$month,year=cetradCumulus3$year),
                                sum, na.rm=TRUE) 
  Cumulus3OneWayMonthly <- aggregate(cetradCumulus3OneWay[,-c(1:3)],list(month=cetradCumulus3OneWay$month,year=cetradCumulus3OneWay$year),
                                      sum, na.rm=TRUE) 
  ERA5Monthly <- aggregate(cetradERA5[,-c(1:3)],list(month=cetradERA5$month,year=cetradERA5$year),
                           sum, na.rm=TRUE) 
  
  CETRADMonthly <- aggregate(PrecCETRAD[,-c(1:3)],list(month=PrecCETRAD$month,year=PrecCETRAD$year),
                             sum, na.rm=TRUE) 
  
  TargetMarcelo <- MarceloMonthly[,i+2]
  TargetMartina <- MartinaMonthly[,i+2]
  TargetCumulus3 <- Cumulus3Monthly[,i+2]
  TargetCumulus3OneWay <- Cumulus3OneWayMonthly[,i+2]
  TargetERA5 <- ERA5Monthly[,i+2]
  TargetPrec <- CETRADMonthly[,3]
  
  
  # Copy the NA structure
  
  indexNA <- is.na(TargetPrec)
  is.na(TargetMarcelo) <- indexNA
  is.na(TargetMartina) <- indexNA
  is.na(TargetCumulus3) <- indexNA
  is.na(TargetCumulus3OneWay) <- indexNA
  is.na(TargetERA5) <- indexNA
  
  
  # calculate the scores independently
  # correlations 
  corObsMarcelo[i+length(nearestWMO$stID)] <- cor(x=TargetPrec,y=TargetMarcelo,use = "everything",method='pearson')
  corObsCum3[i+length(nearestWMO$stID)] <- cor(x=TargetPrec,y=TargetCumulus3,use = "everything",method='pearson')
  corObsMartina[i+length(nearestWMO$stID)] <- cor(x=TargetPrec,y=TargetMartina,use = "everything",method='pearson')
  corObsERA5[i+length(nearestWMO$stID)] <- cor(x=TargetPrec,y=TargetERA5,use = "everything",method='pearson')
  corObsCum31Way[i+length(nearestWMO$stID)] <- cor(x=TargetPrec,y=TargetCumulus3OneWay,use = "everything",method='pearson')
  
  #Standard Deviations
  sdObs[i+length(nearestWMO$stID)] <- sd(TargetPrec)
  sdMarcelo[i+length(nearestWMO$stID)] <- sd(TargetMarcelo)
  sdCum3[i+length(nearestWMO$stID)] <- sd(TargetCumulus3)
  sdMartina[i+length(nearestWMO$stID)] <- sd(TargetMartina)
  sdERA5[i+length(nearestWMO$stID)] <- sd(TargetERA5)
  sdCum31Way[i+length(nearestWMO$stID)] <- sd(TargetCumulus3OneWay)
  
  #Standard Deviations - Normalized
  sdNormMarcelo[i+length(nearestWMO$stID)] <- sd(TargetMarcelo)/sd(TargetPrec)
  sdNormCum3[i+length(nearestWMO$stID)] <- sd(TargetCumulus3)/sd(TargetPrec)
  sdNormMartina[i+length(nearestWMO$stID)] <- sd(TargetMartina)/sd(TargetPrec)
  sdNormERA5[i+length(nearestWMO$stID)] <- sd(TargetERA5)/sd(TargetPrec)
  sdNormCum31Way[i+length(nearestWMO$stID)] <- sd(TargetCumulus3OneWay)/sd(TargetPrec)
  
  #RMSEs
  xprime <- TargetPrec - mean(TargetPrec, na.rm = TRUE)
  yprime <- TargetMarcelo - mean(TargetMarcelo, na.rm = TRUE)
  RMSEObsMarcelo[i+length(nearestWMO$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetCumulus3 - mean(TargetCumulus3, na.rm = TRUE)
  RMSEObsCum3[i+length(nearestWMO$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetMartina - mean(TargetMartina, na.rm = TRUE)
  RMSEObsMartina[i+length(nearestWMO$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetERA5 - mean(TargetERA5, na.rm = TRUE)
  RMSEObsERA5[i+length(nearestWMO$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetCumulus3OneWay - mean(TargetCumulus3OneWay, na.rm = TRUE)
  RMSEObsCum31Way[i+length(nearestWMO$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  
  #RMSEs - normalized
  RMSENormObsMarcelo[i+length(nearestWMO$stID)] <- RMSEObsMarcelo[i+length(nearestWMO$stID)]/sd(TargetPrec)
  RMSENormObsMartina[i+length(nearestWMO$stID)] <- RMSEObsMartina[i+length(nearestWMO$stID)]/sd(TargetPrec)
  RMSENormObsCum3[i+length(nearestWMO$stID)] <- RMSEObsCum3[i+length(nearestWMO$stID)]/sd(TargetPrec)
  RMSENormObsCum31Way[i+length(nearestWMO$stID)] <- RMSEObsCum31Way[i+length(nearestWMO$stID)]/sd(TargetPrec)
  RMSENormObsERA5[i+length(nearestWMO$stID)] <- RMSEObsERA5[i+length(nearestWMO$stID)]/sd(TargetPrec)
  
  if(useIMERG==TRUE){
    is.na(cetradIMERG[,i+3]) <- indexNA
    IMERGMonthly <- aggregate(cetradIMERG[,-c(1:3)],list(month=cetradIMERG$month,year=cetradIMERG$year),
                              sum, na.rm=TRUE) 
    TargetIMERG <- IMERGMonthly[,i+2]
    is.na(TargetIMERG) <- indexNA
    corObsIMERG[i+length(nearestWMO$stID)] <- cor(x=TargetPrec,y=TargetIMERG,use = "everything",method='pearson')
    sdIMERG[i+length(nearestWMO$stID)] <- sd(TargetIMERG)
    sdNormIMERG[i+length(nearestWMO$stID)] <- sd(TargetIMERG)/sd(TargetPrec)
    yprime <- TargetIMERG - mean(TargetIMERG, na.rm = TRUE)
    RMSEObsIMERG[i+length(nearestWMO$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsIMERG[i+length(nearestWMO$stID)] <- RMSEObsIMERG[i+length(nearestWMO$stID)]/sd(TargetPrec)

    is.na(cetradTRMM[,i+3]) <- indexNA
    TRMMMonthly <- aggregate(cetradTRMM[,-c(1:3)],list(month=cetradTRMM$month,year=cetradTRMM$year),
                              sum, na.rm=TRUE) 
    TargetTRMM <- TRMMMonthly[,i+2]
    is.na(TargetTRMM) <- indexNA
    corObsTRMM[i+length(nearestWMO$stID)] <- cor(x=TargetPrec,y=TargetTRMM,use = "everything",method='pearson')
    sdTRMM[i+length(nearestWMO$stID)] <- sd(TargetTRMM)
    sdNormTRMM[i+length(nearestWMO$stID)] <- sd(TargetTRMM)/sd(TargetPrec)
    yprime <- TargetTRMM - mean(TargetTRMM, na.rm = TRUE)
    RMSEObsTRMM[i+length(nearestWMO$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsTRMM[i+length(nearestWMO$stID)] <- RMSEObsTRMM[i+length(nearestWMO$stID)]/sd(TargetPrec)
    
    is.na(cetradNoCumulus[,i+3]) <- indexNA
    NoCumulusMonthly <- aggregate(cetradNoCumulus[,-c(1:3)],list(month=cetradNoCumulus$month,year=cetradNoCumulus$year),
                             sum, na.rm=TRUE) 
    TargetNoCumulus <- NoCumulusMonthly[,i+2]
    is.na(TargetNoCumulus) <- indexNA
    corObsNoCumulus[i+length(nearestWMO$stID)] <- cor(x=TargetPrec,y=TargetNoCumulus,use = "everything",method='pearson')
    sdNoCumulus[i+length(nearestWMO$stID)] <- sd(TargetNoCumulus)
    sdNormNoCumulus[i+length(nearestWMO$stID)] <- sd(TargetNoCumulus)/sd(TargetPrec)
    yprime <- TargetNoCumulus - mean(TargetNoCumulus, na.rm = TRUE)
    RMSEObsNoCumulus[i+length(nearestWMO$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsNoCumulus[i+length(nearestWMO$stID)] <- RMSEObsNoCumulus[i+length(nearestWMO$stID)]/sd(TargetPrec)
    
    is.na(cetradCHIRPS[,i+3]) <- indexNA
    CHIRPSMonthly <- aggregate(cetradCHIRPS[,-c(1:3)],list(month=cetradCHIRPS$month,year=cetradCHIRPS$year),
                                  sum, na.rm=TRUE) 
    TargetCHIRPS <- CHIRPSMonthly[,i+2]
    is.na(TargetCHIRPS) <- indexNA
    corObsCHIRPS[i+length(nearestWMO$stID)] <- cor(x=TargetPrec,y=TargetCHIRPS,use = "everything",method='pearson')
    sdCHIRPS[i+length(nearestWMO$stID)] <- sd(TargetCHIRPS)
    sdNormCHIRPS[i+length(nearestWMO$stID)] <- sd(TargetCHIRPS)/sd(TargetPrec)
    yprime <- TargetCHIRPS - mean(TargetCHIRPS, na.rm = TRUE)
    RMSEObsCHIRPS[i+length(nearestWMO$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsCHIRPS[i+length(nearestWMO$stID)] <- RMSEObsCHIRPS[i+length(nearestWMO$stID)]/sd(TargetPrec)
    
    
    }
  
}

# Now we add the ones from Geography Daily
#-------------------------------------------------

for (i in 1:length(nearestGeoDay$stID)) {
  
  #i=1
  statPath <- nearestGeoDay$stID[i]
  StatName <- as.character(nearestGeoDay$Name[i])
  
  PrecgeoDay <- read.table(sprintf("../Data_Geography/2008/%s",statPath), sep = " ", header = T)
  PrecgeoDay <- as.data.frame(cbind(PrecgeoDay$year,PrecgeoDay$month,PrecgeoDay$day,PrecgeoDay$rr))
  colnames(PrecgeoDay) <- c("year","month","day","rr")
  
  # Copy the NA structure
  
  indexNA <- is.na(PrecgeoDay$rr)
  is.na(geoDayMarcelo[,i+3]) <- indexNA
  is.na(geoDayMartina[,i+3]) <- indexNA
  is.na(geoDayCumulus3[,i+3]) <- indexNA
  is.na(geoDayCumulus3OneWay[,i+3]) <- indexNA
  is.na(geoDayERA5[,i+3]) <- indexNA
  is.na(geoDayIMERG[,i+3]) <- indexNA
  is.na(geoDayTRMM[,i+3]) <- indexNA
  is.na(geoDayNoCumulus[,i+3]) <- indexNA
  is.na(geoDayCHIRPS[,i+3]) <- indexNA
  
  
  # Monthly means
  
  MarceloMonthly <- aggregate(geoDayMarcelo[,-c(1:3)],list(month=geoDayMarcelo$month,year=geoDayMarcelo$year),
                              sum, na.rm=TRUE) 
  MartinaMonthly <- aggregate(geoDayMartina[,-c(1:3)],list(month=geoDayMartina$month,year=geoDayMartina$year),
                              sum, na.rm=TRUE) 
  Cumulus3Monthly <- aggregate(geoDayCumulus3[,-c(1:3)],list(month=geoDayCumulus3$month,year=geoDayCumulus3$year),
                               sum, na.rm=TRUE) 
  Cumulus3OneWayMonthly <- aggregate(geoDayCumulus3OneWay[,-c(1:3)],list(month=geoDayCumulus3OneWay$month,year=geoDayCumulus3OneWay$year),
                                     sum, na.rm=TRUE) 
  ERA5Monthly <- aggregate(geoDayERA5[,-c(1:3)],list(month=geoDayERA5$month,year=geoDayERA5$year),
                           sum, na.rm=TRUE) 
  
  geoDayMonthly <- aggregate(PrecgeoDay[,-c(1:3)],list(month=PrecgeoDay$month,year=PrecgeoDay$year),
                             sum, na.rm=TRUE) 
  
  TargetMarcelo <- MarceloMonthly[,i+2]
  TargetMartina <- MartinaMonthly[,i+2]
  TargetCumulus3 <- Cumulus3Monthly[,i+2]
  TargetCumulus3OneWay <- Cumulus3OneWayMonthly[,i+2]
  TargetERA5 <- ERA5Monthly[,i+2]
  TargetPrec <- geoDayMonthly[,3]
  
  
  
  # Copy the NA structure
  
  indexNA <- is.na(TargetPrec)
  is.na(TargetMarcelo) <- indexNA
  is.na(TargetMartina) <- indexNA
  is.na(TargetCumulus3) <- indexNA
  is.na(TargetCumulus3OneWay) <- indexNA
  is.na(TargetERA5) <- indexNA
  
  
  
  # calculate the scores independently
  # correlations 
  corObsMarcelo[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- cor(x=TargetPrec,y=TargetMarcelo,use = "everything",method='pearson')
  corObsCum3[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- cor(x=TargetPrec,y=TargetCumulus3,use = "everything",method='pearson')
  corObsMartina[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- cor(x=TargetPrec,y=TargetMartina,use = "everything",method='pearson')
  corObsERA5[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- cor(x=TargetPrec,y=TargetERA5,use = "everything",method='pearson')
  corObsCum31Way[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- cor(x=TargetPrec,y=TargetCumulus3OneWay,use = "everything",method='pearson')
  
  #Standard Deviations
  sdObs[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetPrec)
  sdMarcelo[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetMarcelo)
  sdCum3[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetCumulus3)
  sdMartina[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetMartina)
  sdERA5[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetERA5)
  sdCum31Way[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetCumulus3OneWay)
  
  
  #Standard Deviations - Normalized
  sdNormMarcelo[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetMarcelo)/sd(TargetPrec)
  sdNormCum3[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetCumulus3)/sd(TargetPrec)
  sdNormMartina[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetMartina)/sd(TargetPrec)
  sdNormERA5[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetERA5)/sd(TargetPrec)
  sdNormCum31Way[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetCumulus3OneWay)/sd(TargetPrec)
  
  #RMSEs
  xprime <- TargetPrec - mean(TargetPrec, na.rm = TRUE)
  yprime <- TargetMarcelo - mean(TargetMarcelo, na.rm = TRUE)
  RMSEObsMarcelo[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetCumulus3 - mean(TargetCumulus3, na.rm = TRUE)
  RMSEObsCum3[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetMartina - mean(TargetMartina, na.rm = TRUE)
  RMSEObsMartina[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetERA5 - mean(TargetERA5, na.rm = TRUE)
  RMSEObsERA5[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetCumulus3OneWay - mean(TargetCumulus3OneWay, na.rm = TRUE)
  RMSEObsCum31Way[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  
  
  #RMSEs - normalized
  RMSENormObsMarcelo[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- RMSEObsMarcelo[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)]/sd(TargetPrec)
  RMSENormObsMartina[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- RMSEObsMartina[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)]/sd(TargetPrec)
  RMSENormObsCum3[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- RMSEObsCum3[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)]/sd(TargetPrec)
  RMSENormObsCum31Way[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- RMSEObsCum31Way[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)]/sd(TargetPrec)
  RMSENormObsERA5[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- RMSEObsERA5[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)]/sd(TargetPrec)
  
  
  if(useIMERG==TRUE){
    IMERGMonthly <- aggregate(geoDayIMERG[,-c(1:3)],list(month=geoDayIMERG$month,year=geoDayIMERG$year),
                              sum, na.rm=TRUE) 
    TargetIMERG <- IMERGMonthly[,i+2]
    is.na(TargetIMERG) <- indexNA
    corObsIMERG[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- cor(x=TargetPrec,y=TargetIMERG,use = "everything",method='pearson')
    sdIMERG[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetIMERG)
    sdNormIMERG[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetIMERG)/sd(TargetPrec)
    yprime <- TargetIMERG - mean(TargetIMERG, na.rm = TRUE)
    RMSEObsIMERG[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsIMERG[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- RMSEObsIMERG[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)]/sd(TargetPrec)
    
    
    TRMMMonthly <- aggregate(geoDayTRMM[,-c(1:3)],list(month=geoDayTRMM$month,year=geoDayTRMM$year),
                             sum, na.rm=TRUE) 
    TargetTRMM <- TRMMMonthly[,i+2]
    is.na(TargetTRMM) <- indexNA
    corObsTRMM[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- cor(x=TargetPrec,y=TargetTRMM,use = "everything",method='pearson')
    sdTRMM[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetTRMM)
    sdNormTRMM[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetTRMM)/sd(TargetPrec)
    yprime <- TargetTRMM - mean(TargetTRMM, na.rm = TRUE)
    RMSEObsTRMM[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsTRMM[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- RMSEObsTRMM[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)]/sd(TargetPrec)
    
    
    NoCumulusMonthly <- aggregate(geoDayNoCumulus[,-c(1:3)],list(month=geoDayNoCumulus$month,year=geoDayNoCumulus$year),
                             sum, na.rm=TRUE) 
    TargetNoCumulus <- NoCumulusMonthly[,i+2]
    is.na(TargetNoCumulus) <- indexNA
    corObsNoCumulus[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- cor(x=TargetPrec,y=TargetNoCumulus,use = "everything",method='pearson')
    sdNoCumulus[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetNoCumulus)
    sdNormNoCumulus[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetNoCumulus)/sd(TargetPrec)
    yprime <- TargetNoCumulus - mean(TargetNoCumulus, na.rm = TRUE)
    RMSEObsNoCumulus[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsNoCumulus[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- RMSEObsNoCumulus[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)]/sd(TargetPrec)
    
    
    CHIRPSMonthly <- aggregate(geoDayCHIRPS[,-c(1:3)],list(month=geoDayCHIRPS$month,year=geoDayCHIRPS$year),
                                  sum, na.rm=TRUE) 
    TargetCHIRPS <- CHIRPSMonthly[,i+2]
    is.na(TargetCHIRPS) <- indexNA
    corObsCHIRPS[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- cor(x=TargetPrec,y=TargetCHIRPS,use = "everything",method='pearson')
    sdCHIRPS[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetCHIRPS)
    sdNormCHIRPS[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sd(TargetCHIRPS)/sd(TargetPrec)
    yprime <- TargetCHIRPS - mean(TargetCHIRPS, na.rm = TRUE)
    RMSEObsCHIRPS[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsCHIRPS[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)] <- RMSEObsCHIRPS[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)]/sd(TargetPrec)
  }
  
}


# Now we add the ones from Geography Monthly
#-------------------------------------------------

for (i in 1:length(nearestGeoMon$stID)) {
  
  #i=1
  statPath <- nearestGeoMon$stID[i]
  StatName <- as.character(nearestGeoMon$Name[i])
  
  PrecgeoMon <- read.table(sprintf("../Data_Geography/2008/%s",statPath), sep = " ", header = T)
  PrecgeoMon <- as.data.frame(cbind(PrecgeoMon$year,PrecgeoMon$month,PrecgeoMon$day,PrecgeoMon$rr))
  colnames(PrecgeoMon) <- c("year","month","day","rr")
  
  # Copy the NA structure
  
  indexNA <- is.na(PrecgeoMon$rr)
  is.na(geoMonMarcelo[,i+3]) <- indexNA
  is.na(geoMonMartina[,i+3]) <- indexNA
  is.na(geoMonCumulus3[,i+3]) <- indexNA
  is.na(geoMonCumulus3OneWay[,i+3]) <- indexNA
  is.na(geoMonERA5[,i+3]) <- indexNA
  is.na(geoMonIMERG[,i+3]) <- indexNA
  is.na(geoMonTRMM[,i+3]) <- indexNA
  is.na(geoMonNoCumulus[,i+3]) <- indexNA
  is.na(geoMonCHIRPS[,i+3]) <- indexNA
  
  
  # Monthly means
  
  MarceloMonthly <- aggregate(geoMonMarcelo[,-c(1:3)],list(month=geoMonMarcelo$month,year=geoMonMarcelo$year),
                              sum, na.rm=TRUE) 
  MartinaMonthly <- aggregate(geoMonMartina[,-c(1:3)],list(month=geoMonMartina$month,year=geoMonMartina$year),
                              sum, na.rm=TRUE) 
  Cumulus3Monthly <- aggregate(geoMonCumulus3[,-c(1:3)],list(month=geoMonCumulus3$month,year=geoMonCumulus3$year),
                               sum, na.rm=TRUE) 
  Cumulus3OneWayMonthly <- aggregate(geoMonCumulus3OneWay[,-c(1:3)],list(month=geoMonCumulus3OneWay$month,year=geoMonCumulus3OneWay$year),
                                     sum, na.rm=TRUE) 
  ERA5Monthly <- aggregate(geoMonERA5[,-c(1:3)],list(month=geoMonERA5$month,year=geoMonERA5$year),
                           sum, na.rm=TRUE) 
  
  geoMonMonthly <- aggregate(PrecgeoMon[,-c(1:3)],list(month=PrecgeoMon$month,year=PrecgeoMon$year),
                             sum, na.rm=TRUE) 
  
  TargetMarcelo <- MarceloMonthly[,i+2]
  TargetMartina <- MartinaMonthly[,i+2]
  TargetCumulus3 <- Cumulus3Monthly[,i+2]
  TargetCumulus3OneWay <- Cumulus3OneWayMonthly[,i+2]
  TargetERA5 <- ERA5Monthly[,i+2]
  TargetPrec <- geoMonMonthly[,3]
  
  
  
  # Copy the NA structure
  
  indexNA <- is.na(TargetPrec)
  is.na(TargetMarcelo) <- indexNA
  is.na(TargetMartina) <- indexNA
  is.na(TargetCumulus3) <- indexNA
  is.na(TargetCumulus3OneWay) <- indexNA
  is.na(TargetERA5) <- indexNA
  
  
  # calculate the scores independently
  # correlations 
  corObsMarcelo[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- cor(x=TargetPrec,y=TargetMarcelo,use = "everything",method='pearson')
  corObsCum3[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- cor(x=TargetPrec,y=TargetCumulus3,use = "everything",method='pearson')
  corObsMartina[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- cor(x=TargetPrec,y=TargetMartina,use = "everything",method='pearson')
  corObsERA5[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- cor(x=TargetPrec,y=TargetERA5,use = "everything",method='pearson')
  corObsCum31Way[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- cor(x=TargetPrec,y=TargetCumulus3OneWay,use = "everything",method='pearson')
  
  #Standard Deviations
  sdObs[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetPrec)
  sdMarcelo[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetMarcelo)
  sdCum3[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetCumulus3)
  sdMartina[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetMartina)
  sdERA5[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetERA5)
  sdCum31Way[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetCumulus3OneWay)
  
  
  #Standard Deviations - Normalized
  sdNormMarcelo[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetMarcelo)/sd(TargetPrec)
  sdNormCum3[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetCumulus3)/sd(TargetPrec)
  sdNormMartina[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetMartina)/sd(TargetPrec)
  sdNormERA5[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetERA5)/sd(TargetPrec)
  sdNormCum31Way[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetCumulus3OneWay)/sd(TargetPrec)
  
  #RMSEs
  xprime <- TargetPrec - mean(TargetPrec, na.rm = TRUE)
  yprime <- TargetMarcelo - mean(TargetMarcelo, na.rm = TRUE)
  RMSEObsMarcelo[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetCumulus3 - mean(TargetCumulus3, na.rm = TRUE)
  RMSEObsCum3[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetMartina - mean(TargetMartina, na.rm = TRUE)
  RMSEObsMartina[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetERA5 - mean(TargetERA5, na.rm = TRUE)
  RMSEObsERA5[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  yprime <- TargetCumulus3OneWay - mean(TargetCumulus3OneWay, na.rm = TRUE)
  RMSEObsCum31Way[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
  
  
  #RMSEs - normalized
  RMSENormObsMarcelo[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- RMSEObsMarcelo[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)]/sd(TargetPrec)
  RMSENormObsMartina[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- RMSEObsMartina[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)]/sd(TargetPrec)
  RMSENormObsCum3[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- RMSEObsCum3[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)]/sd(TargetPrec)
  RMSENormObsCum31Way[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- RMSEObsCum31Way[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)]/sd(TargetPrec)
  RMSENormObsERA5[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- RMSEObsERA5[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)]/sd(TargetPrec)
  
  
  if(useIMERG==TRUE){
    IMERGMonthly <- aggregate(geoMonIMERG[,-c(1:3)],list(month=geoMonIMERG$month,year=geoMonIMERG$year),
                              sum, na.rm=TRUE) 
    TargetIMERG <- IMERGMonthly[,i+2]
    is.na(TargetIMERG) <- indexNA
    corObsIMERG[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- cor(x=TargetPrec,y=TargetIMERG,use = "everything",method='pearson')
    sdIMERG[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetIMERG)
    sdNormIMERG[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetIMERG)/sd(TargetPrec)
    yprime <- TargetIMERG - mean(TargetIMERG, na.rm = TRUE)
    RMSEObsIMERG[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsIMERG[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- RMSEObsIMERG[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)]/sd(TargetPrec)
    
    
    TRMMMonthly <- aggregate(geoMonTRMM[,-c(1:3)],list(month=geoMonTRMM$month,year=geoMonTRMM$year),
                             sum, na.rm=TRUE) 
    TargetTRMM <- TRMMMonthly[,i+2]
    is.na(TargetTRMM) <- indexNA
    corObsTRMM[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- cor(x=TargetPrec,y=TargetTRMM,use = "everything",method='pearson')
    sdTRMM[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetTRMM)
    sdNormTRMM[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetTRMM)/sd(TargetPrec)
    yprime <- TargetTRMM - mean(TargetTRMM, na.rm = TRUE)
    RMSEObsTRMM[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsTRMM[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- RMSEObsTRMM[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)]/sd(TargetPrec)

    
    NoCumulusMonthly <- aggregate(geoMonNoCumulus[,-c(1:3)],list(month=geoMonNoCumulus$month,year=geoMonNoCumulus$year),
                             sum, na.rm=TRUE) 
    TargetNoCumulus <- NoCumulusMonthly[,i+2]
    is.na(TargetNoCumulus) <- indexNA
    corObsNoCumulus[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- cor(x=TargetPrec,y=TargetNoCumulus,use = "everything",method='pearson')
    sdNoCumulus[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetNoCumulus)
    sdNormNoCumulus[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetNoCumulus)/sd(TargetPrec)
    yprime <- TargetNoCumulus - mean(TargetNoCumulus, na.rm = TRUE)
    RMSEObsNoCumulus[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsNoCumulus[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- RMSEObsNoCumulus[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)]/sd(TargetPrec)
  
    
    CHIRPSMonthly <- aggregate(geoMonCHIRPS[,-c(1:3)],list(month=geoMonCHIRPS$month,year=geoMonCHIRPS$year),
                                  sum, na.rm=TRUE) 
    TargetCHIRPS <- CHIRPSMonthly[,i+2]
    is.na(TargetCHIRPS) <- indexNA
    corObsCHIRPS[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- cor(x=TargetPrec,y=TargetCHIRPS,use = "everything",method='pearson')
    sdCHIRPS[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetCHIRPS)
    sdNormCHIRPS[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sd(TargetCHIRPS)/sd(TargetPrec)
    yprime <- TargetCHIRPS - mean(TargetCHIRPS, na.rm = TRUE)
    RMSEObsCHIRPS[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- sqrt(sum((xprime - yprime)^2)/length(complete.cases(TargetPrec)))
    RMSENormObsCHIRPS[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)] <- RMSEObsCHIRPS[i+length(nearestWMO$stID)+length(nearestCETRAD$stID)+length(nearestGeoDay$stID)]/sd(TargetPrec)
    
    
  }
  
}





# Create raw tables for the Scores
#--------------------------------

# Correlations
namesBoots <- sprintf("V%01d", 1:length(TotalStations))
tableCorRaw=c("Set-Up",'EXP',"Meru", "Nyeri", "Embu", "Archers Post", "Kalaku",  
              "Munyaka","Naro Moru Gate", "Naru Moru Met",nearestGeoDay$Name,nearestGeoMon$Name)
exp2B=c("9km_3Doms",'Marcelo',corObsMarcelo)
exp3B=c("9km_3Doms",'Martina',corObsMartina)
exp4B=c("9km_3Doms",'Cum3',corObsCum3)
exp5B=c("9km_3Doms",'Cum3-1W',corObsCum31Way)
exp6B=c("9km_3Doms",'ERA5',corObsERA5)

if(useIMERG==TRUE){
  exp7B=c("9km_3Doms",'IMERG',corObsIMERG)
  exp8B=c("9km_3Doms",'TRMM',corObsTRMM)
  exp9B=c("9km_3Doms",'NoCum',corObsNoCumulus)
  exp10B=c("9km_3Doms",'CHIRPS',corObsCHIRPS)
  tableCorRaw<-rbind(tableCorRaw,exp2B,exp3B,exp4B,exp5B,exp6B,exp7B,exp8B, exp9B,exp10B)
} else {
  tableCorRaw<-rbind(tableCorRaw,exp2B,exp3B,exp4B,exp5B,exp6B)
}

write.table(tableCorRaw,file="ScoresData/RawCorData_SetUp9km_3Doms.txt",append=FALSE,quote=FALSE,
            sep=";",row.names=FALSE,col.names=FALSE)


# SDs
tableSDRaw=c("Set-Up",'EXP',"Meru", "Nyeri", "Embu", "Archers Post", "Kalaku",  
             "Munyaka","Naro Moru Gate", "Naru Moru Met",nearestGeoDay$Name,nearestGeoMon$Name)
exp1B=c("9km_3Doms","Obs",sdObs)
exp2B=c("9km_3Doms",'Marcelo',sdMarcelo)
exp3B=c("9km_3Doms",'Martina',sdMartina)
exp4B=c("9km_3Doms",'Cum3',sdCum3)
exp5B=c("9km_3Doms",'Cum3-1W',sdCum31Way)
exp6B=c("9km_3Doms",'ERA5',sdERA5)

if(useIMERG==TRUE){
  exp7B=c("9km_3Doms",'IMERG',sdIMERG)
  exp8B=c("9km_3Doms",'TRMM',sdTRMM)
  exp9B=c("9km_3Doms",'NoCum',sdNoCumulus)
  exp10B=c("9km_3Doms",'CHIRPS',sdCHIRPS)
  tableSDRaw<-rbind(tableSDRaw,exp1B,exp2B,exp3B,exp4B,exp5B,exp6B,exp7B,exp8B,exp9B,exp10B)
} else {
  tableSDRaw<-rbind(tableSDRaw,exp1B,exp2B,exp3B,exp4B,exp5B,exp6B)
}

write.table(tableSDRaw,file="ScoresData/RawSDData_SetUp9km_3Doms.txt",append=FALSE,quote=FALSE,
            sep=";",row.names=FALSE,col.names=FALSE)


# RMSEs
tableRMSERaw=c("Set-Up",'EXP',"Meru", "Nyeri", "Embu", "Archers Post", "Kalaku",  
               "Munyaka","Naro Moru Gate", "Naru Moru Met",nearestGeoDay$Name,nearestGeoMon$Name)
exp2B=c("9km_3Doms",'Marcelo',RMSEObsMarcelo)
exp3B=c("9km_3Doms",'Martina',RMSEObsMartina)
exp4B=c("9km_3Doms",'Cum3',RMSEObsCum3)
exp5B=c("9km_3Doms",'Cum3-1W',RMSEObsCum31Way)
exp6B=c("9km_3Doms",'ERA5',RMSEObsERA5)

if(useIMERG==TRUE){
  exp7B=c("9km_3Doms",'IMERG',RMSEObsIMERG)
  exp8B=c("9km_3Doms",'TRMM',RMSEObsTRMM)
  exp9B=c("9km_3Doms",'NoCum',RMSEObsNoCumulus)
  exp10B=c("9km_3Doms",'CHIRPS',RMSEObsCHIRPS)
  tableRMSERaw<-rbind(tableRMSERaw,exp2B,exp3B,exp4B,exp5B,exp6B,exp7B,exp8B, exp9B,exp10B)
} else {
  tableRMSERaw<-rbind(tableRMSERaw,exp2B,exp3B,exp4B,exp5B,exp6B)
}

write.table(tableRMSERaw,file="ScoresData/RawRMSEData_SetUp9km_3Doms.txt",append=FALSE,quote=FALSE,
            sep=";",row.names=FALSE,col.names=FALSE)


# SDs Normalized
tableSDNormRaw=c("Set-Up",'EXP',"Meru", "Nyeri", "Embu", "Archers Post", "Kalaku",  
                 "Munyaka","Naro Moru Gate", "Naru Moru Met",nearestGeoDay$Name,nearestGeoMon$Name)
exp2B=c("9km_3Doms",'Marcelo',sdNormMarcelo)
exp3B=c("9km_3Doms",'Martina',sdNormMartina)
exp4B=c("9km_3Doms",'Cum3',sdNormCum3)
exp5B=c("9km_3Doms",'Cum3-1W',sdNormCum31Way)
exp6B=c("9km_3Doms",'ERA5',sdNormERA5)

if(useIMERG==TRUE){
  exp7B=c("9km_3Doms",'IMERG',sdNormIMERG)
  exp8B=c("9km_3Doms",'TRMM',sdNormTRMM)
  exp9B=c("9km_3Doms",'NoCum',sdNormNoCumulus)
  exp10B=c("9km_3Doms",'CHIRPS',sdNormCHIRPS)
  tableSDNormRaw<-rbind(tableSDNormRaw,exp2B,exp3B,exp4B,exp5B,exp6B,exp7B,exp8B, exp9B,exp10B)
} else {
  tableSDNormRaw<-rbind(tableSDNormRaw,exp2B,exp3B,exp4B,exp5B,exp6B)
}

write.table(tableSDNormRaw,file="ScoresData/RawSDNormData_SetUp9km_3Doms.txt",append=FALSE,quote=FALSE,
            sep=";",row.names=FALSE,col.names=FALSE)

# RMSEs Normalized
tableRMSENormRaw=c("Set-Up",'EXP',"Meru", "Nyeri", "Embu", "Archers Post", "Kalaku",  
                   "Munyaka","Naro Moru Gate", "Naru Moru Met",nearestGeoDay$Name,nearestGeoMon$Name)
exp2B=c("9km_3Doms",'Marcelo',RMSENormObsMarcelo)
exp3B=c("9km_3Doms",'Martina',RMSENormObsMartina)
exp4B=c("9km_3Doms",'Cum3',RMSENormObsCum3)
exp5B=c("9km_3Doms",'Cum3-1W',RMSENormObsCum31Way)
exp6B=c("9km_3Doms",'ERA5',RMSENormObsERA5)

if(useIMERG==TRUE){
  exp7B=c("9km_3Doms",'IMERG',RMSENormObsIMERG)
  exp8B=c("9km_3Doms",'TRMM',RMSENormObsTRMM)
  exp9B=c("9km_3Doms",'NoCum',RMSENormObsNoCumulus)
  exp10B=c("9km_3Doms",'CHIRPS',RMSENormObsCHIRPS)
  tableRMSENormRaw<-rbind(tableRMSENormRaw,exp2B,exp3B,exp4B,exp5B,exp6B,exp7B,exp8B, exp9B,exp10B)
} else {
  tableRMSENormRaw<-rbind(tableRMSENormRaw,exp2B,exp3B,exp4B,exp5B,exp6B)
}

write.table(tableRMSENormRaw,file="ScoresData/RawRMSENormData_SetUp9km_3Doms.txt",append=FALSE,quote=FALSE,
            sep=";",row.names=FALSE,col.names=FALSE)



