%SWIMMERCHLMAY.M SETS UP SWIMMER STRUCTS FOR MULTI-CHLAMY 
%
% Inputs:
%	NCHLAMY 		- Number of swimmers
%	CHLAMYMODEL 	- Function handle for generating chlamy discretisaion
%	BEATMODEL 	- Function handle for chlamy flagellar beat
%	CHLAMYSIZE 	- Size parameters for chlamy head in multiples
%					of the flagellum length [a1,a2,a3]
%	CHLAMYDISC 	- Number of discretisation points for the chlamy 
%					[nTail,nHead,qTail,qHead]
%	NBEATS 		- Number of beats to set up chlamy
%   X0          - Initial location in space 
%   BODYFRAME   - Body frame = [Direction, normal, binormal];
%	ANG 		- Chlamy flagellar angle
%
function swimmer = SwimmersChlamy(nChlamy,chlamyModel,beatModel,...
    chlamySize,chlamyDisc,nBeats,x0,bodyFrame,ang)

% Initialise swimmers
swimmer = cell(nChlamy,1);

% Discretise S and T for construction of chlamy-wave interpolant
s = linspace(0, 1, 30);
dt = 0.05 * 2 * pi;
t = 0 : dt : 2*pi*nBeats;
[S,T] = ndgrid(s,t);

% Set up swimmer struct
for iSw = 1 : nChlamy
	swimmer{iSw} = struct( ...
		'fn', 	 	chlamyModel, ...
        'x0',       x0{iSw}, ...
        'b10',      bodyFrame{iSw}(:,1), ...
        'b20',      bodyFrame{iSw}(:,2), ...
		'model', 	struct( ...
			'F', 	[], ...
			'ns', 	chlamyDisc(1), ...
			'nh', 	chlamyDisc(2), ...
			'Ns',	chlamyDisc(3), ...
			'Nh',	chlamyDisc(4), ...
			'a1',	chlamySize(1), ...
			'a2',	chlamySize(2), ...
			'a3',	chlamySize(3), ...
			'ang',	ang));
        
    swimmer{iSw}.model.F = ConstructInterpolantFromSTForm(S,T,beatModel,[]);
end

end
