
library(Ritc)
library(tidyverse)
library(vroom)

calc_r2 <- function(fits_raw) {
  y_mean <- fits_raw %>% pull(raw) %>% mean()
  
  SS_tot = fits_raw %>% 
    pull(raw) %>% 
    `-`(y_mean) %>% 
    `^`(2) %>% 
    sum()
  
  SS_resid <- fits_raw %>% 
    pull(resid_sq) %>% 
    sum()
  
  r_sq <- 1 - SS_resid/SS_tot
  r_sq
}

fititcdata_resid <- function(x = "inputparam.txt", y = "itcout"){
  inputdata1=read.csv(x, colClass="character", header=FALSE, comment.char="#", strip.white=TRUE);
  itcdata1=importorigin(inputdata1[1,2]);
  constantparam=as.list(as.numeric(inputdata1[2:5,2]));
  names(constantparam)=inputdata1[2:5,1];
  fittingparam=as.list(as.numeric(inputdata1[6:9,2]));
  names(fittingparam)=inputdata1[6:9,1];
  # data input
  
  fititc1=nls.lm(par=fittingparam,fn=residNDH11,NDH0=itcdata1$NDH,q=constantparam, injV1=itcdata1$INJV, control=nls.lm.control(nprint=1)); # perform fitting
  fititc2=coef(fititc1);
  
  validindex=which(!is.na(itcdata1$NDH));
  
  fit_vals <- itcONE11(varpar=as.list(fititc2),stapar=constantparam, injV0=itcdata1$INJV)[validindex]/1000
  
  df_out <- tibble(XMt = itcdata1$XMt[validindex],
                   fit = fit_vals,
                   raw = itcdata1$NDH[validindex]/1000) %>%
    mutate(resid = raw - fit) %>%
    mutate(resid_sq = resid^2) 
  
  output_name <- paste0("output-", inputdata1[1,2]) 
  
  write_csv(output_name, x = df_out)
  
  #	r2 <- calc_r2(df_out)
  
  #	out <- list( "data" = df_out, "r2" = r2)
  df_out
}


### create the list of parameter files and ITC files ----
# their order is determined alphabetically, and element i of param_files will be applied to element i of origin_files
param_files <- list.files(path = ".", pattern = NULL, all.files = FALSE,
                          full.names = FALSE, recursive = FALSE,
                          ignore.case = FALSE, include.dirs = FALSE, no.. = FALSE) %>%
  .[grep(pattern =  ".txt", x = .)] %>% 
  sort()

param_list <- vroom::vroom(param_files, id = "path", col_names = FALSE) %>%
  filter(X1 == "file_name") %>%
  select(-X1) %>%
  set_names(c("param_file", "output_name"))%>%
  mutate(output_name = gsub(pattern = ".csv", 
                            replacement = "", 
                            x = output_name))
fits <- map2(param_list$param_file, # itc parameter files
             param_list$output_name, # names of the output files
             Ritc::fititcdata # function applied
)

r2 <- map2(param_list$param_file, # itc parameter files
           param_list$output_name, # names of the output files
           Ritc::fititcdata # function applied
)

#### create a concise, tidy summary of all of the output results -------
names(fits) <- param_list$output_name

r2_and_data <- fits_raw <- map2(param_list$param_file, # itc parameter files
                                param_list$output_name, # names of the output files
                                fititcdata_resid # function applied
) %>%
  lapply(. , calc_r2) %>%
  flatten() %>%
  as_vector()

summarised_results <- fits %>%
  as_tibble() %>%
  mutate(parameter = fits[[1]] %>% names()) %>%
  pivot_longer(-parameter, names_to = "exp_name", values_to = "value") %>%
  pivot_wider(names_from = parameter, values_from = value) %>%
  mutate(R2 = r2_and_data,
         exp_name = fits %>% names()) %>%
  select(exp_name, R2, K, DH, HD, N)
summarised_results

write_csv(x = summarised_results, path = "summarised_fits.csv") # write the summarised results to a file