find_package(Git)

if(GIT_FOUND)
execute_process(
  COMMAND ${GIT_EXECUTABLE} rev-parse --abbrev-ref HEAD
  WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
  OUTPUT_VARIABLE GIT_BRANCH
  OUTPUT_STRIP_TRAILING_WHITESPACE
)

# Get the latest abbreviated commit hash of the working branch
execute_process(
  COMMAND ${GIT_EXECUTABLE} rev-parse --short HEAD
  WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
  OUTPUT_VARIABLE GIT_COMMIT_HASH
  OUTPUT_STRIP_TRAILING_WHITESPACE
  )

execute_process(
  COMMAND "${GIT_EXECUTABLE}" diff-index --quiet HEAD --
	WORKING_DIRECTORY	"${CMAKE_SOURCE_DIR}"
  RESULT_VARIABLE res
  OUTPUT_VARIABLE out
	OUTPUT_STRIP_TRAILING_WHITESPACE
  )

if(res EQUAL 0)
	set(GIT_STATE "CLEAN")
else()
		set(GIT_STATE "DIRTY")
	endif()
endif()
