---
output:
  pdf_document: default
  html_document: default
---

# Replication files for "Information exchange in governance networks - Who brokers across political divides?"


## Purpose

The folders contain all replication files for the paper:

Angst, Mario and Laurence Brandenberger. 2021. Information exchange in governance networks - Who brokers across political divides? Governance.

All R scripts are commented to facilitate replication.
System requirements and package versions are documented in the following section. 


## Setup

### Operating system

The analysis was performed on a macOS 10.15.6 using R-Version 4.0.3.

### R-packages

The following R-packages (and verions) were used for the analysis: 

* Bergm_5.0.2
* colourvalues_0.3.7
* cluster_2.1.0
* DiagrammeR_1.0.6.1
* dplyr_1.0.3 
* factoextra_1.0.7
* forcats_0.5.1
* GGally_2.1.0 
* ggplot2_3.3.3
* here_1.0.1
* mice_3.13.0
* proxy_0.4-24
* RColorBrewer_1.1-2 
* reshape2_1.4.4
* rethinking_2.13
* rstan_2.21.2
* scales_1.1.1
* StanHeaders_2.21.0-7
* statnet_2019.6
* statnet.common_4.4.1
* stringr_1.4.0
* tergm_3.7.0
* tibble_3.0.6
* tsna_0.3.1

Additionally, we custom coded an ERGM term using the `ergm.userterms` package. 
The source package is included and needs to be installed manually before
running the code. 

## Content

### 0_Data folder

The data folder contains anonymized data tables. 

* agg_atts -> attributes of surveyed and non-surveyed organizations and actors
* atts_surveyonly -> attributes of surveyed organizations and actors
* el.issues  -> edgelist of organizations/actors linking to issues
* expertise_df  -> expertise of surveyed organizations and actors
* info_el_directed  -> edgelist of information exchange (directed)
* info_nw_directed -> network of information exchange (directed)
* info_nw_total_missing  -> network of information exchange, missing values
* occ_allies  -> named allies
* occ_opps  -> named opponents
* policybeliefvars  -> policy beliefs
* survey_only_mat  -> adjacency matrix of surveyed organizations only (subset)


### 1_Analysis folder

The analysis folder contains: 

* 1_dataprep.R -> data preparation file
* 2_analysis.R -> R code to replicate analysis
* custom_bergm_functions.R  -> custom function for BERGM estimation (auxiliary R-file)
* ergm.userterms_3.9.0.tar.gz  -> custom ERGM userterm R-package
* output  -> output folder
    * Figure2_cluster_cluster_dot.dot  -> dot-File for cluster plot, Figure 2
    * Figure3_brokering_distanceij_boxplot.pdf -> Figure 3
    * Figure4_pred_prob_plots_bergm5_new.pdf  -> Figure 4
    * Figure5_pred_prob_plots_bergm5_forums.pdf  -> Figure 5
    * FigureA2_bergm_m0b.pdf  -> Figure A2 in the Appendix
    * FigureA3_bergm_final.pdf  -> Figure A3 in the Appendix
    * FigureS1_summary_actortype.pdf -> Figure S1 in the Supplementary Materials
    * FigureS2a_silhouette.pdf -> Figure S2a in the Supplementary Materials
    * FigureS2b_wss.pdf -> Figure S2b in the Supplementary Materials
    * FigureS3_clustering_overview.pdf -> Figure S3 in the Supplementary Materials
    * FigureS4_bergm_m0b_gof.pdf -> Figure S24 in the Supplementary Materials
    * FigureS5_bergm_final_gof.pdf -> Figure S25 in the Supplementary Materials 


## Contact

Analysis was performed by Mario Angst with earlier versions and code snippets by Laurence Brandenberger. Please direct any questions to Mario Angst (mario.angst@gmail.com).