my_d_bgof <- function(x,
                 sample.size = 100,
                 aux.iters   = 10000,
                 n.deg       = NULL,
                 n.dist      = NULL,
                 n.esp       = NULL,
                 n.ideg      = NULL,
                 n.odeg      = NULL,
                 n.dsp = NULL,
                 ...){
  
  FF <- as.matrix(x$Theta[sample(dim(x$Theta)[1], sample.size), ])
  DN <- is.directed(ergm.getnetwork(x$formula))
  
  if (DN == FALSE) { # undirected
   stop("ain't working with undirected here")
  } else {# directed
    
    for (i in 1:sample.size) {
      a <- gof(x$formula,
               coef = FF[i,],
               verbose = FALSE,
               GOF = ~ idegree + odegree + espartners + distance +
                 dspartners + model,
               control = control.gof.formula(nsim = 1, MCMC.burnin = aux.iters))
      if (i == 1) A <- as.vector(a$pobs.ideg)
      A <- cbind(A, as.vector(a$psim.ideg))
      if (i == 1) AA <- as.vector(a$pobs.odeg)
      AA <- cbind(AA, as.vector(a$psim.odeg))
      if (i == 1) B <- as.vector(a$pobs.dist) 
      B <- cbind(B, as.vector(a$psim.dist))
      if (i == 1) C <- as.vector(a$pobs.espart)
      C <- cbind(C, as.vector(a$psim.espart))
      if (i == 1) D <- as.vector(a$pobs.dspart)
      D <- cbind(D, as.vector(a$psim.dspart))
      if (i == 1) MOD <- as.vector(a$obs.model)
      MOD <- cbind(MOD,as.vector(a$sim.model))
    }
    if (is.null(n.ideg)) n.ideg <- dim(A)[1]
    if (is.null(n.odeg)) n.odeg <- dim(AA)[1]
    if (is.null(n.dist)) n.dist <- dim(B)[1] - 1
    if (is.null(n.esp)) n.esp <- dim(C)[1]
    if (is.null(n.dsp)) n.dsp <- dim(D)[1]
    
    a5 <- apply(A[1:n.ideg, -1], 1, quantile, probs = 0.05)
    aa5 <- apply(AA[1:n.odeg, -1], 1, quantile, probs = 0.05)
    b5 <- apply(B[-(n.dist:(dim(B)[1] - 1)), -1], 1, quantile, probs = 0.05)
    c5 <- apply(C[1:n.esp, -1], 1, quantile, probs = 0.05)
    d5 <- apply(D[1:n.dsp, -1], 1, quantile, probs = 0.05)
    a95 <- apply(A[1:n.ideg, -1], 1, quantile, probs = 0.95)
    aa95 <- apply(AA[1:n.odeg, -1], 1, quantile, probs = 0.95)
    b95 <- apply(B[-(n.dist:(dim(B)[1] - 1)), -1], 1, quantile, probs = 0.95)
    c95 <- apply(C[1:n.esp, -1], 1, quantile, probs = 0.95)	
    d95 <- apply(D[1:n.dsp, -1], 1, quantile, probs = 0.95)	
    par(mfrow = c(3, 2), oma = c(0, 0, 3, 0), mar = c(4, 3, 1.5, 1))
    
    boxplot(as.data.frame(t(A[1:n.ideg,-1])),
            xaxt = "n",
            xlab = "in degree",
            ylab = "proportion of nodes")
    axis(1, seq(1, n.ideg), seq(0, n.ideg - 1))
    lines(A[1:n.ideg, 1], lwd = 2, col = 2)
    lines(a5, col = "darkgray")
    lines(a95, col = "darkgray")
    
    title("Bayesian goodness-of-fit diagnostics", outer = TRUE)
    
    boxplot(as.data.frame(t(AA[1:n.odeg, -1])),
            xaxt = "n",
            xlab = "out degree",
            ylab = "proportion of nodes")
    axis(1,seq(1, n.odeg),seq(0, n.odeg - 1))
    lines(AA[1:n.odeg, 1],lwd = 2,col = 2)
    lines(aa5, col = "darkgray")
    lines(aa95, col = "darkgray")
    
    boxplot(as.data.frame(t(B[-(n.dist:(dim(B)[1] - 1)), -1])),
            xaxt = "n",
            xlab = "minimum geodesic distance",
            ylab = "proportion of dyads")
    axis(1, seq(1, n.dist), labels = c(seq(1, (n.dist - 1)), "NR"))
    lines(B[-(n.dist:(dim(B)[1] - 1)), 1], lwd = 2 , col = 2)
    lines(b5,col = "darkgray")
    lines(b95,col = "darkgray")
    
    boxplot(as.data.frame(t(C[1:n.esp, -1])),
            xaxt = "n",
            xlab = "edge-wise shared partners",
            ylab = "proportion of edges")
    axis(1, seq(1, n.esp), seq(0, n.esp - 1))
    lines(C[1:n.esp, 1],lwd = 2, col = 2)
    lines(c5, col = "darkgray")
    lines(c95, col = "darkgray")
    
    boxplot(as.data.frame(t(C[1:n.dsp, -1])),
            xaxt = "n",
            xlab = "dyad-wise shared partners",
            ylab = "proportion of edges")
    axis(1, seq(1, n.dsp), seq(0, n.dsp - 1))
    lines(D[1:n.dsp, 1],lwd = 2, col = 2)
    lines(d5, col = "darkgray")
    lines(d95, col = "darkgray")
    
    out = list(sim.idegree = A[,-1],
               sim.odegree = AA[,-1],
               sim.dist = B[,-1],
               sim.esp = C[,-1],
               obs.degree = A[,1],
               obs.dist = B[,1],
               obs.esp = C[,1],
               model.sim = MOD[,-1],
               model.obs = MOD[,1],
               model.terms = rownames(a$summary.model))
  }     
}

plot_model_gof <- function(bgof_object, modelterms = NULL){
  # plot model obs vs sim
  model_obs_sim_df <- as.data.frame(t(cbind(bgof_object$model.obs, bgof_object$model.sim)))
  if(is.null(modelterms)){
    colnames(model_obs_sim_df) <- bgof_object$model.terms
  }else{
    colnames(model_obs_sim_df) <- modelterms
  }
  rownames(model_obs_sim_df) <- c("observed",paste(rep("sim",(nrow(model_obs_sim_df)-1)),
                                                   c(1:(nrow(model_obs_sim_df)-1))))
  # rescale to compare magnitudes of difference
  model_obs_sim_df <- as.data.frame(apply(model_obs_sim_df,2,scales::rescale, to = c(0,1)))
  
  ggplot(data = melt(model_obs_sim_df[,-1]), 
         aes(x=variable, y=value)) + 
    geom_boxplot(aes(fill=variable), alpha = 0.3, outlier.alpha = 0.05) +
    geom_point(data = as.data.frame(t(model_obs_sim_df[1,])), shape = 4, color = "black",
               aes(x = colnames(model_obs_sim_df), y = observed)) +
    theme(legend.position = "none", 
          axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1,size = 12))
}

plot_fun_bergm <- function(bergm_output, modelterms = NULL, raw_posterior = FALSE){
  
  if (raw_posterior == TRUE){
    posterior <- bergm_output
    if(!(is.null(modelterms))){
      colnames(posterior) <- modelterms
    }
  }
  else{
    posterior <- as.matrix(bergm_output$Theta)
    if(is.null(modelterms)){
      colnames(posterior) <- bergm_output$specs
    }else{
      colnames(posterior) <- modelterms
    }
  }
  

  coef.vect <- apply(posterior, 2, function(x) mean(x))
  lower.vect <- apply(posterior, 2, function(x) quantile(x,probs = 0.025))
  upper.vect <- apply(posterior, 2, function(x) quantile(x,probs = 0.925))
  lower.vect50 <- apply(posterior, 2, function(x) quantile(x,probs = 0.25))
  upper.vect50 <- apply(posterior, 2, function(x) quantile(x,probs = 0.75))
  
  long.names <- colnames(posterior)
  plot.dat <- data.frame(coef.vect, lower.vect, upper.vect, lower.vect50, upper.vect50, long.names)
  plot.dat$long.names <- factor(plot.dat$long.names, levels = plot.dat$long.names[c(1:nrow(plot.dat))])
  
  plot.dat[,c(1:5)] <- apply(plot.dat[,c(1:5)],2,exp)
  
  p_model <- ggplot(data = plot.dat, aes(x = as.numeric(as.character(coef.vect)), y = long.names)) + 
    geom_segment(aes(x = as.numeric(as.character(lower.vect)), xend = as.numeric(as.character(upper.vect)), 
                     y = long.names, yend = long.names),
                 size = 1.5,
                 alpha = 0.5) +
    geom_segment(aes(x = as.numeric(as.character(lower.vect50)), xend = as.numeric(as.character(upper.vect50)), 
                     y = long.names, yend = long.names, color = "red"),
                 size = 1.7,
                 alpha = 0.7) +
    geom_point(size = 3) +
    geom_vline(xintercept = 1) + 
    scale_x_continuous(trans = "log2", 
                       breaks = c(
                         round(min(plot.dat$coef.vect),2),
                         0.25,
                         0.5,
                         0.75,
                         1,
                         1.5,
                         round(max(plot.dat$coef.vect),digits = 2))
    )

  p_model <- p_model + 
    xlab("Posterior estimates") + 
    ylab("") + ggtitle("(Exponentiated) Posterior means and credible intervals") +
    guides(colour = F)
  p_model + theme_minimal()
  
}

get_model_vs_obs_df <- function(bgof_object){
  model_obs_sim_df <- as.data.frame(t(cbind(bgof_object$model.obs, bgof_object$model.sim)))
colnames(model_obs_sim_df) <- bgof_object$model.terms
rownames(model_obs_sim_df) <- c("observed",paste(rep("sim",(nrow(model_obs_sim_df)-1)),
                                                 c(1:(nrow(model_obs_sim_df)-1))))
  model_obs_sim_df
}
