#!/bin/csh

rm -fr ft1.smile

xyz2pipe -in ft1/test%04d.ft1 -x               \
| nmrPipe  -fn SMILE -thresh 0.95 -report 2    \
           -nThread 16 -maxMem 64              \
           -sample nuslist -sampleCount 3987   \
           -xP0 90 -xP1   0 -xzf 1             \
           -yP0 38 -yP1 180 -yzf 1 -yNeg -yAlt \
           -zP0 90 -zP1   0 -zzf 1 -zNeg -zAlt \
| pipe2xyz -out ft1.smile/test%04d.ft1 -x

rm -fr ft

xyz2pipe -in ft1.smile/test%04d.ft1 -x \
| nmrPipe  -fn ZF -zf 1 -auto          \
| nmrPipe  -fn FT                      \
| nmrPipe  -fn PS -p0 90 -p1 0 -di     \
| nmrPipe  -fn TP                      \
| nmrPipe  -fn ZF -zf 1 -auto          \
| nmrPipe  -fn FT -neg -alt            \
| nmrPipe  -fn PS -p0 38 -p1 180 -di   \
| pipe2xyz -out ft/test%04d.ft3 -y

xyz2pipe -in ft/test%04d.ft3 -z        \
| nmrPipe  -fn ZF -zf 1 -auto          \
| nmrPipe  -fn FT -neg -alt            \
| nmrPipe  -fn PS -p0 90 -p1 0 -di     \
| nmrPipe  -fn TP                      \
| pipe2xyz -out ft/test%04d.ft4 -z

proj4D.tcl -in ft/test%04d.ft4

rm -fr ft/test*.ft3

