#!/bin/csh

#FLATT requires the latest SMILE Version 2.1 Rev 2019.337.11.19

nusExpand.tcl -mode bruker -sampleCount 3987 -off 0 \
 -in ./ser -out ./ser_full -sample ./nuslist

rm -fr tmp

bruk2pipe -verb -in ./ser_full \
  -bad 0.0 -ext -aswap -AMX -decim 1560 -dspfvs 20 -grpdly 67.9867858886719  \
  -xN         3072  -yN              180  -zN        182  -aN         180  \
  -xT         1536  -yT               90  -zT         91  -aT          90  \
  -xMODE       DQD  -yMODE Echo-AntiEcho  -zMODE Complex  -aMODE  Complex  \
  -xSW   12820.513  -ySW        2564.103  -zSW  4545.455  -aSW   2564.103  \
  -xOBS    800.134  -yOBS         81.086  -zOBS  800.134  -aOBS    81.086  \
  -xCAR      4.773  -yCAR        116.682  -zCAR    9.033  -aCAR   116.682  \
  -xLAB        Htr  -yLAB            Ntr  -zLAB     Hnoe  -aLAB      Nnoe  \
  -ndim          4  -aq2D        Complex                                   \
| pipe2xyz -x -out tmp/test%04d.fid -ov

rm -fr fid

xyz2pipe -in tmp/test%04d.fid -z                           \
| nmrPipe -fn MAC -macro $NMRTXT/bruk_ranceA.M -noRd -noWr \
| pipe2xyz -out fid/test%04d.fid -z -ov

rm -fr ft1

xyz2pipe -in fid/test%04d.fid -x                           \
| nmrPipe  -fn POLY -time                                  \
| nmrPipe  -fn EXT -xn 780 -sw                             \
| nmrPipe  -fn SP -off 0.4 -end 0.98 -pow 2 -elb 15 -c 0.5 \
| nmrPipe  -fn ZF -zf 1 -auto                              \
| nmrPipe  -fn FT                                          \
| nmrPipe  -fn PS -p0 -40 -p1 0 -di                        \
| nmrPipe  -fn FLATT -x1 12.5ppm -xn 5.3ppm -noauto -m 1   \
              -fitNodes 12.5ppm to 10.5ppm, 6ppm to 5.3ppm \
| nmrPipe  -fn POLY -auto -ord 1 -x1 12.5ppm -xn 5.3ppm    \
| nmrPipe  -fn EXT -x1 10.8ppm -xn 6.0ppm -sw              \
| pipe2xyz -out ft1/test%04d.ft1 -a

rm -fr prof*.dat ser_full tmp fid


exit


#below is the equivalent conversion script that runs faster
#it treats 4D as 2D and convert the data before expanding it

rm -fr ft1.tmp

bruk2pipe -verb -in ./ser \
  -bad 0.0 -ext -aswap -AMX -decim 1560 -dspfvs 20 -grpdly 67.9867858886719  \
  -xN         3072  -yN            31896  -zN           1  -aN           1  \
  -xT         1536  -yT               90  -zT          91  -aT          90  \
  -xMODE       DQD  -yMODE Echo-AntiEcho  -zMODE     Real  -aMODE     Real  \
  -xSW   12820.513  -ySW        2564.103  -zSW   4545.455  -aSW   2564.103  \
  -xOBS    800.134  -yOBS         81.086  -zOBS   800.134  -aOBS    81.086  \
  -xCAR      4.773  -yCAR        116.682  -zCAR     9.033  -aCAR   116.682  \
  -xLAB        Htr  -yLAB            Ntr  -zLAB      Hnoe  -aLAB      Nnoe  \
  -ndim          2  -aq2D        Complex  -nusDim             4             \
| nmrPipe  -fn POLY -time                                  \
| nmrPipe  -fn EXT -xn 780 -sw                             \
| nmrPipe  -fn SP -off 0.4 -end 0.98 -pow 2 -elb 15 -c 0.5 \
| nmrPipe  -fn ZF -zf 1 -auto                              \
| nmrPipe  -fn FT                                          \
| nmrPipe  -fn PS -p0 -40 -p1 0 -di                        \
| nmrPipe  -fn FLATT -x1 12.5ppm -xn 5.3ppm -noauto -m 1   \
              -fitNodes 12.5ppm to 10.5ppm, 6ppm to 5.3ppm \
| nmrPipe  -fn POLY -auto -ord 1 -x1 12.5ppm -xn 5.3ppm    \
| nmrPipe  -fn EXT -x1 10.8ppm -xn 6.0ppm -sw              \
| nusExpand.tcl -in stdin -out stdout -aqORD 0             \
              -sample nuslist -sampleCount 3987            \
| pipe2xyz -out ft1.tmp/test%04d.ft1 -a

rm -fr prof*.dat ft1

xyz2pipe -in ft1.tmp/test%04d.ft1 -y \
| nmrPipe -fn MAC -macro $NMRTXT/bruk_ranceZ.M -noRd -noWr \
| pipe2xyz -out ft1/test%04d.ft1 -y -ov

rm -fr ft1.tmp

